/*===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 * 
 * IBM SDK, Java(tm) Technology Edition, v8
 * (C) Copyright IBM Corp. 2014, 2014. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 *===========================================================================
 */
/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date    Origin   Description
 * ------ ------   -------- ----------------------------------------------------
 * 087365 18052005 mpartrid Module created. 
 * J-2295 13072007 mbluemel ported to Java 6
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Class containing Socket utility methods.
 * ===========================================================================
 */
 
package java.net;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SocketUtil
{
    public SocketUtil()
    {
    }

    /**
     * Load net library into runtime.
     */
    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>() {
           public Void run() {
                  System.loadLibrary("net");
                  return null;
        }});
    }

    static private native long getThreadTag();
    static private native boolean isBlocked(long tag);
    static private native boolean interrupt(long tag);

}
