/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.ConstEntry;
import com.ibm.idl.EnumEntry;
import com.ibm.idl.ExceptionEntry;
import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.InterfaceState;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.ParameterEntry;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.StructEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.UnionBranch;
import com.ibm.idl.UnionEntry;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.constExpr.BinaryExpr;
import com.ibm.idl.constExpr.Divide;
import com.ibm.idl.constExpr.Expression;
import com.ibm.idl.constExpr.Minus;
import com.ibm.idl.constExpr.Not;
import com.ibm.idl.constExpr.Plus;
import com.ibm.idl.constExpr.Terminal;
import com.ibm.idl.constExpr.Times;
import com.ibm.idl.constExpr.UnaryExpr;
import com.ibm.idl.toJavaPortable.Arguments;
import com.ibm.idl.toJavaPortable.Compile;
import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class Util
extends com.ibm.idl.Util {
    public static final String TOJAVAPORTABLE_PROPERTIES_FILE = "com/ibm/idl/toJavaPortable/toJavaPortable.properties";
    public static final short TypeFile = 0;
    public static final short StubFile = 1;
    public static final short HelperFile = 2;
    public static final short HolderFile = 3;
    public static final short StateFile = 4;
    public static final short UnknownFile = 5;
    static Hashtable symbolTable = new Hashtable();
    private static String[][] escapeLiterals = new String[][]{{"\\v", "\\u000B"}, {"\\a", "\\u0007"}, {"\\?", "?"}};

    public static String getVersion() {
        return com.ibm.idl.Util.getVersion(TOJAVAPORTABLE_PROPERTIES_FILE);
    }

    static void setSymbolTable(Hashtable hashtable) {
        symbolTable = hashtable;
    }

    public static boolean isInterface(String string) {
        return Util.isInterface(string, symbolTable);
    }

    static String arrayInfo(Vector vector) {
        int n = vector.size();
        String string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + '[' + Util.parseExpression((Expression)enumeration.nextElement()) + ']';
        }
        return string;
    }

    public static String sansArrayInfo(Vector vector) {
        int n = vector.size();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "[]";
        }
        return string;
    }

    public static String sansArrayInfo(String string) {
        int n = string.indexOf(91);
        if (n >= 0) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            while (!string2.equals("")) {
                string = string + "[]";
                string2 = string2.substring(string2.indexOf(93) + 1);
            }
        }
        return string;
    }

    public static String fileName(SymtabEntry symtabEntry) {
        String string = Util.containerFullName(symtabEntry.container());
        if (string != null && !string.equals("")) {
            Util.mkdir(string);
        }
        String string2 = symtabEntry.name();
        if (string != null && !string.equals("")) {
            string2 = string + '/' + string2;
        }
        return string2.replace('/', File.separatorChar);
    }

    public static GenFileStream stream(SymtabEntry symtabEntry, String string) {
        return Util.getStream(Util.fileName(symtabEntry) + string, symtabEntry);
    }

    public static GenFileStream getStream(String string, SymtabEntry symtabEntry) {
        String string2 = ((Arguments)Compile.compiler.arguments).targetDir + string;
        if (Compile.compiler.arguments.keepOldFiles && new File(string2).exists()) {
            return null;
        }
        return new GenFileStream(string2, Compile.compiler.arguments.generateLatin1);
    }

    public static String containerFullName(SymtabEntry symtabEntry) {
        String string = "";
        if (symtabEntry == null) {
            string = "";
        } else {
            string = symtabEntry instanceof InterfaceEntry || symtabEntry instanceof StructEntry || symtabEntry instanceof UnionEntry ? symtabEntry.name() + "Package" : symtabEntry.name();
            if (symtabEntry.container() != null && !symtabEntry.container().name().equals("")) {
                string = Util.containerFullName(symtabEntry.container()) + '/' + string;
            }
        }
        return string;
    }

    public static String javaName(SymtabEntry symtabEntry) {
        if (symtabEntry.typeName().equals("native")) {
            return Util.nativeName(symtabEntry);
        }
        String string = "";
        if (symtabEntry instanceof TypedefEntry || symtabEntry instanceof SequenceEntry) {
            try {
                string = Util.sansArrayInfo((String)symtabEntry.dynamicVariable(Compile.typedefInfo));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                string = symtabEntry.name();
            }
        } else if (symtabEntry instanceof PrimitiveEntry) {
            string = Util.javaPrimName(symtabEntry.name());
        } else if (symtabEntry instanceof StringEntry) {
            string = "String";
        } else if (symtabEntry instanceof ValueEntry && symtabEntry.name().equals("ValueBase")) {
            string = "java.io.Serializable";
        } else if (symtabEntry instanceof ValueBoxEntry) {
            ValueBoxEntry valueBoxEntry = (ValueBoxEntry)symtabEntry;
            TypedefEntry typedefEntry = ((InterfaceState)valueBoxEntry.state().elementAt((int)0)).entry;
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (symtabEntry2 instanceof PrimitiveEntry) {
                string = Util.containerFullName(symtabEntry.container());
                if (!string.equals("")) {
                    string = string + '.';
                }
                string = string + symtabEntry.name();
            } else {
                string = Util.javaName(symtabEntry2);
            }
        } else {
            string = Util.containerFullName(symtabEntry.container());
            string = string.equals("") ? symtabEntry.name() : string + '.' + symtabEntry.name();
        }
        return string.replace('/', '.');
    }

    public static String nativeName(SymtabEntry symtabEntry) {
        String string = Util.containerFullName(symtabEntry.container());
        string = string.equals("") ? symtabEntry.name() : string + '.' + symtabEntry.name();
        if ((string = string.replace('/', '.')).equals("org.omg.PortableServer.ServantLocatorPackage.Cookie")) {
            string = "java.lang.Object";
        }
        return string;
    }

    public static String javaPrimName(String string) {
        if (string.equals("long") || string.equals("unsigned long")) {
            string = "int";
        } else if (string.equals("octet")) {
            string = "byte";
        } else if (string.equals("long long") || string.equals("unsigned long long")) {
            string = "long";
        } else if (string.equals("wchar")) {
            string = "char";
        } else if (string.equals("unsigned short")) {
            string = "short";
        } else if (string.equals("any")) {
            string = "org.omg.CORBA.Any";
        } else if (string.equals("TypeCode")) {
            string = "org.omg.CORBA.TypeCode";
        } else if (string.equals("Principal")) {
            string = "org.omg.CORBA.Principal";
        }
        return string;
    }

    public static String javaQualifiedName(SymtabEntry symtabEntry) {
        String string = "";
        if (symtabEntry instanceof PrimitiveEntry && !symtabEntry.typeName().equals("native")) {
            string = Util.javaPrimName(symtabEntry.name());
        } else if (symtabEntry instanceof StringEntry) {
            string = "String";
        } else if (symtabEntry instanceof ValueEntry && symtabEntry.name().equals("ValueBase")) {
            string = "java.io.Serializable";
        } else {
            SymtabEntry symtabEntry2 = symtabEntry.container();
            if (symtabEntry2 != null) {
                string = symtabEntry2.name();
            }
            string = string.equals("") ? symtabEntry.name() : Util.containerFullName(symtabEntry.container()) + '.' + symtabEntry.name();
        }
        return string.replace('/', '.');
    }

    public static String collapseName(String string) {
        if (string.equals("unsigned short")) {
            string = "ushort";
        } else if (string.equals("unsigned long")) {
            string = "ulong";
        } else if (string.equals("unsigned long long")) {
            string = "ulonglong";
        } else if (string.equals("long long")) {
            string = "longlong";
        }
        return string;
    }

    public static SymtabEntry typeOf(SymtabEntry symtabEntry) {
        if (symtabEntry == null) {
            return null;
        }
        String string = symtabEntry.typeName();
        if (string != null && string.equals("native")) {
            return symtabEntry;
        }
        while (symtabEntry instanceof TypedefEntry && ((TypedefEntry)symtabEntry).arrayInfo().isEmpty() && !(symtabEntry.type() instanceof SequenceEntry)) {
            symtabEntry = symtabEntry.type();
        }
        return symtabEntry;
    }

    static void fillInfo(SymtabEntry symtabEntry) {
        String string = "";
        SymtabEntry symtabEntry2 = symtabEntry;
        boolean bl = false;
        do {
            try {
                bl = symtabEntry2.dynamicVariable(Compile.typedefInfo) != null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (bl) continue;
            if (symtabEntry2 instanceof TypedefEntry) {
                string = string + Util.arrayInfo(((TypedefEntry)symtabEntry2).arrayInfo());
            } else if (symtabEntry2 instanceof SequenceEntry) {
                Expression expression = ((SequenceEntry)symtabEntry2).maxSize();
                string = expression == null ? string + "[]" : string + '[' + Util.parseExpression(expression) + ']';
            }
            if (symtabEntry2.type() == null) continue;
            symtabEntry2 = symtabEntry2.type();
        } while (!bl && symtabEntry2 != null && (symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof SequenceEntry));
        if (symtabEntry2 instanceof ValueBoxEntry) {
            Util.fillValueBoxInfo((ValueBoxEntry)symtabEntry2);
        }
        try {
            if (bl) {
                symtabEntry.dynamicVariable(Compile.typedefInfo, (String)symtabEntry2.dynamicVariable(Compile.typedefInfo) + string);
            } else {
                symtabEntry.dynamicVariable(Compile.typedefInfo, Util.javaName(symtabEntry2) + string);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    static void fillValueBoxInfo(ValueBoxEntry valueBoxEntry) {
        TypedefEntry typedefEntry = ((InterfaceState)valueBoxEntry.state().elementAt((int)0)).entry;
        if (typedefEntry.type() != null) {
            Util.fillInfo(typedefEntry.type());
        }
        Util.fillInfo(typedefEntry);
    }

    public static String holderName(SymtabEntry symtabEntry) {
        TypedefEntry typedefEntry;
        String string = symtabEntry instanceof PrimitiveEntry ? (symtabEntry.name().equals("any") ? "org.omg.CORBA.AnyHolder" : (symtabEntry.name().equals("TypeCode") ? "org.omg.CORBA.TypeCodeHolder" : (symtabEntry.name().equals("Principal") ? "org.omg.CORBA.PrincipalHolder" : "org.omg.CORBA." + Util.capitalize(Util.javaQualifiedName(symtabEntry)) + "Holder"))) : (symtabEntry instanceof TypedefEntry ? (!(typedefEntry = (TypedefEntry)symtabEntry).arrayInfo().isEmpty() || typedefEntry.type() instanceof SequenceEntry || typedefEntry.typeName().equals("native") ? Util.javaQualifiedName(symtabEntry) + "Holder" : Util.holderName(symtabEntry.type())) : (symtabEntry instanceof StringEntry ? "org.omg.CORBA.StringHolder" : (symtabEntry instanceof ValueEntry ? (symtabEntry.name().equals("ValueBase") ? "org.omg.CORBA.ValueBaseHolder" : Util.javaQualifiedName(symtabEntry) + "Holder") : Util.javaQualifiedName(symtabEntry) + "Holder")));
        return string;
    }

    public static String helperName(SymtabEntry symtabEntry, boolean bl) {
        if (symtabEntry instanceof ValueEntry && symtabEntry.name().equals("ValueBase")) {
            return "org.omg.CORBA.ValueBaseHelper";
        }
        if (bl) {
            return Util.javaQualifiedName(symtabEntry) + "Helper";
        }
        return Util.javaName(symtabEntry) + "Helper";
    }

    public static void writePackage(PrintWriter printWriter, SymtabEntry symtabEntry) {
        Util.writePackage(printWriter, symtabEntry, (short)0);
    }

    public static void writePackage(PrintWriter printWriter, SymtabEntry symtabEntry, String string, short s) {
        if (string != null && !string.equals("")) {
            printWriter.println("package " + string.replace('/', '.') + ';');
            if (!Compile.compiler.importTypes.isEmpty()) {
                printWriter.println();
                Vector vector = Util.addImportLines(symtabEntry, Compile.compiler.importTypes, s);
                Util.printImports(vector, printWriter);
            }
        }
    }

    public static void writePackage(PrintWriter printWriter, SymtabEntry symtabEntry, short s) {
        String string = Util.containerFullName(symtabEntry.container());
        if (string != null && !string.equals("")) {
            printWriter.println("package " + string.replace('/', '.') + ';');
            if ((s != 3 || symtabEntry instanceof TypedefEntry) && !Compile.compiler.importTypes.isEmpty()) {
                printWriter.println();
                Vector vector = Util.addImportLines(symtabEntry, Compile.compiler.importTypes, s);
                Util.printImports(vector, printWriter);
            }
        }
    }

    private static void printImports(Vector vector, PrintWriter printWriter) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println("import " + (String)enumeration.nextElement() + ';');
        }
    }

    private static void addTo(Vector vector, String string) {
        if (string.startsWith("ValueBase") && (string.compareTo("ValueBase") == 0 || string.compareTo("ValueBaseHolder") == 0 || string.compareTo("ValueBaseHelper") == 0)) {
            return;
        }
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private static void addTo2(Vector vector, SymtabEntry symtabEntry, Vector vector2) {
        symtabEntry = Util.typeOf(symtabEntry);
        while (symtabEntry != null && (symtabEntry instanceof ValueBoxEntry || symtabEntry instanceof TypedefEntry || symtabEntry instanceof SequenceEntry)) {
            if (symtabEntry instanceof ValueBoxEntry) {
                SymtabEntry symtabEntry2 = (SymtabEntry)((InterfaceEntry)symtabEntry).state().elementAt(0);
                if (symtabEntry2.type() == null) continue;
                symtabEntry = Util.typeOf(symtabEntry2.type());
                continue;
            }
            symtabEntry = Util.typeOf(symtabEntry.type());
        }
        if (vector2.contains(symtabEntry)) {
            Util.addTo(vector, symtabEntry.name());
        }
    }

    private static Vector addImportLines(SymtabEntry symtabEntry, Vector vector, short s) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Vector vector2 = new Vector();
        if (symtabEntry instanceof ConstEntry) {
            object5 = (ConstEntry)symtabEntry;
            object4 = ((ConstEntry)object5).value().value();
            if (object4 instanceof ConstEntry && vector.contains(object4)) {
                Util.addTo(vector2, ((ConstEntry)object4).name());
            }
        } else if (symtabEntry instanceof ValueEntry && s == 2) {
            if (((ValueEntry)symtabEntry).derivedFrom().size() > 0 && !"ValueBase".equals(object4 = ((SymtabEntry)(object5 = (ValueEntry)((ValueEntry)symtabEntry).derivedFrom().elementAt(0))).name()) && vector.contains(object5)) {
                Util.addTo(vector2, object4 + "Helper");
            }
        } else if (symtabEntry instanceof InterfaceEntry && (s == 0 || s == 1)) {
            object5 = (InterfaceEntry)symtabEntry;
            if (object5 instanceof ValueEntry) {
                object4 = ((ValueEntry)object5).supports().elements();
                while (object4.hasMoreElements()) {
                    object3 = (SymtabEntry)object4.nextElement();
                    if (vector.contains(object3)) {
                        Util.addTo(vector2, ((SymtabEntry)object3).name() + "Operations");
                    }
                    if (s != 1) continue;
                    if (vector.contains(object3)) {
                        Util.addTo(vector2, ((SymtabEntry)object3).name());
                    }
                    object2 = Util.addImportLines((SymtabEntry)object3, vector, (short)1);
                    object = ((Vector)object2).elements();
                    while (object.hasMoreElements()) {
                        Util.addTo(vector2, (String)object.nextElement());
                    }
                }
            }
            object4 = ((InterfaceEntry)object5).derivedFrom().elements();
            while (object4.hasMoreElements()) {
                object3 = (SymtabEntry)object4.nextElement();
                if (vector.contains(object3)) {
                    Util.addTo(vector2, ((SymtabEntry)object3).name());
                    if (!(object3 instanceof ValueEntry)) {
                        Util.addTo(vector2, ((SymtabEntry)object3).name() + "Operations");
                    }
                }
                if (s != 1) continue;
                object2 = Util.addImportLines((SymtabEntry)object3, vector, (short)1);
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    Util.addTo(vector2, (String)object.nextElement());
                }
            }
            object4 = ((InterfaceEntry)object5).methods().elements();
            while (object4.hasMoreElements()) {
                Object object6;
                object3 = (MethodEntry)object4.nextElement();
                object2 = Util.typeOf(((SymtabEntry)object3).type());
                if (object2 != null && vector.contains(object2) && (s == 0 || s == 1)) {
                    Util.addTo2(vector2, (SymtabEntry)object2, vector);
                    Util.addTo(vector2, ((SymtabEntry)object2).name() + "Holder");
                    if (s == 1) {
                        Util.addTo(vector2, ((SymtabEntry)object2).name() + "Helper");
                    }
                }
                Util.checkForArrays((SymtabEntry)object2, vector, vector2);
                if (s == 1) {
                    Util.checkForBounds((SymtabEntry)object2, vector, vector2);
                }
                object = ((MethodEntry)object3).exceptions().elements();
                while (object.hasMoreElements()) {
                    object6 = (ExceptionEntry)object.nextElement();
                    if (!vector.contains(object6)) continue;
                    Util.addTo(vector2, ((SymtabEntry)object6).name());
                    Util.addTo(vector2, ((SymtabEntry)object6).name() + "Helper");
                }
                object6 = ((MethodEntry)object3).parameters().elements();
                while (object6.hasMoreElements()) {
                    ParameterEntry parameterEntry = (ParameterEntry)object6.nextElement();
                    SymtabEntry symtabEntry2 = Util.typeOf(parameterEntry.type());
                    if (vector.contains(symtabEntry2)) {
                        if (s == 1) {
                            Util.addTo(vector2, symtabEntry2.name() + "Helper");
                        }
                        if (parameterEntry.passType() == 0) {
                            Util.addTo2(vector2, symtabEntry2, vector);
                        } else {
                            Util.addTo(vector2, symtabEntry2.name() + "Holder");
                        }
                    }
                    Util.checkForArrays(symtabEntry2, vector, vector2);
                    if (s != 1) continue;
                    Util.checkForBounds(symtabEntry2, vector, vector2);
                }
            }
        } else if (symtabEntry instanceof StructEntry) {
            object5 = (StructEntry)symtabEntry;
            object4 = ((StructEntry)object5).members().elements();
            while (object4.hasMoreElements()) {
                object3 = (TypedefEntry)object4.nextElement();
                object2 = ((SymtabEntry)object3).type();
                if (vector.contains(object3 = Util.typeOf((SymtabEntry)object3))) {
                    Util.addTo2(vector2, (SymtabEntry)object3, vector);
                    if (s == 2) {
                        Util.addTo(vector2, ((SymtabEntry)object3).name() + "Helper");
                        if (object2 instanceof TypedefEntry) {
                            Util.addTo(vector2, ((SymtabEntry)object2).name() + "Helper");
                        }
                    }
                } else if (object2 instanceof TypedefEntry && vector.contains(object2) && s == 2) {
                    Util.addTo(vector2, ((SymtabEntry)object2).name() + "Helper");
                }
                Util.checkForArrays((SymtabEntry)object3, vector, vector2, s);
                Util.checkForBounds((SymtabEntry)object3, vector, vector2);
            }
        } else if (symtabEntry instanceof TypedefEntry) {
            object5 = (TypedefEntry)symtabEntry;
            object4 = Util.checkForArrayBase((TypedefEntry)object5, vector, vector2);
            if (s == 2) {
                Util.checkForArrayDimensions(object4, vector, vector2);
                try {
                    object3 = (String)((SymtabEntry)object5).dynamicVariable(Compile.typedefInfo);
                    int n = ((String)object3).indexOf(91);
                    if (n >= 0) {
                        object3 = ((String)object3).substring(0, n);
                    }
                    if ((object = (SymtabEntry)symbolTable.get(object3)) != null && vector.contains(object)) {
                        Util.addTo(vector2, ((SymtabEntry)object).name() + "Helper");
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                Util.checkForBounds(Util.typeOf((SymtabEntry)object5), vector, vector2);
                if (((SymtabEntry)object5).type() instanceof ValueBoxEntry && vector.contains(((SymtabEntry)object5).type())) {
                    Util.addTo(vector2, ((SymtabEntry)object5).type().name() + "Helper");
                }
            }
            object3 = Util.addImportLines(((SymtabEntry)object5).type(), vector, s);
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                Util.addTo(vector2, (String)object2.nextElement());
            }
        } else if (symtabEntry instanceof UnionEntry) {
            object5 = (UnionEntry)symtabEntry;
            object4 = Util.typeOf(((SymtabEntry)object5).type());
            if (object4 instanceof EnumEntry && vector.contains(object4)) {
                Util.addTo2(vector2, object4, vector);
            }
            object3 = ((UnionEntry)object5).branches().elements();
            while (object3.hasMoreElements()) {
                object2 = (UnionBranch)object3.nextElement();
                object = Util.typeOf(((UnionBranch)object2).typedef);
                if (vector.contains(object)) {
                    Util.addTo2(vector2, object, vector);
                    if (s == 2) {
                        Util.addTo(vector2, ((SymtabEntry)object).name() + "Helper");
                    }
                } else if (vector.contains(((UnionBranch)object2).typedef.type()) && s == 2) {
                    Util.addTo(vector2, ((UnionBranch)object2).typedef.type().name() + "Helper");
                }
                Util.checkForArrays(object, vector, vector2);
                Util.checkForBounds(object, vector, vector2);
            }
        }
        object5 = vector2.elements();
        while (object5.hasMoreElements()) {
            object4 = (String)object5.nextElement();
            object3 = (SymtabEntry)symbolTable.get(object4);
            if (object3 == null || !(object3 instanceof TypedefEntry) || ((TypedefEntry)(object2 = (TypedefEntry)object3)).arrayInfo().size() != 0 && ((SymtabEntry)object2).type() instanceof SequenceEntry) continue;
            vector2.removeElement(object4);
        }
        return vector2;
    }

    private static void checkForArrays(SymtabEntry symtabEntry, Vector vector, Vector vector2) {
        Util.checkForArrays(symtabEntry, vector, vector2, (short)5);
    }

    private static void checkForArrays(SymtabEntry symtabEntry, Vector vector, Vector vector2, short s) {
        if (symtabEntry instanceof TypedefEntry) {
            TypedefEntry typedefEntry = (TypedefEntry)symtabEntry;
            String string = Util.checkForArrayBase(typedefEntry, vector, vector2, s);
            Util.checkForArrayDimensions(string, vector, vector2);
        }
    }

    private static String checkForArrayBase(TypedefEntry typedefEntry, Vector vector, Vector vector2) {
        return Util.checkForArrayBase(typedefEntry, vector, vector2, (short)5);
    }

    private static String checkForArrayBase(TypedefEntry typedefEntry, Vector vector, Vector vector2, short s) {
        String string = "";
        try {
            SymtabEntry symtabEntry;
            String string2 = (String)typedefEntry.dynamicVariable(Compile.typedefInfo);
            int n = string2.indexOf(91);
            if (n >= 0) {
                string = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            if ((symtabEntry = (SymtabEntry)symbolTable.get(string2)) != null && vector.contains(symtabEntry)) {
                Util.addTo2(vector2, symtabEntry, vector);
                if (s == 2) {
                    Util.addTo(vector2, symtabEntry.name() + "Helper");
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return string;
    }

    private static void checkForArrayDimensions(String string, Vector vector, Vector vector2) {
        while (!string.equals("")) {
            int n;
            int n2 = string.indexOf(93);
            String string2 = string.substring(1, n2);
            string = string.substring(n2 + 1);
            SymtabEntry symtabEntry = (SymtabEntry)symbolTable.get(string2);
            if (symtabEntry == null && (n = string2.lastIndexOf(46)) >= 0) {
                symtabEntry = (SymtabEntry)symbolTable.get(string2.substring(0, n));
            }
            if (symtabEntry == null || !vector.contains(symtabEntry)) continue;
            Util.addTo(vector2, symtabEntry.name());
        }
    }

    private static void checkForBounds(SymtabEntry symtabEntry, Vector vector, Vector vector2) {
        SymtabEntry symtabEntry2 = symtabEntry;
        while (symtabEntry2 instanceof TypedefEntry) {
            symtabEntry2 = symtabEntry2.type();
        }
        if (symtabEntry2 instanceof StringEntry && ((StringEntry)symtabEntry2).maxSize() != null) {
            Util.checkForGlobalConstants(((StringEntry)symtabEntry2).maxSize().rep(), vector, vector2);
        } else if (symtabEntry2 instanceof SequenceEntry && ((SequenceEntry)symtabEntry2).maxSize() != null) {
            Util.checkForGlobalConstants(((SequenceEntry)symtabEntry2).maxSize().rep(), vector, vector2);
        }
    }

    private static void checkForGlobalConstants(String string, Vector vector, Vector vector2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " +-*()~&|^%<>");
        while (stringTokenizer.hasMoreTokens()) {
            SymtabEntry symtabEntry;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("/") || !((symtabEntry = (SymtabEntry)symbolTable.get(string2)) instanceof ConstEntry)) continue;
            int n = string2.indexOf(47);
            if (n < 0) {
                if (!vector.contains(symtabEntry)) continue;
                Util.addTo(vector2, symtabEntry.name());
                continue;
            }
            SymtabEntry symtabEntry2 = (SymtabEntry)symbolTable.get(string2.substring(0, n));
            if (!(symtabEntry2 instanceof InterfaceEntry) || !vector.contains(symtabEntry2)) continue;
            Util.addTo(vector2, symtabEntry2.name());
        }
    }

    public static void writeInitializer(String string, String string2, String string3, SymtabEntry symtabEntry, PrintWriter printWriter) {
        if (symtabEntry instanceof TypedefEntry) {
            TypedefEntry typedefEntry = (TypedefEntry)symtabEntry;
            Util.writeInitializer(string, string2, string3 + Util.sansArrayInfo(typedefEntry.arrayInfo()), typedefEntry.type(), printWriter);
        } else if (symtabEntry instanceof SequenceEntry) {
            Util.writeInitializer(string, string2, string3 + "[]", symtabEntry.type(), printWriter);
        } else if (symtabEntry instanceof EnumEntry) {
            if (string3.length() > 0) {
                printWriter.println(string + Util.javaName(symtabEntry) + ' ' + string2 + string3 + " = null;");
            } else {
                printWriter.println(string + Util.javaName(symtabEntry) + ' ' + string2 + " = null;");
            }
        } else if (symtabEntry instanceof PrimitiveEntry) {
            boolean bl = string3.length() > 0;
            String string4 = "";
            string4 = Util.javaPrimName(symtabEntry.name());
            if (string4.equals("boolean")) {
                printWriter.println(string + "boolean " + string2 + string3 + " = " + (bl ? "null;" : "false;"));
            } else if (string4.equals("org.omg.CORBA.TypeCode")) {
                printWriter.println(string + "org.omg.CORBA.TypeCode " + string2 + string3 + " = null;");
            } else if (string4.equals("org.omg.CORBA.Any")) {
                printWriter.println(string + "org.omg.CORBA.Any " + string2 + string3 + " = null;");
            } else if (string4.equals("org.omg.CORBA.Principal")) {
                printWriter.println(string + "org.omg.CORBA.Principal " + string2 + string3 + " = null;");
            } else {
                printWriter.println(string + string4 + ' ' + string2 + string3 + " = " + (bl ? "null;" : '(' + string4 + ")0;"));
            }
        } else {
            printWriter.println(string + Util.javaName(symtabEntry) + ' ' + string2 + string3 + " = null;");
        }
    }

    public static void writeInitializer(String string, String string2, String string3, SymtabEntry symtabEntry, String string4, PrintWriter printWriter) {
        if (symtabEntry instanceof TypedefEntry) {
            TypedefEntry typedefEntry = (TypedefEntry)symtabEntry;
            Util.writeInitializer(string, string2, string3 + Util.sansArrayInfo(typedefEntry.arrayInfo()), typedefEntry.type(), string4, printWriter);
        } else if (symtabEntry instanceof SequenceEntry) {
            Util.writeInitializer(string, string2, string3 + "[]", symtabEntry.type(), string4, printWriter);
        } else if (symtabEntry instanceof EnumEntry) {
            if (string3.length() > 0) {
                printWriter.println(string + Util.javaName(symtabEntry) + ' ' + string2 + string3 + " = " + string4 + ';');
            } else {
                printWriter.println(string + Util.javaName(symtabEntry) + ' ' + string2 + " = " + string4 + ';');
            }
        } else if (symtabEntry instanceof PrimitiveEntry) {
            boolean bl = string3.length() > 0;
            String string5 = "";
            string5 = Util.javaPrimName(symtabEntry.name());
            if (string5.equals("boolean")) {
                printWriter.println(string + "boolean " + string2 + string3 + " = " + string4 + ';');
            } else if (string5.equals("org.omg.CORBA.TypeCode")) {
                printWriter.println(string + "org.omg.CORBA.TypeCode " + string2 + string3 + " = " + string4 + ';');
            } else if (string5.equals("org.omg.CORBA.Any")) {
                printWriter.println(string + "org.omg.CORBA.Any " + string2 + string3 + " = " + string4 + ';');
            } else if (string5.equals("org.omg.CORBA.Principal")) {
                printWriter.println(string + "org.omg.CORBA.Principal " + string2 + string3 + " = " + string4 + ';');
            } else {
                printWriter.println(string + string5 + ' ' + string2 + string3 + " = " + string4 + ';');
            }
        } else {
            printWriter.println(string + Util.javaName(symtabEntry) + ' ' + string2 + string3 + " = " + string4 + ';');
        }
    }

    public static void mkdir(String string) {
        String string2;
        File file;
        if (string.length() > 0 && !(file = new File(string = ((string2 = ((Arguments)Compile.compiler.arguments).targetDir) + string).replace('/', File.separatorChar))).exists() && !file.mkdirs()) {
            System.err.println(Util.getMessage("Util.cantCreatePkg", string));
        }
    }

    public static void writeProlog(PrintWriter printWriter, String string) {
        String string2 = ((Arguments)Compile.compiler.arguments).targetDir;
        if (string2 != null) {
            string = string.substring(string2.length());
        }
        printWriter.println();
        printWriter.println("/**");
        printWriter.println("* " + string.replace(File.separatorChar, '/') + " .");
        printWriter.println("* " + Util.getMessage("toJavaProlog1", Util.getMessage("Version.product", Util.getMessage("Version.number"))));
        printWriter.println("* " + Util.getMessage("toJavaProlog2", Compile.compiler.arguments.file.replace(File.separatorChar, '/')));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.getDefault());
        if (Locale.getDefault() == Locale.JAPAN) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("JST"));
        } else {
            dateFormat.setTimeZone(TimeZone.getDefault());
        }
        printWriter.println("* " + dateFormat.format(new Date()));
        printWriter.println("*/");
        printWriter.println();
    }

    public static String stripLeadingUnderscores(String string) {
        while (string.startsWith("_")) {
            string = string.substring(1);
        }
        return string;
    }

    public static String stripLeadingUnderscoresFromID(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            do {
                string2 = string2 + string.substring(0, n + 1);
                string = string.substring(n + 1);
                while (string.startsWith("_")) {
                    string = string.substring(1);
                }
            } while ((n = string.indexOf(47)) >= 0);
        }
        return string2 + string;
    }

    public static String parseExpression(Expression expression) {
        if (expression instanceof Terminal) {
            return Util.parseTerminal((Terminal)expression);
        }
        if (expression instanceof BinaryExpr) {
            return Util.parseBinary((BinaryExpr)expression);
        }
        if (expression instanceof UnaryExpr) {
            return Util.parseUnary((UnaryExpr)expression);
        }
        return "(UNKNOWN_VALUE)";
    }

    static String parseTerminal(Terminal terminal) {
        if (terminal.value() instanceof ConstEntry) {
            ConstEntry constEntry = (ConstEntry)terminal.value();
            if (constEntry.container() instanceof InterfaceEntry) {
                return Util.javaQualifiedName(constEntry.container()) + '.' + constEntry.name();
            }
            return Util.javaQualifiedName(constEntry) + ".value";
        }
        if (terminal.value() instanceof Expression) {
            return '(' + Util.parseExpression((Expression)terminal.value()) + ')';
        }
        if (terminal.value() instanceof Character) {
            if (((Character)terminal.value()).charValue() == '\u000b') {
                return "'\\013'";
            }
            if (((Character)terminal.value()).charValue() == '\u0007') {
                return "'\\007'";
            }
            if (terminal.rep().startsWith("'\\x")) {
                return Util.hexToOctal(terminal.rep());
            }
            if (terminal.rep().equals("'\\?'")) {
                return "'?'";
            }
            return terminal.rep();
        }
        if (terminal.value() instanceof Boolean) {
            return terminal.value().toString();
        }
        if (terminal.value() instanceof BigInteger) {
            if (terminal.type().equals("unsigned long long") && ((BigInteger)terminal.value()).compareTo(Expression.llMax) > 0) {
                BigInteger bigInteger = (BigInteger)terminal.value();
                bigInteger = bigInteger.subtract(Expression.twoPow64);
                int n = terminal.rep().indexOf(41);
                if (n < 0) {
                    return bigInteger.toString() + 'L';
                }
                return '(' + bigInteger.toString() + 'L' + ')';
            }
            if (terminal.type().indexOf("long long") >= 0 || terminal.type().equals("unsigned long")) {
                String string = terminal.rep();
                int n = string.indexOf(41);
                if (n < 0) {
                    return string + 'L';
                }
                return string.substring(0, n) + 'L' + string.substring(n);
            }
            return terminal.rep();
        }
        if (terminal.value() instanceof String) {
            return Util.formatJava(terminal.rep());
        }
        return terminal.rep();
    }

    private static String formatJava(String string) {
        int n;
        for (n = 0; n < escapeLiterals.length; ++n) {
            int n2 = 0;
            while (n2 != -1) {
                if ((n2 = string.indexOf(escapeLiterals[n][0], n2 + 1)) == -1 || Util.checkEscapeChar(string, n2 - 1)) continue;
                string = string.substring(0, n2) + escapeLiterals[n][1] + string.substring(n2 + escapeLiterals[n][0].length());
            }
        }
        for (n = 0; n < string.length() && (n = string.indexOf("\\", n)) != -1; ++n) {
            if (string.charAt(n + 1) != 'x' && string.charAt(n + 1) != 'X') continue;
            String string2 = "";
            if (string.length() >= n + 4) {
                string2 = string.substring(n + 4);
            }
            string = string.substring(0, n) + Util.hexToOctal2(string.substring(n, n + 4)) + string2;
        }
        return string;
    }

    private static boolean checkEscapeChar(String string, int n) {
        int n2 = 1;
        for (int i = n; i >= 0 && string.charAt(i) == '\\'; --i) {
            ++n2;
        }
        return n2 % 2 == 0;
    }

    private static String findNumbers(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; Character.isDigit(string.charAt(n)) && i < n2; ++i) {
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    static String hexToOctal(String string) {
        string = string.substring(3, string.length() - 1);
        return "'\\" + Integer.toString(Integer.parseInt(string, 16), 8) + "'";
    }

    static String hexToOctal2(String string) {
        string = string.substring(2, string.length());
        String string2 = Integer.toString(Integer.parseInt(string, 16), 8);
        for (int i = 3 - string2.length(); i > 0; --i) {
            string2 = "0" + string2;
        }
        return "\\" + string2;
    }

    private static String octalToUnicode(String string) {
        String string2 = new String(Integer.toString(Integer.parseInt(string, 8), 16));
        int n = 4 - string2.length();
        for (int i = 0; i < n; ++i) {
            string2 = "0" + string2;
        }
        string2 = "\\u" + string2;
        return string2;
    }

    static String parseBinary(BinaryExpr binaryExpr) {
        String string = "";
        if (binaryExpr.value() instanceof Float || binaryExpr.value() instanceof Double) {
            string = "(double)";
            if (!(binaryExpr instanceof Plus || binaryExpr instanceof Minus || binaryExpr instanceof Times || binaryExpr instanceof Divide)) {
                System.err.println("Operator " + binaryExpr.op() + " is invalid on floating point numbers");
            }
        } else if (binaryExpr.value() instanceof Number) {
            string = binaryExpr.type().indexOf("long long") >= 0 ? "(long)" : "(int)";
        } else {
            string = "";
            System.err.println("Unknown type in constant expression");
        }
        if (binaryExpr.type().equals("unsigned long long")) {
            BigInteger bigInteger = (BigInteger)binaryExpr.value();
            if (bigInteger.compareTo(Expression.llMax) > 0) {
                bigInteger = bigInteger.subtract(Expression.twoPow64);
            }
            return string + '(' + bigInteger.toString() + 'L' + ')';
        }
        return string + '(' + Util.parseExpression(binaryExpr.left()) + ' ' + binaryExpr.op() + ' ' + Util.parseExpression(binaryExpr.right()) + ')';
    }

    static String parseUnary(UnaryExpr unaryExpr) {
        if (!(unaryExpr.value() instanceof Number)) {
            return "(UNKNOWN_VALUE)";
        }
        if ((unaryExpr.value() instanceof Float || unaryExpr.value() instanceof Double) && unaryExpr instanceof Not) {
            return "(UNKNOWN_VALUE)";
        }
        String string = "";
        string = unaryExpr.operand().value() instanceof Float || unaryExpr.operand().value() instanceof Double ? "(double)" : (unaryExpr.type().indexOf("long long") >= 0 ? "(long)" : "(int)");
        if (unaryExpr.type().equals("unsigned long long")) {
            BigInteger bigInteger = (BigInteger)unaryExpr.value();
            if (bigInteger.compareTo(Expression.llMax) > 0) {
                bigInteger = bigInteger.subtract(Expression.twoPow64);
            }
            return string + '(' + bigInteger.toString() + 'L' + ')';
        }
        return string + unaryExpr.op() + Util.parseExpression(unaryExpr.operand());
    }

    public static boolean IDLEntity(SymtabEntry symtabEntry) {
        boolean bl = true;
        if (symtabEntry instanceof PrimitiveEntry || symtabEntry instanceof StringEntry) {
            bl = false;
        } else if (symtabEntry instanceof TypedefEntry) {
            bl = Util.IDLEntity(symtabEntry.type());
        }
        return bl;
    }
}

