/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.AttributeEntry;
import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.toJavaPortable.Arguments;
import com.ibm.idl.toJavaPortable.AuxGen;
import com.ibm.idl.toJavaPortable.Compile;
import com.ibm.idl.toJavaPortable.MethodGen;
import com.ibm.idl.toJavaPortable.Util;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.InitialNameService;
import com.sun.corba.se.spi.activation.Locator;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.Server;
import com.sun.corba.se.spi.activation.ServerManager;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynFixed;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynValue;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;

public class Stub
implements AuxGen {
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected Vector methodList = null;
    protected String classSuffix = "";
    private static final Set<String> pseudoIDLInterfaceTypeNames = Stub.initPseudoIDLInterfaceTypeNames();
    private static final Set<String> corbaServiceIDLInterfaceTypeNames = Stub.initCorbaServiceIDLInterfaceTypeNames();

    @Override
    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        if ((((Arguments)Compile.compiler.arguments).suppress & 4) != 0) {
            return;
        }
        this.symbolTable = hashtable;
        this.i = (InterfaceEntry)symtabEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.classSuffix = "Stub";
    }

    protected void openStream() {
        String string = '_' + this.i.name() + this.classSuffix;
        String string2 = Util.containerFullName(this.i.container());
        if (string2 != null && !string2.equals("")) {
            Util.mkdir(string2);
            string = string2 + '/' + string;
        }
        this.stream = Util.getStream(string.replace('/', File.separatorChar) + ".java", this.i);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)1);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        this.writeClassDeclaration();
        this.stream.println('{');
    }

    protected void writeClassDeclaration() {
        String string = Compile.compiler.arguments.corbaLevel.gte(2.3f) ? "_2_3" : "";
        this.stream.print("public class _" + this.i.name() + this.classSuffix + " extends org.omg.CORBA" + string + ".portable.ObjectImpl");
        this.stream.println(" implements " + Util.javaName(this.i));
    }

    protected void writeBody() {
        this.writeCtors();
        this.buildMethodList();
        this.writeMethods();
        this.writeCORBAObjectMethods();
        if (this.i.name().equals("DynAnyFactory")) {
            this.writeSerializationMethodsForDynAnyFactoryStub();
        } else if (Stub.isPseudoIDLInterface(this.i.name())) {
            this.writeSerializationMethodsForPseudoIDLInterfaceStub(this.i.name());
        } else if (Stub.isCorbaServiceIDLInterface(this.i.name())) {
            this.writeSerializationMethodsForCorbaServiceIDLInterfaceStub(this.i.name());
        } else {
            this.writeSerializationMethods();
        }
    }

    protected static boolean isPseudoIDLInterface(String string) {
        return pseudoIDLInterfaceTypeNames.contains(string);
    }

    protected static boolean isCorbaServiceIDLInterface(String string) {
        return corbaServiceIDLInterfaceTypeNames.contains(string);
    }

    protected void writeClosing() {
        this.stream.println("} // class _" + this.i.name() + this.classSuffix);
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeCtors() {
        String string = this.i.name();
        this.stream.println("  // Constructors");
        this.stream.println("  // NOTE:  If the default constructor is used, the");
        this.stream.println("  //        object is useless until _set_delegate (...)");
        this.stream.println("  //        is called.");
        this.stream.println("  public _" + string + this.classSuffix + " ()");
        this.stream.println("  {");
        this.stream.println("    super ();");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public _" + string + this.classSuffix + " (org.omg.CORBA.portable.Delegate delegate)");
        this.stream.println("  {");
        this.stream.println("    super ();");
        this.stream.println("    _set_delegate (delegate);");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void buildMethodList() {
        this.methodList = new Vector();
        this.buildMethodList(this.i);
    }

    private void buildMethodList(InterfaceEntry interfaceEntry) {
        Enumeration enumeration = interfaceEntry.methods().elements();
        while (enumeration.hasMoreElements()) {
            this.addMethod((MethodEntry)enumeration.nextElement());
        }
        Enumeration enumeration2 = interfaceEntry.derivedFrom().elements();
        while (enumeration2.hasMoreElements()) {
            InterfaceEntry interfaceEntry2 = (InterfaceEntry)enumeration2.nextElement();
            if (interfaceEntry2.name().equals("Object")) continue;
            this.buildMethodList(interfaceEntry2);
        }
    }

    private void addMethod(MethodEntry methodEntry) {
        if (!this.methodList.contains(methodEntry)) {
            this.methodList.addElement(methodEntry);
        }
    }

    protected void writeMethods() {
        int n = this.methodList.size();
        Enumeration enumeration = this.methodList.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AttributeEntry) || ((AttributeEntry)e).readOnly()) continue;
            ++n;
        }
        int n2 = 0;
        for (int i = 0; i < this.methodList.size(); ++i) {
            MethodEntry methodEntry = (MethodEntry)this.methodList.elementAt(i);
            ((MethodGen)methodEntry.generator()).stub(this.symbolTable, methodEntry, this.stream, n2, this.i.isAbstract());
            if (methodEntry instanceof AttributeEntry && !((AttributeEntry)methodEntry).readOnly()) {
                n2 += 2;
                continue;
            }
            ++n2;
        }
    }

    private void buildIDList(InterfaceEntry interfaceEntry, Vector vector) {
        if (!interfaceEntry.fullName().equals("org/omg/CORBA/Object")) {
            String string = Util.stripLeadingUnderscoresFromID(interfaceEntry.repositoryID().ID());
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            Enumeration enumeration = interfaceEntry.derivedFrom().elements();
            while (enumeration.hasMoreElements()) {
                this.buildIDList((InterfaceEntry)enumeration.nextElement(), vector);
            }
        }
    }

    private void writeIDs() {
        Vector vector = new Vector();
        this.buildIDList(this.i, vector);
        Enumeration enumeration = vector.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                this.stream.println(", ");
            }
            this.stream.print("    \"" + (String)enumeration.nextElement() + '\"');
        }
    }

    protected void writeCORBAObjectMethods() {
        this.stream.println("  // Type-specific CORBA::Object operations");
        this.stream.println("  private static String[] __ids = {");
        this.writeIDs();
        this.stream.println("};");
        this.stream.println();
        this.stream.println("  public String[] _ids ()");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
        String string = Util.javaQualifiedName(this.i);
        if (!this.i.isAbstract()) {
            string = string + "Operations";
        }
        this.stream.println("  final public static java.lang.Class _opsClass =");
        this.stream.println("    " + string + ".class;");
        this.stream.println();
    }

    protected void writeSerializationMethods() {
        this.stream.println("  private void readObject (java.io.ObjectInputStream s)");
        this.stream.println("  {");
        this.stream.println("     try ");
        this.stream.println("     {");
        this.stream.println("       String str = s.readUTF ();");
        this.stream.println("       org.omg.CORBA.Object obj = org.omg.CORBA.ORB.init ((String[])null, null).string_to_object (str);");
        this.stream.println("       org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();");
        this.stream.println("       _set_delegate (delegate);");
        this.stream.println("     } catch (java.io.IOException e) {}");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private void writeObject (java.io.ObjectOutputStream s)");
        this.stream.println("  {");
        this.stream.println("     try ");
        this.stream.println("     {");
        this.stream.println("       String str = org.omg.CORBA.ORB.init ((String[])null, null).object_to_string (this);");
        this.stream.println("       s.writeUTF (str);");
        this.stream.println("     } catch (java.io.IOException e) {}");
        this.stream.println("  }");
    }

    protected void writeSerializationMethodsForDynAnyFactoryStub() {
        this.stream.println("  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String str = s.readUTF ();");
        this.stream.println("     if (iorCheckEnabled() && !allowCorbanameInIOR()) {");
        this.stream.println("       if (!str.startsWith(\"IOR:\")) {");
        this.stream.println("         throw new java.io.IOException(\"DynAnyFactory only supports IOR format for Stringified Object Reference:  \" + str);");
        this.stream.println("       }");
        this.stream.println("     }");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     org.omg.CORBA.Object obj = orb.string_to_object (str);");
        this.stream.println("     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();");
        this.stream.println("     _set_delegate (delegate);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     String str = orb.object_to_string (this);");
        this.stream.println("     s.writeUTF (str);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private static boolean iorCheckEnabled() ");
        this.stream.println("  {");
        this.stream.println("     return !java.security.AccessController.doPrivileged(");
        this.stream.println("       new java.security.PrivilegedAction<Boolean>() {");
        this.stream.println("         public Boolean run() {");
        this.stream.println("             return Boolean");
        this.stream.println("               .getBoolean(");
        this.stream.println("                 \"org.omg.DynamicAny.DynAnyFactoryStub.disableIORCheck\");");
        this.stream.println("         }");
        this.stream.println("       });");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private static boolean allowCorbanameInIOR() ");
        this.stream.println("  {");
        this.stream.println("     return java.security.AccessController.doPrivileged(");
        this.stream.println("       new java.security.PrivilegedAction<Boolean>() {");
        this.stream.println("         public Boolean run() {");
        this.stream.println("             return Boolean");
        this.stream.println("               .getBoolean(");
        this.stream.println("                 \"com.sun.CORBA.DynamicAny.Stubs.allowCorbanameInIOR\");");
        this.stream.println("         }");
        this.stream.println("       });");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeSerializationMethodsForPseudoIDLInterfaceStub(String string) {
        this.stream.println("  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String str = s.readUTF ();");
        this.stream.println("     if (!allowCorbanameInIOR()) {");
        this.stream.println("       if (!str.startsWith(\"IOR:\")) {");
        this.stream.println("         throw new java.io.IOException(\" " + string + " only supports IOR format for Stringified Object Reference:  \" + str);");
        this.stream.println("       }");
        this.stream.println("     }");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     org.omg.CORBA.Object obj = orb.string_to_object (str);");
        this.stream.println("     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();");
        this.stream.println("     _set_delegate (delegate);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     String str = orb.object_to_string (this);");
        this.stream.println("     s.writeUTF (str);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private static boolean allowCorbanameInIOR() ");
        this.stream.println("  {");
        this.stream.println("     return java.security.AccessController.doPrivileged(");
        this.stream.println("       new java.security.PrivilegedAction<Boolean>() {");
        this.stream.println("         public Boolean run() {");
        this.stream.println("             return Boolean");
        this.stream.println("               .getBoolean(");
        this.stream.println("                 \"com.sun.CORBA.DynamicAny.Stubs.allowCorbanameInIOR\");");
        this.stream.println("         }");
        this.stream.println("       });");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeSerializationMethodsForCorbaServiceIDLInterfaceStub(String string) {
        this.stream.println("  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String str = s.readUTF ();");
        this.stream.println("     if (!allowCorbaNameInIOR()) {");
        this.stream.println("       if (!str.startsWith(\"IOR:\")) {");
        this.stream.println("         throw new java.io.IOException(\" " + string + " only supports IOR format for Stringified Object Reference:  \" + str);");
        this.stream.println("       }");
        this.stream.println("     }");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     org.omg.CORBA.Object obj = orb.string_to_object (str);");
        this.stream.println("     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();");
        this.stream.println("     _set_delegate (delegate);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     String str = orb.object_to_string (this);");
        this.stream.println("     s.writeUTF (str);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private static boolean allowCorbaNameInIOR() ");
        this.stream.println("  {");
        this.stream.println("     return java.security.AccessController.doPrivileged(");
        this.stream.println("       new java.security.PrivilegedAction<Boolean>() {");
        this.stream.println("         public Boolean run() {");
        this.stream.println("           String prop = System.getProperty(\"com.sun.CORBA.IDL.Stubs.allowCorbanameInIOR\");");
        this.stream.println("             return prop == null ? true :");
        this.stream.println("               (prop.equalsIgnoreCase(\"false\") ? false : true);");
        this.stream.println("         }");
        this.stream.println("       });");
        this.stream.println("  }");
        this.stream.println();
    }

    private static Set<String> initCorbaServiceIDLInterfaceTypeNames() {
        Set<Class<?>> set = Stub.initCorbaServiceIDLInterfaceTypes();
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (Class<?> clazz : set) {
            stringArray[n++] = clazz.getSimpleName();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }

    private static Set<Class<?>> initCorbaServiceIDLInterfaceTypes() {
        Class[] classArray = new Class[]{Activator.class, InitialNameService.class, Locator.class, Repository.class, ServerManager.class, Server.class, BindingIterator.class, NamingContextExt.class, NamingContext.class, ServantActivator.class, ServantLocator.class};
        return new HashSet(Arrays.asList(classArray));
    }

    private static Set<String> initPseudoIDLInterfaceTypeNames() {
        Set<Class<?>> set = Stub.initPseudoIDLInterfaceTypes();
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (Class<?> clazz : set) {
            stringArray[n++] = clazz.getSimpleName();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }

    private static Set<Class<?>> initPseudoIDLInterfaceTypes() {
        Class[] classArray = new Class[]{DynAnyFactory.class, DynAny.class, DynArray.class, DynEnum.class, DynFixed.class, DynSequence.class, DynStruct.class, DynUnion.class, DynValue.class};
        return new HashSet(Arrays.asList(classArray));
    }
}

