/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyFactory;
import com.ibm.crypto.hdwrCCA.provider.RSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.a;
import com.ibm.crypto.hdwrCCA.provider.o;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import javax.security.auth.DestroyFailedException;

public final class RSAPrivateHWKey
extends PrivateKeyInfo
implements RSAPrivateCrtKey,
Serializable {
    static final long serialVersionUID = 4391380867216055006L;
    private boolean hasBeenDestroyed;
    private byte[] keyLabel;
    private byte[] externalKeyToken;
    private RSAKeyHWAttributes keyAttribs;
    private RSAUtil.KeyType rsaPssKeyType;
    private static Debug debug;
    private static String className;
    private static final String[] a;

    @Deprecated
    public RSAPrivateHWKey(byte[] byArray, RSAKeyHWAttributes rSAKeyHWAttributes) throws InvalidKeyException {
        this((AlgorithmId)new AlgIdRSA(), byArray, rSAKeyHWAttributes);
    }

    RSAPrivateHWKey(AlgorithmId algorithmId, byte[] byArray, RSAKeyHWAttributes rSAKeyHWAttributes) throws InvalidKeyException {
        block12: {
            block11: {
                this.hasBeenDestroyed = false;
                this.externalKeyToken = null;
                this.keyAttribs = null;
                this.rsaPssKeyType = null;
                this.keyLabel = (byte[])byArray.clone();
                this.keyAttribs = new RSAKeyHWAttributes(rSAKeyHWAttributes.getKeyType(), rSAKeyHWAttributes.getKeyUsage());
                if (algorithmId != null) {
                    try {
                        if (!algorithmId.getOID().equals(AlgorithmId.RSAPSS_oid)) break block11;
                        this.rsaPssKeyType = RSAUtil.KeyType.PSS;
                        break block12;
                    }
                    catch (IOException iOException) {
                        throw RSAPrivateHWKey.b(iOException);
                    }
                }
            }
            this.rsaPssKeyType = RSAUtil.KeyType.RSA;
        }
        this.algid = new AlgIdRSA();
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(4, this.keyLabel)};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[1], iOException);
                }
            }
            catch (IOException iOException2) {
                throw RSAPrivateHWKey.b(iOException2);
            }
            String[] stringArray = a;
            throw new InvalidKeyException(stringArray[28] + iOException.getMessage());
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[71]);
            }
        }
        catch (IOException iOException) {
            throw RSAPrivateHWKey.b(iOException);
        }
    }

    RSAPrivateHWKey(byte[] byArray, byte[] byArray2, RSAKeyHWAttributes rSAKeyHWAttributes) throws InvalidKeyException {
        this((AlgorithmId)new AlgIdRSA(), byArray, byArray2, rSAKeyHWAttributes);
    }

    /*
     * Loose catch block
     */
    RSAPrivateHWKey(AlgorithmId algorithmId, byte[] byArray, byte[] byArray2, RSAKeyHWAttributes rSAKeyHWAttributes) throws InvalidKeyException {
        block14: {
            block13: {
                this.hasBeenDestroyed = false;
                this.externalKeyToken = null;
                this.keyAttribs = null;
                this.rsaPssKeyType = null;
                this.keyLabel = (byte[])byArray.clone();
                if (byArray2 != null) {
                    this.externalKeyToken = (byte[])byArray2.clone();
                }
                this.keyAttribs = new RSAKeyHWAttributes(rSAKeyHWAttributes.getKeyType(), rSAKeyHWAttributes.getKeyUsage());
                if (algorithmId == null) break block13;
                try {
                    block15: {
                        if (!algorithmId.getOID().equals(AlgorithmId.RSAPSS_oid)) break block13;
                        break block15;
                        catch (IOException iOException) {
                            throw RSAPrivateHWKey.b(iOException);
                        }
                    }
                    this.rsaPssKeyType = RSAUtil.KeyType.PSS;
                    break block14;
                }
                catch (IOException iOException) {
                    throw RSAPrivateHWKey.b(iOException);
                }
            }
            this.rsaPssKeyType = RSAUtil.KeyType.RSA;
        }
        this.algid = new AlgIdRSA();
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(4, this.keyLabel)};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[71], iOException);
                }
            }
            catch (IOException iOException2) {
                throw RSAPrivateHWKey.b(iOException2);
            }
            String[] stringArray = a;
            throw new InvalidKeyException(stringArray[10] + iOException.getMessage());
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[71]);
            }
        }
        catch (IOException iOException) {
            throw RSAPrivateHWKey.b(iOException);
        }
    }

    protected RSAPrivateHWKey(byte[] byArray) throws InvalidKeyException {
        this(byArray, false);
    }

    /*
     * Unable to fully structure code
     */
    protected RSAPrivateHWKey(byte[] var1_1, boolean var2_2) throws InvalidKeyException {
        super();
        this.hasBeenDestroyed = false;
        this.externalKeyToken = null;
        this.keyAttribs = null;
        this.rsaPssKeyType = null;
        if (RSAPrivateHWKey.debug != null) {
            var14_3 = RSAPrivateHWKey.a;
            RSAPrivateHWKey.debug.entry(Debug.TYPE_PUBLIC, (Object)RSAPrivateHWKey.className, var14_3[71], (Object)var1_1);
        }
        try {
            block27: {
                block26: {
                    block28: {
                        var3_4 = null;
                        var4_7 = new DerInputStream(var1_1);
                        var5_8 = var4_7.getSequence(var1_1.length);
                        this.algid = AlgorithmId.parse((DerValue)var5_8[1]);
                        if (var2_2) ** GOTO lbl27
                        if (this.algid == null) break block26;
                        break block28;
                        catch (IOException v0) {
                            throw RSAPrivateHWKey.b(v0);
                        }
                    }
                    try {
                        block29: {
                            if (!this.algid.getOID().equals(AlgorithmId.RSAPSS_oid)) break block26;
                            break block29;
                            catch (IOException v1) {
                                throw RSAPrivateHWKey.b(v1);
                            }
                        }
                        this.rsaPssKeyType = RSAUtil.KeyType.PSS;
                        break block27;
                    }
                    catch (IOException v2) {
                        throw RSAPrivateHWKey.b(v2);
                    }
                }
                this.rsaPssKeyType = RSAUtil.KeyType.RSA;
            }
            this.algid = new AlgIdRSA();
            var6_9 = var5_8[2].getOctetString();
            var7_10 = new DerInputStream(var6_9);
            var8_11 = var7_10.getSequence(var6_9.length);
            var9_12 = 9;
            var10_13 = 2;
            var11_14 = null;
            if (var8_11.length == var9_12) {
                var12_15 = new RSAPrivateCrtKeySpec(var8_11[1].getInteger(), var8_11[2].getInteger(), var8_11[3].getInteger(), var8_11[4].getInteger(), var8_11[5].getInteger(), var8_11[6].getInteger(), var8_11[7].getInteger(), var8_11[8].getInteger());
                var13_17 = new RSAKeyFactory(this.rsaPssKeyType);
                var11_14 = (RSAPrivateHWKey)var13_17.engineGeneratePrivate(var12_15);
            } else if (var8_11.length == var10_13) {
                var12_16 = new RSAPrivateKeySpec(var8_11[0].getInteger(), var8_11[1].getInteger());
                var13_18 = new RSAKeyFactory(this.rsaPssKeyType);
                var11_14 = (RSAPrivateHWKey)var13_18.engineGeneratePrivate(var12_16);
            } else {
                try {
                    if (RSAPrivateHWKey.debug != null) {
                        RSAPrivateHWKey.debug.text(Debug.TYPE_PUBLIC, RSAPrivateHWKey.className, RSAPrivateHWKey.a[71], RSAPrivateHWKey.a[52] + var8_11.length);
                    }
                }
                catch (IOException v3) {
                    throw RSAPrivateHWKey.b(v3);
                }
                var14_3 = RSAPrivateHWKey.a;
                throw new InvalidKeyException(var14_3[38]);
            }
            this.keyLabel = var11_14.getToken();
            this.externalKeyToken = var11_14.getExternalKeyToken();
            this.keyAttribs = new RSAKeyHWAttributes(var11_14.getType(), var11_14.getUsage());
            this.key = var11_14.getKeyBytes();
        }
        catch (IOException var3_5) {
            try {
                if (RSAPrivateHWKey.debug != null) {
                    RSAPrivateHWKey.debug.exception(Debug.TYPE_PUBLIC, RSAPrivateHWKey.className, RSAPrivateHWKey.a[71], var3_5);
                }
            }
            catch (IOException v4) {
                throw RSAPrivateHWKey.b(v4);
            }
            var14_3 = RSAPrivateHWKey.a;
            throw new InvalidKeyException(var14_3[41]);
        }
        catch (Exception var3_6) {
            try {
                if (RSAPrivateHWKey.debug != null) {
                    RSAPrivateHWKey.debug.exception(Debug.TYPE_PUBLIC, RSAPrivateHWKey.className, RSAPrivateHWKey.a[71], var3_6);
                }
            }
            catch (IOException v5) {
                throw RSAPrivateHWKey.b(v5);
            }
            var14_3 = RSAPrivateHWKey.a;
            throw new InvalidKeyException(var14_3[75], var3_6);
        }
        try {
            if (RSAPrivateHWKey.debug != null) {
                RSAPrivateHWKey.debug.exit(Debug.TYPE_PUBLIC, RSAPrivateHWKey.className, RSAPrivateHWKey.a[71]);
            }
        }
        catch (IOException v6) {
            throw RSAPrivateHWKey.b(v6);
        }
    }

    @Override
    public String getFormat() {
        String string = null;
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[14]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[59]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[30], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw RSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        switch (this.getType()) {
            case 0: {
                String[] stringArray = a;
                string = stringArray[37];
                break;
            }
            case 1: {
                String[] stringArray = a;
                string = stringArray[11];
                break;
            }
            case 2: {
                String[] stringArray = a;
                string = stringArray[16];
                break;
            }
            default: {
                String[] stringArray = a;
                string = stringArray[17];
            }
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[30], string);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        return string;
    }

    @Override
    public byte[] getEncoded() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[12]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[54], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw RSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        byte[] byArray = this.getToken();
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[54], byArray);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        return byArray;
    }

    public byte[] getToken() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[48]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[65], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw RSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[65], this.keyLabel);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        try {
            if (this.keyLabel != null) {
                return (byte[])this.keyLabel.clone();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        return null;
    }

    public String getLabelString() throws InvalidKeyException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[51]);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw RSAPrivateHWKey.b(invalidKeyException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[43], illegalStateException);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw RSAPrivateHWKey.b(invalidKeyException);
            }
            throw illegalStateException;
        }
        if (this.getType() != 0) {
            String[] stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[33]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[43], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[43]);
                }
            }
            catch (InvalidKeyException invalidKeyException2) {
                throw RSAPrivateHWKey.b(invalidKeyException2);
            }
            throw invalidKeyException;
        }
        String string = new String(this.keyLabel, o.c);
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[43], string);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw RSAPrivateHWKey.b(invalidKeyException);
        }
        return string;
    }

    public byte[] getExternalKeyToken() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[46]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[73], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw RSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[73], this.externalKeyToken);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        try {
            if (this.externalKeyToken != null) {
                return (byte[])this.externalKeyToken.clone();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        return null;
    }

    public byte getType() {
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[69], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw RSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        return this.keyAttribs.getKeyType();
    }

    public byte getUsage() {
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[67], illegalStateException);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                throw RSAPrivateHWKey.b(illegalStateException2);
            }
            throw illegalStateException;
        }
        return this.keyAttribs.getKeyUsage();
    }

    @Override
    public BigInteger getModulus() throws UnsupportedOperationException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[64]);
                debug.text(Debug.TYPE_PUBLIC, className, a[78], a[22]);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw RSAPrivateHWKey.b(unsupportedOperationException);
        }
        throw new UnsupportedOperationException(a[74]);
    }

    @Override
    public BigInteger getPrivateExponent() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[49]);
                debug.text(Debug.TYPE_PUBLIC, className, a[45], a[63]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[60]);
    }

    @Override
    public BigInteger getPublicExponent() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[44]);
                debug.text(Debug.TYPE_PUBLIC, className, a[4], a[6]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[42]);
    }

    @Override
    public BigInteger getPrimeP() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[36]);
                debug.text(Debug.TYPE_PUBLIC, className, a[34], a[57]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[40]);
    }

    @Override
    public BigInteger getPrimeQ() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[66]);
                debug.text(Debug.TYPE_PUBLIC, className, a[55], a[8]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[24]);
    }

    @Override
    public BigInteger getPrimeExponentP() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[3]);
                debug.text(Debug.TYPE_PUBLIC, className, a[18], a[56]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[47]);
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[7]);
                debug.text(Debug.TYPE_PUBLIC, className, a[70], a[50]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[62]);
    }

    @Override
    public BigInteger getCrtCoefficient() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[13]);
                debug.text(Debug.TYPE_PUBLIC, className, a[2], a[35]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        throw new UnsupportedOperationException(a[26]);
    }

    public String toString() {
        String string;
        block13: {
            block12: {
                try {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, a[77]);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw RSAPrivateHWKey.b(illegalStateException);
                }
                if (this.isDestroyed()) {
                    String[] stringArray = a;
                    IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[21], illegalStateException);
                        }
                    }
                    catch (IllegalStateException illegalStateException2) {
                        throw RSAPrivateHWKey.b(illegalStateException2);
                    }
                    throw illegalStateException;
                }
                string = null;
                try {
                    if (Security.getProvider(a[27]) != null || Security.getProvider(a[9]) != null) break block12;
                }
                catch (IllegalStateException illegalStateException) {
                    throw RSAPrivateHWKey.b(illegalStateException);
                }
                String[] stringArray = a;
                string = new String(stringArray[0]);
                break block13;
            }
            String[] stringArray = a;
            string = new String(stringArray[31]);
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[21]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        a a2 = new a();
        String string2 = a2.encodeBuffer(this.keyLabel);
        return string + a[76] + string2 + "\n";
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        try {
            if (this.rsaPssKeyType == RSAUtil.KeyType.PSS) {
                return PSSParameterSpec.DEFAULT;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        return null;
    }

    protected void parseKeyBits() throws IOException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[15]);
            }
        }
        catch (Exception exception) {
            throw RSAPrivateHWKey.b(exception);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[23], illegalStateException);
                }
            }
            catch (Exception exception) {
                throw RSAPrivateHWKey.b(exception);
            }
            throw illegalStateException;
        }
        try {
            DerValue derValue = new DerValue(this.key);
            try {
                this.keyLabel = derValue.getData().getOctetString();
                if (derValue.getData().available() != 0) {
                    throw new IOException(a[58]);
                }
            }
            catch (Exception exception) {
                throw RSAPrivateHWKey.b(exception);
            }
        }
        catch (Exception exception) {
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[23], exception);
                }
            }
            catch (Exception exception2) {
                throw RSAPrivateHWKey.b(exception2);
            }
            throw new IOException(exception.getMessage());
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[23]);
            }
        }
        catch (Exception exception) {
            throw RSAPrivateHWKey.b(exception);
        }
    }

    public void deletePKDSEntry() throws InvalidKeyException {
        block20: {
            block19: {
                try {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, a[5]);
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw RSAPrivateHWKey.b(invalidKeyException);
                }
                if (this.isDestroyed()) {
                    String[] stringArray = a;
                    IllegalStateException illegalStateException = new IllegalStateException(stringArray[19]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[53], illegalStateException);
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw RSAPrivateHWKey.b(invalidKeyException);
                    }
                    throw illegalStateException;
                }
                if (this.getType() != 0) {
                    String[] stringArray = a;
                    InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[72]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[53], invalidKeyException);
                            debug.exit(Debug.TYPE_PUBLIC, className, stringArray[53]);
                        }
                    }
                    catch (InvalidKeyException invalidKeyException2) {
                        throw RSAPrivateHWKey.b(invalidKeyException2);
                    }
                    throw invalidKeyException;
                }
                byte[] byArray = this.getToken();
                try {
                    if (byArray.length > 64) break block19;
                    KeyPairUtils.c(byArray);
                    break block20;
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw RSAPrivateHWKey.b(invalidKeyException);
                }
            }
            String[] stringArray = a;
            RuntimeException runtimeException = new RuntimeException(stringArray[39]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[53], runtimeException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[53]);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw RSAPrivateHWKey.b(invalidKeyException);
            }
            throw runtimeException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[53]);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw RSAPrivateHWKey.b(invalidKeyException);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        int n2;
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[29]);
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw RSAPrivateHWKey.b(destroyFailedException);
        }
        if (null != this.keyLabel) {
            try {
                for (n2 = 0; n2 < this.keyLabel.length; ++n2) {
                    this.keyLabel[n2] = 0;
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw RSAPrivateHWKey.b(destroyFailedException);
            }
            try {
                this.keyLabel = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[61], a[20]);
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw RSAPrivateHWKey.b(destroyFailedException);
            }
        }
        if (null != this.externalKeyToken) {
            try {
                for (n2 = 0; n2 < this.externalKeyToken.length; ++n2) {
                    this.externalKeyToken[n2] = 0;
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw RSAPrivateHWKey.b(destroyFailedException);
            }
            try {
                this.externalKeyToken = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[61], a[68]);
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw RSAPrivateHWKey.b(destroyFailedException);
            }
        }
        try {
            this.hasBeenDestroyed = true;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[61]);
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw RSAPrivateHWKey.b(destroyFailedException);
        }
    }

    @Override
    public boolean isDestroyed() {
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[61], "" + this.hasBeenDestroyed);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw RSAPrivateHWKey.b(illegalStateException);
        }
        return this.hasBeenDestroyed;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[79];
                var3_1 = 0;
                var2_2 = "\rr0,[G%s\u0005E\u000f\u0016c<6jog%D\u0018.OMt=\u0011#U\t%jrR+U\u001b\u0000qex!^\t\u0011#U\t6jo|!u\u0005\u0016wht*D-\u0011#U\t6md}-S8\u001ehi\u007f!^\t\u000f U\u0011\u0003lcA\u000ft.#vrc=5\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lVd&\\\u0014\u0005]~a+^\u0018\bl&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\u0011#U\t6jo|!u\u0005\u0016wht*D,-\"E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u001878np7\u0010\u0013\t8kt%^\u0014\b\u007f&x*\u0010\u0015\u0007jbf%B\u0018\n\rr0,[C%s\u0005E\u0016'_\b\n|&\u007f+D]\"]T1!^\u001e\t|c+d\u0006\u0016u)'QH\n#U\t#ve~ U\u0019\u0011#U\t%jrR+U\u001b\u0000qex!^\t\t#U\t wt|%D\f4Q\u000f\u0015}Mt=r\u0014\u0012k\t\rs. Liz!^\u0007\u0011~6(WQ_\u0011#U\t6jo|!u\u0005\u0016wht*D-- U\u000e\u0012jihl\u0019]\u000eyu1&U\u0018\b8ep(\\\u0018\u00028o\u007fdD\u0015\u000fk&z!I]\tzlt'DS-/U\u0004*ydt(\u0010\u0015\u0007k&s!U\u0013Fbcc+U\u0019FwsedQ\u0013\u00028ut0\u0010\t\t8hd(\\S\b0_.\u0012jo\u007f#.\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lK~ E\u0011\u0013k&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\f4Q\u000f\u0015}Mt=r\u0014\u0012k=\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}W1,Q\u000eFvi1)U\u001c\bqhvdY\u0013Fpgc G\u001c\u0014}\t-R\u0010\f{cr'QE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0007B\t%wcw\"Y\u001e\u000f}hedX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc\t\rr0,[CR\u0007q\u0016'_\b\n|&\u007f+D]\"]T1!^\u001e\t|c+d\u0007 U\u000e\u0012jih\t#U\t wt|%D\t\rr0,[CR\u0007q/'_\u0010Hqd|jS\u000f\u001fhr~jX\u0019\u0011jER\u0005\u001e\r\u0014wpx U\u000fHJUP\u0014B\u0014\u0010yrt\fg6\u0003a.\u000fU\u0004Fusb0\u0010\u001f\u00038iwdD\u0004\u0016}&Z!I51Yre6Y\u001f\u0013lcG%\\\b\u0003k(A\u000ft.H\t#U\t6jo|!`5\"E\u0013\u0005lo~*\u0010\u001a\u0003lEc0s\u0012\u0003~`x'Y\u0018\bl&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\t#U\t6jo|!`\t\u0014{95Tgs!\\\u001c\u0006Q\u0019FJUPd@\u000f\u000fnge!\u0010\u0016\u0003a&t*S\u0012\u0002qhv(\r^\u000b\u0007toud\\\u001c\u0004}j1(U\u0013\u0001ln1\"_\u000fFHMU\u0017\u0010\u0016\u0003a&~&Z\u0018\u0005l=\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}V1,Q\u000eFvi1)U\u001c\bqhvdY\u0013Fpgc G\u001c\u0014}\u001c\u0006Q\u0019FJUPd@\u000f\u000fnge!\u0010\u0016\u0003a&t*S\u0012\u0002qhvE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014E\u001f\nqeT<@\u0012\b}hedX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc\u000e#U\t*ydt(c\t\u0014qhv\u0011#U\t6md}-S8\u001ehi\u007f!^\t\u0012#U\t6jog%D\u0018#`v~*U\u0013\u0012\u0013#U\t#`rt6^\u001c\nSch\u0010_\u0016\u0003vE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}Ci4_\u0013\u0003vrAdX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc\b#U\t*ydt(\u0012#U\t6jog%D\u0018#`v~*U\u0013\u00125\"E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u0018#`v~*U\u0013\u0012I&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\u000e#U\t*ydt(c\t\u0014qhv&\u0006Q\u0019FJUPd@\u000f\u000fnge!\u0010\u0016\u0003a&b!A\b\u0003vetd\\\u0018\b\u007fryd\u001d]\u000f U\u0011\u0003lcA\u000ft.#vrc=\n#U\t#ve~ U\u0019\t#U\t6jo|!a5\"E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u0018#`v~*U\u0013\u0012H&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003-\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u001868np7\u0010\u0013\t8kt%^\u0014\b\u007f&x*\u0010\u0015\u0007jbf%B\u0018.\r^\u000b\u0007toudb.'Htx2Q\t\u0003PQZ!I]\u0003ve~ Y\u0013\u00014&u%D\u001cFwpt6B\b\b- U\u000e\u0012jihl\u0019]\u000eyu1&U\u0018\b8ep(\\\u0018\u00028o\u007fdD\u0015\u000fk&z!I]\tzlt'DSF\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u0010yrt\u0001H\r\tvc\u007f0\u0010\u0015\u0007k&\u007f+\u0010\u0010\u0003yhx*W]\u000fv&y%B\u0019\u0011ytt\u0007 U\u000e\u0012jihE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}Ci4_\u0013\u0003vr@dX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc6\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lVc-F\u001c\u0012}Ci4_\u0013\u0003vr1,Q\u000eFvi1)U\u001c\bqhvdY\u0013Fpgc G\u001c\u0014}\n#U\t+wbd(E\u000e\b#U\t*ydt(\t#U\t6jo|!a\b#U\t3kgv!5!H\t\u0003jhp({\u0018\u001fLiz!^]\u000eyu1&U\u0018\b8|t6_\u0018\u00028id0\u0010\u001c\b|&b!D]\u0012w&\u007f1\\\u0011H\u0007#U\t2avt\u0011#U\t6jo|!u\u0005\u0016wht*D,\u000f\u0016c<6jog%D\u0018.OMt=1\u0001B\u000f\tj&p0D\u0018\u000bhrx*W]\u0012w&u!\\\u0018\u0012}&\u007f+^P6SBBd[\u0018\u001f8`c+]]6SBB\u0013#U\t#`rt6^\u001c\nSch\u0010_\u0016\u0003v>\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\t_\u0019\u0013tsbdX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc?\r^\t\u0003jhp(\u0010\u0018\u0014jicdS\u0012\bncc0Y\u0013\u00018TB\u0005\u0010\u000e\t~rf%B\u0018Fhtx2Q\t\u00038mt=\u0010\t\t8OS\tz>#[EP\u0012db.'8Vc-F\u001c\u0012}&Z!IGl";
                var4_3 = "\rr0,[G%s\u0005E\u000f\u0016c<6jog%D\u0018.OMt=\u0011#U\t%jrR+U\u001b\u0000qex!^\t\u0011#U\t6jo|!u\u0005\u0016wht*D-\u0011#U\t6md}-S8\u001ehi\u007f!^\t\u000f U\u0011\u0003lcA\u000ft.#vrc=5\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lVd&\\\u0014\u0005]~a+^\u0018\bl&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\u0011#U\t6jo|!u\u0005\u0016wht*D,-\"E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u001878np7\u0010\u0013\t8kt%^\u0014\b\u007f&x*\u0010\u0015\u0007jbf%B\u0018\n\rr0,[C%s\u0005E\u0016'_\b\n|&\u007f+D]\"]T1!^\u001e\t|c+d\u0006\u0016u)'QH\n#U\t#ve~ U\u0019\u0011#U\t%jrR+U\u001b\u0000qex!^\t\t#U\t wt|%D\f4Q\u000f\u0015}Mt=r\u0014\u0012k\t\rs. Liz!^\u0007\u0011~6(WQ_\u0011#U\t6jo|!u\u0005\u0016wht*D-- U\u000e\u0012jihl\u0019]\u000eyu1&U\u0018\b8ep(\\\u0018\u00028o\u007fdD\u0015\u000fk&z!I]\tzlt'DS-/U\u0004*ydt(\u0010\u0015\u0007k&s!U\u0013Fbcc+U\u0019FwsedQ\u0013\u00028ut0\u0010\t\t8hd(\\S\b0_.\u0012jo\u007f#.\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lK~ E\u0011\u0013k&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\f4Q\u000f\u0015}Mt=r\u0014\u0012k=\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}W1,Q\u000eFvi1)U\u001c\bqhvdY\u0013Fpgc G\u001c\u0014}\t-R\u0010\f{cr'QE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0007B\t%wcw\"Y\u001e\u000f}hedX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc\t\rr0,[CR\u0007q\u0016'_\b\n|&\u007f+D]\"]T1!^\u001e\t|c+d\u0007 U\u000e\u0012jih\t#U\t wt|%D\t\rr0,[CR\u0007q/'_\u0010Hqd|jS\u000f\u001fhr~jX\u0019\u0011jER\u0005\u001e\r\u0014wpx U\u000fHJUP\u0014B\u0014\u0010yrt\fg6\u0003a.\u000fU\u0004Fusb0\u0010\u001f\u00038iwdD\u0004\u0016}&Z!I51Yre6Y\u001f\u0013lcG%\\\b\u0003k(A\u000ft.H\t#U\t6jo|!`5\"E\u0013\u0005lo~*\u0010\u001a\u0003lEc0s\u0012\u0003~`x'Y\u0018\bl&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\t#U\t6jo|!`\t\u0014{95Tgs!\\\u001c\u0006Q\u0019FJUPd@\u000f\u000fnge!\u0010\u0016\u0003a&t*S\u0012\u0002qhv(\r^\u000b\u0007toud\\\u001c\u0004}j1(U\u0013\u0001ln1\"_\u000fFHMU\u0017\u0010\u0016\u0003a&~&Z\u0018\u0005l=\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}V1,Q\u000eFvi1)U\u001c\bqhvdY\u0013Fpgc G\u001c\u0014}\u001c\u0006Q\u0019FJUPd@\u000f\u000fnge!\u0010\u0016\u0003a&t*S\u0012\u0002qhvE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014E\u001f\nqeT<@\u0012\b}hedX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc\u000e#U\t*ydt(c\t\u0014qhv\u0011#U\t6md}-S8\u001ehi\u007f!^\t\u0012#U\t6jog%D\u0018#`v~*U\u0013\u0012\u0013#U\t#`rt6^\u001c\nSch\u0010_\u0016\u0003vE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}Ci4_\u0013\u0003vrAdX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc\b#U\t*ydt(\u0012#U\t6jog%D\u0018#`v~*U\u0013\u00125\"E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u0018#`v~*U\u0013\u0012I&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003\u000e#U\t*ydt(c\t\u0014qhv&\u0006Q\u0019FJUPd@\u000f\u000fnge!\u0010\u0016\u0003a&b!A\b\u0003vetd\\\u0018\b\u007fryd\u001d]\u000f U\u0011\u0003lcA\u000ft.#vrc=\n#U\t#ve~ U\u0019\t#U\t6jo|!a5\"E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u0018#`v~*U\u0013\u0012H&y%C]\bw&|!Q\u0013\u000fva1-^]\u000eytu3Q\u000f\u0003-\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lVc-]\u001868np7\u0010\u0013\t8kt%^\u0014\b\u007f&x*\u0010\u0015\u0007jbf%B\u0018.\r^\u000b\u0007toudb.'Htx2Q\t\u0003PQZ!I]\u0003ve~ Y\u0013\u00014&u%D\u001cFwpt6B\b\b- U\u000e\u0012jihl\u0019]\u000eyu1&U\u0018\b8ep(\\\u0018\u00028o\u007fdD\u0015\u000fk&z!I]\tzlt'DSF\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u0010yrt\u0001H\r\tvc\u007f0\u0010\u0015\u0007k&\u007f+\u0010\u0010\u0003yhx*W]\u000fv&y%B\u0019\u0011ytt\u0007 U\u000e\u0012jihE\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\u0014B\u0014\u000b}Ci4_\u0013\u0003vr@dX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc6\u0002E\u0013\u0005lo~*\u0010\u001a\u0003lVc-F\u001c\u0012}Ci4_\u0013\u0003vr1,Q\u000eFvi1)U\u001c\bqhvdY\u0013Fpgc G\u001c\u0014}\n#U\t+wbd(E\u000e\b#U\t*ydt(\t#U\t6jo|!a\b#U\t3kgv!5!H\t\u0003jhp({\u0018\u001fLiz!^]\u000eyu1&U\u0018\b8|t6_\u0018\u00028id0\u0010\u001c\b|&b!D]\u0012w&\u007f1\\\u0011H\u0007#U\t2avt\u0011#U\t6jo|!u\u0005\u0016wht*D,\u000f\u0016c<6jog%D\u0018.OMt=1\u0001B\u000f\tj&p0D\u0018\u000bhrx*W]\u0012w&u!\\\u0018\u0012}&\u007f+^P6SBBd[\u0018\u001f8`c+]]6SBB\u0013#U\t#`rt6^\u001c\nSch\u0010_\u0016\u0003v>\fQ\u000f\u0002ogc!\u0010\u0018\u0014jich\u0010\u001b\u0013vee-_\u0013F\u007fce\t_\u0019\u0013tsbdX\u001c\u00158h~d]\u0018\u0007vo\u007f#\u0010\u0014\b8np6T\n\u0007jc?\r^\t\u0003jhp(\u0010\u0018\u0014jicdS\u0012\bncc0Y\u0013\u00018TB\u0005\u0010\u000e\t~rf%B\u0018Fhtx2Q\t\u00038mt=\u0010\t\t8OS\tz>#[EP\u0012db.'8Vc-F\u001c\u0012}&Z!IGl".length();
                var1_4 = 10;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 87;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "~\u0011`\\$!1m\nm\u001bGe9,*f\u000b@";
                    var4_3 = "~\u0011`\\$!1m\nm\u001bGe9,*f\u000b@".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 25;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_7 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_7;
                while (true) {
                    switch (var6_7 % 7) {
                        case 0: {
                            v15 = 19;
                            break;
                        }
                        case 1: {
                            v15 = 103;
                            break;
                        }
                        case 2: {
                            v15 = 42;
                            break;
                        }
                        case 3: {
                            v15 = 49;
                            break;
                        }
                        case 4: {
                            v15 = 79;
                            break;
                        }
                        case 5: {
                            v15 = 81;
                            break;
                        }
                        default: {
                            v15 = 70;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_7;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_7);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        RSAPrivateHWKey.a = var5;
        var0_6 = RSAPrivateHWKey.a;
        RSAPrivateHWKey.debug = Debug.getInstance(var0_6[25]);
        RSAPrivateHWKey.className = var0_6[32];
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

