/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ECHWKeyAttributes;
import com.ibm.crypto.hdwrCCA.provider.ECKeyFactory;
import com.ibm.crypto.hdwrCCA.provider.ECParameters;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.a;
import com.ibm.crypto.hdwrCCA.provider.k;
import com.ibm.crypto.hdwrCCA.provider.o;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.security.auth.DestroyFailedException;

public final class ECPrivateHWKey
extends PrivateKeyInfo
implements ECPrivateKey,
ECKey,
Serializable {
    static final long serialVersionUID = 3503623093811037403L;
    private boolean hasBeenDestroyed;
    private byte[] externalKeyToken;
    private byte[] internalKeyTokenOrLabel;
    private ECParameterSpec parameterSpec;
    private ECHWKeyAttributes keyAttributes;
    private static Debug debug;
    private static String className;
    private static final String[] a;

    ECPrivateHWKey(byte[] byArray) throws InvalidKeyException {
        String[] stringArray;
        this.hasBeenDestroyed = false;
        this.externalKeyToken = null;
        this.internalKeyTokenOrLabel = null;
        this.parameterSpec = null;
        this.keyAttributes = null;
        if (debug != null) {
            stringArray = a;
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, stringArray[50], (Object)byArray);
        }
        if (byArray == null) {
            stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[10]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException) {
                throw ECPrivateHWKey.b(iOException);
            }
            throw invalidKeyException;
        }
        try {
            this.decode(byArray);
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                stringArray = a;
                IOException iOException = new IOException(stringArray[4]);
                try {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], iOException);
                        debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                    }
                }
                catch (IOException iOException2) {
                    throw ECPrivateHWKey.b(iOException2);
                }
                throw iOException;
            }
            DerInputStream derInputStream2 = derValue.getData();
            int n2 = derInputStream2.getInteger().intValue();
            if (n2 != 1) {
                stringArray = a;
                IOException iOException = new IOException(stringArray[43]);
                try {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], iOException);
                        debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                    }
                }
                catch (IOException iOException3) {
                    throw ECPrivateHWKey.b(iOException3);
                }
                throw iOException;
            }
            byte[] byArray2 = derInputStream2.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            ECKeyFactory eCKeyFactory = new ECKeyFactory();
            ECPrivateHWKey eCPrivateHWKey = (ECPrivateHWKey)eCKeyFactory.engineGeneratePrivate(new ECPrivateKeySpec(bigInteger, this.parameterSpec));
            this.externalKeyToken = eCPrivateHWKey.getExternalKeyToken();
            this.internalKeyTokenOrLabel = eCPrivateHWKey.getToken();
            this.keyAttributes = new ECHWKeyAttributes(eCPrivateHWKey.getType(), eCPrivateHWKey.getUsage());
            DerValue[] derValueArray = new DerValue[]{new DerValue(4, this.internalKeyTokenOrLabel)};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            derOutputStream.close();
        }
        catch (IOException iOException) {
            stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[8], iOException);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], iOException);
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException4) {
                throw ECPrivateHWKey.b(iOException4);
            }
            throw invalidKeyException;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[45], invalidKeySpecException);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], invalidKeySpecException);
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException) {
                throw ECPrivateHWKey.b(iOException);
            }
            throw invalidKeyException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[50]);
            }
        }
        catch (IOException iOException) {
            throw ECPrivateHWKey.b(iOException);
        }
    }

    /*
     * Loose catch block
     */
    ECPrivateHWKey(byte[] byArray, ECParameterSpec eCParameterSpec, ECHWKeyAttributes eCHWKeyAttributes) throws InvalidKeyException, InvalidParameterSpecException {
        String[] stringArray;
        Object object;
        block29: {
            block26: {
                block27: {
                    block25: {
                        this.hasBeenDestroyed = false;
                        this.externalKeyToken = null;
                        this.internalKeyTokenOrLabel = null;
                        this.parameterSpec = null;
                        this.keyAttributes = null;
                        if (debug != null) {
                            object = new Object[]{byArray, eCParameterSpec, eCHWKeyAttributes};
                            stringArray = a;
                            debug.entry(Debug.TYPE_PUBLIC, (Object)className, stringArray[34], (Object[])object);
                        }
                        if (byArray == null) {
                            stringArray = a;
                            object = new InvalidKeyException(stringArray[31]);
                            try {
                                if (debug != null) {
                                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], (Throwable)object);
                                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                                }
                            }
                            catch (IOException iOException) {
                                throw ECPrivateHWKey.b(iOException);
                            }
                            throw object;
                        }
                        try {
                            if (eCParameterSpec != null && eCHWKeyAttributes != null) break block25;
                        }
                        catch (IOException iOException) {
                            throw ECPrivateHWKey.b(iOException);
                        }
                        stringArray = a;
                        object = new NullPointerException(stringArray[15]);
                        try {
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], (Throwable)object);
                                debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                            }
                        }
                        catch (IOException iOException) {
                            throw ECPrivateHWKey.b(iOException);
                        }
                        throw object;
                    }
                    if (eCHWKeyAttributes.getKeyType() != 2) break block26;
                    try {
                        block28: {
                            if (debug == null) break block27;
                            break block28;
                            catch (IOException iOException) {
                                throw ECPrivateHWKey.b(iOException);
                            }
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, a[50], a[61]);
                    }
                    catch (IOException iOException) {
                        throw ECPrivateHWKey.b(iOException);
                    }
                }
                this.externalKeyToken = (byte[])byArray.clone();
                object = new KeyPairUtils();
                this.internalKeyTokenOrLabel = ((KeyPairUtils)object).importExternalToken(this.externalKeyToken, KeyPairUtils.KeyPairAlgorithm.EC);
                break block29;
            }
            try {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[50], a[35]);
                }
            }
            catch (IOException iOException) {
                throw ECPrivateHWKey.b(iOException);
            }
            this.internalKeyTokenOrLabel = (byte[])byArray.clone();
        }
        this.parameterSpec = eCParameterSpec;
        this.keyAttributes = new ECHWKeyAttributes(eCHWKeyAttributes.getKeyType(), eCHWKeyAttributes.getKeyUsage());
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(eCParameterSpec));
        try {
            object = new DerValue[]{new DerValue(4, this.internalKeyTokenOrLabel)};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence((DerValue[])object);
            this.key = derOutputStream.toByteArray();
            derOutputStream.close();
        }
        catch (IOException iOException) {
            stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[57] + iOException.getMessage(), iOException);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], iOException);
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException2) {
                throw ECPrivateHWKey.b(iOException2);
            }
            throw invalidKeyException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[50]);
            }
        }
        catch (IOException iOException) {
            throw ECPrivateHWKey.b(iOException);
        }
    }

    ECPrivateHWKey(byte[] byArray, byte[] byArray2, ECParameterSpec eCParameterSpec, ECHWKeyAttributes eCHWKeyAttributes) throws InvalidKeyException, InvalidParameterSpecException {
        String[] stringArray;
        Object[] objectArray;
        block24: {
            block23: {
                this.hasBeenDestroyed = false;
                this.externalKeyToken = null;
                this.internalKeyTokenOrLabel = null;
                this.parameterSpec = null;
                this.keyAttributes = null;
                if (debug != null) {
                    objectArray = new Object[]{byArray, byArray2, eCParameterSpec, eCHWKeyAttributes};
                    stringArray = a;
                    debug.entry(Debug.TYPE_PUBLIC, (Object)className, stringArray[50], objectArray);
                }
                try {
                    if (byArray != null && byArray2 != null) break block23;
                }
                catch (IOException iOException) {
                    throw ECPrivateHWKey.b(iOException);
                }
                stringArray = a;
                objectArray = new InvalidKeyException(stringArray[48]);
                try {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], (Throwable)objectArray);
                        debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                    }
                }
                catch (IOException iOException) {
                    throw ECPrivateHWKey.b(iOException);
                }
                throw objectArray;
            }
            try {
                if (eCParameterSpec != null && eCHWKeyAttributes != null) break block24;
            }
            catch (IOException iOException) {
                throw ECPrivateHWKey.b(iOException);
            }
            stringArray = a;
            objectArray = new NullPointerException(stringArray[60]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], (Throwable)objectArray);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException) {
                throw ECPrivateHWKey.b(iOException);
            }
            throw objectArray;
        }
        if (eCHWKeyAttributes.getKeyType() != 2) {
            stringArray = a;
            objectArray = new InvalidKeyException(stringArray[6]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], (Throwable)objectArray);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException) {
                throw ECPrivateHWKey.b(iOException);
            }
            throw objectArray;
        }
        this.externalKeyToken = (byte[])byArray.clone();
        this.internalKeyTokenOrLabel = (byte[])byArray2.clone();
        this.parameterSpec = eCParameterSpec;
        this.keyAttributes = new ECHWKeyAttributes(eCHWKeyAttributes.getKeyType(), eCHWKeyAttributes.getKeyUsage());
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(eCParameterSpec));
        try {
            objectArray = new DerValue[]{new DerValue(4, this.internalKeyTokenOrLabel)};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence((DerValue[])objectArray);
            this.key = derOutputStream.toByteArray();
            derOutputStream.close();
        }
        catch (IOException iOException) {
            stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[30] + iOException.getMessage(), iOException);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], iOException);
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[50], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[50]);
                }
            }
            catch (IOException iOException2) {
                throw ECPrivateHWKey.b(iOException2);
            }
            throw invalidKeyException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[50]);
            }
        }
        catch (IOException iOException) {
            throw ECPrivateHWKey.b(iOException);
        }
    }

    protected void parseKeyBits() throws IOException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[41]);
            }
        }
        catch (Exception exception) {
            throw ECPrivateHWKey.b(exception);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[25], illegalStateException);
                }
            }
            catch (Exception exception) {
                throw ECPrivateHWKey.b(exception);
            }
            throw illegalStateException;
        }
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                String[] stringArray = a;
                IOException iOException = new IOException(stringArray[14]);
                try {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, stringArray[25], iOException);
                        debug.exit(Debug.TYPE_PUBLIC, className, stringArray[25]);
                    }
                }
                catch (Exception exception) {
                    throw ECPrivateHWKey.b(exception);
                }
                throw iOException;
            }
            this.parameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage(), exception);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, a[25], exception);
                    debug.exception(Debug.TYPE_PUBLIC, className, a[25], iOException);
                    debug.exit(Debug.TYPE_PUBLIC, className, a[25]);
                }
            }
            catch (Exception exception2) {
                throw ECPrivateHWKey.b(exception2);
            }
            throw iOException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[25]);
            }
        }
        catch (Exception exception) {
            throw ECPrivateHWKey.b(exception);
        }
    }

    public byte[] getToken() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[40]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[22]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[54], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[54], this.internalKeyTokenOrLabel);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        try {
            if (this.internalKeyTokenOrLabel != null) {
                return (byte[])this.internalKeyTokenOrLabel.clone();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return null;
    }

    public String getLabelString() throws InvalidKeyException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[7]);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw ECPrivateHWKey.b(invalidKeyException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[36], illegalStateException);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw ECPrivateHWKey.b(invalidKeyException);
            }
            throw illegalStateException;
        }
        if (this.getType() != 0) {
            String[] stringArray = a;
            InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[28]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[36], invalidKeyException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[36]);
                }
            }
            catch (InvalidKeyException invalidKeyException2) {
                throw ECPrivateHWKey.b(invalidKeyException2);
            }
            throw invalidKeyException;
        }
        String string = new String(this.internalKeyTokenOrLabel, o.c);
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[36], string);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw ECPrivateHWKey.b(invalidKeyException);
        }
        return string;
    }

    public byte[] getExternalKeyToken() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[3]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[3], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[3], this.externalKeyToken);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        try {
            if (this.externalKeyToken != null) {
                return (byte[])this.externalKeyToken.clone();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return null;
    }

    public byte getType() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[27]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[11], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[33], this.keyAttributes.getKeyType());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return this.keyAttributes.getKeyType();
    }

    public byte getUsage() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[39]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[26], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[26], this.keyAttributes.getKeyUsage());
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return this.keyAttributes.getKeyUsage();
    }

    @Override
    public BigInteger getS() {
        String[] stringArray = a;
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(stringArray[1]);
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, stringArray[32]);
                debug.exception(Debug.TYPE_PUBLIC, className, stringArray[13], unsupportedOperationException);
                debug.exit(Debug.TYPE_PUBLIC, className, stringArray[13]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        throw unsupportedOperationException;
    }

    @Override
    public ECParameterSpec getParams() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[19]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[56], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[56], this.parameterSpec);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return this.parameterSpec;
    }

    @Override
    public synchronized byte[] getEncoded() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[47]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[44], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        if (this.keyAttributes.getKeyType() == 2) {
            byte[] byArray = this.getExternalKeyToken();
            try {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[44], byArray);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            return byArray;
        }
        byte[] byArray = this.getToken();
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[44], byArray);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return byArray;
    }

    @Override
    public String getFormat() {
        block14: {
            block15: {
                try {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, a[46]);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw ECPrivateHWKey.b(nullPointerException);
                }
                if (this.isDestroyed()) {
                    String[] stringArray = a;
                    IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[38], illegalStateException);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        throw ECPrivateHWKey.b(nullPointerException);
                    }
                    throw illegalStateException;
                }
                try {
                    try {
                        if (this.keyAttributes.getKeyType() != 2) break block14;
                        if (debug == null) break block15;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw ECPrivateHWKey.b(nullPointerException);
                    }
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[38], a[9]);
                }
                catch (NullPointerException nullPointerException) {
                    throw ECPrivateHWKey.b(nullPointerException);
                }
            }
            String[] stringArray = a;
            return stringArray[42];
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[38], a[16]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return a[20];
    }

    public ECPrivateKey getSoftwareECPrivateKey() throws InvalidKeyException {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[23]);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw ECPrivateHWKey.b(invalidKeyException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[5], illegalStateException);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw ECPrivateHWKey.b(invalidKeyException);
            }
            throw illegalStateException;
        }
        if (this.keyAttributes.getKeyType() == 2) {
            ECPrivateKey eCPrivateKey = k.b(this);
            try {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[5], eCPrivateKey);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw ECPrivateHWKey.b(invalidKeyException);
            }
            return eCPrivateKey;
        }
        String[] stringArray = a;
        InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[55]);
        try {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, stringArray[5], invalidKeyException);
                debug.exit(Debug.TYPE_PUBLIC, className, stringArray[5]);
            }
        }
        catch (InvalidKeyException invalidKeyException2) {
            throw ECPrivateHWKey.b(invalidKeyException2);
        }
        throw invalidKeyException;
    }

    public String toString() {
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[17]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        if (this.isDestroyed()) {
            String[] stringArray = a;
            IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[18], illegalStateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw ECPrivateHWKey.b(nullPointerException);
            }
            throw illegalStateException;
        }
        String[] stringArray = a;
        String string = new String(stringArray[29]);
        a a2 = new a();
        String string2 = a2.encodeBuffer(this.internalKeyTokenOrLabel);
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, stringArray[18]);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return string + a[21] + string2 + "\n";
    }

    public void deletePKDSEntry() throws InvalidKeyException {
        block20: {
            block19: {
                try {
                    if (debug != null) {
                        debug.entry(Debug.TYPE_PUBLIC, className, a[0]);
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw ECPrivateHWKey.b(invalidKeyException);
                }
                if (this.isDestroyed()) {
                    String[] stringArray = a;
                    IllegalStateException illegalStateException = new IllegalStateException(stringArray[58]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[52], illegalStateException);
                        }
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw ECPrivateHWKey.b(invalidKeyException);
                    }
                    throw illegalStateException;
                }
                if (this.getType() != 0) {
                    String[] stringArray = a;
                    InvalidKeyException invalidKeyException = new InvalidKeyException(stringArray[59]);
                    try {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, stringArray[52], invalidKeyException);
                            debug.exit(Debug.TYPE_PUBLIC, className, stringArray[52]);
                        }
                    }
                    catch (InvalidKeyException invalidKeyException2) {
                        throw ECPrivateHWKey.b(invalidKeyException2);
                    }
                    throw invalidKeyException;
                }
                byte[] byArray = this.getToken();
                try {
                    if (byArray.length > 64) break block19;
                    KeyPairUtils.c(byArray);
                    break block20;
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw ECPrivateHWKey.b(invalidKeyException);
                }
            }
            String[] stringArray = a;
            RuntimeException runtimeException = new RuntimeException(stringArray[2]);
            try {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, stringArray[52], runtimeException);
                    debug.exit(Debug.TYPE_PUBLIC, className, stringArray[52]);
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw ECPrivateHWKey.b(invalidKeyException);
            }
            throw runtimeException;
        }
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[52]);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw ECPrivateHWKey.b(invalidKeyException);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        int n2;
        try {
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, a[12]);
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw ECPrivateHWKey.b(destroyFailedException);
        }
        if (null != this.internalKeyTokenOrLabel) {
            try {
                for (n2 = 0; n2 < this.internalKeyTokenOrLabel.length; ++n2) {
                    this.internalKeyTokenOrLabel[n2] = 0;
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw ECPrivateHWKey.b(destroyFailedException);
            }
            try {
                this.internalKeyTokenOrLabel = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[49], a[24]);
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw ECPrivateHWKey.b(destroyFailedException);
            }
        }
        if (null != this.externalKeyToken) {
            try {
                for (n2 = 0; n2 < this.externalKeyToken.length; ++n2) {
                    this.externalKeyToken[n2] = 0;
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw ECPrivateHWKey.b(destroyFailedException);
            }
            try {
                this.externalKeyToken = null;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, a[49], a[37]);
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw ECPrivateHWKey.b(destroyFailedException);
            }
        }
        try {
            this.hasBeenDestroyed = true;
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, a[49]);
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw ECPrivateHWKey.b(destroyFailedException);
        }
    }

    @Override
    public boolean isDestroyed() {
        try {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, a[49], "" + this.hasBeenDestroyed);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw ECPrivateHWKey.b(nullPointerException);
        }
        return this.hasBeenDestroyed;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[62];
                var3_1 = 0;
                var2_2 = "Jge:P\u0004(eFZ\u001aJ\u0015\nW8fc{;S\u0000\nK\"l-V\u000e\n\u0002\"o*J\u0002\fGmg\u007fC\u0004\f}\"a>WA\u0016A\"d:E\u000f\u0011@e)6JA\u0010Opm(E\u0013\u001d(gl\u007f>H\b\u001c\u000enh=A\rXBgg8P\tXHm{\u007ft*<}\"b:]A\u0017Lhl<P\u0013Ig}\u001a\\\u0015\u001d\\lh3o\u0004\u0001zmb:J@lcm\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\u0011\nGth+AA\u0013K{):J\u0002\u0017Jkg8\bA\u001dVrl<P\u0004\u001c\u000ec)\fa0-kLJ\u001a\u0004\u0015\u0019I\u0017Ig}\fK\u0007\fYc{:a\"(\\k\u007f>P\u00043K{,zjl\u007fW\u0011\u001dMko6A\u0005XEgp\u007fM\u0012X@m}\u007fEA;bGH\r\u0004\u0011\nGth+AA\u0013K{\u000eIg}\u0013E\u0003\u001dBQ}-M\u000f\u001f'lcm\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\u0011\nGth+AA\u0013K{):J\u0002\u0017Jkg8\tgAZ\u0019p\u000e\u0013Kl<zjl\u007fW\u0014\b^n`:@A(eAZ|\u001cA<kP):J\u0002\u0017Jgm\u007fT\u0013\u0011Xc}:\u0004\n\u001dW\"d*W\u0015X@m}\u007fF\u0004X@we3\u0013Ig}\u001a\\\u0015\u001d\\lh3o\u0004\u0001zmb:J\u0007Jgz+V\u000e\u0001\u0004Ig}\f7{lh=H\u0004XZm)-A\u0015\nGg\u007f:\u0004\u0015\u0010K\"L3H\b\bZkj\u007fg\u0014\nXg);K\f\u0019Gl)/E\u0013\u0019Cg}:V\u0012Zzjl\u007fW\u0014\b^n`:@A=Bn`/P\b\u001b\u000eA|-R\u0004XJmd>M\u000fX^c{>I\u0004\fKpz\u007fE\u000f\u001c\u000ejh-@\u0016\u0019\\g)4A\u0018XOv}-M\u0003\rZgz\u007fI\u0014\u000bZ\"g0PA\u001aK\"g*H\r\t~IM\fh\u0000\u001aKn\bZmZ+V\b\u0016I\bZmZ+V\b\u0016I\tIg}\u000fE\u0013\u0019Cq\t~IM\fh\u0000\u001aKn\u001d\u000eGe3M\u0011\fGa)\u001cQ\u0013\u000eK\"y-M\u0017\u0019Zg)4A\u0018B$-Jgz+V\u000e\u0001\u0006+)7E\u0012XLgl1\u0004\u0002\u0019Bnl;\u0004\b\u0016\u000eva6WA\u0013K{)0F\u000b\u001dMv'\u0017Ig}\fK\u0007\fYc{:a\"(\\k\u007f>P\u00043K{<Gl}:V\u000f\u0019BIl&p\u000e\u0013KlF-h\u0000\u001aKn)7E\u0012XLgl1\u0004\u001b\u001d\\ml;\u0004\u000e\rZ\"h1@A\u000bKv)+KA\u0016[neq\f^c{,A*\u001dW@`+W\bIg}\nW\u0000\u001fK\u0007Ig}\u000b]\u0011\u001d.egp\u007fI\u0014\u000bZ\"k:\u0004\u000e\u001e\u000evp/AA3K{A\be\u0015\f\\kk*P\u0004.On|:WO(eFZq\tg@D\u0015g$;mC\u0016mm|3@A\u0016Av)\u001ba3XKlj0@\u0004B\u000e:zjl\u007fW\u0014\b^n`:@A\u001dVvl-J\u0000\u0014\u000evf4A\u000fXAp)\u000fo%+\u000enh=A\rXCwz+\u0004\u000f\u0017Z\"k:\u0004\u000f\rBn\u0004Ig}\f\u0007Ig}\u000b]\u0011\u001d\u000ekAY-M\u0017\u0019ZgA\bo\u0004\u0001\u0010egp\u007fP\u0018\bK\"`,\u000413jQ\u000eIg}\u0013E\u0003\u001dBQ}-M\u000f\u001f5Kz}:V\u000f\u0019BIl&p\u000e\u0013Kl)7E\u0012XLgl1\u0004\u001b\u001d\\ml;\u0004\u000e\rZ\"h1@A\u000bKv)+KA\u0016[neq\tIg}\u0019K\u0013\u0015Ov\bIg}\nW\u0000\u001fK\bIg}\u000bK\n\u001d@\f^c{,A*\u001dW@`+W\tgAZ\u0019p\u000e\u0013Kl:lcm\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\u0011\nGth+AA\u0013K{))A\u0013\u000bGmgs\u0004\u0004\u0000^gj+A\u0005XXg{,M\u000e\u0016\u000e3\nIg}\u001aJ\u0002\u0017Jgm=gl}:V\u000f\u0019B\"l-V\u000e\n\u000eaf1R\u0004\nZkg8\u0004$\u0014Bky+M\u0002Xmw{)AA\u000bAd}(E\u0013\u001d\u000er{6R\u0000\fK\"b:]\tIg}\u0019K\u0013\u0015Ov\nIg}\u001aJ\u0002\u0017Jgm2zjl\u007fW\u0011\u001dMko6A\u0005X~IH\u007fT\u0013\u0011Xc}:\u0004\n\u001dW\"}0O\u0004\u0016]\"h-AA\u0016Av))E\r\u0011J\u0007Jgz+V\u000e\u0001\u000ekAY-M\u0017\u0019ZgA\bo\u0004\u0001\tG`d5G\u0004\u001bMc\u000fJge:P\u0004(eFZ\u001aJ\u0015\nW.MmdqM\u0003\u0015\u0000a{&T\u0015\u0017\u0000jm(V\";o,y-K\u0017\u0011Jg{qa\"(\\k\u007f>P\u00040yIl&\bIg}\u000bK\n\u001d@\u0086zj`,\u0004\b\u000b\u000ec)\u000fo%+\u000ejh-@\u0016\u0019\\g)\u001aH\r\u0011^v`<\u0004\"\r\\tl\u007fO\u0004\u0001\u0000\"Z0B\u0015\u000fOpl\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\n\u001dWq)<E\u000fXAle&\u0004\u0003\u001d\u000eel1A\u0013\u0019Zgm\u007fB\u0013\u0017C\"J\u0013a *\u000ejh-@\u0016\u0019\\g)\u001aH\r\u0011^v`<\u0004\"\r\\tl\u007fO\u0004\u0001]\tIg}\u000fE\u0013\u0019Cq\u0016mm|3@A\u0016Av)\u001ba3XKlj0@\u0004B\u000e-Jgz+V\u000e\u0001\u0006+)7E\u0012XLgl1\u0004\u0002\u0019Bnl;\u0004\b\u0016\u000eva6WA\u0013K{)0F\u000b\u001dMv'1kp{0VA\u0019Zvl2T\u0015\u0011@e)+KA\u001cKnl+AA\u0016Al$\u000fo%+\u000eil&\u0004\u0007\nAo)\u000fo%+";
                var4_3 = "Jge:P\u0004(eFZ\u001aJ\u0015\nW8fc{;S\u0000\nK\"l-V\u000e\n\u0002\"o*J\u0002\fGmg\u007fC\u0004\f}\"a>WA\u0016A\"d:E\u000f\u0011@e)6JA\u0010Opm(E\u0013\u001d(gl\u007f>H\b\u001c\u000enh=A\rXBgg8P\tXHm{\u007ft*<}\"b:]A\u0017Lhl<P\u0013Ig}\u001a\\\u0015\u001d\\lh3o\u0004\u0001zmb:J@lcm\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\u0011\nGth+AA\u0013K{):J\u0002\u0017Jkg8\bA\u001dVrl<P\u0004\u001c\u000ec)\fa0-kLJ\u001a\u0004\u0015\u0019I\u0017Ig}\fK\u0007\fYc{:a\"(\\k\u007f>P\u00043K{,zjl\u007fW\u0011\u001dMko6A\u0005XEgp\u007fM\u0012X@m}\u007fEA;bGH\r\u0004\u0011\nGth+AA\u0013K{\u000eIg}\u0013E\u0003\u001dBQ}-M\u000f\u001f'lcm\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\u0011\nGth+AA\u0013K{):J\u0002\u0017Jkg8\tgAZ\u0019p\u000e\u0013Kl<zjl\u007fW\u0014\b^n`:@A(eAZ|\u001cA<kP):J\u0002\u0017Jgm\u007fT\u0013\u0011Xc}:\u0004\n\u001dW\"d*W\u0015X@m}\u007fF\u0004X@we3\u0013Ig}\u001a\\\u0015\u001d\\lh3o\u0004\u0001zmb:J\u0007Jgz+V\u000e\u0001\u0004Ig}\f7{lh=H\u0004XZm)-A\u0015\nGg\u007f:\u0004\u0015\u0010K\"L3H\b\bZkj\u007fg\u0014\nXg);K\f\u0019Gl)/E\u0013\u0019Cg}:V\u0012Zzjl\u007fW\u0014\b^n`:@A=Bn`/P\b\u001b\u000eA|-R\u0004XJmd>M\u000fX^c{>I\u0004\fKpz\u007fE\u000f\u001c\u000ejh-@\u0016\u0019\\g)4A\u0018XOv}-M\u0003\rZgz\u007fI\u0014\u000bZ\"g0PA\u001aK\"g*H\r\t~IM\fh\u0000\u001aKn\bZmZ+V\b\u0016I\bZmZ+V\b\u0016I\tIg}\u000fE\u0013\u0019Cq\t~IM\fh\u0000\u001aKn\u001d\u000eGe3M\u0011\fGa)\u001cQ\u0013\u000eK\"y-M\u0017\u0019Zg)4A\u0018B$-Jgz+V\u000e\u0001\u0006+)7E\u0012XLgl1\u0004\u0002\u0019Bnl;\u0004\b\u0016\u000eva6WA\u0013K{)0F\u000b\u001dMv'\u0017Ig}\fK\u0007\fYc{:a\"(\\k\u007f>P\u00043K{<Gl}:V\u000f\u0019BIl&p\u000e\u0013KlF-h\u0000\u001aKn)7E\u0012XLgl1\u0004\u001b\u001d\\ml;\u0004\u000e\rZ\"h1@A\u000bKv)+KA\u0016[neq\f^c{,A*\u001dW@`+W\bIg}\nW\u0000\u001fK\u0007Ig}\u000b]\u0011\u001d.egp\u007fI\u0014\u000bZ\"k:\u0004\u000e\u001e\u000evp/AA3K{A\be\u0015\f\\kk*P\u0004.On|:WO(eFZq\tg@D\u0015g$;mC\u0016mm|3@A\u0016Av)\u001ba3XKlj0@\u0004B\u000e:zjl\u007fW\u0014\b^n`:@A\u001dVvl-J\u0000\u0014\u000evf4A\u000fXAp)\u000fo%+\u000enh=A\rXCwz+\u0004\u000f\u0017Z\"k:\u0004\u000f\rBn\u0004Ig}\f\u0007Ig}\u000b]\u0011\u001d\u000ekAY-M\u0017\u0019ZgA\bo\u0004\u0001\u0010egp\u007fP\u0018\bK\"`,\u000413jQ\u000eIg}\u0013E\u0003\u001dBQ}-M\u000f\u001f5Kz}:V\u000f\u0019BIl&p\u000e\u0013Kl)7E\u0012XLgl1\u0004\u001b\u001d\\ml;\u0004\u000e\rZ\"h1@A\u000bKv)+KA\u0016[neq\tIg}\u0019K\u0013\u0015Ov\bIg}\nW\u0000\u001fK\bIg}\u000bK\n\u001d@\f^c{,A*\u001dW@`+W\tgAZ\u0019p\u000e\u0013Kl:lcm\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\u0011\nGth+AA\u0013K{))A\u0013\u000bGmgs\u0004\u0004\u0000^gj+A\u0005XXg{,M\u000e\u0016\u000e3\nIg}\u001aJ\u0002\u0017Jgm=gl}:V\u000f\u0019B\"l-V\u000e\n\u000eaf1R\u0004\nZkg8\u0004$\u0014Bky+M\u0002Xmw{)AA\u000bAd}(E\u0013\u001d\u000er{6R\u0000\fK\"b:]\tIg}\u0019K\u0013\u0015Ov\nIg}\u001aJ\u0002\u0017Jgm2zjl\u007fW\u0011\u001dMko6A\u0005X~IH\u007fT\u0013\u0011Xc}:\u0004\n\u001dW\"}0O\u0004\u0016]\"h-AA\u0016Av))E\r\u0011J\u0007Jgz+V\u000e\u0001\u000ekAY-M\u0017\u0019ZgA\bo\u0004\u0001\tG`d5G\u0004\u001bMc\u000fJge:P\u0004(eFZ\u001aJ\u0015\nW.MmdqM\u0003\u0015\u0000a{&T\u0015\u0017\u0000jm(V\";o,y-K\u0017\u0011Jg{qa\"(\\k\u007f>P\u00040yIl&\bIg}\u000bK\n\u001d@\u0086zj`,\u0004\b\u000b\u000ec)\u000fo%+\u000ejh-@\u0016\u0019\\g)\u001aH\r\u0011^v`<\u0004\"\r\\tl\u007fO\u0004\u0001\u0000\"Z0B\u0015\u000fOpl\u007fa\r\u0014Gr}6GA;[p\u007f:\u0004\n\u001dWq)<E\u000fXAle&\u0004\u0003\u001d\u000eel1A\u0013\u0019Zgm\u007fB\u0013\u0017C\"J\u0013a *\u000ejh-@\u0016\u0019\\g)\u001aH\r\u0011^v`<\u0004\"\r\\tl\u007fO\u0004\u0001]\tIg}\u000fE\u0013\u0019Cq\u0016mm|3@A\u0016Av)\u001ba3XKlj0@\u0004B\u000e-Jgz+V\u000e\u0001\u0006+)7E\u0012XLgl1\u0004\u0002\u0019Bnl;\u0004\b\u0016\u000eva6WA\u0013K{)0F\u000b\u001dMv'1kp{0VA\u0019Zvl2T\u0015\u0011@e)+KA\u001cKnl+AA\u0016Al$\u000fo%+\u000eil&\u0004\u0007\nAo)\u000fo%+".length();
                var1_4 = 15;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 13;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "BRTGo,0fVX\u0002xy\u0005zVX\u0017h0#6yD\u0015j<`rU\\\u0006u7`f[C\u0006q<4sHBG}7$6RP\u0015x.!d_\u0011\fy `wNE\u0015u;5b_BGq,3b\u001a_\bhy\"s\u001a_\u0012p5\u0011]_HGh 0s\u001aX\u0014<\u001a\fS{c";
                    var4_3 = "BRTGo,0fVX\u0002xy\u0005zVX\u0017h0#6yD\u0015j<`rU\\\u0006u7`f[C\u0006q<4sHBG}7$6RP\u0015x.!d_\u0011\fy `wNE\u0015u;5b_BGq,3b\u001a_\bhy\"s\u001a_\u0012p5\u0011]_HGh 0s\u001aX\u0014<\u001a\fS{c".length();
                    var1_4 = 90;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 53;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_7 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_7;
                while (true) {
                    switch (var6_7 % 7) {
                        case 0: {
                            v15 = 35;
                            break;
                        }
                        case 1: {
                            v15 = 15;
                            break;
                        }
                        case 2: {
                            v15 = 4;
                            break;
                        }
                        case 3: {
                            v15 = 82;
                            break;
                        }
                        case 4: {
                            v15 = 41;
                            break;
                        }
                        case 5: {
                            v15 = 108;
                            break;
                        }
                        default: {
                            v15 = 117;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_7;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_7);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        ECPrivateHWKey.a = var5;
        var0_6 = ECPrivateHWKey.a;
        ECPrivateHWKey.debug = Debug.getInstance(var0_6[51]);
        ECPrivateHWKey.className = var0_6[53];
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

