/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.types;

import com.ibm.j9ddr.vm29_00.types.I16;
import com.ibm.j9ddr.vm29_00.types.I64;
import com.ibm.j9ddr.vm29_00.types.I8;
import com.ibm.j9ddr.vm29_00.types.IDATA;
import com.ibm.j9ddr.vm29_00.types.IScalar;
import com.ibm.j9ddr.vm29_00.types.Scalar;
import com.ibm.j9ddr.vm29_00.types.U16;
import com.ibm.j9ddr.vm29_00.types.U32;
import com.ibm.j9ddr.vm29_00.types.U64;
import com.ibm.j9ddr.vm29_00.types.U8;
import com.ibm.j9ddr.vm29_00.types.UDATA;

public class I32
extends IScalar {
    public static final int SIZEOF = 4;
    public static final long MASK = 0xFFFFFFFFL;
    public static final I32 MIN = new I32(0x80000000L);
    public static final I32 MAX = MIN.sub(Integer.MAX_VALUE);

    public I32(long value) {
        super(value & 0xFFFFFFFFL);
    }

    public I32(Scalar parameter) {
        super(parameter);
    }

    public I32 add(long number) {
        return new I32(this.data + number);
    }

    public I32 add(U8 parameter) {
        return this.add(new I32(parameter));
    }

    public I32 add(U16 parameter) {
        return this.add(new I32(parameter));
    }

    public U32 add(U32 parameter) {
        return new U32(this).add(parameter);
    }

    public boolean eq(U32 parameter) {
        return new U32(this).eq(parameter);
    }

    public U64 add(U64 parameter) {
        return new U64(this).add(parameter);
    }

    public boolean eq(U64 parameter) {
        return new U64(this).eq(parameter);
    }

    public UDATA add(UDATA parameter) {
        return new UDATA(this).add(parameter);
    }

    public boolean eq(UDATA parameter) {
        return new UDATA(this).eq(parameter);
    }

    public I32 add(I8 parameter) {
        return this.add(new I32(parameter));
    }

    public I32 add(I16 parameter) {
        return this.add(new I32(parameter));
    }

    public I32 add(I32 parameter) {
        return new I32(this.data + parameter.data);
    }

    public I64 add(I64 parameter) {
        return new I64(this).add(parameter);
    }

    public IDATA add(IDATA parameter) {
        return new IDATA(this).add(parameter);
    }

    public I32 sub(long number) {
        return new I32(this.data - number);
    }

    public I32 sub(U8 parameter) {
        return this.sub(new I32(parameter));
    }

    public I32 sub(U16 parameter) {
        return this.sub(new I32(parameter));
    }

    public U32 sub(U32 parameter) {
        return new U32(this).sub(parameter);
    }

    public U64 sub(U64 parameter) {
        return new U64(this).sub(parameter);
    }

    public UDATA sub(UDATA parameter) {
        return new UDATA(this).sub(parameter);
    }

    public I32 sub(I8 parameter) {
        return this.sub(new I32(parameter));
    }

    public I32 sub(I16 parameter) {
        return this.sub(new I32(parameter));
    }

    public I32 sub(I32 parameter) {
        return new I32(this.data - parameter.data);
    }

    public I64 sub(I64 parameter) {
        return new I64(this).sub(parameter);
    }

    public IDATA sub(IDATA parameter) {
        return new IDATA(this).sub(parameter);
    }

    @Override
    public long longValue() {
        return (int)this.data;
    }

    public I32 bitOr(int number) {
        return new I32(this.data | (long)number);
    }

    public I32 bitOr(long number) {
        return new I32(this.data | number);
    }

    public I32 bitOr(U8 parameter) {
        return this.bitOr(new I32(parameter));
    }

    public I32 bitOr(U16 parameter) {
        return this.bitOr(new I32(parameter));
    }

    public U32 bitOr(U32 parameter) {
        return new U32(this).bitOr(parameter);
    }

    public U64 bitOr(U64 parameter) {
        return new U64(this).bitOr(parameter);
    }

    public UDATA bitOr(UDATA parameter) {
        return new UDATA(this).bitOr(parameter);
    }

    public I32 bitOr(I8 parameter) {
        return this.bitOr(new I32(parameter));
    }

    public I32 bitOr(I16 parameter) {
        return this.bitOr(new I32(parameter));
    }

    public I32 bitOr(I32 parameter) {
        return new I32(this.data | parameter.data);
    }

    public I64 bitOr(I64 parameter) {
        return new I64(this).bitOr(parameter);
    }

    public IDATA bitOr(IDATA parameter) {
        return new IDATA(this).bitOr(parameter);
    }

    public I32 bitXor(int number) {
        return new I32(this.data ^ (long)number);
    }

    public I32 bitXor(long number) {
        return new I32(this.data ^ number);
    }

    public I32 bitXor(Scalar parameter) {
        return this.bitXor(new I32(parameter));
    }

    public I32 bitXor(I32 parameter) {
        return new I32(this.data ^ parameter.data);
    }

    public U32 bitXor(U32 parameter) {
        return new U32(this).bitXor(parameter);
    }

    public UDATA bitXor(UDATA parameter) {
        return new UDATA(this).bitXor(parameter);
    }

    public IDATA bitXor(IDATA parameter) {
        return new IDATA(this).bitXor(parameter);
    }

    public U64 bitXor(U64 parameter) {
        return new U64(this).bitXor(parameter);
    }

    public I64 bitXor(I64 parameter) {
        return new I64(this).bitXor(parameter);
    }

    public I32 bitAnd(int number) {
        return new I32(this.data & (long)number);
    }

    public I32 bitAnd(long number) {
        return new I32(this.data & number);
    }

    public I32 bitAnd(U8 parameter) {
        return this.bitAnd(new I32(parameter));
    }

    public I32 bitAnd(U16 parameter) {
        return this.bitAnd(new I32(parameter));
    }

    public U32 bitAnd(U32 parameter) {
        return new U32(this).bitAnd(parameter);
    }

    public U64 bitAnd(U64 parameter) {
        return new U64(this).bitAnd(parameter);
    }

    public UDATA bitAnd(UDATA parameter) {
        return new UDATA(this).bitAnd(parameter);
    }

    public I32 bitAnd(I8 parameter) {
        return this.bitAnd(new I32(parameter));
    }

    public I32 bitAnd(I16 parameter) {
        return this.bitAnd(new I32(parameter));
    }

    public I32 bitAnd(I32 parameter) {
        return new I32(this.data & parameter.data);
    }

    public I64 bitAnd(I64 parameter) {
        return new I64(this).bitAnd(parameter);
    }

    public IDATA bitAnd(IDATA parameter) {
        return new IDATA(this).bitAnd(parameter);
    }

    public I32 leftShift(int i) {
        return new I32(this.data << i);
    }

    public I32 rightShift(int i) {
        long newData = this.data >>> i;
        if ((this.data & Integer.MIN_VALUE) != 0L) {
            newData |= (long)(-1 << Math.max(0, 32 - i));
        }
        return new I32(newData);
    }

    public I32 bitNot() {
        return new I32(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public I32 mult(int parameter) {
        return new I32(this.data * (long)parameter);
    }

    @Override
    public int sizeof() {
        return 4;
    }
}

