/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MemCategoryPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MemCategorySetPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29_00.structure.J9PortLibrary;
import com.ibm.j9ddr.vm29_00.types.U32;

public class J9MemCategoryHelper {
    public static J9MemCategoryPointer getMemoryCategory(U32 memoryCategory) throws CorruptDataException {
        J9PortLibraryPointer portLib = J9RASHelper.getVM(DataType.getJ9RASPointer()).portLibrary();
        if (memoryCategory.eq(J9PortLibrary.J9MEM_CATEGORY_PORT_LIBRARY)) {
            return portLib.omrPortLibrary().portGlobals().portLibraryMemoryCategory();
        }
        if (J9BuildFlags.env_data64 && memoryCategory.eq(J9PortLibrary.J9MEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS)) {
            return portLib.omrPortLibrary().portGlobals().unusedAllocate32HeapRegionsMemoryCategory();
        }
        J9MemCategorySetPointer registeredSet = J9MemCategorySetPointer.NULL;
        long index = 0L;
        if (memoryCategory.lt(new U32(Integer.MAX_VALUE))) {
            registeredSet = portLib.omrPortLibrary().portGlobals().control().language_memory_categories();
            index = memoryCategory.longValue();
        } else {
            registeredSet = portLib.omrPortLibrary().portGlobals().control().omr_memory_categories();
            index = Integer.MAX_VALUE & memoryCategory.longValue();
        }
        if (registeredSet.notNull()) {
            if (registeredSet.numberOfCategories().gt(index) && registeredSet.categories().at(index).notNull()) {
                return J9MemCategoryPointer.cast(registeredSet.categories().at(index));
            }
            return portLib.omrPortLibrary().portGlobals().unknownMemoryCategory();
        }
        return portLib.omrPortLibrary().portGlobals().unknownMemoryCategory();
    }

    public static void visitMemoryCategoryChildren(J9MemCategoryPointer startNode, IJ9MemCategoryVisitor visitor) throws CorruptDataException {
        visitor.visit(startNode);
        int numberOfChildren = startNode.numberOfChildren().intValue();
        for (int i = 0; i < numberOfChildren; ++i) {
            U32 childCode = startNode.children().at(i);
            J9MemCategoryPointer child = J9MemCategoryHelper.getMemoryCategory(childCode);
            if (!child.categoryCode().eq(childCode)) {
                U32 thisCategoryCode = null;
                try {
                    thisCategoryCode = startNode.categoryCode();
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                if (thisCategoryCode == null) {
                    throw new CorruptDataException("Bad memory category child relationship. Memory Category at " + startNode.getHexAddress() + " references unknown memory category code " + childCode);
                }
                throw new CorruptDataException("Bad memory category child relationship. Memory Category at " + startNode.getHexAddress() + " code " + thisCategoryCode + " references unknown memory category code " + childCode);
            }
            J9MemCategoryHelper.visitMemoryCategoryChildren(child, visitor);
        }
    }

    public static interface IJ9MemCategoryVisitor {
        public void visit(J9MemCategoryPointer var1) throws CorruptDataException;
    }
}

