/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.monitors;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm28.j9.ObjectMonitor;
import com.ibm.j9ddr.vm28.j9.walkers.MonitorIterator;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.StructurePointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm28.structure.J9AbstractThread;
import com.ibm.j9ddr.vm28.structure.J9VMThread;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.monitors.JavaDeadlockGraphNode;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.monitors.NativeDeadlockGraphNode;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;
import java.util.HashMap;

public class DeadlockUtils {
    public static void findThreadCycle(J9ThreadPointer aThread, HashMap<Integer, NativeDeadlockGraphNode> deadlocks, HashMap<J9ObjectPointer, Object> objectMonitorsMap) throws CorruptDataException {
        NativeDeadlockGraphNode node = null;
        NativeDeadlockGraphNode prev = null;
        do {
            StructurePointer owner;
            J9VMThreadPointer vmThread;
            boolean isJavaThread = null != (vmThread = J9ThreadHelper.getVMThread(aThread)) && vmThread.notNull();
            boolean isJavaWaiter = false;
            if (isJavaThread) {
                JavaDeadlockGraphNode javaNode = new JavaDeadlockGraphNode();
                javaNode.javaThread = vmThread;
                owner = null;
                J9ObjectPointer lockObject = null;
                J9ThreadAbstractMonitorPointer lock = null;
                lockObject = vmThread.blockingEnterObject();
                if (null != lockObject && lockObject.notNull()) {
                    Object mon;
                    isJavaWaiter = true;
                    Object current = objectMonitorsMap.get(lockObject);
                    if (current instanceof ObjectMonitor) {
                        mon = (ObjectMonitor)current;
                        owner = ((ObjectMonitor)mon).getOwner();
                        lock = ((ObjectMonitor)mon).getInflatedMonitor();
                    } else if (current instanceof J9ThreadMonitorPointer) {
                        mon = (J9ThreadMonitorPointer)current;
                        J9ThreadPointer sysThread = ((J9ThreadMonitorPointer)mon).owner();
                        lock = J9ThreadAbstractMonitorPointer.cast((AbstractPointer)mon);
                        if (sysThread.notNull()) {
                            owner = J9ThreadHelper.getVMThread(sysThread);
                        }
                    }
                    if (null == owner || owner.isNull() || owner.equals(vmThread)) {
                        isJavaWaiter = false;
                    } else {
                        javaNode.javaLock = lock;
                        javaNode.lockObject = lockObject;
                        javaNode.cycle = 0;
                        javaNode.nativeThread = vmThread.osThread();
                        deadlocks.put(javaNode.hashCode(), javaNode);
                        if (null != prev) {
                            prev.next = javaNode;
                        }
                        prev = javaNode;
                        prev.next = deadlocks.get(((J9VMThreadPointer)owner).osThread().hashCode());
                        aThread = ((J9VMThreadPointer)owner).osThread();
                    }
                }
                node = javaNode;
            }
            if (!isJavaThread) {
                node = new NativeDeadlockGraphNode();
            }
            node.nativeThread = aThread;
            J9ThreadMonitorPointer nativeLock = aThread.monitor();
            owner = null;
            if (null == nativeLock || nativeLock.isNull()) {
                if (!isJavaThread) {
                    return;
                }
            } else {
                node.nativeLock = nativeLock;
                owner = nativeLock.owner();
            }
            if (isJavaWaiter) continue;
            deadlocks.put(node.hashCode(), node);
            if (null != prev) {
                prev.next = node;
            }
            if (null == owner || owner.isNull() || owner.equals(aThread)) {
                return;
            }
            prev = node;
            prev.next = deadlocks.get(owner.hashCode());
            aThread = owner;
        } while (null == prev.next);
    }

    public static void writeDeadlockNode(NativeDeadlockGraphNode node, boolean isCycleHead, HashMap<J9ObjectPointer, Object> objectMonitorsMap, PrintStream out) throws CorruptDataException {
        out.println(node.toString());
        String stateMsg = DeadlockUtils.getThreadStateDescription(node);
        if (isCycleHead) {
            out.println("\tis " + stateMsg);
        } else {
            out.println("\twhich is " + stateMsg);
        }
        if (node instanceof JavaDeadlockGraphNode) {
            DeadlockUtils.writeJavaDeadlockNode((JavaDeadlockGraphNode)node, isCycleHead, objectMonitorsMap, out);
        } else {
            DeadlockUtils.writeNativeDeadlockNode(node, isCycleHead, objectMonitorsMap, out);
        }
    }

    private static String getThreadStateDescription(NativeDeadlockGraphNode node) throws CorruptDataException {
        String retVal = "unknown state for:";
        if (node instanceof JavaDeadlockGraphNode) {
            JavaDeadlockGraphNode javaNode = (JavaDeadlockGraphNode)node;
            J9VMThreadPointerUtil.ThreadInfo thrInfo = J9VMThreadPointerUtil.getJ9State(javaNode.javaThread);
            UDATA state = new UDATA(thrInfo.getState());
            if (state.allBitsIn(J9VMThread.J9VMTHREAD_STATE_WAITING) || state.allBitsIn(J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED)) {
                retVal = "waiting for:";
            } else if (state.allBitsIn(J9VMThread.J9VMTHREAD_STATE_BLOCKED)) {
                retVal = "blocking on:";
            }
        } else {
            UDATA flags = node.nativeThread.flags();
            if (flags.allBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED)) {
                retVal = "blocking on:";
            } else if (flags.allBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING)) {
                retVal = "waiting for";
            }
        }
        return retVal;
    }

    private static void writeJavaDeadlockNode(JavaDeadlockGraphNode node, boolean isCycleHead, HashMap<J9ObjectPointer, Object> objectMonitorsMap, PrintStream out) throws CorruptDataException {
        if (null != node.javaLock) {
            String monitorName = "[system]";
            if (node.javaLock.name().notNull()) {
                monitorName = node.javaLock.name().getCStringAtOffset(0L);
            }
            out.print("\t\t" + monitorName);
            out.println(" lock (" + node.javaLock.formatShortInteractive() + ")");
        } else if (null == node.javaLock && null != node.lockObject) {
            String className = J9ObjectHelper.getClassName(node.lockObject);
            out.format("\t\t%s\t\"%s\"\n", node.lockObject.formatShortInteractive(), className);
            ObjectMonitor objMon = (ObjectMonitor)objectMonitorsMap.get(node.lockObject);
            J9ObjectMonitorPointer j9objMonPtr = objMon.getJ9ObjectMonitorPointer();
            if (null != j9objMonPtr && j9objMonPtr.notNull()) {
                out.print(String.format("\t\t%s\n", j9objMonPtr.formatShortInteractive()));
                out.print(String.format("\t\t%s\n", j9objMonPtr.monitor().formatShortInteractive()));
                out.print(String.format("\t\t%s\n", objMon.getOwner().osThread().formatShortInteractive()));
            }
        } else if (null != node.nativeLock) {
            DeadlockUtils.printNativeLockHelper(node.nativeLock, out);
        }
        out.println("\twhich is owned by:");
    }

    private static void writeNativeDeadlockNode(NativeDeadlockGraphNode node, boolean isCycleHead, HashMap<J9ObjectPointer, Object> objectMonitorsMap, PrintStream out) throws CorruptDataException {
        DeadlockUtils.printNativeLockHelper(node.nativeLock, out);
        out.println("\twhich is owned by:");
    }

    private static void printNativeLockHelper(J9ThreadMonitorPointer nativeLock, PrintStream out) throws CorruptDataException {
        String monitorName = "[system]";
        if (nativeLock.name().notNull()) {
            monitorName = nativeLock.name().getCStringAtOffset(0L);
        }
        out.print("\t\t" + monitorName);
        out.println(" lock (" + nativeLock.formatShortInteractive() + ")");
    }

    public static HashMap<J9ObjectPointer, Object> readObjectMonitors(J9JavaVMPointer vm) throws CorruptDataException {
        HashMap<J9ObjectPointer, Object> objectMonitorsMap = new HashMap<J9ObjectPointer, Object>();
        MonitorIterator iterator = new MonitorIterator(vm);
        while (iterator.hasNext()) {
            J9ThreadAbstractMonitorPointer lock;
            Object mon;
            Object current = iterator.next();
            if (current instanceof ObjectMonitor) {
                mon = (ObjectMonitor)current;
                J9ObjectPointer object = ((ObjectMonitor)mon).getObject();
                objectMonitorsMap.put(object, mon);
                continue;
            }
            if (!(current instanceof J9ThreadMonitorPointer) || (lock = J9ThreadAbstractMonitorPointer.cast((AbstractPointer)(mon = (J9ThreadMonitorPointer)current))).userData().eq(0L)) continue;
            J9ObjectPointer object = J9ObjectPointer.cast(lock.userData());
            objectMonitorsMap.put(object, mon);
        }
        return objectMonitorsMap;
    }
}

