/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.tenant.TenantContextHelper;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class TenantCheckCommand
extends Command {
    public TenantCheckCommand() {
        this.addCommand("tenantcheck", "", "Validates tenant data structures");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            TenantContextHelper tenantContextHelper = new TenantContextHelper(vm);
            this.checkClasses(vm, tenantContextHelper, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void checkClasses(J9JavaVMPointer vm, TenantContextHelper tenantContextHelper, PrintStream out) throws CorruptDataException {
        int problemsFound = 0;
        out.print("checking class->tenant mappings ...");
        for (J9ObjectPointer tenantObject : tenantContextHelper.getAllTenants()) {
            for (J9ObjectPointer heapClass : tenantContextHelper.getClasses(tenantObject)) {
                J9ObjectPointer classLoaderTenant;
                J9ClassPointer ramClass = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(heapClass);
                PointerPointer tenantJNIRef = ramClass.classLoader().hostTenant();
                if (tenantJNIRef.isNull() || tenantObject.equals(classLoaderTenant = J9ObjectPointer.cast(tenantJNIRef.at(0L)))) continue;
                out.printf("\n  %s(%s) located in region for tenant %s but heapClass->ramClass->hostTenant was %s", J9ClassHelper.getName(ramClass), ramClass.getHexAddress(), tenantContextHelper.id(tenantObject), tenantContextHelper.id(classLoaderTenant));
                ++problemsFound;
            }
        }
        if (0 == problemsFound) {
            out.println(" ok");
        } else {
            out.printf("\n  fail (%d problems found)\n", problemsFound);
        }
    }
}

