/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectMonitor;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.structure.J9AbstractThread;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.structure.J9VMThread;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.HashMap;

public class J9VMThreadPointerUtil {
    private static int STATE_ALIVE = 1;
    private static int STATE_TERMINATED = 2;
    private static int STATE_RUNNABLE = 4;
    private static int STATE_WAITING_INDEFINITELY = 16;
    private static int STATE_WAITING_WITH_TIMEOUT = 32;
    private static int STATE_SLEEPING = 64;
    private static int STATE_WAITING = 128;
    private static int STATE_IN_OBJECT_WAIT = 256;
    private static int STATE_PARKED = 512;
    private static int STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static int STATE_SUSPENDED = 0x100000;
    private static int STATE_INTERRUPTED = 0x200000;
    private static int STATE_IN_NATIVE = 0x400000;
    private static int STATE_VENDOR_1 = 0x10000000;
    private static int STATE_VENDOR_2 = 0x20000000;
    private static int STATE_VENDOR_3 = 0x40000000;
    private static final int J9THREAD_MONITOR_OBJECT = 393216;
    private static final HashMap<Long, Integer> threadStateMap = new HashMap(9);

    public static int getDTFJState(J9VMThreadPointer vmThread) throws CorruptDataException {
        try {
            return threadStateMap.get(J9VMThreadPointerUtil.getJ9State(vmThread).state);
        }
        catch (NullPointerException e) {
            return STATE_VENDOR_3;
        }
    }

    public static ThreadInfo getJ9State(J9VMThreadPointer targetThread) throws CorruptDataException {
        ThreadInfo thrinfo = new ThreadInfo();
        if (targetThread.isNull()) {
            thrinfo.state = new UDATA(J9VMThread.J9VMTHREAD_STATE_UNKNOWN).longValue();
            return thrinfo;
        }
        thrinfo.thread = targetThread;
        long vmstate = J9VMThread.J9VMTHREAD_STATE_RUNNING;
        UDATA publicFlags = targetThread.publicFlags();
        J9ThreadPointer j9self = targetThread.osThread();
        ThreadState j9state = new ThreadState(j9self);
        if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED | J9Consts.J9_PUBLIC_FLAGS_THREAD_WAITING)) {
            thrinfo.lockObject = targetThread.blockingEnterObject();
            ObjectMonitor monitor = ObjectMonitor.fromJ9Object(thrinfo.lockObject);
            if (monitor.isInflated()) {
                if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED)) {
                    if (monitor.getOwner().notNull() && !monitor.getOwner().equals(j9self)) {
                        vmstate = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
                        thrinfo.rawLock = J9ThreadMonitorPointer.cast(monitor.getInflatedMonitor());
                    }
                } else if (j9self.isNull()) {
                    vmstate = publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_TIMED) ? J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED : J9VMThread.J9VMTHREAD_STATE_WAITING;
                    thrinfo.rawLock = J9ThreadMonitorPointer.cast(monitor.getInflatedMonitor());
                } else if (monitor.getInflatedMonitor().equals(j9state.blocker)) {
                    vmstate = J9VMThreadPointerUtil.getInflatedMonitorState(j9self, j9state, thrinfo);
                }
            } else if (monitor.getOwner().notNull() && !monitor.getOwner().equals(targetThread)) {
                vmstate = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
            }
        } else if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_PARKED)) {
            if (j9self.isNull() || j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_PARKED)) {
                thrinfo.lockObject = targetThread.blockingEnterObject();
                vmstate = publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_TIMED) ? J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED : J9VMThread.J9VMTHREAD_STATE_PARKED;
            }
        } else if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_SLEEPING)) {
            if (j9self.isNull() || j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
                vmstate = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
            }
        } else if (j9self.isNull()) {
            vmstate = J9VMThread.J9VMTHREAD_STATE_UNKNOWN;
        } else if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_PARKED)) {
            vmstate = j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_TIMER_SET) ? J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED : J9VMThread.J9VMTHREAD_STATE_PARKED;
        } else if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
            vmstate = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
        } else if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_DEAD)) {
            vmstate = J9VMThread.J9VMTHREAD_STATE_DEAD;
        }
        if (J9VMThread.J9VMTHREAD_STATE_RUNNING == vmstate) {
            thrinfo.lockObject = null;
            vmstate = J9VMThreadPointerUtil.getInflatedMonitorState(j9self, j9state, thrinfo);
        }
        if (thrinfo.rawLock != null && thrinfo.rawLock.flags().allBitsIn(393216L)) {
            thrinfo.lockObject = J9ObjectPointer.cast(thrinfo.rawLock.userData());
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_INTERRUPTED)) {
            vmstate |= J9VMThread.J9VMTHREAD_STATE_INTERRUPTED;
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SUSPENDED)) {
            vmstate |= J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
        }
        if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_HALT_THREAD_JAVA_SUSPEND)) {
            vmstate |= J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
        }
        thrinfo.state = new UDATA(vmstate).longValue();
        return thrinfo;
    }

    private static long getInflatedMonitorState(J9ThreadPointer j9self, ThreadState j9state, ThreadInfo thrinfo) {
        if (j9self.isNull()) {
            return J9VMThread.J9VMTHREAD_STATE_UNKNOWN;
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED) && j9state.owner.notNull() && !j9state.owner.equals(j9self)) {
            thrinfo.rawLock = j9state.blocker;
            return J9VMThread.J9VMTHREAD_STATE_BLOCKED;
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING) && !j9state.owner.equals(j9self)) {
            thrinfo.rawLock = j9state.blocker;
            if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_TIMER_SET)) {
                return J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED;
            }
            return J9VMThread.J9VMTHREAD_STATE_WAITING;
        }
        return J9VMThread.J9VMTHREAD_STATE_RUNNING;
    }

    static {
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_DEAD, STATE_TERMINATED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_SUSPENDED, STATE_ALIVE | STATE_SUSPENDED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_RUNNING, STATE_ALIVE | STATE_RUNNABLE);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_BLOCKED, STATE_ALIVE | STATE_BLOCKED_ON_MONITOR_ENTER);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_WAITING, STATE_ALIVE | STATE_WAITING | STATE_WAITING_INDEFINITELY | STATE_IN_OBJECT_WAIT);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_WITH_TIMEOUT | STATE_IN_OBJECT_WAIT);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_SLEEPING, STATE_ALIVE | STATE_WAITING | STATE_SLEEPING);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_PARKED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_INDEFINITELY | STATE_PARKED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_WITH_TIMEOUT | STATE_PARKED);
    }

    public static class ThreadInfo {
        private long state = 0L;
        private J9ObjectPointer lockObject;
        private J9ThreadMonitorPointer rawLock;
        private J9VMThreadPointer lockOwner;
        private J9VMThreadPointer thread;

        private ThreadInfo() {
        }

        public long getState() {
            return this.state;
        }

        public J9ObjectPointer getLockObject() {
            return this.lockObject;
        }

        public J9ThreadMonitorPointer getRawLock() {
            return this.rawLock;
        }

        public J9VMThreadPointer getLockOwner() {
            return this.lockOwner;
        }

        public J9VMThreadPointer getThread() {
            return this.thread;
        }
    }

    private static class ThreadState {
        private UDATA flags;
        private J9ThreadMonitorPointer blocker;
        private J9ThreadPointer owner;

        public ThreadState(J9ThreadPointer j9self) throws CorruptDataException {
            if (j9self.isNull()) {
                this.flags = new UDATA(0L);
                this.blocker = J9ThreadMonitorPointer.NULL;
                this.owner = J9ThreadPointer.NULL;
            } else {
                this.flags = j9self.flags();
                this.blocker = j9self.monitor();
                this.owner = this.blocker.isNull() ? J9ThreadPointer.NULL : this.blocker.owner();
            }
        }
    }
}

