/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9CfrClassFile;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.structure.J9ROMMethod;
import com.ibm.j9ddr.vm24.types.UDATA;

public class J9ROMMethodHelper {
    public static String getName(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return J9UTF8Helper.stringValue(romMethod.nameAndSignature().name());
    }

    public static String getSignature(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return J9UTF8Helper.stringValue(romMethod.nameAndSignature().signature());
    }

    public static U8Pointer bytecodes(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return U8Pointer.cast(romMethod).addOffset(J9ROMMethod.SIZEOF);
    }

    public static UDATA bytecodeSize(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.bytecodeSizeLow().add(new UDATA(romMethod.bytecodeSizeHigh().leftShift(16)));
    }

    public static U8Pointer bytecodeEnd(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return J9ROMMethodHelper.bytecodes(romMethod).add(J9ROMMethodHelper.bytecodeSize(romMethod));
    }

    public static boolean isGetter(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccGetterMethod);
    }

    public static boolean isForwarder(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccForwarderMethod);
    }

    public static boolean isEmpty(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccEmptyMethod);
    }

    public static boolean hasVTable(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodVTable);
    }

    public static boolean hasExceptionInfo(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo);
    }

    public static boolean hasBackwardBranches(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasBackwardBranches);
    }

    public static boolean isAsyncInterruptable(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodAsyncInterruptable);
    }

    public static boolean isDebuggable(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodDebuggable);
    }

    public static boolean hasGenericSignature(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasGenericSignature);
    }

    public static boolean hasManyIterationLoops(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return romMethod.modifiers().allBitsIn(J9JavaAccessFlags.J9AccMethodHasManyIterationsLoops);
    }

    public static J9ROMMethodPointer romMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return J9ROMMethodPointer.cast(J9ROMMethodHelper.bytecodes(romMethod).addOffset(-J9ROMMethod.SIZEOF));
    }

    public static boolean isNonEmptyObjectConstructor(J9ROMMethodPointer method) throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("ALG_OBJECT_CONSTRUCTOR_VERSION").getAlgorithmVersion() >= 1) {
            return method.modifiers().maskAndCompare(J9JavaAccessFlags.J9AccMethodObjectConstructor + J9JavaAccessFlags.J9AccEmptyMethod, J9JavaAccessFlags.J9AccMethodObjectConstructor);
        }
        return false;
    }

    public static int getReflectModifiers(J9ROMMethodPointer method) throws CorruptDataException {
        return method.modifiers().bitAnd(J9CfrClassFile.CFR_METHOD_ACCESS_MASK).intValue();
    }
}

