/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.walkers.SegmentIterator;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.structure.J9MemorySegment;
import com.ibm.j9ddr.vm24.structure.J9Object;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassSegmentIterator
implements Iterator {
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private final Iterator segments;
    private J9MemorySegmentPointer segment;
    private U8Pointer heapPtr = null;
    private boolean isJIT = false;
    private boolean EOS = false;
    private boolean hasNextClass = false;
    private J9ClassPointer clazzPtr = null;

    public ClassSegmentIterator(J9JavaVMPointer vm, J9MemorySegmentListPointer source) throws CorruptDataException {
        this(vm, source.nextSegment());
    }

    public ClassSegmentIterator(J9JavaVMPointer vm, J9MemorySegmentPointer source) throws CorruptDataException {
        this.segments = new SegmentIterator(source, J9MemorySegment.MEMORY_TYPE_RAM_CLASS, true);
        this.isJIT = vm.jitConfig().notNull();
        this.EOS = !this.segments.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextClass) {
            return true;
        }
        if (this.EOS) {
            return false;
        }
        while (!this.hasNextClass) {
            try {
                if (this.heapPtr == null || this.heapPtr.gte(this.segment.heapAlloc())) {
                    boolean bl = this.EOS = !this.segments.hasNext();
                    if (this.EOS) {
                        return false;
                    }
                    this.segment = (J9MemorySegmentPointer)this.segments.next();
                    this.heapPtr = this.segment.heapBase();
                }
                if (this.isJIT) {
                    this.heapPtr = this.heapPtr.add(UDATAPointer.cast(this.heapPtr).at(0L));
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.format("Class found : SEG=0x%016x : PTR=0x%016x", this.segment.getAddress(), this.heapPtr.getAddress()));
                }
                this.clazzPtr = J9ClassPointer.cast(this.heapPtr);
                this.hasNextClass = true;
                this.heapPtr = this.heapPtr.add(this.clazzPtr.size());
                this.heapPtr = this.heapPtr.add(J9Object.SIZEOF);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Problem locating the next class", e, false);
                this.EOS = this.segments.hasNext();
                if (this.EOS) {
                    return false;
                }
                this.heapPtr = null;
            }
        }
        return this.hasNextClass;
    }

    public Object next() {
        if (this.hasNext()) {
            this.hasNextClass = false;
            return this.clazzPtr;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }
}

