/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.HashTable;
import com.ibm.j9ddr.vm24.j9.SlotIterator;
import com.ibm.j9ddr.vm24.j9.StringTable;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.types.I32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.NoSuchElementException;

public class StringTable_V2
extends StringTable {
    protected HashTable<PointerPointer> stringTable;

    protected StringTable_V2(HashTable<PointerPointer> hashTable) throws CorruptDataException {
        this.stringTable = hashTable;
    }

    public static StringTable fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        HashTable<PointerPointer> hashTable = HashTable.fromJ9HashTable(vm.stringTable(), false, PointerPointer.class, new StringHashFunction(), new StringComparatorFunction());
        return new StringTable_V2(hashTable);
    }

    @Override
    public SlotIterator<J9ObjectPointer> iterator() {
        return new SlotIterator<J9ObjectPointer>(){
            SlotIterator<PointerPointer> stringTableIterator;
            {
                this.stringTableIterator = StringTable_V2.this.stringTable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.stringTableIterator.hasNext();
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    PointerPointer next = (PointerPointer)this.stringTableIterator.next();
                    return J9ObjectPointer.cast(next);
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    return VoidPointer.cast(this.stringTableIterator.nextAddress());
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                this.stringTableIterator.remove();
            }
        };
    }

    @Override
    public long getCount() {
        return this.stringTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.stringTable.getTableName();
    }

    @Override
    public J9ObjectPointer search(J9ObjectPointer objectPointer) throws CorruptDataException {
        PointerPointer result = this.stringTable.find(PointerPointer.cast(objectPointer));
        return J9ObjectPointer.cast(result);
    }

    public static class StringComparatorFunction<StructType extends AbstractPointer>
    implements HashTable.HashComparatorFunction<StructType> {
        @Override
        public int compare(StructType o1, StructType o2) throws CorruptDataException {
            J9ObjectPointer leftObject = J9ObjectPointer.cast(o1);
            J9ObjectPointer rightObject = J9ObjectPointer.cast(o2);
            String leftString = J9ObjectHelper.stringValue(leftObject);
            String rightString = J9ObjectHelper.stringValue(rightObject);
            return leftString.compareTo(rightString);
        }
    }

    public static class StringEqualFunction<StructType extends AbstractPointer>
    implements HashTable.HashEqualFunction<StructType> {
        @Override
        public boolean equal(StructType left, StructType right) {
            try {
                J9ObjectPointer leftObject = J9ObjectPointer.cast(left);
                J9ObjectPointer rightObject = J9ObjectPointer.cast(right);
                String leftString = J9ObjectHelper.stringValue(leftObject);
                String rightString = J9ObjectHelper.stringValue(rightObject);
                return leftString.equals(rightString);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }

    public static class StringHashFunction<StructType extends AbstractPointer>
    implements HashTable.HashFunction<StructType> {
        @Override
        public UDATA hash(StructType entry) {
            try {
                J9ObjectPointer entryObject = J9ObjectPointer.cast(entry);
                String stringValue = J9ObjectHelper.stringValue(entryObject);
                I32 hashCode = new I32(stringValue.hashCode());
                return new UDATA(hashCode);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
        }
    }
}

