/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.corereaders.minidump.EarlyInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import java.io.IOException;

class MiscInfoStream
extends EarlyInitializedStream {
    private static final int MISC1_PROCESS_ID = 1;

    public MiscInfoStream(int dataSize, int location) {
        super(dataSize, location);
    }

    @Override
    public void readFrom(MiniDumpReader dump) throws IOException {
        dump.seek(this.getLocation());
        if (this.getDataSize() < 4) {
            return;
        }
        int infoSize = dump.readInt();
        if (infoSize > this.getDataSize()) {
            infoSize = this.getDataSize();
        }
        if ((infoSize = infoSize / 4 - 1) <= 0) {
            return;
        }
        int[] misc = new int[infoSize];
        for (int i = 0; i < infoSize; ++i) {
            misc[i] = dump.readInt();
        }
        int flags = misc[0];
        if ((flags & 1) != 0 && infoSize > 1) {
            dump.setProcessID(misc[1]);
        }
    }
}

