/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public final class ThreadPoolRepositoryManager {
    private static final TraceComponent tc = Tr.register(ThreadPoolRepositoryManager.class, null, null);
    private static ThreadPoolRepository _threadPoolRepository;
    static /* synthetic */ Class class$com$ibm$wsspi$runtime$ThreadPoolRepositoryManager$DefaultThreadPoolRepository;

    private ThreadPoolRepositoryManager() {
    }

    public static ThreadPoolRepository getThreadPoolRepository() {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getThreadPoolRepository");
            }
            if (_threadPoolRepository != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getThreadPoolRepository", _threadPoolRepository);
                }
                return _threadPoolRepository;
            }
            String string = System.getProperty("com.ibm.wsspi.runtime.ThreadPoolRepositoryName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Thread pool repository name", string);
            }
            Class<?> clazz = null;
            if (string == null) {
                _threadPoolRepository = new DefaultThreadPoolRepository();
            } else {
                block16: {
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        if (classLoader != null) {
                            clazz = classLoader.loadClass(string);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.wsspi.runtime.ThreadPoolRepositoryManager.getThreadPoolRepository", "92");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Class load failed using context class loader", exception);
                        }
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException(exception2, "com.ibm.wsspi.runtime.ThreadPoolRepositoryManager.getThreadPoolRepository", "100");
                            if (!tc.isDebugEnabled()) break block16;
                            Tr.debug(tc, "Class load failed using Class.forName", exception2);
                        }
                    }
                }
                if (clazz != null) {
                    try {
                        _threadPoolRepository = (ThreadPoolRepository)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.wsspi.runtime.ThreadPoolRepositoryManager.getThreadPoolRepository", "116");
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug(tc, "The creation of a new instance of class " + clazz + "failed", exception);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPoolRepository", _threadPoolRepository);
        }
        return _threadPoolRepository;
    }

    private static class DefaultThreadPool
    implements ThreadPool {
        private static final int DEFAULT_MAXIMUM_POOL_SIZE = 10;
        private static final int DEFAULT_MINIMUM_POOL_SIZE = 0;
        private static final long DEFAULT_KEEP_ALIVE_TIME = 5000L;
        private int _maximumPoolSize = 10;
        private int _minimumPoolSize = 0;
        private int _poolSize = 0;
        private int _activeThreads = 0;
        private long _keepAliveTime = 5000L;
        private BoundedBuffer _requestBuffer;
        private boolean _shutdown = false;
        private int _threadId = 0;
        protected String _name;
        private int _requestBufferExpansionLimit;
        private int _requestBufferInitialCapacity;
        private int _daemonId = -1;

        public DefaultThreadPool(String string, int n, int n2, long l) {
            this(string, n, n2, l, Math.max(n2, 1));
        }

        public DefaultThreadPool(String string, int n, int n2, long l, int n3) {
            this._name = string;
            this._maximumPoolSize = n2;
            this._minimumPoolSize = n;
            this._keepAliveTime = l;
            this._requestBufferInitialCapacity = n3;
            this._requestBufferExpansionLimit = this._requestBufferInitialCapacity * 10;
            this._requestBuffer = new BoundedBuffer(this._requestBufferInitialCapacity);
        }

        public void setThreadWaiting(boolean bl) {
        }

        protected void addThread(Runnable runnable) {
            Worker worker = new Worker(runnable, this._threadId++);
            ++this._poolSize;
            ++this._activeThreads;
            worker.start();
        }

        protected synchronized void workerDone(Worker worker, boolean bl) {
            if (bl) {
                --this._activeThreads;
                --this._poolSize;
            }
            if (this._poolSize == 0 && this._shutdown) {
                this._maximumPoolSize = 0;
                this._minimumPoolSize = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Runnable getTask() throws InterruptedException {
            Runnable runnable = null;
            boolean bl = true;
            while (true) {
                long l;
                DefaultThreadPool defaultThreadPool = this;
                synchronized (defaultThreadPool) {
                    if (bl) {
                        --this._activeThreads;
                    }
                    if (this._poolSize > this._maximumPoolSize && !bl) {
                        --this._poolSize;
                        return null;
                    }
                    l = this._shutdown ? 0L : (this._poolSize <= this._minimumPoolSize ? -1L : this._keepAliveTime);
                }
                runnable = l >= 0L ? (Runnable)this._requestBuffer.poll(l) : (Runnable)this._requestBuffer.take();
                defaultThreadPool = this;
                synchronized (defaultThreadPool) {
                    if (runnable == null) {
                        runnable = (Runnable)this._requestBuffer.poll(0L);
                    }
                    if (runnable != null) {
                        ++this._activeThreads;
                        break;
                    }
                    if (this._poolSize > this._minimumPoolSize) {
                        --this._poolSize;
                        break;
                    }
                }
                bl = false;
            }
            return runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeOnDaemon(Runnable runnable) {
            int n = 0;
            final Runnable runnable2 = runnable;
            Object object = this;
            synchronized (object) {
                ++this._daemonId;
                n = this._daemonId;
            }
            object = this._name + " : DMN" + n;
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction((String)object){
                private final /* synthetic */ String val$runId;
                {
                    this.val$runId = string;
                }

                public Object run() {
                    Thread thread = new Thread(runnable2, this.val$runId);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            thread.start();
        }

        public int execute(Runnable runnable) {
            return this.execute(runnable, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Runnable runnable, int n) {
            int n2;
            int n3;
            block20: {
                boolean bl = false;
                if (this._shutdown) {
                    return 1;
                }
                while (true) {
                    if (!bl) {
                        try {
                            bl = this._requestBuffer.offer(runnable, 0L);
                            if (bl && this._minimumPoolSize == this._maximumPoolSize && this._poolSize == this._minimumPoolSize) {
                                return 0;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DefaultThreadPool defaultThreadPool = this;
                    synchronized (defaultThreadPool) {
                        if (!this._shutdown) {
                            n3 = this._poolSize;
                            if (bl && n3 - this._activeThreads > this._requestBuffer.size()) {
                                return 0;
                            }
                            if (n3 < this._maximumPoolSize) {
                                AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        DefaultThreadPool.this.addThread(null);
                                        return null;
                                    }
                                });
                            }
                            if (bl) {
                                return 0;
                            }
                        } else {
                            return 1;
                        }
                    }
                    if (n == 1) {
                        try {
                            this._requestBuffer.put(runnable);
                            bl = true;
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (n == 0) {
                        return 2;
                    }
                    n2 = this._requestBuffer.capacity();
                    if (n2 != this._requestBufferExpansionLimit) break block20;
                    if (n != 3) break;
                    try {
                        this._requestBuffer.put(runnable);
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return 2;
            }
            n3 = Math.min(n2 / 2, this._requestBufferExpansionLimit - n2);
            this._requestBuffer.expand(n3);
            return this.execute(runnable, n);
        }

        public void setMinimumPoolSize(int n) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void setMaximumPoolSize(int n) {
            throw new UnsupportedOperationException();
        }

        public int getMaximumPoolSize() {
            return this._maximumPoolSize;
        }

        public void setKeepAliveTime(long l) {
            this._keepAliveTime = l;
        }

        public void shutdown() {
            this._shutdown = true;
            if (this._poolSize == 0) {
                this._maximumPoolSize = 0;
                this._minimumPoolSize = 0;
            }
            ((DefaultThreadPoolRepository)_threadPoolRepository).removeThreadPool(this._name);
        }

        private class BoundedBuffer {
            private Object[] buffer;
            private int takeIndex = 0;
            private int putIndex = 0;
            private int numberOfUsedSlots = 0;
            private int numberOfEmptySlots;
            private final Object lock = new Object();

            public BoundedBuffer(int n) throws IllegalArgumentException {
                if (n <= 0) {
                    throw new IllegalArgumentException();
                }
                this.buffer = new Object[n];
                this.numberOfEmptySlots = n;
            }

            public synchronized int size() {
                return this.numberOfUsedSlots;
            }

            public int capacity() {
                return this.buffer.length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object peek() {
                BoundedBuffer boundedBuffer = this;
                synchronized (boundedBuffer) {
                    if (this.numberOfUsedSlots > 0) {
                        return this.buffer[this.takeIndex];
                    }
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void put(Object object) throws InterruptedException {
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    while (this.numberOfEmptySlots <= 0) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.lock.notify();
                            throw interruptedException;
                        }
                    }
                    this.insert(object);
                }
                this.incrementUsedSlotCount();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object put(Object object, long l) throws InterruptedException {
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    long l2 = l <= 0L ? 0L : System.currentTimeMillis();
                    long l3 = l;
                    while (this.numberOfEmptySlots <= 0) {
                        if (l3 <= 0L) {
                            return null;
                        }
                        try {
                            this.lock.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            this.lock.notify();
                            throw interruptedException;
                        }
                        l3 = l - (System.currentTimeMillis() - l2);
                    }
                    this.insert(object);
                }
                this.incrementUsedSlotCount();
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object put(Object object, long l, int n) throws InterruptedException {
                if (object == null || n > this.buffer.length) {
                    throw new IllegalArgumentException();
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    int n2 = this.buffer.length - n;
                    long l2 = l <= 0L ? 0L : System.currentTimeMillis();
                    long l3 = l;
                    while (this.numberOfEmptySlots - n2 <= 0) {
                        if (l3 <= 0L) {
                            return null;
                        }
                        try {
                            this.lock.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            this.lock.notify();
                            throw interruptedException;
                        }
                        l3 = l - (System.currentTimeMillis() - l2);
                    }
                    this.insert(object);
                }
                this.incrementUsedSlotCount();
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean offer(Object object, long l) throws InterruptedException {
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                long l2 = l <= 0L ? 0L : System.currentTimeMillis();
                long l3 = l;
                Object object2 = this.lock;
                synchronized (object2) {
                    while (this.numberOfEmptySlots <= 0) {
                        if (l3 <= 0L) {
                            return false;
                        }
                        try {
                            this.lock.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            this.lock.notify();
                            throw interruptedException;
                        }
                        l3 = l - (System.currentTimeMillis() - l2);
                    }
                    this.insert(object);
                }
                this.incrementUsedSlotCount();
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object take() throws InterruptedException {
                Object object = null;
                BoundedBuffer boundedBuffer = this;
                synchronized (boundedBuffer) {
                    while (this.numberOfUsedSlots <= 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.notify();
                            throw interruptedException;
                        }
                    }
                    object = this.extract();
                }
                this.incrementEmptySlotCount();
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object poll(long l) throws InterruptedException {
                Object object = null;
                long l2 = l <= 0L ? 0L : System.currentTimeMillis();
                long l3 = l;
                BoundedBuffer boundedBuffer = this;
                synchronized (boundedBuffer) {
                    while (this.numberOfUsedSlots <= 0) {
                        if (l3 <= 0L) {
                            return null;
                        }
                        try {
                            this.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            this.notify();
                            throw interruptedException;
                        }
                        l3 = l - (System.currentTimeMillis() - l2);
                    }
                    object = this.extract();
                }
                this.incrementEmptySlotCount();
                return object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void incrementEmptySlotCount() {
                Object object = this.lock;
                synchronized (object) {
                    ++this.numberOfEmptySlots;
                    this.lock.notify();
                }
            }

            private synchronized void incrementUsedSlotCount() {
                ++this.numberOfUsedSlots;
                this.notify();
            }

            private final void insert(Object object) {
                --this.numberOfEmptySlots;
                this.buffer[this.putIndex] = object;
                if (++this.putIndex >= this.buffer.length) {
                    this.putIndex = 0;
                }
            }

            private final Object extract() {
                --this.numberOfUsedSlots;
                Object object = this.buffer[this.takeIndex];
                this.buffer[this.takeIndex] = null;
                if (++this.takeIndex >= this.buffer.length) {
                    this.takeIndex = 0;
                }
                return object;
            }

            public synchronized void expand(int n) {
                if (n <= 0) {
                    throw new IllegalArgumentException();
                }
                Object[] objectArray = new Object[this.buffer.length + n];
                if (this.putIndex > this.takeIndex) {
                    System.arraycopy(this.buffer, this.takeIndex, objectArray, 0, this.numberOfUsedSlots);
                } else {
                    System.arraycopy(this.buffer, this.takeIndex, objectArray, 0, this.buffer.length - this.takeIndex);
                    System.arraycopy(this.buffer, 0, objectArray, this.buffer.length - this.takeIndex, this.putIndex);
                }
                this.putIndex = this.numberOfUsedSlots;
                this.takeIndex = 0;
                this.numberOfEmptySlots = objectArray.length - this.numberOfUsedSlots;
                this.buffer = objectArray;
            }
        }

        private class Worker
        extends Thread
        implements ThreadPool.WorkerThread {
            protected Runnable _firstTask;

            protected Worker(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
                super(threadGroup, runnable, string, l);
            }

            protected Worker(Runnable runnable, int n) {
                super(DefaultThreadPool.this._name + " : " + n);
                this._firstTask = runnable;
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Runnable runnable = this._firstTask;
                try {
                    this._firstTask = null;
                    do {
                        if (runnable == null) continue;
                        runnable.run();
                    } while ((runnable = DefaultThreadPool.this.getTask()) != null);
                    DefaultThreadPool.this.workerDone(this, runnable != null);
                }
                catch (InterruptedException interruptedException) {
                    DefaultThreadPool.this.workerDone(this, runnable != null);
                    catch (Throwable throwable) {
                        DefaultThreadPool.this.workerDone(this, runnable != null);
                        throw throwable;
                    }
                }
            }
        }
    }

    private static class DefaultThreadPoolRepository
    implements ThreadPoolRepository {
        private static final TraceComponent tc = Tr.register(class$com$ibm$wsspi$runtime$ThreadPoolRepositoryManager$DefaultThreadPoolRepository == null ? (class$com$ibm$wsspi$runtime$ThreadPoolRepositoryManager$DefaultThreadPoolRepository = ThreadPoolRepositoryManager.class$("com.ibm.wsspi.runtime.ThreadPoolRepositoryManager$DefaultThreadPoolRepository")) : class$com$ibm$wsspi$runtime$ThreadPoolRepositoryManager$DefaultThreadPoolRepository, null, null);
        private static HashMap _threadPools = new HashMap();

        private DefaultThreadPoolRepository() {
        }

        public ThreadPool createThreadPool(String string) throws ThreadPoolAlreadyKnownException {
            return this.createThreadPool(string, 0, 10, 5000L);
        }

        public ThreadPool createThreadPool(String string, int n, int n2) throws ThreadPoolAlreadyKnownException {
            return this.createThreadPool(string, n, n2, 5000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadPool createThreadPool(String string, int n, int n2, long l) throws ThreadPoolAlreadyKnownException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createThreadPool", new Object[]{string, new Integer(n), new Integer(n2), new Long(l), this});
            }
            HashMap hashMap = _threadPools;
            synchronized (hashMap) {
                if (_threadPools.containsKey(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Known thread pools", _threadPools);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createThreadPool", "ThreadPoolAlreadyKnownException");
                    }
                    throw new ThreadPoolAlreadyKnownException();
                }
                DefaultThreadPool defaultThreadPool = new DefaultThreadPool(string, n, n2, l);
                _threadPools.put(string, defaultThreadPool);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createThreadPool", defaultThreadPool);
                }
                return defaultThreadPool;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadPool createThreadPool(String string, int n, int n2, long l, int n3) throws ThreadPoolAlreadyKnownException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createThreadPool", new Object[]{string, new Integer(n), new Integer(n2), new Long(l), new Integer(n3), this});
            }
            HashMap hashMap = _threadPools;
            synchronized (hashMap) {
                if (_threadPools.containsKey(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Known thread pools", _threadPools);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createThreadPool", "ThreadPoolAlreadyKnownException");
                    }
                    throw new ThreadPoolAlreadyKnownException();
                }
                DefaultThreadPool defaultThreadPool = new DefaultThreadPool(string, n, n2, l, n3);
                _threadPools.put(string, defaultThreadPool);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createThreadPool", defaultThreadPool);
                }
                return defaultThreadPool;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadPool getThreadPool(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getThreadPool", new Object[]{string, this});
            }
            ThreadPool threadPool = null;
            HashMap hashMap = _threadPools;
            synchronized (hashMap) {
                threadPool = (ThreadPool)_threadPools.get(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPool", threadPool);
            }
            return threadPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeThreadPool(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeThreadPool", new Object[]{string, this});
            }
            HashMap hashMap = _threadPools;
            synchronized (hashMap) {
                _threadPools.remove(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeThreadPool");
            }
        }
    }
}

