/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.threads;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;

public class ThreadDataProvider {
    public static final String CAPABILITY_THREAD_SUBSYSTEM = "threads_subsystem";
    private static final String DELIMITER = "@#";
    private static final String START_THREAD_REPORT = "startThreads";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EMPTY_STRING = "";
    private static final String REPORT_VERSION = "3.0.7";
    public static final String SET_STACK_DEPTH = "setStack";
    private static final String REALTIME_IDENTIFIER = "real-time";
    private static final String SOFT_REALTIME_IDENTIFER = "srt";
    public static final String TAG = "ThreadsSource";
    private static ThreadMXBean threadBean = null;
    private static boolean isObjectMonitorUsageSupported = false;
    private static boolean isSynchronizerUsageSupported = false;

    public static String getJMXData() {
        ThreadDataProvider.providerInitialisation();
        return ThreadDataProvider.getThreadReport();
    }

    private static void providerInitialisation() {
        if (threadBean != null) {
            return;
        }
        threadBean = ManagementFactory.getThreadMXBean();
        try {
            isObjectMonitorUsageSupported = threadBean.isObjectMonitorUsageSupported();
            isSynchronizerUsageSupported = threadBean.isSynchronizerUsageSupported();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private static synchronized String getThreadReport() {
        String report;
        if (!Util.isHardRealTimeVM()) {
            String threads = EMPTY_STRING;
            long[] threadIDs = threadBean.getAllThreadIds();
            ThreadInfo[] infos = null;
            long timestamp = System.currentTimeMillis();
            try {
                infos = threadBean.getThreadInfo(threadIDs, isObjectMonitorUsageSupported, isSynchronizerUsageSupported);
            }
            catch (NoSuchMethodError e) {
                infos = threadBean.getThreadInfo(threadIDs);
            }
            catch (IllegalArgumentException e) {
                ArrayList<Long> threadIDsAux = new ArrayList<Long>();
                long[] lArray = threadIDs;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    long threadID = lArray[i];
                    if (threadID <= 0L) continue;
                    threadIDsAux.add(threadID);
                }
                threadIDs = new long[threadIDsAux.toArray().length];
                int i = 0;
                Iterator iterator = threadIDsAux.iterator();
                while (iterator.hasNext()) {
                    long threadID;
                    threadIDs[i] = threadID = ((Long)iterator.next()).longValue();
                    ++i;
                }
            }
            catch (InternalError e) {
                if (e.getMessage().contains("JVM_GetThreadStateValues")) {
                    return EMPTY_STRING;
                }
                throw e;
            }
            StringBuffer buffer = new StringBuffer();
            int totalElements = 0;
            for (ThreadInfo info : infos) {
                if (info == null) continue;
                String name = info.getThreadName();
                long threadId = info.getThreadId();
                Thread.State state = info.getThreadState();
                String monitorNames = EMPTY_STRING;
                int ownedMonitors = 0;
                String lockSynchronizers = EMPTY_STRING;
                int ownedLockSynchronizers = 0;
                try {
                    MonitorInfo[] monitors = info.getLockedMonitors();
                    ownedMonitors = monitors.length;
                    StringBuffer sb = new StringBuffer();
                    for (MonitorInfo monitor : monitors) {
                        if (monitor != null) {
                            sb.append(monitor.getClassName().length());
                            sb.append(DELIMITER);
                            sb.append(monitor.getClassName());
                            sb.append(monitor.getIdentityHashCode());
                            sb.append(DELIMITER);
                            sb.append(monitor.getLockedStackDepth());
                            sb.append(DELIMITER);
                            continue;
                        }
                        --ownedMonitors;
                    }
                    monitorNames = sb.toString();
                    LockInfo[] locks = info.getLockedSynchronizers();
                    ownedLockSynchronizers = locks.length;
                    sb = new StringBuffer();
                    for (LockInfo lock : locks) {
                        sb.append(lock.getClassName().length());
                        sb.append(DELIMITER);
                        sb.append(lock.getClassName());
                        sb.append(lock.getIdentityHashCode());
                        sb.append(DELIMITER);
                    }
                    lockSynchronizers = sb.toString();
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
                String contendedMonitor = EMPTY_STRING;
                contendedMonitor = info.getLockName();
                if (contendedMonitor == null) {
                    contendedMonitor = EMPTY_STRING;
                }
                String stackInfo = EMPTY_STRING;
                int stackElements = 0;
                StackTraceElement[] stack = info.getStackTrace();
                StringBuffer buf = new StringBuffer();
                for (StackTraceElement element : stack) {
                    String className = element.getClassName();
                    String fileName = element.getFileName();
                    if (fileName == null) {
                        fileName = EMPTY_STRING;
                    }
                    String methodName = element.getMethodName();
                    int lineNumber = element.getLineNumber();
                    buf.append(className.length()).append(DELIMITER).append(className).append(methodName.length()).append(DELIMITER).append(methodName).append(fileName.length()).append(DELIMITER).append(fileName).append(lineNumber).append(DELIMITER);
                    ++stackElements;
                }
                stackInfo = buf.toString();
                totalElements = 6 + ownedMonitors * 2 + 1 + stackElements * 2 + 1;
                buffer.append(START_THREAD_REPORT);
                buffer.append(REPORT_VERSION);
                buffer.append(DELIMITER).append(timestamp);
                buffer.append(DELIMITER).append(threadIDs.length);
                buffer.append(DELIMITER).append(totalElements);
                buffer.append(DELIMITER).append(threadId);
                buffer.append(DELIMITER).append(name.length());
                buffer.append(DELIMITER);
                buffer.append(name);
                buffer.append(state.toString().length());
                buffer.append(DELIMITER);
                buffer.append(state.toString());
                buffer.append(stackElements);
                buffer.append(DELIMITER);
                if (stackElements > 0) {
                    buffer.append(stackInfo);
                }
                buffer.append(ownedMonitors);
                buffer.append(DELIMITER);
                if (ownedMonitors > 0) {
                    buffer.append(monitorNames);
                }
                buffer.append(ownedLockSynchronizers);
                buffer.append(DELIMITER);
                if (ownedLockSynchronizers > 0) {
                    buffer.append(lockSynchronizers);
                }
                buffer.append(contendedMonitor.length());
                buffer.append(DELIMITER);
                buffer.append(contendedMonitor);
                buffer.append(NEW_LINE);
            }
            threads = buffer.toString();
            report = threads != null ? threads : EMPTY_STRING;
        } else {
            report = EMPTY_STRING;
        }
        return report;
    }
}

