/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Properties;

public final class Message {
    TraceContext context;
    private int ptrSize;
    private int type;
    private String message;
    private String component;
    private boolean zero = false;
    private Arg[] parameterTypes;
    private Arg[] nonConstantParameterTypes;
    private int id;
    private int level;
    private Properties statistics = new Properties();

    public Message(int type, String message, int id, int level, String component, String symbol, TraceContext context) {
        this.context = context;
        this.type = type;
        this.message = message;
        this.component = component;
        this.ptrSize = context.getPointerSize();
        this.parameterTypes = this.parseMessageTemplate(null);
        this.nonConstantParameterTypes = this.filterTypes(this.parameterTypes);
        this.id = id;
        this.level = level;
        this.statistics.put("component", component);
    }

    private Message(String message, int pointerSize) {
        this.message = message;
        this.ptrSize = pointerSize;
    }

    public void addStatistic(String key, long value) {
        long total = 0L;
        if (this.statistics.containsKey(key)) {
            total = (Long)this.statistics.get(key);
        }
        this.statistics.put(key, (Object)(total += value));
    }

    public Properties getStatistics() {
        return this.statistics;
    }

    public static Arg[] getArgumentDetails(String template, int bytesPerPointer, StringBuffer templateErrors) {
        Message msg = new Message(template, bytesPerPointer);
        Arg[] parameters = msg.parseMessageTemplate(templateErrors);
        return msg.filterTypes(parameters);
    }

    private Arg[] filterTypes(Arg[] types) {
        int totalElems = types.length;
        ArrayList<Arg> result = new ArrayList<Arg>(totalElems);
        for (int i = 0; i < totalElems; ++i) {
            if (types[i] instanceof FixedStringArg) continue;
            result.add(types[i]);
        }
        return Message.wrangleToArgArray(result);
    }

    private static Arg[] wrangleToArgArray(ArrayList v) {
        int resSize = v.size();
        Arg[] res = new Arg[resSize];
        for (int i = 0; i < resSize; ++i) {
            res[i] = (Arg)v.get(i);
        }
        return res;
    }

    protected static final void padBuffer(StringBuilder sb, int i, char c) {
        Message.padBuffer(sb, i, c, false);
    }

    protected static final void padBuffer(StringBuilder sb, int i, char c, boolean leftJustified) {
        while (sb.length() < i) {
            if (leftJustified) {
                sb.append(c);
                continue;
            }
            sb.insert(0, c);
        }
    }

    protected StringBuilder processPercents(String str, byte[] buffer, int offset) {
        int totalElems = this.parameterTypes.length;
        StringBuilder result = new StringBuilder();
        ByteStream dataStream = this.context.createByteStream(buffer, offset);
        int item = 0;
        try {
            for (item = 0; item < totalElems; ++item) {
                this.parameterTypes[item].format(dataStream, result);
            }
        }
        catch (BufferUnderflowException e) {
            this.context.warning(this, "BufferUnderflowException processing " + this.component + "." + this.id);
        }
        while (item < totalElems) {
            if (!(this.parameterTypes[item] instanceof FixedStringArg)) {
                result.append("<missing in trace>");
            } else {
                this.parameterTypes[item].format(dataStream, result);
            }
            ++item;
        }
        return result;
    }

    protected StringBuilder skipPercents(String str, byte[] buffer, int offset) {
        int totalElems = this.parameterTypes.length;
        StringBuilder result = new StringBuilder();
        ByteStream dataStream = this.context.createByteStream(buffer, offset);
        for (int i = 0; i < totalElems; ++i) {
            if (!(this.parameterTypes[i] instanceof FixedStringArg)) {
                result.append("???");
                continue;
            }
            this.parameterTypes[i].format(dataStream, result);
        }
        return result;
    }

    protected void setPointerSize(int size) {
        this.ptrSize = size;
    }

    private static String readDigits(String str) {
        char[] digits = new char[10];
        int index = 0;
        while (Character.isDigit(str.charAt(index))) {
            if (index >= digits.length) continue;
            digits[index] = str.charAt(index);
            ++index;
        }
        return new String(digits, 0, index);
    }

    public String getMessage(byte[] buffer, int offset, int end) {
        String prefix = "";
        if (offset < end) {
            if (this.component == "ApplicationTrace") {
                offset += 4;
            }
            return prefix + this.processPercents(this.message, buffer, offset).toString();
        }
        return prefix + this.skipPercents(this.message, buffer, offset).toString();
    }

    protected String getComponent() {
        return this.component;
    }

    protected int getLevel() {
        return this.level;
    }

    protected int getType() {
        return this.type;
    }

    protected String getFormattingTemplate() {
        return this.message;
    }

    protected Object[] parseMessage(byte[] buffer, int offset) {
        int totalElems = this.nonConstantParameterTypes.length;
        if (totalElems == 0 || buffer == null) {
            return new Object[0];
        }
        Object[] result = new Object[totalElems];
        ByteStream dataStream = this.context.createByteStream(buffer, offset);
        for (int i = 0; i < totalElems; ++i) {
            result[i] = this.nonConstantParameterTypes[i].getValue(dataStream);
        }
        return result;
    }

    Arg[] parseMessageTemplate(StringBuffer templateErrors) {
        ArrayList<Arg> result = new ArrayList<Arg>();
        String str = this.message;
        int index = str.indexOf("%");
        String errors = "";
        while (index != -1) {
            char first;
            FormatSpec fspec = null;
            if (index != 0) {
                result.add(new FixedStringArg(str.substring(0, index)));
            }
            boolean prefix0x = index > 1 ? "0x".equalsIgnoreCase(str.substring(index - 2, index)) : false;
            boolean utf8 = false;
            int dataSize = 4;
            if ((str = str.substring(index + 1, str.length())).charAt(0) == '-') {
                fspec = new FormatSpec(true);
                str = str.substring(1, str.length());
            }
            if (str.charAt(0) == '0') {
                if (fspec == null) {
                    fspec = new FormatSpec();
                    fspec.setZeroPad(true);
                }
                str = str.substring(1, str.length());
            }
            if (Character.isDigit(str.charAt(0))) {
                if (fspec == null) {
                    fspec = new FormatSpec();
                }
                String val = Message.readDigits(str);
                fspec.width = Integer.valueOf(val);
                str = str.substring(val.length(), str.length());
            }
            if (str.charAt(0) == '.') {
                if ((str = str.substring(1, str.length())).charAt(0) == '*') {
                    utf8 = true;
                    str = str.substring(1, str.length());
                } else {
                    if (fspec == null) {
                        fspec = new FormatSpec();
                    }
                    String prec = Message.readDigits(str);
                    fspec.precision = Integer.valueOf(prec);
                    str = str.substring(prec.length(), str.length());
                }
            }
            if ((first = str.charAt(0)) == 'l') {
                if (str.charAt(1) == 'l') {
                    dataSize = 8;
                    str = str.substring(2, str.length());
                } else {
                    str = str.substring(1, str.length());
                }
            } else if (first == 'I' && str.charAt(1) == '6' && str.charAt(2) == '4') {
                dataSize = 8;
                str = str.substring(3, str.length());
            } else if (first == 'h') {
                dataSize = 2;
                str = str.substring(1, str.length());
            } else if (first == 'z') {
                dataSize = -1;
                str = str.substring(1, str.length());
            }
            first = str.charAt(0);
            switch (first) {
                case 'p': {
                    if (!prefix0x) {
                        result.add(new FixedStringArg("0x"));
                    }
                    str = str.substring(1, str.length());
                    result.add(new PointerArg(this.ptrSize));
                    break;
                }
                case 's': {
                    if (utf8) {
                        result.add(new UTF8StringArg());
                    } else {
                        result.add(new StringArg());
                    }
                    str = str.substring(1, str.length());
                    break;
                }
                case 'd': 
                case 'i': {
                    str = str.substring(1, str.length());
                    if (dataSize == 4 || dataSize == -1 && this.ptrSize == 4) {
                        result.add(new I32_Arg(fspec, dataSize));
                        break;
                    }
                    result.add(new I64_Arg(fspec, dataSize));
                    break;
                }
                case 'u': {
                    str = str.substring(1, str.length());
                    if (dataSize == 4 || dataSize == -1 && this.ptrSize == 4) {
                        result.add(new U32_Arg(fspec, dataSize));
                        break;
                    }
                    result.add(new U64_Arg(fspec, dataSize));
                    break;
                }
                case 'f': 
                case 'g': {
                    str = str.substring(1, str.length());
                    result.add(new Double_Arg(fspec, this.ptrSize));
                    break;
                }
                case 'X': 
                case 'x': {
                    if (fspec == null) {
                        fspec = new FormatSpec();
                    }
                    fspec.setRadix(16);
                    if (!prefix0x) {
                        fspec.addOxPrefix();
                    }
                    str = str.substring(1, str.length());
                    if (dataSize == 4 || dataSize == -1 && this.ptrSize == 4) {
                        result.add(new U32_Arg(fspec, dataSize));
                        break;
                    }
                    result.add(new U64_Arg(fspec, dataSize));
                    break;
                }
                case 'c': {
                    str = str.substring(1, str.length());
                    result.add(new CharArg());
                    break;
                }
                case '%': {
                    str = str.substring(1, str.length());
                    result.add(new FixedStringArg("%"));
                    break;
                }
                case ' ': 
                case '#': 
                case '+': {
                    if (templateErrors != null) {
                        templateErrors.append("Used a printf flag not supported " + first);
                    }
                    if (this.context != null) {
                        this.context.error(this, "Used a printf flag not supported " + first);
                    }
                    str = str.substring(1, str.length());
                    break;
                }
                default: {
                    if (templateErrors != null) {
                        templateErrors.append("error percent directive looked like => " + str);
                    }
                    if (this.context != null) {
                        this.context.error(this, "error percent directive looked like => " + str);
                    }
                    str = str.substring(1, str.length());
                }
            }
            index = str.indexOf("%");
            fspec = null;
        }
        if (str.length() > 0) {
            result.add(new FixedStringArg(str));
        }
        int resSize = result.size();
        Arg[] res = new Arg[resSize];
        for (int j = 0; j < resSize; ++j) {
            res[j] = (Arg)result.get(j);
        }
        return res;
    }

    StringBuilder formatz(long val, FormatSpec spec) {
        StringBuilder str = new StringBuilder();
        if (spec != null && spec.needsOxPrefix()) {
            str.append("0x");
        }
        String s = Long.toString(val, spec != null ? spec.getRadix() : 10);
        str.append(s);
        if (spec != null) {
            if (spec.precision != null) {
                Message.padBuffer(str, spec.precision, '0');
            }
            if (spec.width != null) {
                Message.padBuffer(str, spec.width, spec.needsZeroPad() && !spec.leftJustified ? (char)'0' : ' ', spec.leftJustified);
            }
        }
        return str;
    }

    public abstract class Arg {
        boolean zeroPad = false;
        int sizeof;
        String signature;

        Arg(int size) {
            this.sizeof = size;
        }

        abstract Object getValue(ByteStream var1);

        abstract void format(ByteStream var1, StringBuilder var2);

        public int sizeof() {
            return this.sizeof;
        }

        public String signature() {
            return this.signature;
        }

        void zeroPad(boolean pad) {
            this.zeroPad = pad;
        }
    }

    public class CharArg
    extends Arg {
        CharArg() {
            super(1);
            this.signature = "char";
        }

        Object getValue(ByteStream msg) {
            return Character.valueOf((char)msg.get());
        }

        void format(ByteStream msg, StringBuilder out) {
            Character val = (Character)this.getValue(msg);
            out.append(val.charValue());
        }
    }

    public class Double_Arg
    extends Arg {
        private FormatSpec fspec;

        Double_Arg(FormatSpec fspec, int size) {
            super(size);
            this.signature = "double";
            this.fspec = fspec;
        }

        Object getValue(ByteStream msg) {
            return msg.getDouble();
        }

        void format(ByteStream msg, StringBuilder out) {
            Double val = (Double)this.getValue(msg);
            StringBuilder str = new StringBuilder(val.toString());
            if (this.fspec != null && this.fspec.width != null) {
                Message.padBuffer(str, this.fspec.width, ' ', this.fspec.leftJustified);
            }
            out.append((CharSequence)str);
        }
    }

    public class FixedStringArg
    extends Arg {
        private String val;

        FixedStringArg(String fixedString) {
            super(-1);
            this.signature = "const char *";
            this.val = fixedString;
        }

        Object getValue(ByteStream msg) {
            return null;
        }

        void format(ByteStream msg, StringBuilder out) {
            out.append(this.val);
        }
    }

    public class Float_Arg
    extends Arg {
        private FormatSpec fspec;

        Float_Arg(FormatSpec fspec, int size) {
            super(size);
            this.signature = "float";
            this.fspec = fspec;
        }

        Object getValue(ByteStream msg) {
            return Float.valueOf(msg.getFloat());
        }

        void format(ByteStream msg, StringBuilder out) {
            Float val = (Float)this.getValue(msg);
            StringBuilder str = new StringBuilder(val.toString());
            if (this.fspec != null && this.fspec.width != null) {
                Message.padBuffer(str, this.fspec.width, ' ', this.fspec.leftJustified);
            }
            out.append((CharSequence)str);
        }
    }

    class FormatSpec {
        protected Integer width;
        protected Integer precision;
        protected boolean leftJustified = false;
        private int radix = -1;
        private boolean addOxPrefix = false;
        private boolean zeroPad = false;

        public FormatSpec() {
            this(false);
        }

        public FormatSpec(boolean left) {
            this.leftJustified = left;
        }

        public void setRadix(int rdx) {
            this.radix = rdx;
        }

        public int getRadix() {
            return this.radix;
        }

        public void addOxPrefix() {
            this.addOxPrefix = true;
        }

        public boolean needsOxPrefix() {
            return this.addOxPrefix;
        }

        public void setZeroPad(boolean pad) {
            this.zeroPad = pad;
        }

        public boolean needsZeroPad() {
            return this.zeroPad;
        }

        public String toString() {
            return "FormatSpec w: " + this.width + " p:" + this.precision + " just: " + this.leftJustified;
        }
    }

    public class I32_Arg
    extends Arg {
        private FormatSpec fspec;

        I32_Arg(FormatSpec fspec, int size) {
            super(size);
            if (size == -1) {
                this.signature = "IDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "I_32";
            }
            this.fspec = fspec;
        }

        Object getValue(ByteStream msg) {
            return (long)msg.getInt();
        }

        void format(ByteStream msg, StringBuilder out) {
            Long val = (Long)this.getValue(msg);
            out.append((CharSequence)Message.this.formatz(val, this.fspec));
        }
    }

    public class I64_Arg
    extends Arg {
        private FormatSpec fspec;

        I64_Arg(FormatSpec fspec, int size) {
            super(size);
            if (size == -1) {
                this.signature = "IDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "I_64";
            }
            this.fspec = fspec;
        }

        Object getValue(ByteStream msg) {
            return msg.getLong();
        }

        void format(ByteStream msg, StringBuilder out) {
            Long val = (Long)this.getValue(msg);
            out.append((CharSequence)Message.this.formatz(val, this.fspec));
        }
    }

    public class PointerArg
    extends Arg {
        PointerArg(int size) {
            super(size);
            this.signature = "const void *";
        }

        Object getValue(ByteStream msg) {
            return new Long(Message.this.ptrSize == 4 ? msg.getUnsignedInt() : msg.getLong());
        }

        void format(ByteStream msg, StringBuilder out) {
            Long val = (Long)this.getValue(msg);
            out.append(Long.toHexString(val));
        }
    }

    public class StringArg
    extends Arg {
        StringArg() {
            super(-1);
            this.signature = "const char *";
        }

        Object getValue(ByteStream msg) {
            return msg.getASCIIString();
        }

        void format(ByteStream msg, StringBuilder out) {
            String val = this.getValue(msg).toString();
            out.append(val);
        }
    }

    public class U32_Arg
    extends Arg {
        private FormatSpec fspec;

        U32_Arg(FormatSpec fspec, int size) {
            super(size);
            if (size == -1) {
                this.signature = "UDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "U_32";
            }
            this.fspec = fspec;
        }

        Object getValue(ByteStream msg) {
            return msg.getUnsignedInt();
        }

        void format(ByteStream msg, StringBuilder out) {
            Long val = (Long)this.getValue(msg);
            out.append((CharSequence)Message.this.formatz(val, this.fspec));
        }
    }

    public class U64_Arg
    extends Arg {
        private FormatSpec fspec;

        U64_Arg(FormatSpec fspec, int size) {
            super(size);
            if (size == -1) {
                this.signature = "UDATA";
                this.sizeof = Message.this.ptrSize;
            } else {
                this.signature = "U_64";
            }
            this.fspec = fspec;
        }

        Object getValue(ByteStream msg) {
            return msg.getLong();
        }

        void format(ByteStream msg, StringBuilder out) {
            Long val = (Long)this.getValue(msg);
            out.append((CharSequence)Message.this.formatz(val, this.fspec));
        }
    }

    public class UTF8StringArg
    extends Arg {
        UTF8StringArg() {
            super(-1);
            this.signature = "const char *";
        }

        Object getValue(ByteStream msg) {
            try {
                return msg.getUTF8String();
            }
            catch (UnsupportedEncodingException e) {
                Message.this.context.error(this, "UTF-8 is reported as an invalid encoding!");
                return "see error output for details";
            }
        }

        void format(ByteStream msg, StringBuilder out) {
            String val = this.getValue(msg).toString();
            out.append(val);
        }
    }
}

