/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.locking.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.ByteParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.locking.LockingData;
import com.ibm.java.diagnostics.healthcenter.locking.LockingDataImpl;
import com.ibm.java.diagnostics.healthcenter.locking.LockingLabels;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorMetrics;
import com.ibm.java.diagnostics.healthcenter.locking.data.MonitorTableData;
import com.ibm.java.diagnostics.healthcenter.locking.parser.Messages;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.LockingInternalObject;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LockingParser
implements ByteParser {
    private static final String CLASSNAME = LockingParser.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(LockingParser.class);
    public static final String JAVA_MONITORS_LABEL = LockingLabels.JAVA_MONITORS_LABEL;
    private static final String SYSTEM_MONITORS_LABEL = LockingLabels.SYSTEM_MONITORS_LABEL;
    private static final String REPORT_TIME_EYECATCHER = "reportTime,";
    private static final String INTERVAL_TIME_EYECATCHER = "IntervalTime,";
    private static final String REPORT_COMPLETE_EYECATCHER = "reportcomplete";
    private static final String JAVA_MONITOR_EYECATCHER = "javaMonitor,";
    private static final String SYSTEM_MONITOR_EYECATCHER = "systemMonitor,";
    private static final String[] KNOWN_EYECATCHERS = new String[]{"reportTime,", "IntervalTime,", "reportcomplete", "javaMonitor,", "systemMonitor,"};
    private static final int PARSING_ERROR = -1;
    private boolean foundLockingReport = false;
    private ParserState state = ParserState.EXPECT_EYECATCHER;
    private CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
    private SubsystemDataBuilder lockingData = null;
    private MonitorMetrics currentMonitorData = null;
    private MonitorTableData javaMonitorTableData = null;
    private MonitorTableData systemMonitorTableData = null;
    private MonitorTableData currentMonitorTableData = null;
    private String partialToken = null;
    private long reportTimeMillis;
    private long intervalTime;
    private int sequenceNumber = 0;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, byte[] byArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        ByteBuffer byteBuffer;
        CoderResult coderResult;
        TRACE.entering(CLASSNAME, "parse");
        int n = 0;
        int n2 = byArray.length;
        if (this.partialToken != null) {
            n2 += this.partialToken.length();
        }
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        if (this.partialToken != null) {
            charBuffer.put(this.partialToken);
        }
        if ((coderResult = this.utf8Decoder.decode(byteBuffer = ByteBuffer.wrap(byArray), charBuffer, false)).isError()) {
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine(Messages.getString("LockingParser.not.text"));
            }
            if (this.foundLockingReport) {
                TRACE.warning(Messages.getString("LockingParser.corrupted.data"));
            }
            TRACE.exiting(CLASSNAME, "parse");
            return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        n = byteBuffer.position();
        charBuffer.flip();
        if (!this.parse(charBuffer, dataBuilder, outputProperties)) {
            TRACE.exiting(CLASSNAME, "parse");
            return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        }
        this.partialToken = charBuffer.hasRemaining() ? charBuffer.toString() : null;
        TRACE.exiting(CLASSNAME, "parse");
        return new ProgressIndicatorImpl(n, n);
    }

    public boolean parse(CharBuffer charBuffer, DataBuilder dataBuilder, OutputProperties outputProperties) {
        while (charBuffer.hasRemaining()) {
            if (this.state == ParserState.EXPECT_EYECATCHER) {
                int n = this.parseEyeCatcher(charBuffer, dataBuilder, outputProperties);
                if (n == -1) {
                    return false;
                }
                if (n != 0) continue;
                return true;
            }
            String string = LockingParser.getNextToken(charBuffer);
            if (string == null) {
                return true;
            }
            int n = charBuffer.position() + string.length() + 1;
            charBuffer.position(n);
            try {
                if (this.state == ParserState.EXPECT_REPORT_TIME) {
                    if (string == null) continue;
                    this.reportTimeMillis = Long.valueOf(string.trim());
                    this.state = ParserState.EXPECT_EYECATCHER;
                    continue;
                }
                if (this.state == ParserState.EXPECT_INTERVAL_TIME) {
                    if (string == null) continue;
                    this.intervalTime = Long.valueOf(string.trim());
                    this.state = ParserState.EXPECT_EYECATCHER;
                    continue;
                }
                if (this.state == ParserState.EXPECT_PERCENT_MISS) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setPercentMiss(n);
                    this.state = ParserState.EXPECT_GETS;
                    continue;
                }
                if (this.state == ParserState.EXPECT_GETS) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setGets(n);
                    this.state = ParserState.EXPECT_NON_RECURSIVE;
                    continue;
                }
                if (this.state == ParserState.EXPECT_NON_RECURSIVE) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setNonRecursive(n);
                    this.state = ParserState.EXPECT_SLOW;
                    continue;
                }
                if (this.state == ParserState.EXPECT_SLOW) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setSlow(n);
                    this.state = ParserState.EXPECT_RECURSIVE;
                    continue;
                }
                if (this.state == ParserState.EXPECT_RECURSIVE) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setRecursive(n);
                    this.state = ParserState.EXPECT_TIER2;
                    continue;
                }
                if (this.state == ParserState.EXPECT_TIER2) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setTier2(n);
                    this.state = ParserState.EXPECT_TIER3;
                    continue;
                }
                if (this.state == ParserState.EXPECT_TIER3) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setTier3(n);
                    this.state = ParserState.EXPECT_PERCENT_UTIL;
                    continue;
                }
                if (this.state == ParserState.EXPECT_PERCENT_UTIL) {
                    if (string == null) continue;
                    n = Integer.valueOf(string.trim());
                    this.currentMonitorData.setPercentUtil(n);
                    this.state = ParserState.EXPECT_AVERAGE_HOLD_TIME;
                    continue;
                }
                if (this.state == ParserState.EXPECT_AVERAGE_HOLD_TIME) {
                    if (string == null) continue;
                    long l = Long.valueOf(string.trim());
                    this.currentMonitorData.setAverageHoldTime(l);
                    this.state = ParserState.EXPECT_MONITOR_NAME;
                    continue;
                }
                if (this.state != ParserState.EXPECT_MONITOR_NAME || string == null) continue;
                this.currentMonitorData.setName(string);
                this.state = ParserState.EXPECT_EYECATCHER;
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = Messages.getString("LockingParser.number.format.exception");
                String string3 = MessageFormat.format(string2, numberFormatException);
                TRACE.warning(string3);
                this.currentMonitorData = null;
                this.state = ParserState.EXPECT_EYECATCHER;
            }
        }
        return true;
    }

    private int parseEyeCatcher(CharBuffer charBuffer, DataBuilder dataBuilder, OutputProperties outputProperties) {
        String string = LockingParser.getKnownToken(charBuffer, KNOWN_EYECATCHERS);
        if (string == null) {
            int n = 0;
            for (String string2 : KNOWN_EYECATCHERS) {
                int n2 = string2.length();
                if (n2 <= n) continue;
                n = n2;
            }
            if (charBuffer.remaining() < n) {
                return 0;
            }
            if (this.foundLockingReport) {
                int n3 = this.correctCurrentMonitorName(charBuffer);
                return n3;
            }
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine(Messages.getString("LockingParser.no.eyecatcher"));
            }
            return -1;
        }
        this.foundLockingReport = true;
        int n = charBuffer.position() + string.length();
        charBuffer.position(n);
        if (string == REPORT_TIME_EYECATCHER) {
            this.state = ParserState.EXPECT_REPORT_TIME;
        } else if (string == INTERVAL_TIME_EYECATCHER) {
            this.state = ParserState.EXPECT_INTERVAL_TIME;
        } else if (string == REPORT_COMPLETE_EYECATCHER) {
            this.addCurrentMonitorData(outputProperties);
            this.currentMonitorData = null;
            this.currentMonitorTableData = null;
            ++this.sequenceNumber;
        } else if (string == JAVA_MONITOR_EYECATCHER) {
            this.state = ParserState.EXPECT_PERCENT_MISS;
            this.ensureLockingDataExists(dataBuilder);
            this.addCurrentMonitorData(outputProperties);
            this.currentMonitorData = new MonitorMetrics(this.reportTimeMillis);
            this.currentMonitorData.setIntervalTime(this.intervalTime);
            this.currentMonitorTableData = this.getJavaMonitorTableData(outputProperties);
        } else if (string == SYSTEM_MONITOR_EYECATCHER) {
            this.state = ParserState.EXPECT_PERCENT_MISS;
            this.ensureLockingDataExists(dataBuilder);
            this.addCurrentMonitorData(outputProperties);
            this.currentMonitorData = new MonitorMetrics(this.reportTimeMillis);
            this.currentMonitorData.setIntervalTime(this.intervalTime);
            this.currentMonitorTableData = this.getSystemMonitorTableData(outputProperties);
        } else {
            String string3 = Messages.getString("LockingParser.bad.eyecatcher");
            TRACE.warning(string3);
            return -1;
        }
        return string.length();
    }

    private void ensureLockingDataExists(DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(LockingDataImpl.DATA_LABEL);
        if (dataBuilder2 != null) {
            if (!(dataBuilder2 instanceof LockingData)) {
                dataBuilder.removeData(LockingDataImpl.DATA_LABEL);
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
                }
                this.lockingData = this.createLockingData();
                this.javaMonitorTableData = null;
                this.systemMonitorTableData = null;
                dataBuilder.addData(this.lockingData);
            } else {
                this.lockingData = (LockingDataImpl)dataBuilder2;
            }
        } else {
            this.lockingData = this.createLockingData();
            this.javaMonitorTableData = null;
            this.systemMonitorTableData = null;
            dataBuilder.addData(this.lockingData);
        }
    }

    private int correctCurrentMonitorName(CharBuffer charBuffer) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(charBuffer.remaining());
        while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            ++n;
            if (c == ',') break;
            stringBuffer.append(c);
        }
        if (this.currentMonitorData != null) {
            String string = this.currentMonitorData.getName();
            StringBuffer stringBuffer2 = new StringBuffer(string.length() + 1 + stringBuffer.length());
            stringBuffer2.append(string);
            stringBuffer2.append(',');
            stringBuffer2.append(stringBuffer.toString());
            this.currentMonitorData.setName(stringBuffer2.toString());
        }
        return n;
    }

    private void addCurrentMonitorData(OutputProperties outputProperties) {
        if (this.currentMonitorData != null && this.currentMonitorTableData != null) {
            LockingInternalObject lockingInternalObject = new LockingInternalObject(this.currentMonitorData.getTimeMillis(), this.currentMonitorData.getName());
            lockingInternalObject.setAverageHoldTime(this.currentMonitorData.getAverageHoldTime());
            lockingInternalObject.setTotalGets(this.currentMonitorData.getGets());
            lockingInternalObject.setPercentMiss(this.currentMonitorData.getPercentMiss());
            lockingInternalObject.setPercentUtilisation(this.currentMonitorData.getPercentUtil());
            lockingInternalObject.setRecursiveAcquires(this.currentMonitorData.getRecursive());
            lockingInternalObject.setSlowAcquire(this.currentMonitorData.getSlow());
            lockingInternalObject.setTier2Spins(this.currentMonitorData.getTier2());
            lockingInternalObject.setTier3Spins(this.currentMonitorData.getTier3());
            lockingInternalObject.setJavaMonitor(this.currentMonitorTableData.getLabel().equals(JAVA_MONITORS_LABEL));
            MarshallerImpl.getMarshaller().getLockingEventHandler().addEvent(lockingInternalObject);
            if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
                return;
            }
            this.currentMonitorTableData.addMonitorMetrics(this.currentMonitorData, this.sequenceNumber, outputProperties);
        }
    }

    public static String getKnownToken(CharSequence charSequence, String[] stringArray) {
        if (charSequence == null || stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            int n = string.length();
            if (charSequence.length() < n) continue;
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) == string.charAt(i)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return string;
        }
        return null;
    }

    public static String getNextToken(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) != ',') continue;
            return charSequence.subSequence(0, i).toString();
        }
        return null;
    }

    private SubsystemDataBuilder createLockingData() {
        return new LockingDataImpl();
    }

    private MonitorTableData getJavaMonitorTableData(OutputProperties outputProperties) {
        if (this.javaMonitorTableData == null) {
            this.javaMonitorTableData = new MonitorTableData(JAVA_MONITORS_LABEL, outputProperties);
            this.lockingData.addData(this.javaMonitorTableData);
        }
        return this.javaMonitorTableData;
    }

    private MonitorTableData getSystemMonitorTableData(OutputProperties outputProperties) {
        if (this.systemMonitorTableData == null) {
            this.systemMonitorTableData = new MonitorTableData(SYSTEM_MONITORS_LABEL, outputProperties);
            this.lockingData.addData(this.systemMonitorTableData);
        }
        return this.systemMonitorTableData;
    }

    private static enum ParserState {
        EXPECT_EYECATCHER,
        EXPECT_REPORT_TIME,
        EXPECT_INTERVAL_TIME,
        EXPECT_PERCENT_MISS,
        EXPECT_GETS,
        EXPECT_NON_RECURSIVE,
        EXPECT_SLOW,
        EXPECT_RECURSIVE,
        EXPECT_TIER2,
        EXPECT_TIER3,
        EXPECT_PERCENT_UTIL,
        EXPECT_AVERAGE_HOLD_TIME,
        EXPECT_MONITOR_NAME;

    }
}

