/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.classes.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullDataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.classes.ClassHistogramLabels;
import com.ibm.java.diagnostics.healthcenter.classes.ClassesLabels;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassHistogramDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.classes.postprocessor.Messages;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class ClassHistogramPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(ClassHistogramPostProcessor.class);
    private static final String CLASS_NAME = ClassHistogramPostProcessor.class.getName();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(ClassesLabels.DATA_LABEL);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.removeData(ClassHistogramLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(ClassHistogramLabels.RECOMMENDATION_LABEL);
            this.largestClass(subsystemDataBuilder, structuredStringDataImpl);
            this.mostInstances(subsystemDataBuilder, structuredStringDataImpl);
            if (structuredStringDataImpl.hasChildren()) {
                this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
                subsystemDataBuilder.addData(structuredStringDataImpl);
            }
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void largestClass(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(ClassHistogramLabels.CLASS_LIST);
        FullDataPointImpl fullDataPointImpl = null;
        if (data != null && !data.isEmpty()) {
            DataPointBuilder[] dataPointBuilderArray;
            double d = ((TwoDimensionalDataBuilder)data).getMaxX().getRawX();
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = ((TwoDimensionalDataBuilder)data).getDataPoints()) {
                if (dataPointBuilder.getRawX() != d) continue;
                ClassHistogramDataPointImpl classHistogramDataPointImpl = (ClassHistogramDataPointImpl)dataPointBuilder;
                if (fullDataPointImpl != null && classHistogramDataPointImpl.getSize() <= ((ClassHistogramDataPointImpl)fullDataPointImpl).getSize()) continue;
                fullDataPointImpl = classHistogramDataPointImpl;
            }
            if (fullDataPointImpl != null) {
                structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("ClassHistogram.largest.class"), fullDataPointImpl.getComment(), fullDataPointImpl.formatYWithUnits(), ((ClassHistogramDataPointImpl)fullDataPointImpl).getCount()));
            }
        }
    }

    private void mostInstances(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        Data data = subsystemDataBuilder.getData(ClassHistogramLabels.CLASS_LIST);
        FullDataPointImpl fullDataPointImpl = null;
        if (data != null && !data.isEmpty()) {
            DataPointBuilder[] dataPointBuilderArray;
            double d = ((TwoDimensionalDataBuilder)data).getMaxX().getRawX();
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = ((TwoDimensionalDataBuilder)data).getDataPoints()) {
                if (dataPointBuilder.getRawX() != d) continue;
                ClassHistogramDataPointImpl classHistogramDataPointImpl = (ClassHistogramDataPointImpl)dataPointBuilder;
                if (fullDataPointImpl != null && classHistogramDataPointImpl.getCount() <= ((ClassHistogramDataPointImpl)fullDataPointImpl).getCount()) continue;
                fullDataPointImpl = classHistogramDataPointImpl;
            }
            if (fullDataPointImpl != null) {
                structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("ClassHistogram.most.instances"), fullDataPointImpl.getComment(), ((ClassHistogramDataPointImpl)fullDataPointImpl).getCount(), fullDataPointImpl.formatYWithUnits()));
            }
        }
    }
}

