/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.methodtrace.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.methodtrace.MethodTraceData;
import com.ibm.java.diagnostics.healthcenter.api.methodtrace.MethodTraceEvent;
import com.ibm.java.diagnostics.healthcenter.api.methodtrace.impl.MethodTraceEventImpl;
import com.ibm.java.diagnostics.healthcenter.methodtrace.MethodTraceLabels;
import com.ibm.java.diagnostics.healthcenter.methodtrace.data.MethodTraceExitDataPoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.management.Notification;

public class MethodTraceDataImpl
extends HealthCenterDataImpl
implements MethodTraceData {
    private Notification methodTraceNotify;

    public MethodTraceDataImpl(Data data) {
        super(data);
    }

    @Override
    public MethodTraceEvent[] getMethodTraceEvents() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.METHODTRACE);
        ArrayList<MethodTraceEventImpl> arrayList = new ArrayList<MethodTraceEventImpl>();
        MethodTraceEvent[] methodTraceEventArray = new MethodTraceEvent[]{};
        if (data != null) {
            Data[] dataArray = data.getChildren();
            if (dataArray != null) {
                for (Data data2 : dataArray) {
                    Data[] dataArray2;
                    if (!(data2 instanceof StringDataBuilder) || (dataArray2 = data2.getChildren()) == null) continue;
                    for (Data data3 : dataArray2) {
                        if (!(data3 instanceof TwoDimensionalDataBuilder)) continue;
                        List<DataPointBuilder> list = ((TwoDimensionalDataBuilder)data3).getAllDataPoints();
                        ListIterator<DataPointBuilder> listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            DataPointBuilder dataPointBuilder = listIterator.next();
                            if (!(dataPointBuilder instanceof MethodTraceExitDataPoint)) continue;
                            MethodTraceExitDataPoint methodTraceExitDataPoint = (MethodTraceExitDataPoint)dataPointBuilder;
                            String string = data3.getLabel();
                            Long l = Long.parseLong(data3.getID(), 16);
                            double d = methodTraceExitDataPoint.getRawX() - methodTraceExitDataPoint.getDurationTime();
                            double d2 = methodTraceExitDataPoint.getRawX();
                            String string2 = data2.getLabel();
                            MethodTraceEventImpl methodTraceEventImpl = new MethodTraceEventImpl(string2, string, l, d, d2);
                            arrayList.add(methodTraceEventImpl);
                        }
                    }
                }
            }
            Object[] objectArray = new MethodTraceEvent[arrayList.size()];
            methodTraceEventArray = (MethodTraceEvent[])arrayList.toArray(objectArray);
        }
        return methodTraceEventArray;
    }

    @Override
    protected String getRecommendationLabel() {
        return MethodTraceLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.METHODTRACE;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    static /* synthetic */ long access$000(MethodTraceDataImpl methodTraceDataImpl) {
        return methodTraceDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        Date methodTraceTime;
        long count = 0L;
        long delay = MethodTraceDataImpl.access$000(MethodTraceDataImpl.this);

        public Updater(long l) {
            if (l >= MethodTraceDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.methodTraceTime = new Date();
                        if (MethodTraceDataImpl.this.getMethodTraceEvents() != null && MethodTraceDataImpl.this.getMethodTraceEvents().length > 0 && MethodTraceDataImpl.this.getMethodTraceEvents()[MethodTraceDataImpl.this.getMethodTraceEvents().length - 1].getEndTime() != this.methodTraceTime.getTime()) {
                            MethodTraceDataImpl.this.methodTraceNotify = new Notification(null, MethodTraceDataImpl.this, this.count++);
                            MethodTraceDataImpl.this.methodTraceNotify.setUserData("com.ibm.java.diagonstics.healthcenter.api.methodtrace.MethodTraceData");
                            MethodTraceDataImpl.this.sendNotification(MethodTraceDataImpl.this.methodTraceNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

