/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.jvm.j9.dump.extract.JExtractFatalException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Main {
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private static int JEXTRACT_SUCCESS = 0;
    private static int JEXTRACT_SYNTAX_ERROR = 1;
    private static int JEXTRACT_FILE_ERROR = 2;
    private static int JEXTRACT_NOJVM_ERROR = 3;
    private static int JEXTRACT_ADDRESS_ERROR = 4;
    private static int JEXTRACT_VERSION_ERROR = 5;
    private static int JEXTRACT_INTERNAL_ERROR = 6;
    private final DummyBuilder _builder;
    private final List<String> _diagnostics = new ArrayList<String>();
    private final ICoreFileReader _dump;
    private final String _dumpName;
    private final boolean _excludeCoreFile;
    private final boolean _throwExceptions;
    private final boolean _verbose;
    private final String _zipFileName;

    public static void main(String[] args) {
        Main dumper = new Main(args);
        dumper.runZip();
        if (dumper._dump != null) {
            try {
                dumper._dump.releaseResources();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensure(boolean condition, String errorMessage) {
        if (!condition) {
            this.usageMessage(errorMessage, JEXTRACT_SYNTAX_ERROR);
        }
    }

    private void usageMessage(String message, int code) {
        this.report("Usage: jextract [options] dump_name [output_filename]");
        this.report("  output filename defaults to dump_name.zip");
        this.report("  options:");
        this.report("    -e                  throw exceptions instead of calling System.exit()");
        this.report("    -f executable_name  override executable name");
        this.report("    -help               print this usage message");
        this.report("    -p prefix           prefix for all paths (absolute or relative)");
        this.report("    -r                  relax version checking");
        this.report("    -v                  enable verbose output");
        this.report("    -x                  exclude dump_name from output file");
        this.report("    --                  mark end of options");
        this.errorMessage(message, code);
    }

    private void errorMessage(String message, int code) {
        if (this._throwExceptions) {
            throw new JExtractFatalException(message, code);
        }
        if (message != null) {
            this.report(message);
        }
        System.exit(code);
    }

    private void errorMessage(String message, int code, Throwable throwable) {
        throwable.printStackTrace();
        if (this._throwExceptions) {
            throw new JExtractFatalException(message, code);
        }
        if (message != null) {
            this.report(message);
        }
        System.exit(code);
    }

    private Main(String[] args) {
        boolean disableBuildIdCheck = false;
        String dumpName = null;
        boolean excludeCoreFile = false;
        boolean ignoreOptions = false;
        String outputName = null;
        boolean throwExceptions = false;
        boolean verbose = false;
        File virtualRootDirectory = null;
        if (args.length == 0) {
            this.usageMessage(null, JEXTRACT_SUCCESS);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!ignoreOptions && arg.startsWith("-")) {
                File file;
                if ("--".equals(arg)) {
                    ignoreOptions = true;
                    continue;
                }
                if ("-help".equals(arg)) {
                    this.usageMessage(null, JEXTRACT_SUCCESS);
                    continue;
                }
                if ("-f".equals(arg)) {
                    this.ensure(++i < args.length && !args[i].startsWith("-"), "Syntax error: -f option specified with no filename following");
                    arg = args[i];
                    file = new File(arg);
                    this.ensure(file.exists() && file.canRead(), "File specified using -f option (\"" + arg + "\") not found.");
                    System.setProperty("com.ibm.dtfj.corereaders.executable", arg);
                    continue;
                }
                if ("-p".equals(arg)) {
                    this.ensure(++i < args.length && !args[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    arg = args[i];
                    file = new File(arg);
                    this.ensure(file.exists() && file.canRead() && file.isDirectory(), "Virtual directory specified using -p option (\"" + arg + "\") does not exist as a readable directory.");
                    virtualRootDirectory = new File(arg);
                    continue;
                }
                if (arg.equals("-v")) {
                    verbose = true;
                    continue;
                }
                if (arg.equals("-e")) {
                    throwExceptions = true;
                    continue;
                }
                if (arg.equals("-r")) {
                    disableBuildIdCheck = true;
                    continue;
                }
                if (arg.equals("-x")) {
                    excludeCoreFile = true;
                    continue;
                }
                this.usageMessage("Unrecognized option: " + arg, JEXTRACT_SYNTAX_ERROR);
                continue;
            }
            if (dumpName == null) {
                dumpName = arg;
                continue;
            }
            if (outputName == null) {
                outputName = arg;
                continue;
            }
            this.usageMessage("Too many file arguments: " + arg, JEXTRACT_SYNTAX_ERROR);
        }
        if (dumpName == null) {
            this.usageMessage("No dump file specified", JEXTRACT_SYNTAX_ERROR);
        }
        this._dumpName = dumpName;
        this._verbose = verbose;
        this._throwExceptions = throwExceptions;
        this._excludeCoreFile = excludeCoreFile;
        this._zipFileName = null != outputName ? outputName : dumpName.concat(".zip");
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException e) {
            this.errorMessage("Error. Security permissions don't allow required native library to be loaded.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (UnsatisfiedLinkError e) {
            this.errorMessage("Error. Native library j9jextract cannot be found. Please check your path.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (Exception e) {
            this.errorMessage("Error. Unexpected exception occurred loading: j9jextract", JEXTRACT_INTERNAL_ERROR, e);
        }
        this.report("Loading dump file...");
        File dumpFile = new File(dumpName);
        ClosingFileReader reader = null;
        try {
            reader = new ClosingFileReader(dumpFile);
        }
        catch (FileNotFoundException e) {
            if (!dumpFile.exists()) {
                this.errorMessage("Error. Could not find dump file: " + dumpName, JEXTRACT_FILE_ERROR);
            } else if (!dumpFile.canRead()) {
                this.errorMessage("Error. Unable to read dump file (check permission): " + dumpName, JEXTRACT_FILE_ERROR);
            } else {
                this.errorMessage("Error. Unexpected FileNotFoundException occurred opening: " + dumpName, JEXTRACT_FILE_ERROR, e);
            }
        }
        catch (IOException e) {
            this.errorMessage(e.getMessage(), JEXTRACT_FILE_ERROR);
        }
        ICoreFileReader dump = null;
        try {
            dump = DumpFactory.createDumpForCore(reader, this._verbose);
        }
        catch (Exception e) {
            this.errorMessage("Error. Unexpected Exception occurred opening: " + dumpName, JEXTRACT_FILE_ERROR, e);
        }
        if (null == dump) {
            this.errorMessage("Error. Dump type not recognised, file: " + dumpName, JEXTRACT_FILE_ERROR);
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (dump.isTruncated()) {
            this.report("Warning: dump file is truncated. Extracted information may be incomplete.");
        }
        long environmentPointer = 0L;
        try {
            environmentPointer = this.getEnvironmentPointer(dump.getAddressSpace(), disableBuildIdCheck);
        }
        catch (Throwable t) {
            this.errorMessage("Error. Unable to locate executable for " + dumpName, JEXTRACT_INTERNAL_ERROR, t);
        }
        this._builder = new DummyBuilder(virtualRootDirectory, environmentPointer);
        this._dump = dump;
        this._dump.extract(this._builder);
        this.report("Read memory image from " + this._dumpName);
    }

    private void runZip() {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        files.add(this._dumpName);
        Iterator iter = this._dump.getAdditionalFileNames();
        while (iter.hasNext()) {
            files.add((String)iter.next());
        }
        if (this._excludeCoreFile) {
            files.remove(this._dumpName);
        }
        try {
            String osName;
            String omrtrace;
            String j9trace;
            String lib_dir = System.getProperty("java.home") + File.separator + "lib" + File.separator;
            String trace = lib_dir + "TraceFormat.dat";
            if (new File(trace).exists()) {
                files.add(trace);
            }
            if (new File(j9trace = lib_dir + "J9TraceFormat.dat").exists()) {
                files.add(j9trace);
            }
            if (new File(omrtrace = lib_dir + "OMRTraceFormat.dat").exists()) {
                files.add(omrtrace);
            }
            if ("AIX".equalsIgnoreCase(osName = System.getProperty("os.name"))) {
                files.add("libdbx_j9.so");
            }
        }
        catch (Exception lib_dir) {
            // empty catch block
        }
        Set<String> excluded = this._excludeCoreFile ? Collections.singleton(this._dumpName) : Collections.emptySet();
        try {
            this.createZipFromFileNames(files, excluded, this._builder);
        }
        catch (Exception e) {
            this.errorMessage(e.getMessage(), JEXTRACT_INTERNAL_ERROR, e);
        }
        this.report("jextract complete.");
    }

    private void report(String message) {
        System.err.println(message);
        this._diagnostics.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFromFileNames(Collection<String> fileNames, Collection<String> excludedNames, Builder fileResolver) throws Exception {
        this.report("Creating archive file: " + this._zipFileName);
        try {
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this._zipFileName));
            if (!excludedNames.isEmpty()) {
                String excludedFilesFileName = "excluded-files.txt";
                this.report("Adding \"excluded-files.txt\"");
                ZipEntry zipEntry = new ZipEntry("excluded-files.txt");
                zipEntry.setTime(System.currentTimeMillis());
                zip.putNextEntry(zipEntry);
                try {
                    PrintWriter noteWriter = new PrintWriter(new OutputStreamWriter((OutputStream)zip, StandardCharsets.UTF_8));
                    noteWriter.println("Files omitted from archive");
                    noteWriter.println("==========================");
                    for (String excludedName : excludedNames) {
                        noteWriter.println(excludedName);
                    }
                    noteWriter.flush();
                }
                finally {
                    zip.closeEntry();
                }
            }
            byte[] buffer = new byte[32768];
            HashSet<String> filesInZip = new HashSet<String>();
            for (String name : fileNames) {
                try {
                    ClosingFileReader in = fileResolver.openFile(name);
                    Object object = null;
                    try {
                        boolean mvsfile = in.isMVSFile();
                        String absolute = in.getAbsolutePath();
                        if (mvsfile || absolute.equals(new File(name).getAbsolutePath())) {
                            this.report("Adding \"" + name + "\"");
                        } else {
                            this.report("Adding \"" + name + "\" (found at \"" + absolute + "\")");
                        }
                        if (mvsfile) {
                            zip.putNextEntry(new ZipEntry(name));
                            filesInZip.add(name);
                            Main.copy(in, (OutputStream)zip, buffer);
                            continue;
                        }
                        if (filesInZip.contains(absolute)) continue;
                        InputStream fileStream = in.streamFromFile();
                        ZipEntry zipEntry = new ZipEntry(absolute);
                        filesInZip.add(absolute);
                        zipEntry.setTime(new File(absolute).lastModified());
                        zip.putNextEntry(zipEntry);
                        Main.copy(fileStream, (OutputStream)zip, buffer);
                        fileStream.close();
                    }
                    catch (Throwable mvsfile) {
                        object = mvsfile;
                        throw mvsfile;
                    }
                    finally {
                        if (in == null) continue;
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable mvsfile) {
                                ((Throwable)object).addSuppressed(mvsfile);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (FileNotFoundException e) {
                    this.report("Warning:  Could not find file \"" + name + "\" for inclusion in archive");
                }
                catch (IOException e) {
                    throw new Exception("Failure adding file " + name + " to archive", e);
                }
                finally {
                    zip.closeEntry();
                }
            }
            String diagnosticLogFileName = "execution-log.txt";
            this.report("Adding \"execution-log.txt\"");
            ZipEntry zipEntry = new ZipEntry("execution-log.txt");
            zipEntry.setTime(System.currentTimeMillis());
            zip.putNextEntry(zipEntry);
            try {
                PrintWriter noteWriter = new PrintWriter(new OutputStreamWriter((OutputStream)zip, StandardCharsets.UTF_8));
                noteWriter.println("Execution log");
                noteWriter.println("=============");
                for (String message : this._diagnostics) {
                    noteWriter.println(message);
                }
                noteWriter.flush();
            }
            finally {
                zip.closeEntry();
            }
            try {
                zip.close();
            }
            catch (IOException e) {
                throw new Exception("Failure closing archive file (" + this._zipFileName + "): " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            throw new Exception("Could not find archive file to output to: " + e.getMessage());
        }
    }

    private static void copy(InputStream from, OutputStream to, byte[] buffer) throws IOException {
        int count;
        while ((count = from.read(buffer)) != -1) {
            to.write(buffer, 0, count);
        }
    }

    private static void copy(ClosingFileReader from, OutputStream to, byte[] buffer) throws IOException {
        int count;
        while ((count = from.read(buffer)) != -1) {
            to.write(buffer, 0, count);
        }
    }

    private native long getEnvironmentPointer(IAbstractAddressSpace var1, boolean var2) throws Exception;

    private static final class DummyBuilder
    implements Builder {
        private final File _virtualRootDirectory;
        private final List<File> _successfulSearchPaths;
        private final long _environmentPointer;

        public DummyBuilder(File rootDirectory, long environment) {
            this._virtualRootDirectory = rootDirectory;
            String java_home = System.getProperty("java.home");
            this._successfulSearchPaths = new ArrayList<File>();
            this._successfulSearchPaths.add(new File(java_home, "bin"));
            this._environmentPointer = environment;
        }

        @Override
        public Object buildProcess(Object addressSpace, String pid, String commandLine, Properties environment, Object currentThread, Iterator threads, Object executable, Iterator libraries, int addressSize) {
            return new Object();
        }

        @Override
        public Object buildRegister(String name, Number value) {
            return new Register(name, value.longValue());
        }

        @Override
        public Object buildStackSection(Object addressSpace, long stackStart, long stackEnd) {
            return new Object();
        }

        @Override
        public Object buildThread(String name, Iterator registers, Iterator stackSections, Iterator stackFrames, Properties properties, int signalNumber) {
            return new Object();
        }

        @Override
        public Object buildModuleSection(Object addressSpace, String name, long imageStart, long imageEnd) {
            return new Object();
        }

        @Override
        public Object buildModule(String name, Properties properties, Iterator sections, Iterator symbols, long loadAddress) {
            return new Object();
        }

        @Override
        public long getEnvironmentAddress() {
            return this._environmentPointer;
        }

        @Override
        public long getValueOfNamedRegister(List registers, String name) {
            for (Register register : registers) {
                if (!name.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        @Override
        public Object buildStackFrame(Object addressSpace, long stackBasePointer, long pc) {
            return new Object();
        }

        @Override
        public ClosingFileReader openFile(String nameOrPath) throws IOException {
            File fileRep = new File(nameOrPath);
            if (null != this._virtualRootDirectory && fileRep.isAbsolute()) {
                fileRep = DummyBuilder.sysFileRelative(this._virtualRootDirectory, fileRep);
            } else {
                if (fileRep.exists()) {
                    File absolute;
                    ClosingFileReader reader = new ClosingFileReader(fileRep);
                    File parent = fileRep.getParentFile();
                    if (null != parent && !this._successfulSearchPaths.contains(absolute = parent.getAbsoluteFile())) {
                        this._successfulSearchPaths.add(absolute);
                    }
                    return reader;
                }
                if (!fileRep.isAbsolute()) {
                    Iterator<File> paths = this._successfulSearchPaths.iterator();
                    String filename = fileRep.getName();
                    while (paths.hasNext()) {
                        File path = paths.next();
                        File nextPath = new File(path, filename);
                        if (!nextPath.exists()) continue;
                        return new ClosingFileReader(nextPath);
                    }
                }
            }
            return new ClosingFileReader(fileRep);
        }

        private static File sysFileRelative(File virtualRoot, File originalPath) {
            File temp = originalPath;
            while (null != temp.getParentFile()) {
                temp = temp.getParentFile();
            }
            File result = originalPath;
            if (originalPath.isAbsolute()) {
                String middle = originalPath.getAbsolutePath().substring(temp.getAbsolutePath().length());
                result = new File(virtualRoot, middle);
            }
            return result;
        }

        @Override
        public Object buildSymbol(Object addressSpace, String functionName, long relocatedFunctionAddress) {
            return new Object();
        }

        @Override
        public void setExecutableUnavailable(String description) {
        }

        @Override
        public Object buildAddressSpace(String name, int id) {
            return new Object();
        }

        @Override
        public void setOSType(String osType) {
        }

        @Override
        public void setCPUType(String cpuType) {
        }

        @Override
        public void setCPUSubType(String subType) {
        }

        @Override
        public void setCreationTime(long millis) {
        }

        @Override
        public Object buildCorruptData(Object addressSpace, String message, long address) {
            return new Object();
        }

        private static final class Register {
            final String name;
            final long value;

            Register(String name, long value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

