/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

import com.ibm.dtfj.phd.util.BitStream;
import com.ibm.dtfj.phd.util.BufferedNumberStream;
import com.ibm.dtfj.phd.util.LongArray;
import com.ibm.dtfj.phd.util.SortedNumberStream;
import java.util.NoSuchElementException;
import java.util.Random;

public class NumberStream {
    private static final int TYPE_FIELD_BITS = 2;
    private static final int SIGN_FIELD_BITS = 1;
    private static final int REPEATED_DELTA = 0;
    private static final int REPEATED_DELTA_BITS = 32;
    private static final int SMALL_DELTA = 1;
    private static final int SMALL_DELTA_BITS = 11;
    private static final int MEDIUM_DELTA = 2;
    private static final int MEDIUM_DELTA_BITS = 31;
    private static final int LARGE_DELTA = 3;
    private static final int LARGE_DELTA_BITS = 63;
    BitStream bitStream = new BitStream();
    long lastn;
    int repeatCount;
    int elementCount;
    int readElementCount;
    static final boolean dbg = false;

    public void setBitStream(BitStream bitStream) {
        this.bitStream = bitStream;
        this.repeatCount = 0;
        this.lastn = 0L;
    }

    public void writeLong(long n) {
        ++this.elementCount;
        long delta = n - this.lastn;
        if (delta == 0L) {
            if (this.repeatCount == -1) {
                this.flush();
            }
            ++this.repeatCount;
            return;
        }
        this.flush();
        boolean isNegative = delta < 0L;
        long saveDelta = delta;
        delta = Math.abs(delta);
        if (delta < 2048L) {
            int type = 1;
            this.bitStream.writeIntBits(type, 2);
            this.bitStream.writeIntBits(isNegative ? 1 : 0, 1);
            this.bitStream.writeIntBits((int)delta, 11);
        } else if (delta < 0x80000000L) {
            int type = 2;
            this.bitStream.writeIntBits(type, 2);
            this.bitStream.writeIntBits(isNegative ? 1 : 0, 1);
            this.bitStream.writeIntBits((int)delta, 31);
        } else {
            int type = 3;
            this.bitStream.writeIntBits(3, 2);
            this.bitStream.writeIntBits(isNegative ? 1 : 0, 1);
            this.bitStream.writeLongBits(delta, 63);
        }
        this.lastn = n;
    }

    public long readLong() {
        long delta;
        boolean isNegative;
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        --this.readElementCount;
        if (this.repeatCount != 0) {
            --this.repeatCount;
            return this.lastn;
        }
        int type = this.bitStream.readIntBits(2);
        if (type == 0) {
            this.repeatCount = this.bitStream.readIntBits(32);
            NumberStream.Assert(this.repeatCount != 0);
            --this.repeatCount;
            return this.lastn;
        }
        boolean bl = isNegative = this.bitStream.readIntBits(1) != 0;
        if (type == 1) {
            delta = this.bitStream.readIntBits(11);
            if (isNegative) {
                delta = -delta;
            }
        } else if (type == 2) {
            delta = this.bitStream.readIntBits(31);
            if (isNegative) {
                delta = -delta;
            }
        } else {
            delta = this.bitStream.readLongBits(63);
            if (isNegative) {
                delta = -delta;
            }
        }
        this.lastn += delta;
        return this.lastn;
    }

    public void flush() {
        if (this.repeatCount != 0) {
            int type = 0;
            this.bitStream.writeIntBits(type, 2);
            this.bitStream.writeIntBits(this.repeatCount, 32);
            this.repeatCount = 0;
        }
    }

    void reset() {
        this.flush();
        this.bitStream.reset();
        this.repeatCount = 0;
        this.lastn = 0L;
    }

    public void rewind() {
        this.reset();
        this.readElementCount = this.elementCount;
    }

    public void clear() {
        this.rewind();
        this.bitStream.clear();
        this.elementCount = 0;
        this.readElementCount = 0;
    }

    public boolean hasMore() {
        return this.readElementCount != 0;
    }

    public int elementCount() {
        return this.elementCount;
    }

    public int[] toIntArray() {
        this.rewind();
        int[] array = new int[this.elementCount()];
        for (int i = 0; i < this.elementCount(); ++i) {
            array[i] = (int)this.readLong();
        }
        return array;
    }

    public long[] toLongArray() {
        this.rewind();
        long[] array = new long[this.elementCount()];
        for (int i = 0; i < this.elementCount(); ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    int memoryUsage() {
        return this.bitStream.memoryUsage();
    }

    static void Assert(boolean condition) {
        if (!condition) {
            throw new Error("assert failed");
        }
    }

    public static void main(String[] args) {
        long li;
        int total = 0;
        long totalSize = 0L;
        long totalUsedSize = 0L;
        boolean sort = false;
        NumberStream ns = sort ? new SortedNumberStream() : new BufferedNumberStream();
        Random r = new Random(1L);
        for (int n = 0; n < 100; ++n) {
            long l;
            int i;
            System.out.println("pass " + n);
            LongArray la = new LongArray();
            int count = 16384;
            ns.clear();
            for (i = 0; i < count; ++i) {
                l = r.nextLong();
                ns.writeLong(l);
                la.add(l);
                ns.writeLong(l += (long)r.nextInt());
                la.add(l);
                ns.writeLong(l += (long)r.nextInt(2048));
                la.add(l);
                ns.writeLong(l -= (long)r.nextInt(2048));
                la.add(l);
                int j = 0;
                while ((double)j < r.nextGaussian()) {
                    l = 0L;
                    ns.writeLong(l);
                    la.add(l);
                    ++j;
                }
                if (i % 256 != 0) continue;
                for (j = 0; j < i; ++j) {
                    ns.writeLong(l);
                    la.add(l);
                }
            }
            ns.rewind();
            if (sort) {
                la.sort();
            }
            for (i = 0; i < la.size(); ++i) {
                l = ns.readLong();
                if (l == la.get(i)) continue;
                System.err.println("At " + i + " expected 0x" + Long.toHexString(la.get(i)) + " got " + Long.toHexString(l));
                System.exit(1);
            }
            totalSize += (long)ns.memoryUsage();
            totalUsedSize += (long)(ns.bitStream.getOffset() * 4);
            total += la.size();
        }
        System.out.println("Test succeeded for " + total + " pairs");
        System.out.println("Items " + total + ", used bits per item " + (double)totalUsedSize * 8.0 / (double)total);
        ns.clear();
        long VAL = 78187493520L;
        long v = 78187493520L;
        long MAXREPEAT = Math.min(0x80000000L, 0x100000001L);
        for (li = -2L; li < MAXREPEAT; ++li) {
            if (li % 100000000L == 0L) {
                System.out.println("Write repeat " + li);
            }
            ns.writeLong(li == -2L ? 0L : v);
        }
        ns.writeLong(0L);
        ns.rewind();
        for (li = -2L; li < MAXREPEAT; ++li) {
            if (li % 100000000L == 0L) {
                System.out.println("Read repeat " + li);
            }
            long l = ns.readLong();
            long l2 = v = li == -2L ? 0L : 78187493520L;
            if (l == v) continue;
            System.err.println("At " + li + " expected 0x" + Long.toHexString(v) + " got " + Long.toHexString(l));
            System.exit(1);
        }
        v = 0L;
        long l = ns.readLong();
        if (l != v) {
            System.err.println("At end expected 0x" + Long.toHexString(v) + " got " + Long.toHexString(l));
            System.exit(1);
        }
        if (ns.hasMore()) {
            l = ns.readLong();
            System.err.println("At end expected no more, got " + Long.toHexString(l));
            System.exit(1);
        }
        total = (int)((long)total + (MAXREPEAT + 3L));
        System.out.println("Test succeeded for " + MAXREPEAT + " repeated values");
        System.out.println("Memory usage " + (totalSize += (long)ns.memoryUsage()) + " bytes, used bytes " + (totalUsedSize += (long)(ns.bitStream.getOffset() * 4)));
    }

    static String hex(long i) {
        return Long.toHexString(i);
    }
}

