/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.phd.PHDCorruptImageSection;
import com.ibm.dtfj.phd.PHDCorruptJavaObject;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImageSection;
import com.ibm.dtfj.phd.PHDJavaObject;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.stream.ImageInputStream;

class PHDJavaHeap
implements JavaHeap {
    private static final boolean LOG = false;
    private final ImageAddressSpace space;
    protected final PHDJavaRuntime runtime;
    private final PHDImage image;
    private final File file;
    private final ImageInputStream stream;
    private final boolean isJ9V4;
    private final int STEP = (int)Math.min(10000000L, Runtime.getRuntime().maxMemory() / 32L);
    private final LinkedHashMap<Integer, CacheHeapSegment> cache = new LinkedHashMap();
    private final CachedReader readerCache;
    private boolean doneScan;
    private boolean lastSegment;
    private static final long[] NOREFS = new long[0];

    PHDJavaHeap(ImageInputStream stream, PHDImage parentImage, ImageAddressSpace space, PHDJavaRuntime runtime) throws IOException {
        this.image = parentImage;
        this.space = space;
        this.runtime = runtime;
        HeapdumpReader reader = new HeapdumpReader(stream, parentImage);
        this.isJ9V4 = reader.version() == 4 && reader.isJ9();
        reader.close();
        this.readerCache = new CachedReader(stream, parentImage);
        this.stream = stream;
        this.file = null;
    }

    PHDJavaHeap(File file, PHDImage parentImage, ImageAddressSpace space, PHDJavaRuntime runtime) throws IOException {
        this.file = file;
        this.image = parentImage;
        this.space = space;
        this.runtime = runtime;
        HeapdumpReader reader = new HeapdumpReader(file, parentImage);
        this.isJ9V4 = reader.version() == 4 && reader.isJ9();
        reader.close();
        this.readerCache = new CachedReader(file, parentImage);
        this.stream = null;
    }

    @Override
    public String getName() {
        return "Java heap";
    }

    private Iterator<JavaObject> getObjects0() {
        try {
            return new Iterator<JavaObject>(){
                int[] count = new int[1];
                int prev;
                Iterator<JavaObject> it = PHDJavaHeap.this.getObjectsViaCache(PHDJavaHeap.access$000(PHDJavaHeap.this), this.count, false).values().iterator();

                @Override
                public boolean hasNext() {
                    if (this.it == null) {
                        return false;
                    }
                    if (this.it.hasNext()) {
                        return true;
                    }
                    boolean withRefs = PHDJavaHeap.this.withRefs(this.prev);
                    this.prev = this.count[0];
                    try {
                        this.it = PHDJavaHeap.this.getObjectsViaCache(PHDJavaHeap.this.STEP, this.count, withRefs).values().iterator();
                    }
                    catch (IOException e) {
                        return false;
                    }
                    if (this.it.hasNext()) {
                        return true;
                    }
                    this.it = null;
                    return false;
                }

                @Override
                public JavaObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException e) {
            return new ArrayList().iterator();
        }
    }

    private boolean withRefs(int pos) {
        CacheHeapSegment seg = this.cache.get(pos);
        return seg != null && seg.withRefs;
    }

    Map<AddressKey, JavaObject> getObjectsViaCache(int size, int[] next, boolean withRefs) throws IOException {
        Map<AddressKey, JavaObject> objects;
        SoftReference<Map<AddressKey, JavaObject>> sr;
        int index = next[0];
        CacheHeapSegment seg = this.cache.get(next[0]);
        if (seg == null || (sr = seg.objects) == null || (objects = sr.get()) == null || withRefs && !seg.withRefs) {
            objects = this.getObjects(size, next, withRefs);
            if (seg == null || size != seg.maxSize || next[0] != seg.nextIndex || withRefs != seg.withRefs) {
                seg = new CacheHeapSegment(index, size, next[0], objects, withRefs);
                this.cache.put(index, seg);
            } else {
                seg.objects = sr = new SoftReference<Map<AddressKey, JavaObject>>(objects);
            }
        } else {
            next[0] = seg.nextIndex;
        }
        if (objects.size() == 0) {
            this.lastSegment = true;
        }
        if (this.lastSegment && !this.doneScan) {
            CacheHeapSegment seg1 = this.cache.get(0);
            while (seg1 != null) {
                if (seg1.nextIndex == seg1.index) {
                    this.doneScan = true;
                    break;
                }
                seg1 = this.cache.get(seg1.nextIndex);
            }
        }
        return objects;
    }

    Map<AddressKey, JavaObject> getObjects(final int maxsize, final int[] next, final boolean withRefs) throws IOException {
        boolean more;
        final LinkedHashMap<AddressKey, JavaObject> objects = new LinkedHashMap<AddressKey, JavaObject>();
        final PHDJavaHeap heap = this;
        boolean REFSCALE = true;
        int OBJSCALE = 10;
        final CachedReader.ReaderPos rdr = this.readerCache.getReader(next[0]);
        final int adjustLen = rdr.reader.version() == 4 && rdr.reader.isJ9() ? 1 : 0;
        final long[] current = new long[1];
        try {
            more = rdr.reader.parse(new PortableHeapDumpListener(){
                int total;

                @Override
                public void classDump(long address, long superAddress, String name, int size, int flags, int hashCode, LongEnumeration refs) throws Exception {
                }

                @Override
                public void objectArrayDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, int length, long instanceSize) throws Exception {
                    current[0] = address;
                    if (rdr.where++ >= next[0]) {
                        int size = 10 + refs.numberOfElements() / 1;
                        this.total += size;
                        if (this.total == size || this.total < maxsize) {
                            int refsLen = refs.numberOfElements();
                            int adjustLen2 = Math.min(adjustLen, refsLen);
                            PHDJavaObject.Builder b = new PHDJavaObject.Builder(heap, address, PHDJavaHeap.this.runtime.arrayOf(classAddress, refs, adjustLen), flags, hashCode);
                            PHDJavaObject jo = withRefs ? b.refs(refs, adjustLen2).length(length - adjustLen2).instanceSize(instanceSize).build() : b.length(length - adjustLen2).instanceSize(instanceSize).build();
                            objects.put(AddressKey.getAddress(PHDJavaHeap.this, address), jo);
                            next[0] = rdr.where;
                        }
                        if (this.total >= maxsize) {
                            rdr.reader.exitParse();
                        }
                    }
                    current[0] = 0L;
                }

                @Override
                public void objectDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, long instanceSize) throws Exception {
                    current[0] = address;
                    if (rdr.where++ >= next[0]) {
                        int size = 10 + refs.numberOfElements() / 1;
                        this.total += size;
                        if (this.total == size || this.total < maxsize) {
                            PHDJavaObject.Builder b = new PHDJavaObject.Builder(heap, address, PHDJavaHeap.this.runtime.findClass(classAddress), flags, hashCode).length(-1).instanceSize(instanceSize);
                            PHDJavaObject jo = withRefs ? b.refs(refs, 0).build() : b.build();
                            objects.put(AddressKey.getAddress(PHDJavaHeap.this, address), jo);
                            next[0] = rdr.where;
                        }
                        if (this.total >= maxsize) {
                            rdr.reader.exitParse();
                        }
                    }
                    current[0] = 0L;
                }

                @Override
                public void primitiveArrayDump(long address, int type, int length, int flags, int hashCode, long instanceSize) throws Exception {
                    current[0] = address;
                    if (rdr.where++ >= next[0]) {
                        int size = 10;
                        this.total += size;
                        if (this.total == size || this.total < maxsize) {
                            objects.put(AddressKey.getAddress(PHDJavaHeap.this, address), new PHDJavaObject.Builder(heap, address, PHDJavaHeap.this.runtime.findArrayOfType(type), flags, hashCode).refsAsArray(NOREFS, 0).length(length).instanceSize(instanceSize).build());
                            next[0] = rdr.where;
                        }
                        if (this.total >= maxsize) {
                            rdr.reader.exitParse();
                        }
                    }
                    current[0] = 0L;
                }
            });
        }
        catch (Exception e) {
            if (next[0] == 0 || current[0] != 0L || objects.size() > 0) {
                objects.put(AddressKey.getAddress(this, current[0]), new PHDCorruptJavaObject("building object", this.space.getPointer(current[0]), e));
                next[0] = next[0] + 1;
                more = true;
            }
            more = false;
        }
        if (more) {
            this.readerCache.returnReader(rdr);
        }
        return objects;
    }

    @Override
    public Iterator<ImageSection> getSections() {
        ArrayList<PHDImageSection> c = new ArrayList<PHDImageSection>();
        long last = this.runtime.maxAddress;
        if (this.runtime.minAddress <= this.runtime.maxAddress) {
            ImagePointer objPointer = this.space.getPointer(last);
            JavaObject lastObj = null;
            try {
                lastObj = this.getLastObject(objPointer, this.runtime.maxObjClass, this.runtime.maxObjLen);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (lastObj != null) {
                    last += lastObj.getSize();
                }
                PHDImageSection s = new PHDImageSection(this.getName(), this.space.getPointer(this.runtime.minAddress), last - this.runtime.minAddress);
                c.add(s);
            }
            catch (CorruptDataException e) {
                PHDImageSection s = new PHDImageSection(this.getName(), this.space.getPointer(this.runtime.minAddress), last - this.runtime.minAddress);
                c.add(s);
                s = new PHDCorruptImageSection("Corrupt " + this.getName(), objPointer, 8L);
                c.add(s);
            }
        }
        if (this.runtime.minClassAddress <= this.runtime.maxClassAddress) {
            PHDImageSection s;
            long last2 = this.runtime.maxClassAddress;
            ImagePointer objPointer = this.space.getPointer(last2);
            int insert = c.size();
            try {
                JavaObject lastObj;
                JavaClass jc = this.runtime.findClass(last2);
                long size = 8L;
                if (jc != null && (lastObj = jc.getObject()) != null && lastObj.getID().equals(jc.getID())) {
                    size = lastObj.getSize();
                }
                last2 += size;
            }
            catch (CorruptDataException e) {
                s = new PHDCorruptImageSection("Corrupt " + this.getName(), objPointer, 8L);
                c.add(s);
            }
            if (last2 < this.runtime.minAddress || last < this.runtime.minClassAddress) {
                s = new PHDImageSection(this.getName(), this.space.getPointer(this.runtime.minClassAddress), last2 - this.runtime.minClassAddress);
                c.add(insert, s);
            } else {
                long minAddr = Math.min(this.runtime.minAddress, this.runtime.minClassAddress);
                long maxAddr = Math.max(last, last2);
                s = new PHDImageSection(this.getName(), this.space.getPointer(minAddr), maxAddr - minAddr);
                c.set(0, s);
            }
        }
        return c.iterator();
    }

    ImageAddressSpace getImageAddressSpace() {
        return this.space;
    }

    PHDJavaRuntime getJavaRuntime() {
        return this.runtime;
    }

    JavaObject getCachedObjectAtAddress(ImagePointer address, boolean withRefs) throws IOException {
        for (CacheHeapSegment seg : this.cache.values()) {
            JavaObject jo;
            long addr;
            SoftReference<Map<AddressKey, JavaObject>> sr = seg.objects;
            Map<AddressKey, JavaObject> map = sr.get();
            if ((map == null || withRefs && !seg.withRefs && map.get(AddressKey.getAddress(this, address.getAddress())) != null) && seg.minAddress <= (addr = address.getAddress()) && addr <= seg.maxAddress) {
                int[] next = new int[]{seg.index};
                map = this.getObjects(seg.maxSize, next, withRefs);
                seg.withRefs = withRefs;
                seg.objects = sr = new SoftReference<Map<AddressKey, JavaObject>>(map);
            }
            if (map == null || (jo = map.get(AddressKey.getAddress(this, address.getAddress()))) == null) continue;
            return jo;
        }
        return null;
    }

    JavaObject getObjectAtAddress(ImagePointer address, boolean withRefs) {
        JavaObject jo = null;
        try {
            jo = this.getCachedObjectAtAddress(address, withRefs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jo != null) {
            return jo;
        }
        if (!this.doneScan) {
            try {
                jo = this.getObjectAtAddress3(address, withRefs);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jo;
    }

    private JavaObject getObjectAtAddress3(ImagePointer address, boolean withRefs) throws IOException {
        Map<AddressKey, JavaObject> map;
        int[] count = new int[1];
        while (!(map = this.getObjectsViaCache(this.STEP, count, withRefs)).isEmpty()) {
            JavaObject jo = map.get(AddressKey.getAddress(this, address.getAddress()));
            if (jo == null) continue;
            return jo;
        }
        return null;
    }

    JavaObject getLastObject(ImagePointer address, long classAddress, int length) throws IOException {
        JavaObject jo = this.getCachedObjectAtAddress(address, false);
        if (jo != null) {
            return jo;
        }
        long addr = address.getAddress();
        if (classAddress < 8L) {
            JavaClass jc = this.runtime.findArrayOfType((int)classAddress);
            jo = new PHDJavaObject.Builder(this, addr, jc, 4, -1).length(length).refsAsArray(NOREFS, 0).build();
        } else if (length >= 0) {
            if (this.isJ9V4) {
                --length;
            }
            JavaClass jc = this.runtime.findArrayOfClass(classAddress);
            jo = new PHDJavaObject.Builder(this, addr, jc, 4, -1).length(length).build();
        } else {
            JavaClass jc = this.runtime.findClass(classAddress);
            jo = new PHDJavaObject.Builder(this, addr, jc, 4, -1).length(-1).build();
        }
        return jo;
    }

    @Override
    public Iterator<JavaObject> getObjects() {
        final PHDJavaHeap heap = this;
        try {
            return new Iterator<JavaObject>(){
                HeapdumpReader reader = PHDJavaHeap.access$500(PHDJavaHeap.this) == null ? new HeapdumpReader(PHDJavaHeap.access$600(PHDJavaHeap.this), PHDJavaHeap.access$700(PHDJavaHeap.this)) : new HeapdumpReader(PHDJavaHeap.access$500(PHDJavaHeap.this), PHDJavaHeap.access$700(PHDJavaHeap.this));
                final int adjustLen = this.reader.version() == 4 && this.reader.isJ9() ? 1 : 0;
                final long[] current = new long[1];
                static final boolean withRefs = true;
                JavaObject jo;
                int count = 0;
                PortableHeapDumpListener listen = new PortableHeapDumpListener(){

                    @Override
                    public void classDump(long address, long superAddress, String name, int size, int flags, int hashCode, LongEnumeration refs) throws Exception {
                    }

                    @Override
                    public void objectArrayDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, int length, long instanceSize) throws Exception {
                        current[0] = address;
                        int refsLen = refs.numberOfElements();
                        int adjustLen2 = Math.min(adjustLen, refsLen);
                        PHDJavaObject.Builder b = new PHDJavaObject.Builder(heap, address, PHDJavaHeap.this.runtime.arrayOf(classAddress, refs, adjustLen), flags, hashCode).instanceSize(instanceSize);
                        jo = b.refs(refs, adjustLen2).length(length - adjustLen2).build();
                        current[0] = 0L;
                        reader.exitParse();
                    }

                    @Override
                    public void objectDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, long instanceSize) throws Exception {
                        current[0] = address;
                        PHDJavaObject.Builder b = new PHDJavaObject.Builder(heap, address, PHDJavaHeap.this.runtime.findClass(classAddress), flags, hashCode).length(-1).instanceSize(instanceSize);
                        jo = b.refs(refs, 0).build();
                        current[0] = 0L;
                        reader.exitParse();
                    }

                    @Override
                    public void primitiveArrayDump(long address, int type, int length, int flags, int hashCode, long instanceSize) throws Exception {
                        current[0] = address;
                        jo = new PHDJavaObject.Builder(heap, address, PHDJavaHeap.this.runtime.findArrayOfType(type), flags, hashCode).refsAsArray(NOREFS, 0).length(length).instanceSize(instanceSize).build();
                        current[0] = 0L;
                        reader.exitParse();
                    }
                };

                @Override
                public boolean hasNext() {
                    if (this.jo == null) {
                        this.getNext();
                    }
                    return this.jo != null;
                }

                @Override
                public JavaObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    JavaObject ret = this.jo;
                    this.jo = null;
                    ++this.count;
                    return ret;
                }

                private void getNext() {
                    try {
                        if (this.reader != null && !this.reader.parse(this.listen)) {
                            this.reader.close();
                            this.reader = null;
                        }
                    }
                    catch (EOFException e) {
                        this.jo = new PHDCorruptJavaObject("Truncated dump found while building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(0L), e);
                        this.reader.close();
                        this.reader = null;
                    }
                    catch (IOException e) {
                        this.jo = new PHDCorruptJavaObject("Corrupted dump found while building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(0L), e);
                        this.reader.close();
                        this.reader = null;
                    }
                    catch (Exception e) {
                        if (this.current[0] != 0L) {
                            this.jo = new PHDCorruptJavaObject("Building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(this.current[0]), e);
                        }
                        this.jo = new PHDCorruptJavaObject("Building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(0L), e);
                        this.reader.close();
                        this.reader = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                protected void finalize() throws Throwable {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                }
            };
        }
        catch (IOException e) {
            return new ArrayList().iterator();
        }
    }

    static /* synthetic */ ImageInputStream access$500(PHDJavaHeap x0) {
        return x0.stream;
    }

    static /* synthetic */ File access$600(PHDJavaHeap x0) {
        return x0.file;
    }

    static /* synthetic */ PHDImage access$700(PHDJavaHeap x0) {
        return x0.image;
    }

    static abstract class AddressKey {
        AddressKey() {
        }

        abstract long value(PHDJavaHeap var1);

        static AddressKey getAddress(PHDJavaHeap jh, long addr) {
            if (jh.runtime.noCompress()) {
                throw new IllegalStateException("Unable to compress addresses");
            }
            int iv = jh.runtime.compressAddress(addr);
            long addr2 = jh.runtime.expandAddress(iv);
            if (addr == addr2) {
                return new IntAddressKey(iv);
            }
            return new LongAddressKey(addr);
        }
    }

    static class CacheHeapSegment {
        final int index;
        final int maxSize;
        final int nextIndex;
        SoftReference<Map<AddressKey, JavaObject>> objects;
        boolean withRefs;
        final long minAddress;
        final long maxAddress;

        CacheHeapSegment(int index, int size, int nextIndex, Map<AddressKey, JavaObject> objs, boolean withRefs) {
            this.objects = new SoftReference<Map<AddressKey, JavaObject>>(objs);
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            for (JavaObject jo : objs.values()) {
                if (jo instanceof CorruptData) continue;
                long addr = jo.getID().getAddress();
                max = Math.max(max, addr);
                min = Math.min(min, addr);
            }
            this.index = index;
            this.maxSize = size;
            this.nextIndex = nextIndex;
            this.maxAddress = max;
            this.minAddress = min;
            this.withRefs = withRefs;
        }
    }

    static class CachedReader {
        File file;
        ImageInputStream stream;
        final PHDImage parentImage;
        List<ReaderPos> readers = new ArrayList<ReaderPos>();

        CachedReader(File f, PHDImage parentImage) {
            this.file = f;
            this.parentImage = parentImage;
        }

        CachedReader(ImageInputStream stream, PHDImage parentImage) {
            this.stream = stream;
            this.parentImage = parentImage;
        }

        ReaderPos getReader(int n) throws IOException {
            ReaderPos best = null;
            for (ReaderPos rp : this.readers) {
                if (rp.where > n || best != null && best.where >= rp.where) continue;
                best = rp;
            }
            if (best == null) {
                best = new ReaderPos(this.parentImage);
            } else {
                this.readers.remove(best);
            }
            return best;
        }

        void returnReader(ReaderPos rdr) {
            this.readers.add(rdr);
        }

        class ReaderPos {
            int where;
            HeapdumpReader reader;

            ReaderPos(PHDImage parentImage) throws IOException {
                this.reader = CachedReader.this.stream == null ? new HeapdumpReader(CachedReader.this.file, parentImage) : new HeapdumpReader(CachedReader.this.stream, parentImage);
                this.where = 0;
            }
        }
    }

    private static final class IntAddressKey
    extends AddressKey {
        final int val;

        private IntAddressKey(int v) {
            this.val = v;
        }

        @Override
        long value(PHDJavaHeap jh) {
            return jh.runtime.expandAddress(this.val);
        }

        public int hashCode() {
            return this.val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof IntAddressKey && this.val == ((IntAddressKey)o).val;
        }
    }

    private static final class LongAddressKey
    extends AddressKey {
        final long val;

        private LongAddressKey(long v) {
            this.val = v;
        }

        @Override
        long value(PHDJavaHeap jh) {
            return this.val;
        }

        public int hashCode() {
            return (int)this.val ^ (int)(this.val >>> 32);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof LongAddressKey && this.val == ((LongAddressKey)o).val;
        }
    }
}

