/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider.icc;

import com.ibm.crypto.plus.provider.Poly1305Constants;
import com.ibm.crypto.plus.provider.icc.ByteArrayOutputDelay;
import com.ibm.crypto.plus.provider.icc.ICCContext;
import com.ibm.crypto.plus.provider.icc.ICCException;
import com.ibm.crypto.plus.provider.icc.NativeInterface;
import com.ibm.crypto.plus.provider.icc.Padding;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public final class Poly1305Cipher
implements Poly1305Constants {
    private ICCContext a;
    private long b;
    private boolean c = false;
    private boolean d = true;
    private Padding e = null;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    private int i = 0;
    private boolean j = false;
    private byte[] k = null;
    private byte[] l = null;
    private ByteArrayOutputDelay m = null;
    private static final String n;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Poly1305Cipher getInstance(ICCContext iCCContext, String string, Padding padding) throws ICCException {
        if (iCCContext == null) {
            throw new IllegalArgumentException(z[1]);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(z[0]);
        }
        if (padding == null) {
            throw new IllegalArgumentException(z[2]);
        }
        return new Poly1305Cipher(iCCContext, string, padding);
    }

    private Poly1305Cipher(ICCContext iCCContext, String string, Padding padding) throws ICCException {
        this.a = iCCContext;
        this.b = NativeInterface.POLY1305CIPHER_create(iCCContext.getId(), string);
        this.e = padding;
    }

    public synchronized void initCipherEncrypt(byte[] byArray, byte[] byArray2) throws ICCException {
        this.a(true, byArray, byArray2);
    }

    public synchronized void initCipherDecrypt(byte[] byArray, byte[] byArray2) throws ICCException {
        this.a(false, byArray, byArray2);
        this.m = new ByteArrayOutputDelay(16);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, byte[] byArray, byte[] byArray2) throws ICCException {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException(z[5]);
        }
        if (byArray.length < this.getKeyLength()) {
            throw new IllegalArgumentException(z[3]);
        }
        if (byArray2 != null && byArray2.length < this.getIVLength()) {
            throw new IllegalArgumentException(z[4]);
        }
        if (this.b == 0L) {
            throw new ICCException(z[6]);
        }
        NativeInterface.POLY1305CIPHER_init(this.a.getId(), this.b, bl ? 1 : 0, byArray, byArray2);
        NativeInterface.POLY1305CIPHER_setPadding(this.a.getId(), this.b, this.e.getId());
        this.d = bl;
        this.f = 0;
        this.j = false;
        if (byArray != this.k) {
            if (this.k != null) {
                Arrays.fill(this.k, (byte)0);
            }
            this.k = (byte[])byArray.clone();
        }
        if (byArray2 != this.l) {
            this.l = byArray2 == null ? null : (byte[])byArray2.clone();
        }
        this.c = true;
    }

    public synchronized int getOutputSize(int n2, boolean bl, int n3) {
        if (n2 < 0) {
            return 0;
        }
        int n4 = this.f + n2;
        if (bl) {
            return n4 + n3;
        }
        int n5 = n4 < n3 ? 0 : n4 - n3;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getBlockSize() throws ICCException {
        if (this.g == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[24]);
            }
            this.g = NativeInterface.POLY1305CIPHER_getBlockSize(this.a.getId(), this.b);
        }
        return this.g;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getKeyLength() throws ICCException {
        if (this.h == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[16]);
            }
            this.h = NativeInterface.POLY1305CIPHER_getKeyLength(this.a.getId(), this.b);
        }
        return this.h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getIVLength() throws ICCException {
        if (this.i == 0) {
            if (this.b == 0L) {
                throw new ICCException(z[17]);
            }
            this.i = NativeInterface.POLY1305CIPHER_getIVLength(this.a.getId(), this.b);
        }
        return this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, ICCException {
        int n5;
        block38: {
            n5 = 0;
            if (!this.c) {
                throw new IllegalStateException(z[21]);
            }
            if (this.j) {
                this.a(this.d, this.k, this.l);
                this.j = false;
            }
            if (n3 == 0) {
                return n5;
            }
            if (byArray == null || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length) {
                throw new IllegalArgumentException(z[23]);
            }
            if (byArray2 != null && (n4 < 0 || n4 > byArray2.length)) {
                throw new IllegalArgumentException(z[22]);
            }
            int n6 = n3;
            if (!this.d) {
                n6 -= this.m.getByteDelay();
            }
            if (byArray2 != null && byArray2.length != 0 && byArray2.length - n4 < n6) {
                throw new ShortBufferException(z[20] + n6 + z[19]);
            }
            byte[] byArray3 = null;
            if (byArray == byArray2 && (n2 == n4 || n2 < n4 && n4 < (n2 = n3) || n2 > n4 && n2 < n4 + n6)) {
                byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
                byArray = byArray3;
                n2 = 0;
            }
            try {
                if (this.b == 0L) {
                    throw new ICCException(z[18]);
                }
                if (this.d) {
                    n5 = NativeInterface.POLY1305CIPHER_encryptUpdate(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4);
                    break block38;
                }
                if (null != byArray2) {
                    byte[] byArray4 = this.a(byArray, n2, n3);
                    n5 = NativeInterface.POLY1305CIPHER_decryptUpdate(this.a.getId(), this.b, byArray4, 0, byArray4.length, byArray2, n4);
                } else {
                    n5 = NativeInterface.POLY1305CIPHER_decryptUpdate(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4);
                }
            }
            finally {
                if (byArray3 != null && this.d) {
                    Arrays.fill(byArray3, (byte)0);
                }
            }
        }
        this.f += n3 - n5;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, ICCException {
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = null;
        int n5 = 0;
        int n6 = 0;
        if (!this.c) {
            throw new IllegalStateException(z[14]);
        }
        if (this.j) {
            this.a(this.d, this.k, this.l);
            this.j = false;
        }
        if (n3 != 0 && (byArray == null || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length)) {
            throw new IllegalArgumentException(z[7]);
        }
        if (!this.d) {
            byArray = this.b(byArray, n2, n3);
            n2 = 0;
            n3 = byArray.length;
            if (byArray3 == null && (byArray == null || n3 < 16)) {
                throw new IllegalArgumentException(z[9]);
            }
            if (n3 > 16) {
                n5 = n3 - 16;
                byArray4 = new byte[n5];
            }
        }
        if (this.d && (byArray2 == null || n4 < 0 || n4 > byArray2.length)) {
            throw new IllegalArgumentException(z[11]);
        }
        if ((!this.d || this.e.isPadding(0)) && (n3 + this.f) % this.getBlockSize() != 0) {
            throw new IllegalBlockSizeException(z[10]);
        }
        int n7 = this.getOutputSize(n3, this.d, 16);
        if (!this.d) {
            n7 -= 16;
        }
        if (byArray2.length - n4 < n7) {
            throw new ShortBufferException(z[15] + n7 + z[12]);
        }
        byte[] byArray5 = null;
        if (byArray == byArray2 && (n2 == n4 || n2 < n4 && n4 < (n2 = n3) || n2 > n4 && n2 < n4 + n7)) {
            byArray5 = new byte[n3];
            System.arraycopy(byArray, n2, byArray5, 0, n3);
            byArray = byArray5;
            n2 = 0;
        }
        try {
            if (this.b == 0L) {
                throw new ICCException(z[13]);
            }
            if (this.d) {
                n6 = NativeInterface.POLY1305CIPHER_encryptFinal(this.a.getId(), this.b, byArray, n2, n3, byArray2, n4, byArray3);
                System.arraycopy(byArray3, 0, byArray2, n6 + n4, 16);
                n6 += 16;
            } else {
                System.arraycopy(byArray, n3 - 16, byArray3, 0, 16);
                if (byArray4 != null) {
                    System.arraycopy(byArray, 0, byArray4, 0, n5);
                }
                n6 = NativeInterface.POLY1305CIPHER_decryptFinal(this.a.getId(), this.b, byArray4, n2, n5, byArray2, n4, byArray3);
            }
        }
        catch (ICCException iCCException) {
            if (iCCException.getCode() == 3) {
                throw new BadPaddingException(z[8]);
            }
            throw iCCException;
        }
        finally {
            if (byArray5 != null && this.d) {
                Arrays.fill(byArray5, (byte)0);
            }
        }
        this.f = 0;
        this.j = true;
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void finalize() throws Throwable {
        try {
            if (this.b == 0L) return;
            NativeInterface.POLY1305CIPHER_delete(this.a.getId(), this.b);
            this.b = 0L;
            return;
        }
        finally {
            if (this.k != null) {
                Arrays.fill(this.k, (byte)0);
                this.k = null;
            }
            super.finalize();
        }
    }

    protected static boolean a(long l2) {
        boolean bl = l2 != 0L;
        return bl;
    }

    protected byte[] a(byte[] byArray, int n2, int n3) {
        return this.m.write(byArray, n2, n3);
    }

    protected byte[] b(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.m.flush();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + n3);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        if (null != byArray) {
            byteArrayOutputStream.write(byArray, n2, n3);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
        int n3 = 24;
        block33: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                block36: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block36;
                    n5 = n5;
                    if (n5 <= n4) break block37;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 31;
                            break;
                        }
                        case 1: {
                            n6 = 35;
                            break;
                        }
                        case 2: {
                            n6 = 26;
                            break;
                        }
                        case 3: {
                            n6 = 117;
                            break;
                        }
                        default: {
                            n6 = 33;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                case 24: {
                    n = string.intern();
                    string2 = "|Jj\u001dDmm{\u0018D?JiUOjOvZDrSn\f";
                    n3 = -1;
                    continue block33;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "|Lt\u0001DgW:\u001cR?Mo\u0019M";
                    n3 = 0;
                    continue block33;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "oB~\u0011HqD:\u001cR?Mo\u0019M";
                    n3 = 1;
                    continue block33;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "tFcUHl\u0003n\u001dD?Th\u001aOx\u0003i\u001c[z";
                    n3 = 2;
                    continue block33;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "Vu:\u001cR?Wr\u0010\u0001hQu\u001bF?Ps\u000fD";
                    n3 = 3;
                    continue block33;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "tFcUHl\u0003t\u0000Ms\f\u007f\u0018QkZ";
                    n3 = 4;
                    continue block33;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
                    n3 = 5;
                    continue block33;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "VMj\u0000U?Q{\u001bFz\u0003s\u0006\u0001vMl\u0014MvG";
                    n3 = 6;
                    continue block33;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "JM\u007f\rQz@n\u0010E?S{\u0011EvM}";
                    n3 = 7;
                    continue block33;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "RJi\u0006HqD:\u0001@x\u0003u\u001b\u0001{Fy\u0007XoW:\u0013HqBv";
                    n3 = 8;
                    continue block33;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "RFi\u0006@xF:\u0018TlW:\u0017D?B:\u0018TsWs\u0005Mz\u0003u\u0013\u0001kK\u007fUCsLy\u001e\u0001lJ`\u0010\u0001hJn\u001dNjW:\u0005@{Gs\u001bF";
                    n3 = 9;
                    continue block33;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "PVn\u0005Tk\u0003h\u0014OxF:\u001cR?Jt\u0003@sJ~";
                    n3 = 10;
                    continue block33;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "?Ac\u0001Dl\u0003v\u001aOx";
                    n3 = 11;
                    continue block33;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
                    n3 = 12;
                    continue block33;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\\Jj\u001dDm\u0003t\u001aU?Jt\u001cUvBv\u001c[zG";
                    n3 = 13;
                    continue block33;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "PVn\u0005Tk\u0003x\u0000GyFhULjPnUCz\u00032\u0014U?O\u007f\u0014Rk\n:";
                    n3 = 14;
                    continue block33;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
                    n3 = 15;
                    continue block33;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
                    n3 = 16;
                    continue block33;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
                    n3 = 17;
                    continue block33;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "?Ac\u0001Dl\u0003v\u001aOx";
                    n3 = 18;
                    continue block33;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "PVn\u0005Tk\u0003x\u0000GyFhULjPnUCz\u00032\u0014U?O\u007f\u0014Rk\n:";
                    n3 = 19;
                    continue block33;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\\Jj\u001dDm\u0003t\u001aU?Jt\u001cUvBv\u001c[zG";
                    n3 = 20;
                    continue block33;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "PVn\u0005Tk\u0003h\u0014OxF:\u001cR?Jt\u0003@sJ~";
                    n3 = 21;
                    continue block33;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "VMj\u0000U?Q{\u001bFz\u0003s\u0006\u0001vMl\u0014MvG";
                    n3 = 22;
                    continue block33;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\\Jj\u001dDm\u0003S\u0011DqWs\u0013HzQ:\u001cR?Mu\u0001\u0001iBv\u001cE";
                    n3 = 23;
                    continue block33;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

