/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamElementInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;

public class StreamElementEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        StreamElementInstruction streamElementInstruction = (StreamElementInstruction)instruction;
        partialInformationCollector.partiallyEvaluate(streamElementInstruction.getOperand1(), letChainManager);
        partialInformationCollector.partiallyEvaluate(streamElementInstruction.getOperand2(), letChainManager);
        Instruction instruction2 = letChainManager.lookupBinding(streamElementInstruction.getOperand1());
        Instruction instruction3 = letChainManager.lookupBinding(streamElementInstruction.getOperand2());
        if (!(instruction3 instanceof LiteralInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (!(instruction2 instanceof StreamInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        StreamInstruction streamInstruction = (StreamInstruction)instruction2;
        int n = (Integer)((LiteralInstruction)instruction3).getValue();
        Type type = streamInstruction.getType(partialInformationCollector.getCurrentTypeEnvironment(), partialInformationCollector.getCurrentBindingEnvironment());
        if (streamInstruction.isString()) {
            String string = streamInstruction.getStringContent();
            if (string.length() <= n) {
                throw new ArrayIndexOutOfBoundsException("index=" + n + " str='" + string + "'");
            }
            return new PartialEvaluationResult(LiteralInstruction.charLiteral(string.charAt(n)));
        }
        for (int i = 0; i <= n; ++i) {
            Instruction instruction4 = streamInstruction.getElements()[i];
            Type type2 = instruction4.getType(partialInformationCollector.getCurrentTypeEnvironment(), partialInformationCollector.getCurrentBindingEnvironment());
            if (type.equals(type2, partialInformationCollector.getCurrentTypeEnvironment())) {
                return PartialEvaluationResult.s_emptyResult;
            }
            if (type2.getStreamType().equals(type)) continue;
            return PartialEvaluationResult.s_emptyResult;
        }
        Instruction instruction5 = streamInstruction.getElements()[n];
        return new PartialEvaluationResult(instruction5);
    }
}

