/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.builders;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import java.util.HashMap;
import java.util.LinkedList;

public class LetChainBuilder {
    protected LetInstruction m_outer = null;
    protected LetInstruction m_inner = null;

    public Instruction bind(Instruction instruction) {
        return this.bind(ReductionHelper.generateIntermediateIdentifier2(), instruction, false);
    }

    public Instruction bind(Instruction instruction, boolean bl) {
        return this.bind(ReductionHelper.generateIntermediateIdentifier2(), instruction, bl);
    }

    public Instruction bind(Object object, Instruction instruction) {
        return this.bind(object, instruction, false);
    }

    public Instruction bind(Object object, Instruction instruction, boolean bl) {
        if (object instanceof Instruction || instruction == null) {
            throw new IllegalArgumentException();
        }
        if (!bl && (instruction instanceof IdentifierInstruction || instruction instanceof LiteralInstruction)) {
            return instruction;
        }
        LetInstruction letInstruction = new LetInstruction(object, instruction, null);
        if (this.m_outer == null) {
            this.m_inner = this.m_outer = letInstruction;
        } else {
            this.m_inner.setBody(letInstruction);
            this.m_inner = letInstruction;
        }
        return new IdentifierInstruction(object);
    }

    public Instruction packageUp(Instruction instruction) {
        if (this.m_outer == null) {
            return instruction;
        }
        this.m_inner.setBody(instruction);
        return this.m_outer;
    }

    public static Instruction inlinebody(Instruction[] instructionArray, IBinding[] iBindingArray, Instruction instruction) {
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        Instruction instruction2 = letChainBuilder.bindAndRenameBody(instructionArray, iBindingArray, instruction, new BindingEnvironment());
        return letChainBuilder.packageUp(instruction2);
    }

    public Instruction bindAndRenameBody(Instruction[] instructionArray, IBinding[] iBindingArray, Instruction instruction, BindingEnvironment bindingEnvironment) {
        if (instructionArray.length != iBindingArray.length) {
            throw new RuntimeException();
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < instructionArray.length; ++i) {
            Instruction instruction2;
            Instruction instruction3 = instructionArray[i];
            if (instruction3 == null) continue;
            if (instruction3 instanceof IdentifierInstruction) {
                instruction2 = (IdentifierInstruction)instruction3;
            } else if (instruction3 instanceof LiteralInstruction) {
                instruction2 = this.bind(instruction3, true);
                if (bindingEnvironment != null) {
                    bindingEnvironment.setVariableBinding(this.m_inner);
                }
            } else {
                throw new IllegalArgumentException();
            }
            hashMap.put(iBindingArray[i].getName(), ((IdentifierInstruction)instruction2).getVariable());
        }
        return this.rebindLetsInternal(instruction, hashMap, bindingEnvironment);
    }

    public Instruction rebindLets(Instruction instruction, BindingEnvironment bindingEnvironment) {
        return this.rebindLetsInternal(instruction, new HashMap(), bindingEnvironment);
    }

    private Instruction rebindLetsInternal(Instruction instruction, HashMap hashMap, BindingEnvironment bindingEnvironment) {
        Instruction instruction22;
        INewNameGenerator iNewNameGenerator = new INewNameGenerator(){

            @Override
            public Object getNewName() {
                return ReductionHelper.generateIntermediateIdentifier2();
            }
        };
        LinkedList linkedList = new LinkedList();
        Instruction instruction3 = OptimizerUtilities.skipLets(instruction, linkedList);
        for (Instruction instruction22 : linkedList) {
            Object object = instruction22.getVariable();
            Instruction instruction4 = instruction22.getValue().assignNewNames(hashMap, iNewNameGenerator);
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)this.bind(instruction4, true);
            if (bindingEnvironment != null) {
                bindingEnvironment.setVariableBinding(this.m_inner);
            }
            hashMap.put(object, identifierInstruction);
        }
        instruction3 = instruction3.assignNewNames(hashMap, iNewNameGenerator);
        instruction22 = this.bind(instruction3);
        if (bindingEnvironment != null && this.m_inner != null) {
            bindingEnvironment.setVariableBinding(this.m_inner);
        }
        return instruction22;
    }
}

