/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.ast.res.ASTMsg;
import org.xml.sax.Attributes;

public final class Number
extends Expr {
    public static final int LEVEL_SINGLE = 0;
    public static final int LEVEL_MULTIPLE = 1;
    public static final int LEVEL_ANY = 2;
    private Expr _from = null;
    private Expr _count = null;
    private Expr _value = null;
    private Expr _select = null;
    private Expr _lang = null;
    private Expr _format = null;
    private Expr _letterValue = null;
    private Expr _groupingSeparator = null;
    private Expr _groupingSize = null;
    private Expr _ordinal = null;
    private int _level = 0;
    private boolean _formatNeeded = false;

    public Number() {
        super(206);
    }

    public Number(int n) {
        super(n);
    }

    public boolean isFormatNeeded() {
        return this._formatNeeded;
    }

    public Expr getCount() {
        return this._count;
    }

    public Expr getFrom() {
        return this._from;
    }

    public Expr getSelect() {
        return this._select;
    }

    public Expr getFormat() {
        return this._format;
    }

    public Expr getLang() {
        return this._lang;
    }

    public Expr getLetterValue() {
        return this._letterValue;
    }

    public Expr getGroupingSeparator() {
        return this._groupingSeparator;
    }

    public Expr getGroupingSize() {
        return this._groupingSize;
    }

    public Expr getOrdinal() {
        return this._ordinal;
    }

    @Override
    public void parseContents(XSLTParser xSLTParser) {
        Attributes attributes = this.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = attributes.getQName(i);
            String string3 = attributes.getValue(i);
            if (string2.equals("value")) {
                this._value = xSLTParser.parseExpression(this, string2, null);
                continue;
            }
            if (string2.equals("select")) {
                this._select = xSLTParser.parseExpression(this, string2, null);
                continue;
            }
            if (string2.equals("count")) {
                this._count = xSLTParser.parsePattern(this, string2, null);
                continue;
            }
            if (string2.equals("from")) {
                this._from = xSLTParser.parsePattern(this, string2, null);
                continue;
            }
            if (string2.equals("level")) {
                if (string3.equals("single")) {
                    this._level = 0;
                    continue;
                }
                if (string3.equals("multiple")) {
                    this._level = 1;
                    continue;
                }
                if (string3.equals("any")) {
                    this._level = 2;
                    continue;
                }
                xSLTParser.reportError(3, new ASTMsg("ELEMENT_CONTENT_ERR"));
                continue;
            }
            if (string2.equals("format")) {
                this._format = Number.parseAVTAttrContent(xSLTParser, string3, this);
                this._formatNeeded = true;
                continue;
            }
            if (string2.equals("lang")) {
                this._lang = Number.parseAVTAttrContent(xSLTParser, string3, this);
                this._formatNeeded = true;
                continue;
            }
            if (string2.equals("letter-value")) {
                this._letterValue = Number.parseAVTAttrContent(xSLTParser, string3, this);
                if (this._letterValue.getId() == 228 && !(string = ((Text)this._letterValue).getText().toString()).equals("alphabetic") && !string.equals("traditional")) {
                    xSLTParser.reportError(3, new ASTMsg("ELEMENT_CONTENT_ERR"));
                }
                this._formatNeeded = true;
                continue;
            }
            if (string2.equals("grouping-separator")) {
                xSLTParser.checkAttributeLength(this, string2, string3);
                this._groupingSeparator = Number.parseAVTAttrContent(xSLTParser, string3, this);
                if (this._groupingSeparator.getId() == 228 && (string = ((Text)this._groupingSeparator).getText().toString()) != null && string.length() > 1) {
                    xSLTParser.reportError(4, new ASTMsg("ELEMENT_CONTENT_ERR"));
                }
                this._formatNeeded = true;
                continue;
            }
            if (string2.equals("grouping-size")) {
                this._groupingSize = Number.parseAVTAttrContent(xSLTParser, string3, this);
                this._formatNeeded = true;
                continue;
            }
            if (!string2.equals("ordinal")) continue;
            this._ordinal = Number.parseAVTAttrContent(xSLTParser, string3, this);
            this._formatNeeded = true;
        }
    }

    public boolean hasValue() {
        return this._value != null;
    }

    public boolean hasSelect() {
        return this._select != null;
    }

    public Expr getValueExpr() {
        return this._value;
    }

    public void setValue(Expr expr) {
        this._value = expr;
    }

    public int getLevel() {
        return this._level;
    }

    public boolean isDefault() {
        return this._from == null && this._count == null;
    }
}

