/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import java.lang.ref.SoftReference;

public class Pool {
    private static final int MAXIMUM_SIZE = 10;
    private final ReferencePool refPool;
    private final Poolable[] array = new Poolable[10];
    private int size = 0;

    public Pool() {
        this.refPool = new ReferencePool();
    }

    public synchronized Poolable get() {
        if (this.size == 0) {
            return this.refPool.get();
        }
        return this.array[--this.size];
    }

    public void assignToPool(Poolable poolable) {
        PoolableHelper poolableHelper = poolable.getPoolableHelper();
        poolableHelper.setPool(this);
    }

    private synchronized void put(Poolable poolable) {
        if (this.size == 10) {
            this.refPool.put(poolable);
        } else {
            this.array[this.size++] = poolable;
        }
    }

    public static interface Poolable {
        public PoolableHelper getPoolableHelper();
    }

    public static class PoolableHelper {
        private Pool fPool;
        private Poolable fPooledObj;

        public PoolableHelper(Poolable poolable) {
            this.fPooledObj = poolable;
        }

        public void returnToPool() {
            this.fPool.put(this.fPooledObj);
        }

        public void setPool(Pool pool) {
            this.fPool = pool;
        }
    }

    private static class ReferencePool {
        private SoftReference[] array = new SoftReference[8];
        private int size = 0;

        private ReferencePool() {
        }

        private Poolable get() {
            while (this.size > 0) {
                --this.size;
                Poolable poolable = (Poolable)this.array[this.size].get();
                this.array[this.size] = null;
                if (poolable != null) {
                    return poolable;
                }
                this.removeDeadReferences();
            }
            return null;
        }

        private void put(Poolable poolable) {
            if (this.size == this.array.length) {
                SoftReference[] softReferenceArray = new SoftReference[this.size * 2];
                System.arraycopy(this.array, 0, softReferenceArray, 0, this.size);
                this.array = softReferenceArray;
            }
            this.array[this.size++] = new SoftReference<Poolable>(poolable);
        }

        private void removeDeadReferences() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                while (n2 < this.size && this.array[n2].get() == null) {
                    this.array[n2] = null;
                    ++n2;
                }
                while (n2 < this.size && this.array[n2].get() != null) {
                    this.array[n++] = this.array[n2];
                    this.array[n2] = null;
                    ++n2;
                }
            }
            this.size = n;
        }
    }
}

