/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.stax.serializer.Encoding;
import com.ibm.xml.xlxp.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.api.stax.serializer.Windows125XEncoding;
import com.ibm.xml.xlxp.api.util.Pool;
import java.io.IOException;
import java.io.OutputStream;

public final class Windows125XWriter
extends StAXWriter {
    private static final Pool fPool = new Pool();
    private int[] fEncodableCharacters;
    private int[] fEncodedCharacters;

    public static final Windows125XWriter getInstance() {
        Windows125XWriter windows125XWriter = (Windows125XWriter)fPool.get();
        if (windows125XWriter == null) {
            windows125XWriter = new Windows125XWriter();
            fPool.assignToPool(windows125XWriter);
        }
        return windows125XWriter;
    }

    public void reset(int n, OutputStream outputStream) {
        super.reset(outputStream);
        switch (n) {
            case 57: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1250_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1250_ENCODED_CHARACTERS;
                break;
            }
            case 58: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1251_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1251_ENCODED_CHARACTERS;
                break;
            }
            case 59: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1252_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1252_ENCODED_CHARACTERS;
                break;
            }
            case 60: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1253_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1253_ENCODED_CHARACTERS;
                break;
            }
            case 61: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1254_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1254_ENCODED_CHARACTERS;
                break;
            }
            case 62: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1255_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1255_ENCODED_CHARACTERS;
                break;
            }
            case 63: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1256_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1256_ENCODED_CHARACTERS;
                break;
            }
            case 64: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1257_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1257_ENCODED_CHARACTERS;
                break;
            }
            case 65: {
                this.fEncodableCharacters = Windows125XEncoding.WINDOWS1258_ENCODABLE_CHARACTERS;
                this.fEncodedCharacters = Windows125XEncoding.WINDOWS1258_ENCODED_CHARACTERS;
            }
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.flushInternal();
            int n3 = n + n2;
            while (n + this.fBuffer.length < n3) {
                this.encodeAndWrite(cArray, n, this.fBuffer.length);
                n += this.fBuffer.length;
                this.flushInternal();
            }
            this.encodeAndWrite(cArray, n, n3 - n);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        this.fBuffer[this.fNumBytes++] = (byte)n;
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (cArray[i] <= '\u007f') {
                this.fBuffer[this.fNumBytes++] = (byte)cArray[i];
                continue;
            }
            int n4 = Encoding.find(cArray[i], this.fEncodableCharacters);
            this.fBuffer[this.fNumBytes++] = (byte)this.fEncodedCharacters[n4];
        }
    }
}

