/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final Entry<?, ?>[] EMPTY_TABLE = new Entry[0];
    private transient Entry<?, ?>[] table = EMPTY_TABLE;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Collection<V> values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    public Hashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = n;
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        super.inflateTable(this.threshold);
        this.putAll(map);
    }

    private void inflateTable(int n) {
        int n2 = n;
        if (n2 == 0) {
            n2 = 1;
        }
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 2.1474836E9f);
        this.table = new Entry[n2];
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getEnumeration(0);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<Object, Object> entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return false;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return null;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry<?, ?>[] entryArray = this.table;
        int n2 = (n << 1) + 1;
        if (n2 - 0x7FFFFFF7 > 0) {
            if (n == 0x7FFFFFF7) {
                return;
            }
            n2 = 0x7FFFFFF7;
        }
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)Math.min((float)n2 * this.loadFactor, 2.1474836E9f);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry<Object, Object> entry = entryArray[n3];
            while (entry != null) {
                Entry<?, ?> entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    private void addEntry(int n, K k, V v, int n2) {
        ++this.modCount;
        Entry<?, ?>[] entryArray = this.table;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n = k.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        Entry<?, ?> entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
    }

    @Override
    public synchronized V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        this.addEntry(n, k, v, n2);
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return null;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object v = entry.value;
                entry.value = null;
                return v;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        Entry<?, ?>[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            if (this.table != EMPTY_TABLE) {
                hashtable.inflateTable(this.table.length);
            }
            int n = this.table.length;
            while (n-- > 0) {
                hashtable.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            hashtable.keySet = null;
            hashtable.entrySet = null;
            hashtable.values = null;
            hashtable.modCount = 0;
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        if (n == -1) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        stringBuilder.append('{');
        int n2 = 0;
        while (true) {
            Map.Entry<K, V> entry = iterator.next();
            K k = entry.getKey();
            V v = entry.getValue();
            stringBuilder.append(k == this ? "(this Map)" : k.toString());
            stringBuilder.append('=');
            stringBuilder.append(v == this ? "(this Map)" : v.toString());
            if (n2 == n) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    private <T> Enumeration<T> getEnumeration(int n) {
        if (this.count == 0) {
            return Collections.emptyEnumeration();
        }
        return new Enumerator(n, false);
    }

    private <T> Iterator<T> getIterator(int n) {
        if (this.count == 0) {
            return Collections.emptyIterator();
        }
        return new Enumerator(n, true);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(), this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(), this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        Entry<?, ?>[] entryArray;
        int n = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return n;
        }
        this.loadFactor = -this.loadFactor;
        for (Entry<Object, Object> entry : entryArray = this.table) {
            while (entry != null) {
                n += entry.hashCode();
                entry = entry.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return n;
    }

    @Override
    public synchronized V getOrDefault(Object object, V v) {
        V v2 = this.get(object);
        return null == v2 ? v : v2;
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Entry<?, ?>[] entryArray;
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        for (Entry<Object, Object> entry : entryArray = this.table) {
            while (entry != null) {
                biConsumer.accept(entry.key, entry.value);
                entry = entry.next;
                if (n == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Entry<?, ?>[] entryArray;
        Objects.requireNonNull(biFunction);
        if (this.count == 0) {
            return;
        }
        int n = this.modCount;
        for (Entry<Object, Object> entry : entryArray = this.table) {
            while (entry != null) {
                entry.value = Objects.requireNonNull(biFunction.apply(entry.key, entry.value));
                entry = entry.next;
                if (n == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        Objects.requireNonNull(v);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                Object v2 = entry.value;
                if (v2 == null) {
                    entry.value = v;
                }
                return v2;
            }
            entry = entry.next;
        }
        this.addEntry(n, k, v, n2);
        return null;
    }

    @Override
    public synchronized boolean remove(Object object, Object object2) {
        Objects.requireNonNull(object2);
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return false;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object) && entry.value.equals(object2)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                entry.value = null;
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K k, V v, V v2) {
        Objects.requireNonNull(v);
        Objects.requireNonNull(v2);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return false;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                if (entry.value.equals(v)) {
                    entry.value = v2;
                    return true;
                }
                return false;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        Objects.requireNonNull(v);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return null;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        Objects.requireNonNull(function);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                return entry.value;
            }
            entry = entry.next;
        }
        V v = function.apply(k);
        if (v != null) {
            this.addEntry(n, k, v, n2);
        }
        return v;
    }

    @Override
    public synchronized V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.count == 0) {
            return null;
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                V v = biFunction.apply(k, entry.value);
                if (v == null) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                } else {
                    entry.value = v;
                }
                return v;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && Objects.equals(entry.key, k)) {
                V v = biFunction.apply(k, entry.value);
                if (v == null) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                } else {
                    entry.value = v;
                }
                return v;
            }
            entry2 = entry;
            entry = entry.next;
        }
        entry2 = (Entry<?, ?>)biFunction.apply(k, null);
        if (entry2 != null) {
            this.addEntry(n, k, entry2, n2);
        }
        return (V)entry2;
    }

    @Override
    public synchronized V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        if (k == null) {
            throw new NullPointerException();
        }
        if (this.table == EMPTY_TABLE) {
            this.inflateTable(this.threshold);
        }
        Entry<?, ?>[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        Entry<?, ?> entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                V v2 = biFunction.apply(entry.value, v);
                if (v2 == null) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                } else {
                    entry.value = v2;
                }
                return v2;
            }
            entry2 = entry;
            entry = entry.next;
        }
        if (v != null) {
            this.addEntry(n, k, v, n2);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Entry entry = null;
        Hashtable hashtable = this;
        synchronized (hashtable) {
            objectOutputStream.defaultWriteObject();
            if (this.table == EMPTY_TABLE) {
                objectOutputStream.writeInt(this.threshold);
            } else {
                objectOutputStream.writeInt(this.table.length);
            }
            objectOutputStream.writeInt(this.count);
            for (int i = 0; i < this.table.length; ++i) {
                Entry<Object, Object> entry2 = this.table[i];
                while (entry2 != null) {
                    entry = new Entry(0, entry2.key, entry2.value, entry);
                    entry2 = entry2.next;
                }
            }
        }
        while (entry != null) {
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.table = EMPTY_TABLE;
        float f = getField.get("loadFactor", 0.75f);
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new StreamCorruptedException("Illegal load factor: " + f);
        }
        f = Math.min(Math.max(0.25f, f), 4.0f);
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        if (n2 < 0) {
            throw new StreamCorruptedException("Illegal # of Elements: " + n2);
        }
        n = Math.max(n, (int)((float)n2 / f) + 1);
        int n3 = (int)((float)(n2 + n2 / 20) / f) + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if ((n3 = Math.min(n3, n)) < 0) {
            n3 = n;
        }
        SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Map.Entry[].class, n3);
        UnsafeHolder.putLoadFactor(this, f);
        if (n2 > 0) {
            this.threshold = (int)Math.min((float)n3 * f, 2.1474836E9f);
            this.table = new Entry[n3];
        } else {
            this.threshold = n3;
            this.table = EMPTY_TABLE;
        }
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.reconstitutionPut(this.table, object, object2);
            --n2;
        }
    }

    private void reconstitutionPut(Entry<?, ?>[] entryArray, K k, V v) throws StreamCorruptedException {
        if (v == null) {
            throw new StreamCorruptedException();
        }
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object, Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                throw new StreamCorruptedException();
            }
            entry = entry.next;
        }
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int n, K k, V v, Entry<K, V> entry) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Hashtable.this.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return super.add(entry);
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Entry[] entryArray = Hashtable.this.table;
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    return true;
                }
                entry2 = entry2.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Entry[] entryArray = Hashtable.this.table;
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n2];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2.hash == n && entry2.equals(entry)) {
                    Hashtable.this.modCount++;
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n2] = entry2.next;
                    }
                    Hashtable.this.count--;
                    entry2.value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        Entry<?, ?>[] table;
        int index;
        Entry<?, ?> entry;
        Entry<?, ?> lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int n, boolean bl) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = n;
            this.iterator = bl;
        }

        @Override
        public boolean hasMoreElements() {
            Entry<?, ?> entry = this.entry;
            int n = this.index;
            Entry<?, ?>[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        @Override
        public T nextElement() {
            Entry<?, ?> entry = this.entry;
            int n = this.index;
            Entry<?, ?>[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                this.lastReturned = this.entry;
                Entry<?, ?> entry2 = this.lastReturned;
                this.entry = entry2.next;
                return (T)(this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry[] entryArray = Hashtable.this.table;
                int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        Hashtable.this.modCount++;
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        Hashtable.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object object) {
            return Hashtable.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return Hashtable.this.remove(object) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private static final class UnsafeHolder {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private static final long LF_OFFSET = UnsafeHolder.getLoadFactorOffset();

        private UnsafeHolder() {
            throw new InternalError();
        }

        static void putLoadFactor(Hashtable<?, ?> hashtable, float f) {
            unsafe.putFloat(hashtable, LF_OFFSET, f);
        }

        static long getLoadFactorOffset() {
            try {
                return unsafe.objectFieldOffset(Hashtable.class.getDeclaredField("loadFactor"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InternalError(noSuchFieldException);
            }
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object object) {
            return Hashtable.this.containsValue(object);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }
}

