/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.TreeSet;

@DTFJPlugin(version=".*", runtime=false, image=false)
public class HelpCommand
extends BaseJdmpviewCommand {
    private static final String CMD_NAME = "help";

    public HelpCommand() {
        this.addCommand(CMD_NAME, "[command name]", "displays list of commands or help for a specific command");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length == 0) {
            this.printHelpSummary();
        } else {
            StringBuilder cmdline = new StringBuilder();
            if (args[0].equalsIgnoreCase("context")) {
                out.println("switches to another context when more than one context is available. For z/OS the ASID can be specified with the 'asid' flag e.g. context asid <ID>. Execute 'context' to see the list of currently available contexts");
            } else {
                for (String arg : args) {
                    cmdline.append(arg);
                    cmdline.append(" ");
                }
                if (!this.ctx.isCommandRecognised(cmdline.toString().trim())) {
                    out.println("Unrecognised command: " + cmdline.toString().trim());
                } else {
                    cmdline.append(" ?");
                    this.ctx.execute(cmdline.toString().trim(), out);
                }
            }
        }
    }

    private void printHelpSummary() {
        TreeSet<String> helpTable = new TreeSet<String>();
        String contextHelp = String.format("%-25s %-20s %s\n", "context", "[ID|asid ID]", "switch to the selected context");
        helpTable.add(contextHelp);
        for (ICommand thisCommand : this.ctx.getCommands()) {
            for (String thisEntry : thisCommand.getCommandDescriptions()) {
                if (!thisEntry.endsWith("\n")) {
                    thisEntry = thisEntry + "\n";
                }
                helpTable.add(thisEntry);
            }
        }
        for (String entry : helpTable) {
            this.out.print(entry);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("displays list of commands or help for a specific command \n\nparameters: none, <command_name>\n\nWith no parameters, \"help\" displays the complete list of commands currently supported.  When a <command_name> is specified, \"help\" will list that command's sub-commands if it has sub-commands; otherwise, the command's complete description will be displayed.\n\nTo view help on a command's sub-command, specify both the command name and the sub-command name.  For example, \"help info thread\" will display \"info thread\"'s description.");
    }
}

