/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sequence.bytes;

import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$ArrayByteSequence$1;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$ByteSubSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory$CompositeByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

final class ByteSequenceFactory$ArrayByteSequence
implements ByteSequence {
    private static final long serialVersionUID = 2L;
    private final byte[] bytes;
    private int hc;
    private boolean hcCalculated;
    private String ts;

    ByteSequenceFactory$ArrayByteSequence(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.bytes.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.bytes[n];
    }

    public int length() {
        return this.bytes.length;
    }

    public ByteSequence append(ByteSequence byteSequence) throws NullPointerException {
        if (byteSequence == null) {
            throw new NullPointerException();
        }
        if (this.bytes.length == 0) {
            return byteSequence;
        }
        if (byteSequence.length() == 0) {
            return this;
        }
        return new ByteSequenceFactory$CompositeByteSequence(this, byteSequence);
    }

    public ByteSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > this.bytes.length || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteSequenceFactory$ByteSubSequence(this, n, n2);
    }

    public int indexOf(byte by) {
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] != by) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.bytes.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator(n);
        while (byteSequenceIterator.hasNextByte()) {
            int n2 = byteSequenceIterator.getPosition();
            byte by2 = byteSequenceIterator.getNextByte();
            if (by2 != by) continue;
            return n2;
        }
        return -1;
    }

    public int lastIndexOf(byte by) {
        for (int i = this.bytes.length - 1; i >= 0; --i) {
            if (this.bytes[i] != by) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.bytes.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator(n);
        while (byteSequenceIterator.hasPreviousByte()) {
            byte by2 = byteSequenceIterator.getPreviousByte();
            int n2 = byteSequenceIterator.getPosition();
            if (by2 != by) continue;
            return n2;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public ByteSequenceIterator getIterator() {
        return this.getIterator(0);
    }

    public ByteSequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.bytes.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return new ByteSequenceFactory$ArrayByteSequence$1(this, n);
    }

    public String toBinaryString() {
        StringBuilder stringBuilder = new StringBuilder();
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            int n = byteSequenceIterator.getNextByte();
            if (n < 0) {
                n += 256;
            }
            String string = Integer.toBinaryString(n);
            for (int i = 0; i < 8 - string.length(); ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toOctalString() {
        StringBuilder stringBuilder = new StringBuilder();
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            int n = byteSequenceIterator.getNextByte();
            if (n < 0) {
                n += 256;
            }
            String string = Integer.toOctalString(n);
            for (int i = 0; i < 3 - string.length(); ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toHexString() {
        StringBuilder stringBuilder = new StringBuilder();
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        while (byteSequenceIterator.hasNextByte()) {
            int n = byteSequenceIterator.getNextByte();
            if (n < 0) {
                n += 256;
            }
            String string = Integer.toHexString(n);
            for (int i = 0; i < 2 - string.length(); ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.ts == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            for (byte by : this.bytes) {
                stringBuilder.append(by);
                if (n++ == this.bytes.length - 1) continue;
                stringBuilder.append("][");
            }
            stringBuilder.append("]");
            this.ts = stringBuilder.toString();
        }
        return this.ts;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ByteSequence)) {
            return false;
        }
        ByteSequence byteSequence = (ByteSequence)object;
        if (byteSequence.length() != this.bytes.length) {
            return false;
        }
        ByteSequenceIterator byteSequenceIterator = this.getIterator();
        ByteSequenceIterator byteSequenceIterator2 = byteSequence.getIterator();
        while (byteSequenceIterator.hasNextByte() && byteSequenceIterator2.hasNextByte()) {
            Byte by;
            Byte by2 = byteSequenceIterator.getNextByte();
            if (by2 == (by = Byte.valueOf(byteSequenceIterator2.getNextByte()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hcCalculated) {
            int n = 461;
            int n2 = 73;
            ByteSequenceIterator byteSequenceIterator = this.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                byte by = byteSequenceIterator.getNextByte();
                n2 = n2 * 461 + by;
            }
            this.hc = n2;
            this.hcCalculated = true;
        }
        return this.hc;
    }

    static byte[] access$000(ByteSequenceFactory$ArrayByteSequence byteSequenceFactory$ArrayByteSequence) {
        return byteSequenceFactory$ArrayByteSequence.bytes;
    }
}

