/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import openj9.internal.tools.attach.target.IPC;

public final class AttachmentConnection {
    private static final String STREAM_ENCODING = "UTF8";

    static byte[] streamReceiveBytes(InputStream channel, int dataLimit, boolean requireNull) throws IOException {
        boolean unlimited;
        int bufferLen = 100;
        byte[] msgBuff = new byte[100];
        ByteArrayOutputStream msg = new ByteArrayOutputStream(100);
        boolean bl = unlimited = 0 == dataLimit;
        if (null == channel) {
            throw new IOException(Msg.getString("K0575"));
        }
        boolean done = false;
        while (!done && (unlimited || dataLimit > msg.size())) {
            int nRead = channel.read(msgBuff, 0, 100);
            if (nRead > 0) {
                if (msgBuff[nRead - 1] == 0) {
                    done = true;
                    --nRead;
                }
                msg.write(msgBuff, 0, nRead);
                continue;
            }
            if (requireNull) {
                throw new IOException(Msg.getString("K0571"));
            }
            done = true;
        }
        if (!done && msg.size() > dataLimit) {
            throw new IOException(Msg.getString("K0572", dataLimit));
        }
        return msg.toByteArray();
    }

    static byte[] streamReceiveBytes(InputStream channel, boolean requireNull) throws IOException {
        return AttachmentConnection.streamReceiveBytes(channel, 0, requireNull);
    }

    public static void streamSend(OutputStream channel, String data) throws IOException {
        IPC.logMessage("streamSend " + data);
        if (null == channel) {
            throw new IOException();
        }
        channel.write(data.getBytes(STREAM_ENCODING));
        channel.write(0);
        channel.flush();
    }

    public static String streamReceiveString(InputStream channel, int dataLimit) throws IOException {
        byte[] msgBuff = AttachmentConnection.streamReceiveBytes(channel, dataLimit, true);
        String message = AttachmentConnection.bytesToString(msgBuff);
        return message;
    }

    public static String streamReceiveString(InputStream channel) throws IOException {
        return AttachmentConnection.streamReceiveString(channel, 0);
    }

    static String bytesToString(byte[] msgBuff) throws UnsupportedEncodingException {
        String message = new String(msgBuff, STREAM_ENCODING);
        return message;
    }
}

