/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.CipherMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class GeneralPKCS11Cipher
extends CipherSpi {
    private byte[] iv = null;
    private PKCS11Cipher cipher = null;
    private CipherMechanismBuilder mechanismBuilder;
    private PKCS11Key hw_key_to_delete = null;
    private SessionManager sessionManager = null;
    private Session session;
    private Provider provider = null;
    private Config config = null;
    private AlgorithmParameters gcmParameters = null;
    private static final int GCM_DEFAULT_TAG_LENGTH = 128;
    private static HashMap<String, Integer> BLOCK_SIZES = new HashMap();
    private int opmode;
    private Key key;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");
    private static Debug debugKeyCleanup = Debug.getInstance((String)"keycleanup");
    private boolean wasThisCipherEverInitialized = false;

    public GeneralPKCS11Cipher(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.mechanismBuilder = MechanismBuilderImpl.createCipherMechanismBuilder(algorithm);
    }

    protected GeneralPKCS11Cipher(Provider provider, String algorithm, String mode, String padding) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.mechanismBuilder = MechanismBuilderImpl.createCipherMechanismBuilder(algorithm, mode, padding);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.mechanismBuilder.setMode(mode);
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        this.mechanismBuilder.setPadding(paddingScheme);
    }

    @Override
    protected int engineGetBlockSize() {
        Integer size = BLOCK_SIZES.get(this.mechanismBuilder.getAlgorithm());
        if (size == null) {
            return 0;
        }
        return size;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (this.mechanismBuilder.isPadding()) {
            Integer size = BLOCK_SIZES.get(this.mechanismBuilder.getAlgorithm());
            int s = 0;
            if (size != null) {
                s = size;
            }
            int rem = inputLen % s;
            int ret = inputLen - rem;
            ret = rem != 0 ? (ret += s) : inputLen + s;
            return ret;
        }
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            inputLen = this.opmode == 1 ? (inputLen += this.cipher.getGCMTagBits() / 8) : (inputLen -= this.cipher.getGCMTagBits() / 8);
            return inputLen;
        }
        return inputLen;
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            if (this.cipher == null) {
                return null;
            }
            byte[] gcmIv = this.cipher.getGCMIV();
            return (byte[])gcmIv.clone();
        }
        return this.iv;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            return this.gcmParameters;
        }
        AlgorithmParameters params = null;
        if (this.iv == null) {
            return null;
        }
        try {
            params = AlgorithmParameters.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (Exception nspe) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            params.init(new IvParameterSpec(this.iv));
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("IvParameterSpec not supported");
        }
        return params;
    }

    private PKCS11SecretKey translateToPKCS11SecretKey(Key key) throws InvalidKeyException {
        PKCS11SecretKey tokenKey = null;
        if (key == null) {
            this.cancelOperation();
            throw new InvalidKeyException("No key given");
        }
        if (key instanceof PKCS11SecretKey) {
            tokenKey = (PKCS11SecretKey)key;
        } else if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase(this.mechanismBuilder.getAlgorithm()) && "RAW".equalsIgnoreCase(key.getFormat())) {
            try {
                SecretKeyFactory kf = SecretKeyFactory.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
                tokenKey = (PKCS11SecretKey)kf.translateKey((SecretKey)key);
                this.hw_key_to_delete = tokenKey;
            }
            catch (Exception e) {
                this.cancelOperation();
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
            }
        } else {
            this.cancelOperation();
            throw new InvalidKeyException("Key given is not the correct key.");
        }
        return tokenKey;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#1: METHOD ENTRY");
            if (opmode == 1) {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#1: The opmode = Cipher.ENCRYPT_MODE");
            } else {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#1: The opmode = Cipher.DECRYPT_MODE");
            }
            if (key == null) {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#1: The key is NULL");
            } else {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#1: The key is a:  " + key.getClass().getName());
            }
            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#1: THE CALLER IS:");
            RuntimeException rtex1 = new RuntimeException();
            rtex1.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineInit-3");
        }
        if (!this.mechanismBuilder.isCompatibleOperationMode(opmode, null)) {
            throw new InvalidKeyException("Parameters missing. IV required.");
        }
        PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(key);
        if (this.mechanismBuilder.isIVRequired()) {
            this.iv = new byte[this.engineGetBlockSize()];
            SecureRandom rnd = random == null ? new SecureRandom() : random;
            rnd.nextBytes(this.iv);
        }
        PKCS11Cipher cp = null;
        cp = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            if (opmode == 2) {
                throw new IllegalStateException("During decryption, cipher requires algorithm parameters or algorithm parameter specification.");
            }
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this.iv);
            try {
                this.gcmParameters = AlgorithmParameters.getInstance("AESGCM");
                this.gcmParameters.init(gcmSpec);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException(nsae.getMessage());
            }
            catch (InvalidParameterSpecException ipse) {
                throw new RuntimeException(ipse.getMessage());
            }
            try {
                cp.engineInitGCM(opmode, tokenKey.getObject(), gcmSpec);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new RuntimeException(iape.getMessage());
            }
        }
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        } else {
            this.cancelOperation();
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            }
        }
        try {
            cp.engineInit(this.session, opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
        }
        catch (InvalidKeyException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        this.opmode = opmode;
        this.iv = this.iv;
        this.key = key;
        this.wasThisCipherEverInitialized = true;
        this.cipher = cp;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineInit-3");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PKCS11SecretKey tokenKey;
        block37: {
            block35: {
                SecureRandom rnd;
                block36: {
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("=======================================================================");
                        System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2: METHOD ENTRY");
                        if (opmode == 1) {
                            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2: The opmode = Cipher.ENCRYPT_MODE");
                        } else {
                            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2: The opmode = Cipher.DECRYPT_MODE");
                        }
                        if (key == null) {
                            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2: The key is NULL");
                        } else {
                            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2: The key is a:  " + key.getClass().getName());
                        }
                        System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2: THE CALLER IS:");
                        RuntimeException rtex2 = new RuntimeException();
                        rtex2.printStackTrace(System.out);
                        System.out.println("=======================================================================");
                    }
                    if (debug != null) {
                        debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineInit-2");
                    }
                    if (!this.mechanismBuilder.isCompatibleOperationMode(opmode, params)) {
                        throw new InvalidAlgorithmParameterException("IV parameter missing");
                    }
                    tokenKey = this.translateToPKCS11SecretKey(key);
                    if (!this.mechanismBuilder.isIVRequired()) break block35;
                    if (params == null) break block36;
                    if (params instanceof IvParameterSpec) {
                        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
                            throw new InvalidAlgorithmParameterException("IvParameterSpec is inappropriate for GCM mode.");
                        }
                        this.iv = ((IvParameterSpec)params).getIV();
                        break block37;
                    } else {
                        if (!(params instanceof GCMParameterSpec)) {
                            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV or GCMParameterSpecexpected");
                        }
                        if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
                            throw new InvalidAlgorithmParameterException("GCMParameterSpec is inappropriate for this cipher mode, reguires GCM mode.");
                        }
                        try {
                            this.gcmParameters = AlgorithmParameters.getInstance("AESGCM");
                            this.gcmParameters.init(params);
                        }
                        catch (NoSuchAlgorithmException nsae) {
                            throw new RuntimeException(nsae.getMessage());
                        }
                        catch (InvalidParameterSpecException ipse) {
                            throw new InvalidAlgorithmParameterException(ipse.getMessage());
                        }
                        this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                        try {
                            this.cipher.engineInitGCM(opmode, tokenKey.getObject(), (GCMParameterSpec)params);
                        }
                        catch (InvalidAlgorithmParameterException iape) {
                            throw new RuntimeException(iape.getMessage());
                        }
                    }
                }
                if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
                    this.iv = new byte[this.engineGetBlockSize()];
                    rnd = random == null ? new SecureRandom() : random;
                    rnd.nextBytes(this.iv);
                    break block37;
                } else {
                    if (opmode == 2) {
                        throw new InvalidAlgorithmParameterException("During decryption, cipher requires algorithm parameters or algorithm parameter specification.");
                    }
                    this.iv = new byte[this.engineGetBlockSize()];
                    rnd = random == null ? new SecureRandom() : random;
                    rnd.nextBytes(this.iv);
                    GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this.iv);
                    try {
                        this.gcmParameters = AlgorithmParameters.getInstance("AESGCM");
                        this.gcmParameters.init(gcmSpec);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        throw new RuntimeException(nsae.getMessage());
                    }
                    catch (InvalidParameterSpecException ipse) {
                        throw new InvalidAlgorithmParameterException(ipse.getMessage());
                    }
                    this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                    try {
                        this.cipher.engineInitGCM(opmode, tokenKey.getObject(), gcmSpec);
                    }
                    catch (InvalidAlgorithmParameterException iape) {
                        throw new RuntimeException(iape.getMessage());
                    }
                }
            }
            if (params != null && params instanceof GCMParameterSpec) {
                throw new InvalidAlgorithmParameterException("GCMParameterSpec is inappropriate for this cipher mode, reguires GCM mode.");
            }
        }
        if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            PKCS11Cipher cp = null;
            cp = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            } else {
                this.cancelOperation();
                if (this.session == null) {
                    this.session = this.sessionManager.getOpSession();
                }
            }
            try {
                cp.engineInit(this.session, opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
            }
            catch (InvalidKeyException ex) {
                this.cancelOperation();
                throw ex;
            }
            catch (PKCS11Exception ex) {
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    System.out.println("===========================================================================================================================================");
                    System.out.println("GeneralPKCS11Cipher.java:  engineInit()#2:  Below is the PKCS11Exception thrown at LINE 612 to cause cancelOperation() to set this.key to NULL.");
                    ex.printStackTrace(System.out);
                    System.out.println("===========================================================================================================================================");
                }
                this.cancelOperation();
                throw ex;
            }
            this.cipher = cp;
        }
        this.opmode = opmode;
        this.iv = this.iv;
        this.key = key;
        this.wasThisCipherEverInitialized = true;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineInit-2");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#3: METHOD ENTRY");
            if (opmode == 1) {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#3: The opmode = Cipher.ENCRYPT_MODE");
            } else {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#3: The opmode = Cipher.DECRYPT_MODE");
            }
            if (key == null) {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#3: The key is NULL");
            } else {
                System.out.println("GeneralPKCS11Cipher.java:  engineInit()#3: The key is a:  " + key.getClass().getName());
            }
            System.out.println("GeneralPKCS11Cipher.java:  engineInit()#3: THE CALLER IS:");
            RuntimeException rtex3 = new RuntimeException();
            rtex3.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineInit");
        }
        if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            IvParameterSpec ivSpec = null;
            if (params != null) {
                try {
                    ivSpec = params.getParameterSpec(IvParameterSpec.class);
                }
                catch (InvalidParameterSpecException ipse) {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                }
            }
            try {
                this.engineInit(opmode, key, ivSpec, random);
            }
            catch (InvalidKeyException ex) {
                this.cancelOperation();
                throw ex;
            }
            catch (PKCS11Exception ex) {
                this.cancelOperation();
                throw ex;
            }
        }
        GCMParameterSpec gcmSpec = null;
        if (params != null) {
            try {
                gcmSpec = params.getParameterSpec(GCMParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: GCM expected");
            }
        }
        try {
            this.engineInit(opmode, key, gcmSpec, random);
        }
        catch (InvalidKeyException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineInit");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#1: METHOD ENTRY");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#1: THE CALLER IS:");
            RuntimeException rtex4 = new RuntimeException();
            rtex4.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            throw new IllegalStateException("Method update() not supported for AES/GCM; only doFinal() is supported");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdate");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(this.key);
                    this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                    this.session = this.sessionManager.getOpSession();
                    this.cipher.engineInit(this.session, this.opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
                }
                catch (InvalidKeyException ex) {
                    this.cancelOperation();
                    throw new RuntimeException(ex);
                }
                catch (PKCS11Exception ex) {
                    this.cancelOperation();
                    throw new RuntimeException(ex);
                }
            } else {
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    System.out.println("=======================================================================");
                    System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#1: This cipher has not yet been initialized with a key");
                    if (!this.wasThisCipherEverInitialized) {
                        System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#1: This cipher has NEVER BEEN initialized with a key");
                    }
                    System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#1: Throwing the \"Cipher engine is not initialized\" exception now");
                    System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#1: THE CALLER IS:");
                    RuntimeException rtex5 = new RuntimeException();
                    rtex5.printStackTrace(System.out);
                    System.out.println("=======================================================================");
                }
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            byte[] result = this.cipher.engineUpdate(this.session, input, inputOffset, inputLen);
            if (debug != null) {
                debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdate");
            }
            return result;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2: METHOD ENTRY");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2: THE CALLER IS:");
            RuntimeException rtex6 = new RuntimeException();
            rtex6.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            throw new IllegalStateException("Method update() not supported for AES/GCM; only doFinal() is supported");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdate-2");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(this.key);
                    this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                    this.session = this.sessionManager.getOpSession();
                    this.cipher.engineInit(this.session, this.opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
                }
                catch (InvalidKeyException ex) {
                    this.cancelOperation();
                    throw new RuntimeException(ex);
                }
                catch (PKCS11Exception ex) {
                    this.cancelOperation();
                    throw ex;
                }
            } else {
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    System.out.println("=======================================================================");
                    System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2: This cipher has not yet been initialized with a key");
                    if (!this.wasThisCipherEverInitialized) {
                        System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2: This cipher has NEVER BEEN initialized with a key");
                    }
                    System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2: Throwing the \"Cipher engine is not initialized\" exception now");
                    System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2: THE CALLER IS:");
                    RuntimeException rtex7 = new RuntimeException();
                    rtex7.printStackTrace(System.out);
                    System.out.println("=======================================================================");
                }
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            int result = this.cipher.engineUpdate(this.session, input, inputOffset, inputLen, output, outputOffset);
            if (debug != null) {
                debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdate-2");
            }
            return result;
        }
        catch (PKCS11Exception ex) {
            if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                System.out.println("===========================================================================================================================================");
                System.out.println("GeneralPKCS11Cipher.java:  engineUpdate()#2:  Below is the PKCS11Exception thrown at LINE 907 to cause cancelOperation() to set this.key to NULL.");
                ex.printStackTrace(System.out);
                System.out.println("===========================================================================================================================================");
            }
            this.cancelOperation();
            throw ex;
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) throws IllegalStateException {
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdateAAD()#3: METHOD ENTRY");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdateAAD()#3: THE CALLER IS:");
            RuntimeException rtex8 = new RuntimeException();
            rtex8.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdateAAD");
        }
        if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            throw new IllegalStateException("updateAAD is only supported in GCM mode.");
        }
        this.cipher.engineUpdateAAD(src, offset, len);
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdateAAD");
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) throws IllegalStateException {
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdateAAD()#4: METHOD ENTRY");
            System.out.println("GeneralPKCS11Cipher.java:  engineUpdateAAD()#4: THE CALLER IS:");
            RuntimeException rtex9 = new RuntimeException();
            rtex9.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdateAAD-2");
        }
        if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            throw new IllegalStateException("updateAAD is only supported in GCM mode.");
        }
        byte[] aad = new byte[src.capacity()];
        src.get(aad, 0, aad.length);
        this.cipher.engineUpdateAAD(aad, 0, aad.length);
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineUpdateAAD-2");
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] saved_rc;
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineDoFinal");
        }
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            try {
                int tLenBytes = this.cipher.getGCMTagBits() / 8;
                byte[] output = null;
                if (this.opmode == 1) {
                    output = new byte[inputLen + tLenBytes];
                } else {
                    if (inputLen - tLenBytes < 0) {
                        throw new IllegalArgumentException("Size for result buffer is less than zero.");
                    }
                    output = new byte[inputLen - tLenBytes];
                }
                this.engineDoFinal(input, inputOffset, inputLen, output, 0);
                return output;
            }
            catch (ShortBufferException sbe) {
                this.cancelOperation();
                throw new IllegalBlockSizeException(sbe.getMessage());
            }
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(this.key);
                    this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                    this.session = this.sessionManager.getOpSession();
                    this.cipher.engineInit(this.session, this.opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
                }
                catch (InvalidKeyException ex) {
                    this.cancelOperation();
                    throw new IllegalArgumentException(ex);
                }
                catch (PKCS11Exception ex) {
                    this.cancelOperation();
                    throw ex;
                }
            } else {
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    System.out.println("=======================================================================");
                    System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#1: This cipher has not yet been initialized with a key");
                    if (!this.wasThisCipherEverInitialized) {
                        System.out.println("GeneralPKCS11Cipher.java:  engineDoFinal()#1: This cipher has NEVER BEEN initialized with a key");
                    }
                    System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#1: Throwing the \"Cipher engine is not initialized\" exception now");
                    System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#1: THE CALLER IS:");
                    RuntimeException rtex10 = new RuntimeException();
                    rtex10.printStackTrace(System.out);
                    System.out.println("=======================================================================");
                }
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            saved_rc = this.cipher.engineDoFinal(this.session, input, inputOffset, inputLen);
        }
        catch (IllegalBlockSizeException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (BadPaddingException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        this.cleanupTranslatedKey();
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineDoFinal");
        }
        return saved_rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException, AEADBadTagException {
        int saved_rc;
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineDoFinal-2");
        }
        PKCS11SecretKey tokenKey = null;
        if (this.session == null) {
            if (this.key != null) {
                if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
                    try {
                        tokenKey = this.translateToPKCS11SecretKey(this.key);
                        this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                        this.session = this.sessionManager.getOpSession();
                        this.cipher.engineInit(this.session, this.opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
                    }
                    catch (InvalidKeyException ex) {
                        this.cancelOperation();
                        throw new IllegalArgumentException(ex);
                    }
                    catch (PKCS11Exception ex) {
                        this.cancelOperation();
                        throw ex;
                    }
                }
                if (this.cipher != null) {
                    try {
                        tokenKey = this.translateToPKCS11SecretKey(this.key);
                        this.session = this.sessionManager.getOpSession();
                    }
                    catch (InvalidKeyException ex) {
                        this.cancelOperation();
                        throw new IllegalArgumentException(ex);
                    }
                    catch (PKCS11Exception ex) {
                        this.cancelOperation();
                        throw ex;
                    }
                } else {
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("=======================================================================");
                        System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#2: This cipher has not yet been successfully initialized. Read GeneralPKCS11Cipher for clarification");
                        if (!this.wasThisCipherEverInitialized) {
                            System.out.println("GeneralPKCS11Cipher.java:  engineDoFinal()#2: This cipher has NEVER BEEN initialized with a key");
                        }
                        System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#2: Throwing the \"Cipher engine is not initialized-2\" exception now");
                        System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#2: THE CALLER IS:");
                        RuntimeException rtex11 = new RuntimeException();
                        rtex11.printStackTrace(System.out);
                        System.out.println("=======================================================================");
                    }
                    throw new RuntimeException("Cipher engine is not initialized-2");
                }
            }
            if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                System.out.println("=======================================================================");
                System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#2: This cipher has not yet been initialized with a key");
                if (!this.wasThisCipherEverInitialized) {
                    System.out.println("GeneralPKCS11Cipher.java:  engineDoFinal()#2: This cipher has NEVER BEEN initialized with a key");
                }
                System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#2: Throwing the \"Cipher engine is not initialized\" exception now");
                System.out.println("GeneralPKCS11Cipher.java:  engineDofinal()#2: THE CALLER IS:");
                RuntimeException rtex12 = new RuntimeException();
                rtex12.printStackTrace(System.out);
                System.out.println("=======================================================================");
            }
            throw new RuntimeException("Cipher engine is not initialized");
        }
        if (!this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            try {
                saved_rc = this.cipher.engineDoFinal(this.session, input, inputOffset, inputLen, output, outputOffset);
            }
            catch (IllegalBlockSizeException ex) {
                this.cancelOperation();
                throw ex;
            }
            catch (BadPaddingException ex) {
                this.cancelOperation();
                throw ex;
            }
            catch (PKCS11Exception ex) {
                this.cancelOperation();
                throw ex;
            }
        }
        try {
            saved_rc = this.cipher.engineDoFinalGCM(this.session, input, inputOffset, inputLen, output, outputOffset);
        }
        catch (AEADBadTagException abte) {
            this.cancelOperation();
            throw abte;
        }
        catch (ShortBufferException sbex) {
            this.cancelOperation();
            throw sbex;
        }
        this.cleanupTranslatedKey();
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineDoFinal-2");
        }
        return saved_rc;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        SecretKeyFactory factory;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("SecretKey type expected.");
        }
        if (key instanceof PKCS11SecretKey) {
            int len = ((GeneralPKCS11Key)key).getValueLen();
            if (len == 0) {
                byte[] encode = null;
                encode = key.getEncoded();
                if (encode != null) {
                    len = encode.length;
                }
            }
            return len << 3;
        }
        try {
            factory = SecretKeyFactory.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e);
        }
        SecretKey translatedKey = factory.translateKey((SecretKey)key);
        this.hw_key_to_delete = (PKCS11Key)((Object)translatedKey);
        if (translatedKey instanceof GeneralPKCS11Key) {
            int len = ((GeneralPKCS11Key)translatedKey).getValueLen();
            if (len == 0) {
                byte[] encode = null;
                encode = translatedKey.getEncoded();
                if (encode != null) {
                    len = encode.length;
                }
            }
            this.cleanupTranslatedKey();
            return len << 3;
        }
        int len = translatedKey.getEncoded().length;
        this.cleanupTranslatedKey();
        return len << 3;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            throw new ProviderException("Unwrap not supported for AES/GCM");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineUnwrap");
        }
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        if (this.session == null) {
            if (this.key != null) {
                try {
                    PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(this.key);
                    this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                    this.session = this.sessionManager.getOpSession();
                    this.cipher.engineInit(this.session, this.opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
                }
                catch (InvalidKeyException ex) {
                    this.cancelOperation();
                    throw ex;
                }
                catch (PKCS11Exception ex) {
                    this.cancelOperation();
                    throw ex;
                }
            } else {
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    System.out.println("=======================================================================");
                    System.out.println("GeneralPKCS11Cipher.java:  engineUnwrap(): This cipher has not yet been initialized with a key");
                    if (!this.wasThisCipherEverInitialized) {
                        System.out.println("GeneralPKCS11Cipher.java:  engineUnwrap(): This cipher has NEVER BEEN initialized with a key");
                    }
                    System.out.println("GeneralPKCS11Cipher.java:  engineUnwrap(): Throwing the \"Cipher engine is not initialized\" exception now");
                    System.out.println("GeneralPKCS11Cipher.java:  engineUnwrap(): THE CALLER IS:");
                    RuntimeException rtex13 = new RuntimeException();
                    rtex13.printStackTrace(System.out);
                    System.out.println("=======================================================================");
                }
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        try {
            switch (wrappedKeyType) {
                case 3: {
                    attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm, this.provider);
                    break;
                }
                case 2: {
                    attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm, this.provider);
                    break;
                }
                case 1: {
                    attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm, this.config);
                    attrTypes = (int[])attrs[0];
                    attrValues = (Object[])attrs[1];
                    objKey = this.cipher.engineUnwrap(this.session, wrappedKey, attrTypes, attrValues);
                    result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm, this.provider);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        this.cleanupTranslatedKey();
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineUnwrap");
        }
        return result;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] saved_rc;
        if (this.mechanismBuilder.getMode().equalsIgnoreCase("GCM")) {
            throw new ProviderException("Wrap not supported for AES/GCM");
        }
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "engineWrap");
        }
        if (this.session == null) {
            if (this.key != null) {
                try {
                    PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(this.key);
                    this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism());
                    this.session = this.sessionManager.getOpSession();
                    this.cipher.engineInit(this.session, this.opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
                }
                catch (InvalidKeyException ex) {
                    this.cancelOperation();
                    throw ex;
                }
                catch (PKCS11Exception ex) {
                    this.cancelOperation();
                    throw ex;
                }
            } else {
                if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                    System.out.println("=======================================================================");
                    System.out.println("GeneralPKCS11Cipher.java:  engineWrap(): This cipher has not yet been initialized with a key");
                    if (!this.wasThisCipherEverInitialized) {
                        System.out.println("GeneralPKCS11Cipher.java:  engineWrap(): This cipher has NEVER BEEN initialized with a key");
                    }
                    System.out.println("GeneralPKCS11Cipher.java:  engineWrap(): Throwing the \"Cipher engine is not initialized\" exception now");
                    System.out.println("GeneralPKCS11Cipher.java:  engineWrap(): THE CALLER IS:");
                    RuntimeException rtex14 = new RuntimeException();
                    rtex14.printStackTrace(System.out);
                    System.out.println("=======================================================================");
                }
                throw new RuntimeException("Cipher engine is not initialized");
            }
        }
        int len = ((PKCS11Key)((Object)key)).getObject().size() + 7;
        try {
            saved_rc = this.cipher.engineWrap(this.session, ((PKCS11Key)((Object)key)).getObject(), len);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        this.cleanupTranslatedKey();
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "engineWrap");
        }
        return saved_rc;
    }

    private void cancelOperation() {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "cancelOperation");
        }
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("=======================================================================");
            System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  METHOD ENTRY");
        }
        if (this.session == null) {
            this.cipher = null;
            this.key = null;
            if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  if (session == null)");
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  Setting this.key = null");
                if (!this.wasThisCipherEverInitialized) {
                    System.out.println("GeneralPKCS11Cipher.java:  cancelOperation(): This cipher has NEVER BEEN initialized with a key");
                }
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  THE CALLER IS:");
                RuntimeException rtex1 = new RuntimeException();
                rtex1.printStackTrace(System.out);
                System.out.println("=======================================================================");
            }
            this.cleanupTranslatedKey();
            return;
        }
        if (!this.session.hasObjects()) {
            if (!IBMPKCS11Impl.doMemoryManagement()) {
                this.sessionManager.closeSession(this.session);
            }
            this.session = null;
            this.cipher = null;
            this.key = null;
            if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  if (!session.hasObjects())");
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  Setting this.key = null");
                if (!this.wasThisCipherEverInitialized) {
                    System.out.println("GeneralPKCS11Cipher.java:  cancelOperation(): This cipher has NEVER BEEN initialized with a key");
                }
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  THE CALLER IS:");
                RuntimeException rtex2 = new RuntimeException();
                rtex2.printStackTrace(System.out);
                System.out.println("=======================================================================");
            }
            this.cleanupTranslatedKey();
            return;
        }
        int blocksize = this.engineGetBlockSize();
        if (blocksize == 0) {
            blocksize = 8;
        }
        byte[] data = new byte[blocksize];
        try {
            this.cipher.engineDoFinal(this.session, data, 0, blocksize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        this.cipher = null;
        this.key = null;
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  AFTER engineDoFinal()");
            System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  Setting this.key = null");
            if (!this.wasThisCipherEverInitialized) {
                System.out.println("GeneralPKCS11Cipher.java:  cancelOperation(): This cipher has NEVER BEEN initialized with a key");
            }
            System.out.println("GeneralPKCS11Cipher.java:  cancelOperation():  THE CALLER IS:");
            RuntimeException rtex3 = new RuntimeException();
            rtex3.printStackTrace(System.out);
            System.out.println("=======================================================================");
        }
        this.cleanupTranslatedKey();
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "cancelOperation");
        }
    }

    protected void cleanupTranslatedKey() {
        if (!IBMPKCS11Impl.doMemoryManagement()) {
            if (debug != null) {
                System.out.println("GeneralPKCS11Cipher.java:  cleanupTranslatedKey():  doMemoryManagement == false    ");
            }
            if (this.hw_key_to_delete != null) {
                if (debug != null) {
                    System.out.println("GeneralPKCS11Cipher.java:  cleanupTranslatedKey():  hw_key_to_delete is NOT NULL.  ");
                    System.out.println("                                                    Executing hw_key_to_delete.rm()");
                }
                this.hw_key_to_delete.rm();
                this.hw_key_to_delete = null;
            } else if (debug != null) {
                System.out.println("GeneralPKCS11Cipher.java:  cleanupTranslatedKey():  hw_key_to_delete is NULL.  DO NOTHING.");
            }
        } else {
            if (debug != null) {
                System.out.println("GeneralPKCS11Cipher.java:  cleanupTranslatedKey():  doMemoryManagement == true.  ");
                System.out.println("                                                    The finalize method of hw_key_to_delete will clean up the hardware key.");
            }
            this.hw_key_to_delete = null;
        }
    }

    static {
        BLOCK_SIZES.put("AES", new Integer(16));
        BLOCK_SIZES.put("DES", new Integer(8));
        BLOCK_SIZES.put("DESede", new Integer(8));
        BLOCK_SIZES.put("Blowfish", new Integer(8));
    }
}

