/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    private static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private final BigInteger p;
    private final BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static final String[] z;

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4]);
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(z[10]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(z[7]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(z[5]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(z[8]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(z[11]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(z[9]);
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[6]);
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (IOException | NumberFormatException exception) {
            throw new InvalidKeyException(z[12], exception);
        }
    }

    @Override
    public String getFormat() {
        return z[1];
    }

    @Override
    public String getAlgorithm() {
        return z[0];
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[14] + this.y.toString() + z[15] + this.p.toString() + z[16] + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(z[13] + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.y, this.p, this.g};
        return Arrays.hashCode(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPublicKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)object;
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        if (this.y.compareTo(dHPublicKey.getY()) != 0) return false;
        if (this.p.compareTo(dHParameterSpec.getP()) != 0) return false;
        if (this.g.compareTo(dHParameterSpec.getG()) != 0) return false;
        if (object instanceof DHPublicKey) {
            return true;
        }
        if (this.hashCode() != object.hashCode()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.key == null || this.key.length == 0) {
            throw new InvalidObjectException(z[3]);
        }
        this.key = (byte[])this.key.clone();
        if (this.encodedKey != null && this.encodedKey.length != 0) {
            this.encodedKey = (byte[])this.encodedKey.clone();
            return;
        }
        throw new InvalidObjectException(z[2]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[17];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "br";
        int n3 = -1;
        block24: while (true) {
            char[] cArray;
            block28: {
                int n4;
                int n5;
                block27: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block27;
                    n5 = n5;
                    if (n5 <= n4) break block28;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 38;
                            break;
                        }
                        case 1: {
                            n6 = 58;
                            break;
                        }
                        case 2: {
                            n6 = 43;
                            break;
                        }
                        case 3: {
                            n6 = 48;
                            break;
                        }
                        default: {
                            n6 = 47;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "~\u0014\u001e\u0000\u0016";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "CTH_KC^\u000b[J_\u001aE_[\u0006^NCJTSJ\\F\\[I\\J";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "M_R\u0010AIN\u000bTJU_YYNJSQQMJ_";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "e[E^@R\u001a[B@BOHU\u000fgie\u001e\u001e\u0006_ES@BSEW";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "v[YQBCNNB\\\u0006WBC\\OTL";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "cBHU\\U\u001a@UV\u0006^JDN";
                    n3 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "gVLyK\u0006SX\u0010AIN\u000bQ\u000fu\u007fzejhyn";
                    n3 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "hOG\\\u000fV[YQBCNNB\\";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "cB_BN\u0006JJBNK__U]\u0006^JDN";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "oT]QCO^\u000b[J_\u001aM_]K[_";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "v[YQBCNNB\\\u0006TDD\u000fG\u001axu~s\u007fesj";
                    n3 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "cHY_]\u0006JJB\\OTL\u0010DCC\u000bUAEUOYAA";
                    n3 = 11;
                    continue block24;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = ",V\u0011:\u000f\u0006\u001a\u000b";
                    n3 = 12;
                    continue block24;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "oxfzlc\u001aoYI@SN\u001dgCVG]NH\u001a{EMJSH\u0010dCC\u0011:V\u001c0";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = ",J\u0011:";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = ",]\u0011:";
                    n3 = 15;
                    continue block24;
                }
                case 15: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

