/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

class CertificateKeyItemImpl
extends CertificateItemImpl
implements CertificateKeyItem {
    protected final PrivateKey key;
    protected final Certificate[] certChain;

    protected CertificateKeyItemImpl(String string, PrivateKey privateKey, Certificate[] certificateArray) throws KeyManagerException {
        super(string, (X509Certificate)certificateArray[0]);
        this.key = privateKey;
        this.certChain = certificateArray;
    }

    public CertificateRequestKeyItem toCertRequest(CommandParameters commandParameters, String string) throws KeyManagerException {
        KeyPair keyPair = new KeyPair(this.getCert().getPublicKey(), this.key);
        CertificateRequestKeyItem certificateRequestKeyItem = EntryFactory.newCertificateRequestItem(commandParameters, this, keyPair, string);
        certificateRequestKeyItem.setDisplayer(this.getDisplayer());
        return certificateRequestKeyItem;
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.PrivateKeyEntry(this.key, this.certChain);
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public Certificate[] getCertificateChain() {
        return this.certChain;
    }
}

