/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandFactory$SignerType;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.command.FilterFactory$Filter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.password.PasswordCallbackHandlerFactory;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractUnloadableEntry;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$SanItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem$ValidationMode;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FilePermissions;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;

public class CommandFactory {
    private static Map commandMap = new HashMap();
    private static CallbackHandler passwordHandler = PasswordCallbackHandlerFactory.getCLIHandler();
    private static boolean isStashFileExists = false;
    private static Map CertPathsMap = new HashMap();

    public static void setCallbackHandler(CallbackHandler callbackHandler) {
        Debug.entering(new Object[]{callbackHandler});
        passwordHandler = callbackHandler;
        Debug.exiting();
    }

    public static Command getCommand(ParameterMap parameterMap) throws KeyManagerException {
        Debug.entering(new Object[]{parameterMap});
        try {
            Constructor constructor = ((Class)commandMap.get(parameterMap.getCommandType())).getConstructor(ParameterMap.class);
            Debug.exiting();
            return (Command)constructor.newInstance(parameterMap);
        }
        catch (Exception exception) {
            Debug.throwing(exception);
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.OBJECT_INSTANTIATION_ERROR, (Throwable)exception);
        }
    }

    private static void setNewFilePermissions(String string) throws KeyManagerException {
        FilePermissions.setFilePermissions(string);
        CommandFactory.setStashFilePermissions(string);
    }

    private static void setStashFilePermissions(String string) throws KeyManagerException {
        if (!isStashFileExists) {
            String string2 = CommandFactory.getStashFileName(string);
            FilePermissions.setFilePermissions(new File(string2));
        }
    }

    public static String getStashFileName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            n = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(string.subSequence(0, n)).append(".sth");
        return stringBuilder.toString();
    }

    private static void checkIfStashFileExists(String string) {
        String string2 = CommandFactory.getStashFileName(string);
        isStashFileExists = new File(string2).exists();
    }

    private static void populateCerts(CommandParameters commandParameters, KeyStoreItem keyStoreItem, CommandFactory$SignerType commandFactory$SignerType) throws KeyManagerException {
        ArrayList<String> arrayList = null;
        try {
            arrayList = commandParameters.getLabels();
        }
        catch (KeyManagerException keyManagerException) {
            arrayList = new ArrayList<String>();
            switch (commandFactory$SignerType) {
                case Default: {
                    arrayList.add("entrust");
                    arrayList.add("verisign");
                    arrayList.add("thawte");
                    break;
                }
                case IBMCloud: {
                    arrayList.add("digiCert");
                    arrayList.add("letsEncrypt");
                    break;
                }
                case All: {
                    arrayList.add("entrust");
                    arrayList.add("verisign");
                    arrayList.add("thawte");
                    arrayList.add("digiCert");
                    arrayList.add("letsEncrypt");
                }
            }
        }
        ArrayList<CertificateItem> arrayList2 = new ArrayList<CertificateItem>();
        Collection collection = null;
        for (String string : arrayList) {
            switch (commandFactory$SignerType) {
                case Default: {
                    collection = CACertificates.getDefaultCACertificates(string);
                    break;
                }
                case IBMCloud: {
                    collection = CACertificates.getIBMCloudTrustCertificates(string);
                    break;
                }
                case All: {
                    collection = CACertificates.getCACertificates(string);
                }
            }
            if (collection == null) {
                if (commandFactory$SignerType == CommandFactory$SignerType.IBMCloud) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_CA_CERT_FOR_LABEL, new String[]{string, Constants$CommandType.ListIBMCloudSigners.getCommandLineParameter()});
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_CA_CERT_FOR_LABEL, new String[]{string, Constants$CommandType.ListSigners.getCommandLineParameter()});
            }
            for (CertificateItem certificateItem : collection) {
                arrayList2.add(certificateItem);
            }
        }
        keyStoreItem.addAll(arrayList2, true, false, KeyStoreItem$ValidationMode.IMPORT);
    }

    private static void showConsoleMessage(Boolean bl, Displayer displayer, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Displayable[] displayableArray, String string, String string2) {
        if (displayableArray.length > 0) {
            displayer.showMessage(MessageFormat.format(Messages.getString(string), databaseDescriptorFactory$DatabaseDescriptor.toString()));
            for (Displayable displayable : displayableArray) {
                String string3 = "";
                String string4 = "";
                if (displayable instanceof AbstractUnloadableEntry) {
                    string3 = "**-> ";
                    string4 = ((AbstractUnloadableEntry)displayable).toShortString() + "\n";
                } else if (!CommandFactory.isValidCertPath(displayable.getLabel())) {
                    string3 = "? ";
                    string4 = Messages.getString((String)CertPathsMap.get(displayable.getLabel()));
                }
                displayer.showMessage("   " + string3 + (displayable.toString().contains(" ") ? "\"" + displayable.toString() + "\"" : displayable.toString()));
                if (bl.booleanValue() && displayable instanceof CertificateItem) {
                    displayer.showMessage("       " + ((CertificateItem)displayable).getValidity());
                }
                if (string4.equals("")) continue;
                displayer.showMessage(string4);
            }
        } else {
            displayer.showMessage(Messages.getString(string2));
        }
    }

    private static void validateCertPath(CertificateItem certificateItem, CertificateItem[] certificateItemArray, Set set) throws IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertPathBuilderException, CertPathValidatorException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (CertificateItem object2 : certificateItemArray) {
            arrayList.add(object2.getCert());
        }
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setCertificate(certificateItem.getCert());
        x509CertSelector.setCertificateValid(new Date());
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(set, (CertSelector)x509CertSelector);
        CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
        CertStore certStore = KeymanUtil.isIBMJCE() ? CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, "IBMCertPath") : CertStore.getInstance("Collection", collectionCertStoreParameters);
        ArrayList<CertStore> arrayList2 = new ArrayList<CertStore>();
        arrayList2.add(certStore);
        pKIXBuilderParameters.setCertStores(arrayList2);
        pKIXBuilderParameters.setRevocationEnabled(false);
        CertPathBuilder certPathBuilder = KeymanUtil.isIBMJCE() ? CertPathBuilder.getInstance("PKIX", "IBMCertPath") : CertPathBuilder.getInstance("PKIX");
        CertPathBuilderResult certPathBuilderResult = certPathBuilder.build(pKIXBuilderParameters);
        CertPath certPath = certPathBuilderResult.getCertPath();
        PKIXParameters pKIXParameters = new PKIXParameters(set);
        pKIXParameters.setRevocationEnabled(false);
        pKIXParameters.setCertStores(arrayList2);
        CertPathValidator certPathValidator = KeymanUtil.isIBMJCE() ? CertPathValidator.getInstance("PKIX", "IBMCertPath") : CertPathValidator.getInstance("PKIX");
        certPathValidator.validate(certPath, pKIXParameters);
    }

    private static String validateCertChain(CommandParameters commandParameters, KeyStoreItem keyStoreItem, CertificateItem[] certificateItemArray) throws KeyManagerException {
        FilterFactory$Filter filterFactory$Filter = FilterFactory.getCertificateFilter(commandParameters);
        CertificateItem[] certificateItemArray2 = filterFactory$Filter.filter(keyStoreItem.getEntries(CertificateItem.class)).toArray(new CertificateItem[0]);
        String string = "Message.CertValidateSuccessful";
        for (CertificateItem certificateItem : certificateItemArray) {
            block41: {
                if (certificateItem instanceof UnloadableCertificateItemImpl || certificateItem instanceof UnloadableCMSCertificateItem) {
                    string = "Message.CannotValidate";
                    continue;
                }
                CertificateItem[] certificateItemArray3 = EntryFactory.extractCertChain(certificateItemArray2, certificateItem).toArray(new CertificateItem[0]);
                Set set = EntryFactory.extractCertTrustAnchor(certificateItemArray3);
                CertPathsMap.remove(certificateItem.getLabel());
                if (!certificateItem.isValid()) {
                    string = "Message.ExpiredCert";
                } else if (set.isEmpty()) {
                    string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors");
                } else {
                    try {
                        CommandFactory.validateCertPath(certificateItem, certificateItemArray3, set);
                        string = "Message.CertValidateSuccessful";
                    }
                    catch (IOException iOException) {
                        throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        string = "Message.CannotValidate";
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        string = "Message.CannotValidate";
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        string = "Message.CannotValidate";
                    }
                    catch (CertPathBuilderException certPathBuilderException) {
                        try {
                            string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathBuilderException.getCause().getMessage() + "\"";
                        }
                        catch (Exception exception) {
                            try {
                                string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathBuilderException.getMessage() + "\"";
                            }
                            catch (Exception exception2) {
                                certPathBuilderException.printStackTrace();
                                string = "Message.CannotValidate";
                            }
                        }
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        try {
                            string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathValidatorException.getCause().getMessage() + "\"";
                        }
                        catch (Exception exception) {
                            try {
                                string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathValidatorException.getMessage() + "\"";
                            }
                            catch (Exception exception3) {
                                certPathValidatorException.printStackTrace();
                                string = "Message.CannotValidate";
                            }
                        }
                    }
                }
                if (string.contains(Messages.getString("Message.MissingTrustAnchors"))) {
                    try {
                        CertificateItem[] certificateItemArray4 = CommandFactory.extractCertChainfromKeyEntry(certificateItemArray3, certificateItem).toArray(new CertificateItem[0]);
                        if (certificateItemArray4.length <= certificateItemArray3.length) break block41;
                        Set set2 = EntryFactory.extractCertTrustAnchor(certificateItemArray4);
                        if (set2.isEmpty()) {
                            string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors");
                            break block41;
                        }
                        try {
                            CommandFactory.validateCertPath(certificateItem, certificateItemArray4, set2);
                            string = "Message.CertValidateSuccessful";
                        }
                        catch (IOException iOException) {
                            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
                        }
                        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                            string = "Message.CannotValidate";
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            string = "Message.CannotValidate";
                        }
                        catch (NoSuchProviderException noSuchProviderException) {
                            string = "Message.CannotValidate";
                        }
                        catch (CertPathBuilderException certPathBuilderException) {
                            try {
                                string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathBuilderException.getCause().getMessage() + "\"";
                            }
                            catch (Exception exception) {
                                try {
                                    string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathBuilderException.getMessage() + "\"";
                                }
                                catch (Exception exception4) {
                                    certPathBuilderException.printStackTrace();
                                    string = "Message.CannotValidate";
                                }
                            }
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            try {
                                string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathValidatorException.getCause().getMessage() + "\"";
                            }
                            catch (Exception exception) {
                                try {
                                    string = Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.MissingTrustAnchors") + "\n\n" + Messages.getString("Message.UntranslatedMessage") + "\t\"" + certPathValidatorException.getMessage() + "\"";
                                }
                                catch (Exception exception5) {
                                    certPathValidatorException.printStackTrace();
                                    string = "Message.CannotValidate";
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            CertPathsMap.put(certificateItem.getLabel(), string);
        }
        return string;
    }

    public static boolean isValidCertPath(String string) {
        boolean bl = true;
        if (CertPathsMap.containsKey(string) && !((String)CertPathsMap.get(string)).equalsIgnoreCase("Message.CertValidateSuccessful")) {
            bl = false;
        }
        return bl;
    }

    public static List extractCertChainfromKeyEntry(CertificateItem[] certificateItemArray, CertificateItem certificateItem) throws KeyManagerException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (CertificateItem certificateItem2 : certificateItemArray) {
            arrayList.add(certificateItem2.getCert());
        }
        ArrayList<CertificateItem> arrayList2 = new ArrayList<CertificateItem>(Arrays.asList(certificateItemArray));
        if (certificateItemArray.length != 0 && certificateItemArray[0] instanceof CertificateKeyItem) {
            CertificateItem certificateItem3 = certificateItemArray[0];
            Certificate[] certificateArray = ((CertificateKeyItem)certificateItem3).getCertificateChain();
            if (certificateArray != null && certificateArray.length > 1) {
                for (int i = certificateArray.length - 1; i > 0; --i) {
                    if (arrayList.contains((X509Certificate)certificateArray[i])) continue;
                    String string = ((X509Certificate)certificateArray[i]).getSubjectX500Principal().toString();
                    arrayList2.add(EntryFactory.newCertificateItem(string, (X509Certificate)certificateArray[i]));
                }
            }
            List list = EntryFactory.extractCertChain(arrayList2.toArray(new CertificateItem[0]), certificateItem);
            return list;
        }
        return arrayList2;
    }

    private static void checkSan(DisplayItemFactory$SanItem displayItemFactory$SanItem, Displayer displayer) {
        if (!displayItemFactory$SanItem.isEmpty() && displayItemFactory$SanItem.getDnsName().isEmpty()) {
            try {
                displayer.showMessage(MessageFormat.format(Messages.getString("GUI.Title.Warning") + ": " + Messages.getString("Message.InvalidSan"), displayItemFactory$SanItem.getSanDNS()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    static void access$000(String string) {
        CommandFactory.checkIfStashFileExists(string);
    }

    static void access$100(String string) throws KeyManagerException {
        CommandFactory.setNewFilePermissions(string);
    }

    static CallbackHandler access$200() {
        return passwordHandler;
    }

    static void access$300(CommandParameters commandParameters, KeyStoreItem keyStoreItem, CommandFactory$SignerType commandFactory$SignerType) throws KeyManagerException {
        CommandFactory.populateCerts(commandParameters, keyStoreItem, commandFactory$SignerType);
    }

    static void access$400(String string) throws KeyManagerException {
        CommandFactory.setStashFilePermissions(string);
    }

    static Map access$500() {
        return CertPathsMap;
    }

    static String access$600(CommandParameters commandParameters, KeyStoreItem keyStoreItem, CertificateItem[] certificateItemArray) throws KeyManagerException {
        return CommandFactory.validateCertChain(commandParameters, keyStoreItem, certificateItemArray);
    }

    static void access$700(DisplayItemFactory$SanItem displayItemFactory$SanItem, Displayer displayer) {
        CommandFactory.checkSan(displayItemFactory$SanItem, displayer);
    }

    static void access$800(Boolean bl, Displayer displayer, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, Displayable[] displayableArray, String string, String string2) {
        CommandFactory.showConsoleMessage(bl, displayer, databaseDescriptorFactory$DatabaseDescriptor, displayableArray, string, string2);
    }

    static {
        commandMap.put(Constants$CommandType.AddCert, AddCertCommand.class);
        commandMap.put(Constants$CommandType.AddCertRename, AddCertCommandRename.class);
        commandMap.put(Constants$CommandType.ChangeDBPassword, ChangeDbPasswordCommand.class);
        commandMap.put(Constants$CommandType.CloseDb, CloseDbCommand.class);
        commandMap.put(Constants$CommandType.ConvertDB, ConvertDbCommand.class);
        commandMap.put(Constants$CommandType.CreateCertRequest, CreateCertRequestCommand.class);
        commandMap.put(Constants$CommandType.CreateDB, CreateDbCommand.class);
        commandMap.put(Constants$CommandType.CreateSSCert, CreateSsCertCommand.class);
        commandMap.put(Constants$CommandType.DeleteCert, DeleteCertCommand.class);
        commandMap.put(Constants$CommandType.DeleteCertRequest, DeleteCertRequestCommand.class);
        commandMap.put(Constants$CommandType.DeleteDB, DeleteDbCommand.class);
        commandMap.put(Constants$CommandType.DisplayCert, DisplayCertCommand.class);
        commandMap.put(Constants$CommandType.DisplayCertRequest, DisplayCertRequestCommand.class);
        commandMap.put(Constants$CommandType.DisplayDBPasswordExpiry, DisplayDbPasswordExpiryCommand.class);
        commandMap.put(Constants$CommandType.ExportCert, ExportCertCommand.class);
        commandMap.put(Constants$CommandType.ExtractCert, ExtractCertCommand.class);
        commandMap.put(Constants$CommandType.ExtractCertRequest, ExtractCertRequestCommand.class);
        commandMap.put(Constants$CommandType.ImportCert, ImportCertCommand.class);
        commandMap.put(Constants$CommandType.ValidateCert, ValidateCertCommand.class);
        commandMap.put(Constants$CommandType.ListCertRequests, ListCertRequestsCommand.class);
        commandMap.put(Constants$CommandType.ListCerts, ListCertsCommand.class);
        commandMap.put(Constants$CommandType.DisplayDefaultCert, DisplayDefaultCertCommand.class);
        commandMap.put(Constants$CommandType.ListSupportedDBTypes, ListSupportedDbTypesCommand.class);
        commandMap.put(Constants$CommandType.LoadDB, LoadDbCommand.class);
        commandMap.put(Constants$CommandType.ModifyCert, ModifyCertCommand.class);
        commandMap.put(Constants$CommandType.ReceiveCert, ReceiveCertCommand.class);
        commandMap.put(Constants$CommandType.RecreateCertRequest, RecreateCertRequestCommand.class);
        commandMap.put(Constants$CommandType.SetDefaultCert, SetDefaultCertCommand.class);
        commandMap.put(Constants$CommandType.SignCert, SignCertCommand.class);
        commandMap.put(Constants$CommandType.StashDBPassword, StashDbPasswordCommand.class);
        commandMap.put(Constants$CommandType.Version, VersionCommand.class);
        commandMap.put(Constants$CommandType.Help, HelpCommand.class);
        commandMap.put(Constants$CommandType.AddProvider, AddProviderCommand.class);
        commandMap.put(Constants$CommandType.CreateSecretKey, CreateSecretKeyCommand.class);
        commandMap.put(Constants$CommandType.DisplaySecretKey, DisplaySecretKeyCommand.class);
        commandMap.put(Constants$CommandType.DeleteSecretKey, DeleteSecretKeyCommand.class);
        commandMap.put(Constants$CommandType.RenameSecretKey, RenameSecretKeyCommand.class);
        commandMap.put(Constants$CommandType.ImportSecretKey, ImportSecretKeyCommand.class);
        commandMap.put(Constants$CommandType.ExportSecretKey, ExportSecretKeyCommand.class);
        commandMap.put(Constants$CommandType.ListSecretKeys, ListSecretKeysCommand.class);
        commandMap.put(Constants$CommandType.Populate, PopulateCommand.class);
        commandMap.put(Constants$CommandType.AddTrust, AddTrustCommand.class);
        commandMap.put(Constants$CommandType.PopulateAll, PopulateAllCommand.class);
        commandMap.put(Constants$CommandType.ListSigners, ListSignerCommand.class);
        commandMap.put(Constants$CommandType.ListIBMCloudSigners, ListIBMCloudSignerCommand.class);
        commandMap.put(Constants$CommandType.ImportCertRename, ImportCertCommandRename.class);
        commandMap.put(Constants$CommandType.RefreshLists, LoadDbCommand.class);
        commandMap.put(Constants$CommandType.RenameCert, RenameCertCommand.class);
    }
}

