/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.util.function.Consumer;
import sun.misc.Cleaner;

public class ReferenceQueue<T> {
    private Reference[] references;
    private int head = 0;
    private int tail = 0;
    private boolean empty = true;
    private static final int DEFAULT_QUEUE_SIZE = 128;
    private static final Class reflectRefClass;
    private static final Class classNameLockRefClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        Reference ref;
        if (this.empty) {
            return null;
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                return null;
            }
            ref = this.references[this.head];
            this.references[this.head++] = null;
            ref.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            }
        }
        return ref;
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> remove(long timeout) throws IllegalArgumentException, InterruptedException {
        Reference ref;
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                this.wait(timeout);
                if (this.empty) {
                    return null;
                }
            }
            ref = this.references[this.head];
            this.references[this.head++] = null;
            ref.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            } else {
                this.notifyAll();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Reference<? extends T> reference) {
        if (reference instanceof Cleaner) {
            reference.dequeue();
            ((Cleaner)reference).clean();
            return;
        }
        Class<? extends Object> refClass = reference.getClass();
        if (refClass == reflectRefClass || refClass == classNameLockRefClass) {
            reference.dequeue();
            ((Runnable)((Object)reference)).run();
            return;
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.references == null) {
                this.references = new Reference[128];
            } else if (!this.empty && this.head == this.tail) {
                int newQueueSize = (int)((double)this.references.length * 1.1);
                Reference[] newQueue = new Reference[newQueueSize];
                System.arraycopy((Object)this.references, this.head, (Object)newQueue, 0, this.references.length - this.head);
                if (this.tail > 0) {
                    System.arraycopy((Object)this.references, 0, (Object)newQueue, this.references.length - this.head, this.tail);
                }
                this.head = 0;
                this.tail = this.references.length;
                this.references = newQueue;
            }
            this.references[this.tail++] = reference;
            if (this.tail == this.references.length) {
                this.tail = 0;
            }
            this.empty = false;
            reference.setEnqueued();
            this.notifyAll();
        }
    }

    void forEach(Consumer<? super Reference<? extends T>> consumer) {
    }

    static {
        Class<Cleaner> cl = Cleaner.class;
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName("java.lang.Class$ReflectRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        reflectRefClass = tmpClass;
        Class<?> tmpClass2 = null;
        try {
            tmpClass2 = Class.forName("java.lang.ClassLoader$ClassNameLockRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        classNameLockRefClass = tmpClass2;
    }
}

