/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.lang.management.PlatformLoggingMXBean;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public final class LoggingMXBeanImpl
extends StandardMBean
implements LoggingMXBean,
PlatformLoggingMXBean {
    private static final LoggingMXBeanImpl instance = LoggingMXBeanImpl.createInstance();
    private ObjectName objectName;

    private static LoggingMXBeanImpl createInstance() {
        return new LoggingMXBeanImpl();
    }

    private LoggingMXBeanImpl() {
        super(PlatformLoggingMXBean.class, true);
    }

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            this.objectName = ManagementUtils.createObjectName("java.util.logging:type=Logging");
        }
        return this.objectName;
    }

    public static LoggingMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        String result = null;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            Level level = logger.getLevel();
            result = level != null ? level.getName() : "";
        }
        return result;
    }

    @Override
    public List<String> getLoggerNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                result.add(enumeration.nextElement());
            }
        }
        return result;
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        String result = null;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            Logger parent = logger.getParent();
            result = parent != null ? parent.getName() : "";
        }
        return result;
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        Level newLevel;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            newLevel = null;
            if (levelName != null) {
                newLevel = Level.parse(levelName);
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K05E7", loggerName));
        }
        logger.setLevel(newLevel);
    }
}

