/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgROMClassBuilderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgStringInternTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9InternHashTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SRPHashTableInternalPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SRPHashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedInternSRPHashTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedInvariantInternTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9TranslationBufferSetPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9SharedInternSRPHashTableEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class WalkInternTableCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final String tab = "\t";

    public WalkInternTableCommand() {
        this.addCommand("walkinterntable", "1|2|3|4|5|6|help", "Prints string intern table information or help");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (args.length != 0) {
                if (args.length == 1) {
                    if (args[0].trim().equalsIgnoreCase("help")) {
                        this.printUsage(out);
                        return;
                    }
                    try {
                        int userSelection = Integer.parseInt(args[0]);
                        this.runWalkInternTableSelection(userSelection, out, context, false);
                        return;
                    }
                    catch (NumberFormatException e) {
                        out.append("Error: Invalid Option :" + args[0] + nl);
                        this.printUsage(out);
                        return;
                    }
                }
                out.append("Error: Too many options : ");
                for (int i = 0; i < args.length; ++i) {
                    out.append(args[i].toString());
                    if (i + 1 >= args.length) continue;
                    out.append(", ");
                }
                out.append(nl + "!walkintertable expects none(to print usage and valid args) or one integer arg." + nl);
                this.printUsage(out);
                return;
            }
            this.printUsage(out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void runSubMenu(Context context, PrintStream out) throws DDRInteractiveCommandException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        out.append("!walkinterntable sub menu command >  " + nl);
        try {
            String userInput;
            try {
                userInput = reader.readLine();
            }
            catch (IOException e) {
                out.append("Exception occured while reading the user input" + nl);
                e.printStackTrace();
                return;
            }
            try {
                if (userInput.compareToIgnoreCase("exit") == 0) {
                    out.append("Exiting !walkinterntable sub menu..." + nl);
                    return;
                }
                int userSelection = Integer.parseInt(userInput);
                this.runWalkInternTableSelection(userSelection, out, context, true);
            }
            catch (NumberFormatException e) {
                userInput = userInput.trim();
                if (userInput.toLowerCase().equals("quit")) {
                    out.println("To quit, please go back to main menu. (Type \"exit\")" + nl);
                }
                String[] components = userInput.split("\\s");
                String[] arguments = new String[components.length - 1];
                for (int i = 1; i < components.length; ++i) {
                    arguments[i - 1] = components[i];
                }
                context.execute(components[0].toLowerCase(), arguments, out);
            }
            this.runSubMenu(context, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void runWalkInternTableSelection(int selection, PrintStream out, Context context, boolean inSubMenu) throws CorruptDataException, DDRInteractiveCommandException {
        switch (selection) {
            case 1: {
                this.printSharedTableStructure(out);
                break;
            }
            case 2: {
                this.printLocalTableStructure(out);
                break;
            }
            case 3: {
                this.walkSharedTable(out);
                break;
            }
            case 4: {
                this.walkLocalTable(out);
                break;
            }
            case 5: {
                this.walkSharedTable(out);
                this.walkLocalTable(out);
                break;
            }
            case 6: {
                this.printSubMenu(out);
                if (inSubMenu) break;
                this.runSubMenu(context, out);
                break;
            }
            default: {
                out.append("Error: Invalid option = " + selection + nl);
                this.printMainOptions(out);
            }
        }
    }

    private void printSharedTableStructure(PrintStream out) throws CorruptDataException {
        J9SRPHashTableInternalPointer srpHashTableInternal;
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9SharedInvariantInternTablePointer sharedInternTable = vm.sharedInvariantInternTable();
        if (!sharedInternTable.isNull()) {
            out.println(sharedInternTable.formatFullInteractive());
        }
        out.append("Total Shared Weight : " + sharedInternTable.totalSharedWeightPtr().at(0L).longValue() + nl);
        J9SRPHashTablePointer srphashtable = sharedInternTable.sharedInvariantSRPHashtable();
        if (!srphashtable.isNull()) {
            out.println(srphashtable.formatFullInteractive());
        }
        if (!(srpHashTableInternal = srphashtable.srpHashtableInternal()).isNull()) {
            out.println(srpHashTableInternal.formatFullInteractive());
        }
    }

    private void printLocalTableStructure(PrintStream out) throws CorruptDataException {
        J9DbgStringInternTablePointer stringInternTablePtr = this.getRomClassBuilderPtr(out);
        if (!stringInternTablePtr.isNull()) {
            out.println(stringInternTablePtr.formatFullInteractive());
        }
    }

    private void walkSharedTable(PrintStream out) throws CorruptDataException {
        int totalWeight = 0;
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9SharedInvariantInternTablePointer sharedInternTable = vm.sharedInvariantInternTable();
        if (!sharedInternTable.isNull()) {
            J9SharedInternSRPHashTableEntryPointer currentEntry = sharedInternTable.headNode();
            int counter = 1;
            out.append("=================================================================================" + nl);
            out.append(this.tab(2) + "WALKING SHARED INTERN SRP HASHTABLE (SRPHashTable " + sharedInternTable.sharedInvariantSRPHashtable().getHexAddress() + ")" + nl);
            out.append(this.tab(2) + "FROM: MRU (MOST RECENTLY USED)" + nl);
            out.append(this.tab(2) + "TO: LRU (LEAST RECENTLY USED)" + nl);
            out.append("=================================================================================" + nl);
            while (!currentEntry.isNull()) {
                out.append(counter + "." + tab + "Shared Table Entry < !J9SharedInternSRPHashTableEntry " + currentEntry.getHexAddress() + " Flags: " + currentEntry.flags().getHexValue() + " IWeight: " + currentEntry.internWeight().longValue() + " IsUTF8Shared: " + currentEntry.flags().allBitsIn(J9SharedInternSRPHashTableEntry.STRINGINTERNTABLES_NODE_FLAG_UTF8_IS_SHARED) + ">" + tab + "UTF8 <Add: " + currentEntry.utf8SRP().getHexAddress() + " Data: \"" + J9UTF8Helper.stringValue(currentEntry.utf8SRP()) + "\">" + nl);
                totalWeight = (int)((long)totalWeight + currentEntry.internWeight().longValue());
                currentEntry = currentEntry.nextNode();
                ++counter;
            }
            out.append("Total Weight = " + totalWeight + nl);
            out.append("=================================================================================" + nl);
            out.append(this.tab(2) + "WALKING SHARED INTERN SRP HASHTABLE COMPLETED" + nl);
            out.append("=================================================================================" + nl);
        }
    }

    private void walkLocalTable(PrintStream out) throws CorruptDataException {
        int totalWeight = 0;
        J9DbgStringInternTablePointer stringInternTablePtr = this.getRomClassBuilderPtr(out);
        if (stringInternTablePtr.isNull()) {
            out.append("StringInternTable is null" + nl);
            return;
        }
        J9InternHashTableEntryPointer currentEntryPtr = stringInternTablePtr.headNode();
        if (currentEntryPtr.isNull()) {
            out.append("HeadNode is null" + nl);
            return;
        }
        int counter = 1;
        out.append("=================================================================================" + nl);
        out.append(this.tab(2) + "WALKING LOCAL INTERN HASHTABLE (stringInternTable )" + stringInternTablePtr.getHexAddress() + ")" + nl);
        out.append(this.tab(2) + "FROM: MRU (MOST RECENTLY USED)" + nl);
        out.append(this.tab(2) + "TO: LRU (LEAST RECENTLY USED)" + nl);
        out.append("=================================================================================" + nl);
        while (!currentEntryPtr.isNull()) {
            out.append(counter + "." + tab + "Local Table Entry < !J9InternHashTableEntry " + currentEntryPtr.getHexAddress() + " Flags: " + currentEntryPtr.flags().getHexValue() + " IWeight: " + currentEntryPtr.internWeight().longValue() + " ClassLoader: !J9ClassLoader " + currentEntryPtr.classLoader().getHexAddress() + ">" + tab + "UTF8 <Add: " + currentEntryPtr.utf8().getHexAddress() + " Data: \"" + J9UTF8Helper.stringValue(currentEntryPtr.utf8()) + "\">" + nl);
            totalWeight = (int)((long)totalWeight + currentEntryPtr.internWeight().longValue());
            currentEntryPtr = currentEntryPtr.nextNode();
            ++counter;
        }
        out.append("Total Weight = " + totalWeight + nl);
        out.append("=================================================================================" + nl);
        out.append(this.tab(2) + "WALKING LOCAL INTERN HASHTABLE COMPLETED" + nl);
        out.append("=================================================================================" + nl);
    }

    private void printSubMenu(PrintStream out) {
        out.append("INFO: You are in !walkinterntable sub menu." + nl);
        this.printMainOptions(out);
        out.append("6" + this.tab(1) + "To print this menu again" + nl);
        out.append("Type 'exit' to exit the sub menu and go back to the main menu. " + nl);
        out.append("Enter one of the options above or any DDR command " + nl);
        out.append("? ");
    }

    private void printUsage(PrintStream out) {
        out.append("USAGE: !walkinterntable <Sub Menu Option>" + nl);
        this.printMainOptions(out);
        out.append("6" + this.tab(1) + "To go into !walkinterntable sub menu" + nl);
    }

    private void printMainOptions(PrintStream out) {
        out.append("Walkinterntable Sub Menu Options :" + nl);
        out.append("1" + this.tab(1) + "To Print Shared Table Structural Info" + nl);
        out.append("2" + this.tab(1) + "To Print Local Table Structural Info" + nl);
        out.append("3" + this.tab(1) + "To Walk Shared Intern Table (From: Most recently used To: Least recently used)" + nl);
        out.append("4" + this.tab(1) + "To Walk Local Intern Table (From: Most recently used To: Least recently used)" + nl);
        out.append("5" + this.tab(1) + "To Walk Both Shared&Local Intern Table (From: Most recently used To; Least recently used)" + nl);
    }

    private String tab(int size) {
        String tabs = "";
        for (int i = 0; i < size; ++i) {
            tabs = tabs + tab;
        }
        return tabs;
    }

    private J9DbgStringInternTablePointer getRomClassBuilderPtr(PrintStream out) throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (vm.isNull()) {
            out.append("VM can not be found " + nl);
            return null;
        }
        J9TranslationBufferSetPointer translationBufferSetPtr = vm.dynamicLoadBuffers();
        if (translationBufferSetPtr.isNull()) {
            out.append("J9TranslationBufferSet can not be found " + nl);
            return null;
        }
        J9DbgROMClassBuilderPointer romClassBuilderPtr = J9DbgROMClassBuilderPointer.cast(translationBufferSetPtr.romClassBuilder());
        if (romClassBuilderPtr.isNull()) {
            out.append("romClassBuilderPtr can not be found " + nl);
            return null;
        }
        return romClassBuilderPtr.stringInternTable();
    }
}

