/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm28.j9.DataType;
import com.ibm.j9ddr.vm28.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm28.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm28.j9.ObjectModel;
import com.ibm.j9ddr.vm28.pointer.DoublePointer;
import com.ibm.j9ddr.vm28.pointer.FloatPointer;
import com.ibm.j9ddr.vm28.pointer.I16Pointer;
import com.ibm.j9ddr.vm28.pointer.I32Pointer;
import com.ibm.j9ddr.vm28.pointer.I64Pointer;
import com.ibm.j9ddr.vm28.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm28.pointer.Pointer;
import com.ibm.j9ddr.vm28.pointer.U16Pointer;
import com.ibm.j9ddr.vm28.pointer.U32Pointer;
import com.ibm.j9ddr.vm28.pointer.U64Pointer;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.UDATAPointer;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9PackedArrayClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9PackedObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassLoaderHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm28.structure.J9FieldFlags;
import com.ibm.j9ddr.vm28.structure.J9Object;
import com.ibm.j9ddr.vm28.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm28.types.U32;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class J9ObjectStructureFormatter
extends BaseStructureFormatter {
    public static final int DEFAULT_ARRAY_FORMAT_BEGIN = 0;
    public static final int DEFAULT_ARRAY_FORMAT_END = 16;
    public static final String PADDING = "      ";

    @Override
    public FormatWalkResult format(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        if (type2.equalsIgnoreCase("j9object") || type2.equalsIgnoreCase("j9indexableobject")) {
            J9ClassPointer clazz = null;
            J9ObjectPointer object = null;
            try {
                object = J9ObjectPointer.cast(address);
                clazz = J9ObjectHelper.clazz(object);
                if (clazz.isNull()) {
                    out.println("<can not read RAM class address>");
                    return FormatWalkResult.STOP_WALKING;
                }
                boolean isArray = J9ClassHelper.isArrayClass(clazz) || J9ClassHelper.isPackedArrayClass(clazz);
                String className = J9UTF8Helper.stringValue(clazz.romClass().className());
                U8Pointer dataStart = U8Pointer.cast(object).add(ObjectModel.getHeaderSize(object));
                if (className.equals("java/lang/String")) {
                    this.formatStringObject(out, 0, clazz, dataStart, object);
                } else if (isArray) {
                    int begin = 0;
                    int end = 16;
                    if (extraArgs.length > 0) {
                        begin = Integer.parseInt(extraArgs[0]);
                    }
                    if (extraArgs.length > 1) {
                        end = Integer.parseInt(extraArgs[1]);
                    }
                    this.formatArrayObject(out, clazz, dataStart, J9IndexableObjectPointer.cast(object), begin, end);
                } else {
                    this.formatObject(out, clazz, dataStart, object);
                }
            }
            catch (MemoryFault ex2) {
                out.println("Unable to read object clazz at " + object.getHexAddress() + " (clazz = " + clazz.getHexAddress() + ")");
            }
            catch (CorruptDataException ex) {
                out.println("Error for ");
                ex.printStackTrace(out);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private void formatObject(PrintStream out, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject) throws CorruptDataException {
        if (J9ClassHelper.isPacked(localClazz)) {
            String comment = ObjectModel.isPackedObjectHeader(localObject) ? (ObjectModel.getTargetObject(localObject).isNull() ? "off-heap" : "derived") : "on-heap";
            out.print(String.format("!J9PackedObject %s { // %s", localObject.getHexAddress(), comment));
        } else {
            out.print(String.format("!J9Object %s {", localObject.getHexAddress()));
        }
        out.println();
        this.printJ9ObjectFields(out, 1, localClazz, dataStart, localObject);
        out.println("}");
    }

    private void formatArrayObject(PrintStream out, J9ClassPointer localClazz, U8Pointer dataStart, J9IndexableObjectPointer localObject, int begin, int end) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(localObject);
        boolean isPacked = J9ClassHelper.isPacked(localClazz);
        if (isPacked) {
            String comment = ObjectModel.isPackedObjectHeader(J9ObjectPointer.cast(localObject)) ? (ObjectModel.getTargetObject(J9ObjectPointer.cast(localObject)).isNull() ? "off-heap" : "derived") : "on-heap";
            out.print(String.format("!J9IndexablePackedObject %s { // %s", localObject.getHexAddress(), comment));
        } else {
            out.print(String.format("!J9IndexableObject %s {", localObject.getHexAddress()));
        }
        out.println();
        out.println(String.format("    struct J9Class* clazz = !j9arrayclass 0x%X   // %s", localClazz.getAddress(), className));
        out.println(String.format("    Object flags = %s;", J9IndexableObjectHelper.flags(localObject).getHexValue()));
        U32 size = J9IndexableObjectHelper.size(localObject);
        if (isPacked) {
            J9ObjectPointer targetObject = ObjectModel.getTargetObject(J9ObjectPointer.cast(localObject));
            UDATA targetOffset = ObjectModel.getTargetOffset(J9ObjectPointer.cast(localObject));
            out.println(String.format("    Object object = %s;", targetObject.formatShortInteractive()));
            out.println(String.format("    UDATA offset = 0x%X; // !packeddata 0x%X 0x%X 0 %d", targetOffset.longValue(), localClazz.getAddress(), targetObject.addOffset(targetOffset).longValue(), size.longValue()));
        }
        if (!J9BuildFlags.thr_lockNursery) {
            out.println(String.format("    j9objectmonitor_t monitor = %s;", J9IndexableObjectHelper.monitor(localObject).getHexValue()));
        }
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            out.println(String.format("    U_32 size = %s; // Size exceeds Integer.MAX_VALUE!", size.getHexValue()));
        } else {
            out.println(String.format("    U_32 size = %s;", size.getHexValue()));
        }
        if (!isPacked || !ObjectModel.isPackedObjectHeader(J9ObjectPointer.cast(localObject))) {
            this.printSubArrayType(out, 1, localClazz, dataStart, begin, end, localObject, 0L);
        }
        out.println("}");
    }

    void printSubArrayType(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, int begin, int end, J9IndexableObjectPointer array, long packedOffsetStart) throws CorruptDataException {
        int finish;
        U32 arraySize = J9IndexableObjectHelper.size(array);
        if (arraySize.anyBitsIn(Integer.MIN_VALUE)) {
            arraySize = new U32(Integer.MAX_VALUE);
        }
        if (begin < (finish = Math.min(arraySize.intValue(), end))) {
            if (J9ClassHelper.isPackedArrayClass(localClazz)) {
                int arrayLength = arraySize.intValue();
                this.printPackedArray(out, tabLevel, localClazz, dataStart, array.clazz(), begin, end, arrayLength, packedOffsetStart);
            } else {
                String className = J9IndexableObjectHelper.getClassName(array);
                char signature = className.charAt(1);
                switch (signature) {
                    case 'B': 
                    case 'Z': {
                        for (int index = begin; index < finish; ++index) {
                            this.padding(out, tabLevel);
                            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 1);
                            out.println(String.format("[%d] = %3d, 0x%02x", index, U8Pointer.cast(slot).at(0L).longValue(), U8Pointer.cast(slot).at(0L).longValue()));
                        }
                        break;
                    }
                    case 'C': {
                        for (int index = begin; index < finish; ++index) {
                            this.padding(out, tabLevel);
                            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 2);
                            long value = U16Pointer.cast(slot).at(0L).longValue();
                            out.println(String.format("[%d] = %5d, 0x%2$04x, '%c'", index, value, Character.valueOf((char)value)));
                        }
                        break;
                    }
                    case 'S': {
                        for (int index = begin; index < finish; ++index) {
                            this.padding(out, tabLevel);
                            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 2);
                            out.println(String.format("[%d] = %6d, 0x%04x", index, I16Pointer.cast(slot).at(0L).longValue(), U16Pointer.cast(slot).at(0L).longValue()));
                        }
                        break;
                    }
                    case 'F': 
                    case 'I': {
                        for (int index = begin; index < finish; ++index) {
                            this.padding(out, tabLevel);
                            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 4);
                            out.println(String.format("[%d] = %10d, 0x%08x, %8.8fF", index, I32Pointer.cast(slot).at(0L).longValue(), U32Pointer.cast(slot).at(0L).longValue(), Float.valueOf(FloatPointer.cast(slot).floatAt(0L))));
                        }
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        for (int index = begin; index < finish; ++index) {
                            this.padding(out, tabLevel);
                            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 8);
                            out.println(String.format("[%d] = %2d, 0x%016x, %8.8fF", index, I64Pointer.cast(slot).at(0L).longValue(), I64Pointer.cast(slot).at(0L).longValue(), DoublePointer.cast(slot).doubleAt(0L)));
                        }
                        break;
                    }
                    case 'L': 
                    case '[': {
                        for (int index = begin; index < finish; ++index) {
                            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, (int)ObjectReferencePointer.SIZEOF);
                            if (slot.notNull()) {
                                long compressedPtrValue = J9BuildFlags.gc_compressedPointers ? I32Pointer.cast(slot).at(0L).longValue() : DataType.getProcess().getPointerAt(slot.getAddress());
                                this.padding(out, tabLevel);
                                out.println(String.format("[%d] = !fj9object 0x%x = !j9object 0x%x", index, compressedPtrValue, ObjectReferencePointer.cast(slot).at(0L).longValue()));
                                continue;
                            }
                            this.padding(out, tabLevel);
                            out.println(String.format("[%d] = null", slot));
                        }
                        break;
                    }
                }
            }
        }
        arraySize = J9IndexableObjectHelper.size(array);
        if (begin > 0 || arraySize.longValue() > (long)finish) {
            out.println(String.format("To print entire range: !j9indexableobject %s %d %d\n", array.getHexAddress(), 0, arraySize.longValue()));
        }
    }

    private void formatStringObject(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject) throws CorruptDataException {
        out.println(String.format("J9VMJavaLangString at %s {\n", localObject.getHexAddress()));
        this.printJ9ObjectFields(out, tabLevel, localClazz, dataStart, localObject);
        this.padding(out, tabLevel);
        out.println(String.format("\"%s\"\n", J9ObjectHelper.stringValue(localObject)));
        out.println("}");
    }

    private void printJ9ObjectFields(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject) throws CorruptDataException {
        UDATA lockword;
        J9ClassPointer instanceClass = localClazz;
        J9ClassPointer previousSuperclass = J9ClassPointer.NULL;
        boolean isPacked = J9ClassHelper.isPacked(localClazz);
        boolean lockwordPrinted = false;
        if (J9BuildFlags.thr_lockNursery) {
            lockwordPrinted = false;
        }
        J9UTF8Pointer classNameUTF = instanceClass.romClass().className();
        this.padding(out, tabLevel);
        out.println(String.format("struct J9Class* clazz = !j9class 0x%X   // %s", localClazz.getAddress(), J9UTF8Helper.stringValue(classNameUTF)));
        this.padding(out, tabLevel);
        out.println(String.format("Object flags = %s;", J9ObjectHelper.flags(localObject).getHexValue()));
        if (!J9BuildFlags.thr_lockNursery && (lockword = J9ObjectHelper.monitor(localObject)) != null) {
            this.padding(out, tabLevel);
            out.println(String.format("j9objectmonitor_t monitor = %s;", lockword.getHexValue()));
        }
        if (isPacked) {
            J9ObjectPointer targetObject = ObjectModel.getTargetObject(J9ObjectPointer.cast(localObject));
            UDATA targetOffset = ObjectModel.getTargetOffset(J9ObjectPointer.cast(localObject));
            this.padding(out, tabLevel);
            out.println(String.format("Object object = %s;", J9PackedObjectPointer.cast(localObject).object().formatShortInteractive()));
            this.padding(out, tabLevel);
            out.println(String.format("UDATA offset = 0x%X; // !packeddata 0x%X 0x%X", J9PackedObjectPointer.cast(localObject).offset().longValue(), localClazz.longValue(), targetObject.addOffset(targetOffset).longValue()));
        }
        if (!isPacked || !ObjectModel.isPackedObjectHeader(localObject)) {
            long depth = J9ClassHelper.classDepth(instanceClass).longValue();
            for (long superclassIndex = 0L; superclassIndex <= depth; ++superclassIndex) {
                J9ClassPointer superclass = superclassIndex == depth ? instanceClass : J9ClassPointer.cast(instanceClass.superclasses().at(superclassIndex));
                U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
                Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(superclass.romClass(), instanceClass, previousSuperclass, flags);
                while (iterator.hasNext()) {
                    J9ObjectFieldOffset result = iterator.next();
                    boolean printField = true;
                    boolean isHiddenField = result.isHidden();
                    if (J9BuildFlags.thr_lockNursery) {
                        boolean isLockword;
                        boolean bl = isLockword = isHiddenField && result.getOffsetOrAddress().add(J9Object.SIZEOF).eq(superclass.lockOffset());
                        if (isLockword) {
                            boolean bl2 = printField = !lockwordPrinted && instanceClass.lockOffset().eq(superclass.lockOffset());
                            if (printField) {
                                lockwordPrinted = true;
                            }
                        }
                    }
                    if (!printField) continue;
                    this.printObjectField(out, tabLevel, localClazz, dataStart, superclass, result, 0L);
                    out.println();
                }
                previousSuperclass = superclass;
            }
        }
    }

    public void printObjectField(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ClassPointer fromClass, J9ObjectFieldOffset objectFieldOffset, long packedOffsetStart) throws CorruptDataException {
        J9ROMFieldShapePointer fieldShape = objectFieldOffset.getField();
        UDATA fieldOffset = objectFieldOffset.getOffsetOrAddress();
        boolean isHiddenField = objectFieldOffset.isHidden();
        String className = J9UTF8Helper.stringValue(fromClass.romClass().className());
        String fieldName = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().name());
        String fieldSignature = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().signature());
        U8Pointer valuePtr = dataStart;
        valuePtr = fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagPacked) ? valuePtr.add(fieldOffset.add(packedOffsetStart)) : valuePtr.add(fieldOffset);
        this.padding(out, tabLevel);
        out.print(String.format("%s %s = ", fieldSignature, fieldName));
        if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            out.print(U64Pointer.cast(valuePtr).at(0L).getHexValue());
        } else if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagNestedPacked)) {
            out.print("{");
            J9ClassPointer fieldClazz = J9ClassLoaderHelper.findClass(localClazz.classLoader(), fieldSignature);
            if (null == fieldClazz) {
                throw new CorruptDataException("Unable to find field clazz: " + fieldSignature);
            }
            this.printNestedPackedObjectField(out, tabLevel + 1, localClazz, dataStart, fieldClazz, objectFieldOffset, packedOffsetStart, 0, 16);
            this.padding(out, tabLevel);
            out.print(String.format("} !packeddata 0x%x 0x%x", fieldClazz.longValue(), valuePtr.longValue()));
            if (J9ClassHelper.isPackedArrayClass(fieldClazz)) {
                long arrayLength = J9ROMFieldShapeHelper.getPackedLengthAnnotationValueFromROMField(objectFieldOffset.getField()).at(0L).longValue();
                out.print(String.format(" %d %d", 0, arrayLength));
            }
        } else if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            Pointer ptr = J9BuildFlags.gc_compressedPointers ? U32Pointer.cast(valuePtr) : UDATAPointer.cast(valuePtr);
            out.print(String.format("!fj9object 0x%x", ptr.at(0L).longValue()));
        } else {
            out.print(I32Pointer.cast(valuePtr).at(0L).getHexValue());
        }
        if (fieldShape.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagPacked)) {
            out.print(String.format(" (offset=%d)", packedOffsetStart + fieldOffset.longValue()));
        } else {
            out.print(String.format(" (offset=%d) (%s)", fieldOffset.longValue(), className));
        }
        if (isHiddenField) {
            out.print(" <hidden>");
        }
    }

    private void printNestedPackedObjectField(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ClassPointer clazz, J9ObjectFieldOffset objectFieldOffset, long packedOffsetStart, int begin, int end) throws CorruptDataException {
        J9ROMFieldShapePointer field = objectFieldOffset.getField();
        if (J9ClassHelper.isPackedArrayClass(clazz)) {
            long arrayLength = J9ROMFieldShapeHelper.getPackedLengthAnnotationValueFromROMField(field).at(0L).longValue();
            out.println(String.format(" // @Length(%d)", arrayLength));
            this.printPackedArray(out, tabLevel, localClazz, dataStart, clazz, begin, end, arrayLength, packedOffsetStart + objectFieldOffset.getOffsetOrAddress().longValue());
            if ((long)end < arrayLength) {
                this.padding(out, tabLevel);
                out.println("... truncated ...");
            }
        } else {
            out.println();
            Iterator<J9ObjectFieldOffset> it = J9ClassHelper.getFieldOffsets(clazz);
            while (it.hasNext()) {
                J9ObjectFieldOffset packedObjectFieldOffset = it.next();
                this.printObjectField(out, tabLevel, localClazz, dataStart, clazz, packedObjectFieldOffset, packedOffsetStart + objectFieldOffset.getOffsetOrAddress().longValue());
                out.println();
            }
        }
    }

    public void printPackedArray(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ClassPointer clazz, long begin, long end, long arrayLength, long packedOffsetStart) throws CorruptDataException {
        J9ClassPointer componentClazz = J9PackedArrayClassPointer.cast(clazz).componentType();
        Iterator<J9ObjectFieldOffset> tempIterator = J9ClassHelper.getFieldOffsets(componentClazz);
        boolean doInline = true;
        if (tempIterator.hasNext()) {
            J9ObjectFieldOffset fieldOffset = tempIterator.next();
            if (tempIterator.hasNext()) {
                doInline = false;
            } else if (fieldOffset.getField().modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagNestedPacked)) {
                doInline = false;
            }
        }
        long endIndex = Math.min(end, arrayLength);
        for (long i = begin; i < endIndex; ++i) {
            Iterator<J9ObjectFieldOffset> it = J9ClassHelper.getFieldOffsets(componentClazz);
            this.padding(out, tabLevel);
            out.print(String.format("[%d] = { ", i));
            if (!doInline) {
                out.println();
            }
            long packedFieldOffset = packedOffsetStart + i * ObjectModel.getPackedDataSize(componentClazz).longValue();
            while (it.hasNext()) {
                J9ObjectFieldOffset packedObjectFieldOffset = it.next();
                if (doInline) {
                    this.printObjectField(out, 0, localClazz, dataStart, componentClazz, packedObjectFieldOffset, packedFieldOffset);
                    continue;
                }
                this.printObjectField(out, tabLevel + 1, localClazz, dataStart, componentClazz, packedObjectFieldOffset, packedFieldOffset);
                out.println();
            }
            if (doInline) {
                out.println(" }");
                continue;
            }
            this.padding(out, tabLevel);
            out.print(String.format("} !packeddata 0x%x 0x%x %d %d", clazz.getAddress(), dataStart.add(packedOffsetStart).longValue(), i, i + 1L));
            if (i >= endIndex - 1L) continue;
            out.println();
        }
        if (!doInline) {
            out.println();
        }
    }

    private void padding(PrintStream out, int level) {
        for (int i = 0; i < level; ++i) {
            out.print(PADDING);
        }
    }
}

