/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemorySegmentPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class SegmentTree {
    private J9MemorySegmentPointer[] cache;

    public SegmentTree(J9MemorySegmentListPointer segmentList) {
        this.setSegmentList(segmentList);
    }

    protected void setSegmentList(J9MemorySegmentListPointer segmentList) {
        ArrayList<J9MemorySegmentPointer> segments = new ArrayList<J9MemorySegmentPointer>();
        try {
            GCSegmentIterator iterator = GCSegmentIterator.fromJ9MemorySegmentList(segmentList, 0L);
            while (iterator.hasNext()) {
                segments.add(iterator.next());
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corrupted segment in list", e, false);
            this.cache = new J9MemorySegmentPointer[0];
        }
        Collections.sort(segments, new Comparator<J9MemorySegmentPointer>(){

            @Override
            public int compare(J9MemorySegmentPointer seg1, J9MemorySegmentPointer seg2) {
                try {
                    return seg1.eq(seg2) ? 0 : (seg1.heapBase().lt(seg2.heapBase()) ? -1 : 1);
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Corrupted segment in list", e, false);
                    return -1;
                }
            }
        });
        this.cache = segments.toArray(new J9MemorySegmentPointer[segments.size()]);
    }

    public J9MemorySegmentPointer findSegment(AbstractPointer key) {
        try {
            return this.findSegment(0, this.cache.length, key);
        }
        catch (CorruptDataException e) {
            return this.linearSearch(0, this.cache.length, key);
        }
    }

    private J9MemorySegmentPointer findSegment(int start, int end, AbstractPointer key) throws CorruptDataException {
        if (end - start < 4) {
            return this.linearSearch(start, end, key);
        }
        int mid = (start + end) / 2;
        J9MemorySegmentPointer segment = this.cache[mid];
        if (key.gte(segment.heapBase())) {
            if (key.lt(segment.heapAlloc())) {
                return segment;
            }
            return this.findSegment(mid, end, key);
        }
        return this.findSegment(start, mid, key);
    }

    private J9MemorySegmentPointer linearSearch(int start, int end, AbstractPointer key) {
        for (int i = start; i < end; ++i) {
            if (this.cache[i] == null || !this.includesKey(this.cache[i], key)) continue;
            return this.cache[i];
        }
        return null;
    }

    private boolean includesKey(J9MemorySegmentPointer segment, AbstractPointer key) {
        try {
            return key.gte(segment.heapBase()) && key.lt(segment.heapAlloc());
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corrupted segment in list", e, false);
            return false;
        }
    }
}

