/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class J9ThreadHelper {
    private static WeakReference<Map<Long, IOSThread>> cachedThreads = null;

    public static VoidPointer getTLS(J9ThreadPointer threadPointer, UDATA key) throws CorruptDataException {
        return VoidPointer.cast(threadPointer.tlsEA().at(key.sub(1L)));
    }

    public static J9VMThreadPointer getVMThread(J9ThreadPointer threadPointer) throws CorruptDataException {
        return J9VMThreadPointer.cast(J9ThreadHelper.getTLS(threadPointer, J9RASHelper.getVM(DataType.getJ9RASPointer()).vmThreadKey()));
    }

    public static IOSThread getOSThread(J9ThreadPointer threadPointer) throws CorruptDataException {
        return J9ThreadHelper.getOSThread(threadPointer.tid().longValue());
    }

    public static IOSThread getOSThread(long tid) throws CorruptDataException {
        Map<Long, IOSThread> threadMap = J9ThreadHelper.getThreadMap();
        return threadMap.get(tid);
    }

    public static Iterator<IOSThread> getOSThreads() throws CorruptDataException {
        Map<Long, IOSThread> threadMap = J9ThreadHelper.getThreadMap();
        return threadMap.values().iterator();
    }

    private static Map<Long, IOSThread> getThreadMap() throws CorruptDataException {
        TreeMap<Long, IOSThread> thrMap = null;
        if (cachedThreads != null) {
            thrMap = (TreeMap<Long, IOSThread>)cachedThreads.get();
        }
        if (thrMap != null) {
            return thrMap;
        }
        thrMap = new TreeMap<Long, IOSThread>();
        for (IOSThread iOSThread : DataType.getProcess().getThreads()) {
            thrMap.put(iOSThread.getThreadId(), iOSThread);
        }
        cachedThreads = new WeakReference(thrMap);
        return thrMap;
    }
}

