/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm27.j9.SystemMonitorSingleTier_V1;
import com.ibm.j9ddr.vm27.j9.SystemMonitorThreeTier_V1;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadPointer;
import java.util.List;

public abstract class SystemMonitor
implements Comparable<SystemMonitor> {
    protected J9ThreadMonitorPointer monitor;

    public static SystemMonitor fromJ9ThreadMonitor(J9ThreadMonitorPointer monitor) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("OBJECT_MONITOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        if (J9BuildFlags.thr_threeTierLocking) {
            return new SystemMonitorThreeTier_V1(monitor);
        }
        return new SystemMonitorSingleTier_V1(monitor);
    }

    public J9ThreadMonitorPointer getRawMonitor() {
        return this.monitor;
    }

    @Override
    public int compareTo(SystemMonitor other) {
        return this.monitor.compare(other.monitor);
    }

    public boolean equals(Object object) {
        return this.compareTo((SystemMonitor)object) == 0;
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }

    public J9ThreadPointer getOwner() throws CorruptDataException {
        return this.monitor.owner();
    }

    public String getName() {
        String monitorName = "<unnamed monitor>";
        try {
            if (this.monitor.name().notNull()) {
                monitorName = String.format("\"%s\"", this.monitor.name().getCStringAtOffset(0L));
            }
        }
        catch (CorruptDataException e) {
            monitorName = "<FAULT>";
        }
        return monitorName;
    }

    public long getCount() throws CorruptDataException {
        return this.monitor.count().longValue();
    }

    public abstract boolean isContended() throws CorruptDataException;

    public abstract List<J9ThreadPointer> getWaitingThreads() throws CorruptDataException;

    public abstract List<J9ThreadPointer> getBlockedThreads() throws CorruptDataException;
}

