/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DeployUIManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;

public class AboutDialog
extends JDialog
implements DeploySIListener {
    private SingleInstanceImpl sil = null;
    private static String ABOUT_JAVA_ID = "com_sun_deploy_AboutJava-" + Config.getStringProperty("deployment.version");
    private final String TEXT_COLOR = "#7A7277";
    private final String LINK_COLOR = "#214F83";
    private final String LINK_HIGHLIGHT_COLOR = "#C03F3F";

    public AboutDialog(JFrame jFrame, boolean bl, boolean bl2) {
        super((Frame)jFrame, bl);
        if (bl2) {
            this.initSIImpl();
        }
        this.initComponents();
    }

    public AboutDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    public AboutDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
    }

    private void initSIImpl() {
        this.sil = new SingleInstanceImpl();
        this.sil.addSingleInstanceListener(this, ABOUT_JAVA_ID);
    }

    public static boolean shouldStartNewInstance() {
        return !SingleInstanceManager.isServerRunning(ABOUT_JAVA_ID) || !SingleInstanceManager.connectToServer("");
    }

    private void initComponents() {
        this.setTitle(this.getMessage("about.dialog.title"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AboutDialog.this.closeDialog();
            }
        });
        Color color = Color.white;
        Color color2 = new Color(122, 114, 119);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(color);
        jPanel.setBackground(color);
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/aboutjava.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.getAccessibleContext().setAccessibleName(this.getMessage("common.java.logo"));
        jLabel.getAccessibleContext().setAccessibleDescription(this.getMessage("common.java.logo"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(40, 0, 50, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n = imageIcon.getIconWidth() - 20;
        String string = this.getVersion();
        String string2 = this.getBuildInfo();
        String string3 = this.getMessage("about.product.name");
        String string4 = this.getMessage("about.license.note");
        String string5 = this.getMessage("about.sun.copyright");
        String string6 = this.getMessage("about.copyright");
        String string7 = this.getMessage("about.prompt.info");
        String string8 = this.getMessage("about.home.link");
        String string9 = new StringBuffer(string3).append("\n").append(string4).append("\n").append(string5).append("\n").append(string6).append("\n").toString();
        Font font = ResourceManager.getUIFont().deriveFont((float)DialogTemplate.getSubpanelFontSize());
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setForeground(color2);
        jLabel2.setBackground(color);
        jLabel2.setFont(font);
        JTextArea jTextArea = new JTextArea(string2);
        jTextArea.setEditable(false);
        jTextArea.setForeground(color2);
        jTextArea.setBackground(color);
        jTextArea.setFont(font);
        UITextArea uITextArea = new UITextArea(DialogTemplate.getSubpanelFontSize(), n, false);
        uITextArea.setText(string9);
        uITextArea.setForeground(color2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(color);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = -1;
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints2);
        jPanel2.add(jLabel2);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 15;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagLayout2.setConstraints(jTextArea, gridBagConstraints2);
        jPanel2.add(jTextArea);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.weightx = 0.0;
        gridBagLayout2.setConstraints(uITextArea, gridBagConstraints2);
        jPanel2.add(uITextArea);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JLabel jLabel3 = new JLabel();
        ImageIcon imageIcon2 = ResourceManager.getIcon("ibm.logo.image");
        jLabel3.setIcon(imageIcon2);
        gridBagConstraints.insets = new Insets(10, 0, 40, 10);
        switch (OSType.getOSType()) {
            case 2: 
            case 3: {
                gridBagConstraints.ipady += 14;
            }
        }
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AboutDialog.this.closeDialog();
            }
        };
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.closeDialog();
            }
        };
        this.getContentPane().addMouseListener(mouseInputAdapter);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(keyStroke, "cancel");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        this.getRootPane().getInputMap(2).put(keyStroke2, "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        if (OSType.getOSType() == 3) {
            this.getRootPane().putClientProperty("Window.zoomable", "false");
        }
        this.pack();
        this.setResizable(false);
        UIFactory.placeWindow(this);
    }

    private void closeDialog() {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void newActivation(String[] stringArray) {
        this.toFront();
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    private String getVersion() {
        int n;
        String string = System.getProperty("java.version");
        int n2 = string.indexOf(".");
        String string2 = string.substring(n2 + 1, string.indexOf(".", n2 + 1));
        int n3 = string.lastIndexOf("_");
        String string3 = null;
        if (n3 != -1 && (string3 = (n = string.indexOf("-")) != -1 ? string.substring(n3 + 1, n) : string.substring(n3 + 1, string.length())).startsWith("0")) {
            string3 = string3.substring(1);
        }
        String string4 = null;
        string4 = string3 != null ? MessageFormat.format(this.getMessage("about.java.version.update"), string2, string3) : MessageFormat.format(this.getMessage("about.java.version"), string2);
        return string4;
    }

    private String getBuildInfo() {
        return MessageFormat.format(this.getMessage("about.java.build"), System.getProperty("java.runtime.version"));
    }

    static {
        DeployUIManager.setLookAndFeel();
    }
}

