/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.util.Arrays;
import sun.misc.VM;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.security.action.GetPropertyAction;

public class SBCS_Encoder
extends CharsetEncoder
implements ArrayEncoder {
    private final short[] index;
    private final char[] charToByteTable_charr;
    private final byte[] byteMap;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private static boolean UseBuffer = false;
    protected static boolean swapAllowed = false;
    protected static int offset;
    private static String swapValue;
    private int charOff;
    private int byteOff;
    private static final int NOOUTPUT = 256;
    protected ByteBuffer trtoXlateTable = null;
    private final int kMinStringSize = 25;
    static final byte kSentinalValue = 0;
    protected boolean subMode = false;
    protected byte[] subBytes;
    protected static final int LINE_FEED_INDEX = 10;
    protected static final char SWAPPED_LINE_FEED_CHAR = '%';
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private final int[] mask1All = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    private final int[] mask2All = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private String csName = null;
    private char[] swaplf_charToByteTable_charr = null;
    private byte[] swaplf_byteMap = null;

    protected SBCS_Encoder(Charset charset, short[] sArray, String string, byte[] byArray, int n, byte[] byArray2) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.charToByteTable_charr = this.handleIBMSwapLF(string).toCharArray();
        this.byteMap = byArray;
        this.mask1 = this.mask1All[n];
        this.mask2 = this.mask2All[n];
        this.shift = n;
        this.csName = charset.name();
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
        this.subBytes = byArray2;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public static byte[] expandByteMap(short[] sArray, String string, int n, int n2) {
        if (n < 5 || n > 8) {
            return null;
        }
        int n3 = 1 << n;
        int n4 = 65536 / n3;
        byte[] byArray = new byte[65536];
        for (int i = 0; i < n4; ++i) {
            int n5 = i * n3;
            if (sArray[i] == n2) continue;
            for (int j = 0; j < n3; ++j) {
                byArray[n5++] = (byte)string.charAt(sArray[i] + j);
            }
        }
        return byArray;
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    public static final boolean isSwapLF() {
        return ExtendedCharsets.isSwapLF();
    }

    protected SBCS_Encoder(Charset charset, short[] sArray, String string, int n, int n2, int n3) {
        this(charset, sArray, string, null, n3, null);
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private int JITintrinsicConvert(ByteBuffer byteBuffer, char[] cArray, int n, byte[] byArray) {
        int n2;
        int n3 = this.byteOff;
        int n4 = this.charOff;
        for (n2 = 0; n2 < n - n4; ++n2) {
            byte by = byteBuffer.get(cArray[n2 + n4]);
            if (by == 0) {
                return 0;
            }
            byArray[n2 + n3] = by;
        }
        this.byteOff += n2;
        this.charOff += n2;
        return n2;
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    @Override
    public boolean canEncode(char c) {
        if (this.byteMap != null) {
            byte by = this.byteMap[c];
            return by != 0 || c == '\u0000';
        }
        char c2 = this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
        return c2 != '\u0000' || c == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        int n5 = 256;
        this.charOff = n;
        this.byteOff = n3;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        try {
            Object object;
            int n6 = n;
            int n7 = n3;
            int n8 = n2 - n6;
            int n9 = n4 - n7;
            boolean bl = true;
            boolean bl2 = false;
            if (n9 < n8) {
                n8 = n9;
                bl2 = true;
            }
            int n10 = n7 + n8;
            if (this.byteMap != null) {
                if (null != this.trtoXlateTable && n8 > 25) {
                    object = this.trtoXlateTable;
                    if (0 != this.JITintrinsicConvert((ByteBuffer)object, cArray, n6 + n8, byArray)) {
                        bl = false;
                        n6 += this.byteOff - n7;
                        n7 = this.byteOff;
                    } else if (n7 != this.byteOff) {
                        bl = false;
                        this.byteOff = n7;
                        this.charOff = n6;
                    }
                }
                if (bl) {
                    int n11 = 0;
                    n11 = this.encodeSBCS(cArray, n6, n10 - n7, byArray, n7, this.byteMap);
                    this.byteOff = n7 += n11;
                    this.charOff = n6 += n11;
                }
            } else {
                char c;
                byte by;
                int n12 = this.mask2;
                while (n7 < n10 && (by = (byte)this.charToByteTable_charr[this.index[(c = cArray[n6]) >> this.shift] + (c & n12)]) != 0) {
                    ++n6;
                    byArray[n7++] = by;
                }
            }
            this.byteOff = n7;
            this.charOff = n6;
            if (n7 == n10 && bl2) {
                object = CoderResult.OVERFLOW;
                return object;
            }
            while (this.charOff < n2) {
                int n13;
                block31: {
                    char c = cArray[this.charOff];
                    n13 = 1;
                    if ((c & 0xF800) == 55296) {
                        if (c <= '\udbff') {
                            if (this.charOff + 1 >= n2) break;
                            c = cArray[this.charOff + 1];
                            if (c >= '\udc00' && c <= '\udfff') {
                                if (!this.subMode) {
                                    object = CoderResult.unmappableForLength(2);
                                    return object;
                                }
                                n5 = this.subBytes.length > 0 ? this.subBytes[0] : 256;
                                n13 = 2;
                                break block31;
                            } else {
                                object = this.sgp.unmappableResult();
                                return object;
                            }
                        }
                        if (c <= '\udfff') {
                            object = CoderResult.malformedForLength(1);
                            return object;
                        }
                    } else {
                        n5 = (byte)(this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)]);
                        byte by = (byte)n5;
                        if (n5 == 0 && cArray[this.charOff] != '\u0000') {
                            if (!this.subMode) {
                                object = CoderResult.unmappableForLength(1);
                                return object;
                            }
                            int n14 = n5 = this.subBytes.length > 0 ? this.subBytes[0] : 256;
                        }
                    }
                }
                if (this.byteOff >= n4) {
                    object = CoderResult.OVERFLOW;
                    return object;
                }
                if (n5 != 256) {
                    byArray[this.byteOff++] = (byte)n5;
                }
                this.charOff += n13;
            }
            object = CoderResult.UNDERFLOW;
            return object;
        }
        finally {
            charBuffer.position(this.charOff - charBuffer.arrayOffset());
            byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
        }
    }

    @Override
    public void implReset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                byte by;
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                byte by2 = by = this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
                if (by == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                byteBuffer.put(by);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    @Override
    public int encode(char[] cArray, int n, int n2, byte[] byArray) {
        BidiConvert bidiConvert;
        int n3;
        int n4 = 256;
        int n5 = byArray.length;
        if (cArray.length - n < n2) {
            n2 = cArray.length - n;
        }
        int n6 = (n3 = n2 - n5) > 0 ? n5 : n2;
        int n7 = n + n6;
        int n8 = n;
        int n9 = 0;
        byte[] byArray2 = this.byteMap;
        char[] cArray2 = this.charToByteTable_charr;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n8, n7, this.bidiParms, this.csName)) {
            cArray = bidiConvert.toSbcs(cArray, n8, n7, this.bidiParms, this.csName);
            n7 = n6;
            n8 = 0;
        }
        if (ExtendedCharsets.isSwapLF()) {
            if (null == this.swaplf_charToByteTable_charr) {
                this.swaplf_charToByteTable_charr = this.handleIBMSwapLF(new String(this.charToByteTable_charr)).toCharArray();
                if (null != this.byteMap) {
                    this.swaplf_byteMap = Arrays.copyOf(this.byteMap, this.byteMap.length);
                    this.swaplf_byteMap[10] = (byte)this.swaplf_charToByteTable_charr[this.index[10 >> this.shift] + (0xA & this.mask2)];
                    this.swaplf_byteMap[133] = (byte)this.swaplf_charToByteTable_charr[this.index[133 >> this.shift] + (0x85 & this.mask2)];
                }
            }
            cArray2 = this.swaplf_charToByteTable_charr;
            byArray2 = this.swaplf_byteMap;
        }
        if (byArray2 != null) {
            int n10 = 0;
            n10 = this.encodeSBCS(cArray, n8, n6, byArray, n9, byArray2);
            n8 += n10;
            n9 += n10;
            while (n8 < n7) {
                char c;
                if (((c = cArray[n8++]) & 0xF800) == 55296) {
                    if (c <= '\udbff' && n8 < n7 && (c = cArray[n8]) >= '\udc00' && c <= '\udfff') {
                        if (n3 > 0) {
                            ++n7;
                            --n3;
                        }
                        ++n8;
                    }
                    byArray[n9++] = this.subBytes[0];
                    continue;
                }
                n4 = byArray2[c];
                if (n4 == 0 && c != '\u0000') {
                    n4 = this.subBytes[0];
                }
                byArray[n9++] = (byte)n4;
            }
        } else {
            char c;
            byte by;
            while (n8 < n7 && (by = (byte)cArray2[this.index[(c = cArray[n8]) >> this.shift] + (c & this.mask2)]) != 0) {
                ++n8;
                byArray[n9++] = by;
            }
            while (n8 < n7) {
                char c2;
                if (((c2 = cArray[n8++]) & 0xF800) == 55296) {
                    if (c2 <= '\udbff' && n8 < n7 && (c2 = cArray[n8]) >= '\udc00' && c2 <= '\udfff') {
                        if (n3 > 0) {
                            ++n7;
                            --n3;
                        }
                        ++n8;
                    }
                    byArray[n9++] = this.subBytes[0];
                    continue;
                }
                n4 = (byte)cArray2[this.index[c2 >> this.shift] + (c2 & this.mask2)];
                if (n4 == 0 && c2 != '\u0000') {
                    n4 = this.subBytes[0];
                }
                byArray[n9++] = (byte)n4;
            }
        }
        return n9;
    }

    private final int encodeSBCS(char[] cArray, int n, int n2, byte[] byArray, int n3, byte[] byArray2) {
        byte by;
        int n4 = 0;
        while (n4 < n2 && (by = byArray2[cArray[n]]) != 0) {
            ++n4;
            ++n;
            byArray[n3++] = by;
        }
        return n4;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.csName)) {
            int n;
            int n2;
            int n3;
            int n4 = charBuffer.remaining();
            if (n4 > byteBuffer.remaining()) {
                n4 = byteBuffer.remaining();
            }
            if (charBuffer.hasArray() && !UseBuffer) {
                char[] cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + charBuffer.position();
                n2 = n3 + n4;
                char c = cArray[n3];
                byte by = this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
                boolean bl = by == 0 && c != '\u0000';
                for (n = n3 + 1; n < n2; ++n) {
                    c = cArray[n];
                    by = this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
                    if ((by == 0 && c != '\u0000') != bl) break;
                }
                n4 = n - n3;
            } else {
                int n5 = charBuffer.position();
                n2 = n4;
                n = charBuffer.get();
                byte by = this.byteMap != null ? this.byteMap[n] : (byte)this.charToByteTable_charr[this.index[n >> this.shift] + (n & this.mask2)];
                boolean bl = by == 0 && n != 0;
                for (n3 = 1; n3 < n2; ++n3) {
                    n = charBuffer.get();
                    by = this.byteMap != null ? this.byteMap[n] : (byte)this.charToByteTable_charr[this.index[n >> this.shift] + (n & this.mask2)];
                    if ((by == 0 && n != 0) != bl) break;
                }
                charBuffer.position(n5);
                n4 = n3;
            }
            int n6 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n4);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.csName);
            charBuffer.limit(n6);
            n2 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n2 = charBuffer.position() + charBuffer2.position() - n2;
            charBuffer.position(n2);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    static {
        try {
            String string = System.getProperty("java.nio.usebuffer");
            if (string != null && string.length() > 0 && string.charAt(0) == '1') {
                UseBuffer = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

