/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkBase64InputStream;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmp.RevPassphraseInfoValue;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class JPKI
implements PkConstants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.certclient.JPKI";
    private static BigInteger BIG_ONE = BigInteger.valueOf(1L);
    private static final ObjectIdentifier EXT_OID = JPKI.getOID();
    private static int APPROVEDAPPLIED = 3;

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.311.2.1.14");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(4L, className, "getOID", (Throwable)e);
            }
            return null;
        }
    }

    public PkAttrs initialCertRequest(String[] values, String[] subjectAltNames, String[] kUsage, PublicKey pubKey, PrivateKey privateKey, String signatureAlgorithm) throws Exception {
        return this.initialCertRequest(values, subjectAltNames, kUsage, null, pubKey, privateKey, signatureAlgorithm);
    }

    public PkAttrs initialCertRequest(String[] values, String[] subjectAltNames, String[] kUsage, String[] extkUsage, PublicKey pubKey, PrivateKey privateKey, String signatureAlgorithm) throws Exception {
        SubjectAlternativeNameExtension sub;
        int i;
        if (values == null || values.length < 7) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        if (debug != null) {
            for (int o = 0; o < values.length; ++o) {
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)values[o]);
            }
        }
        if (values[0] == null && values[1] == null) {
            if (values[0] == null) {
                throw new PkRejectionException("0 " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
            if (values[1] == null) {
                throw new PkRejectionException("1 " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
        }
        for (i = 2; i < values.length; ++i) {
            if (values[i] != null || i == 3 || i == 4) continue;
            throw new PkRejectionException("" + i + " " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (pubKey == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (kUsage != null) {
            for (i = 0; i < kUsage.length; ++i) {
                if (debug == null) continue;
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)kUsage[i]);
            }
        }
        if (extkUsage != null && debug != null) {
            for (i = 0; i < extkUsage.length; ++i) {
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)extkUsage[i]);
            }
        }
        boolean isRSAKeyType = pubKey instanceof RSAPublicKey;
        X509Key publicKey = (X509Key)pubKey;
        String domain = new X500Name(values[1]).getName();
        String subject = null;
        boolean haveSubjectDNPrefix = true;
        boolean haveSubjectDNSuffix = true;
        if (domain == null || domain.length() == 0) {
            haveSubjectDNSuffix = false;
        }
        if (values[0] == null || values[0].length() == 0) {
            haveSubjectDNPrefix = false;
        }
        if (haveSubjectDNPrefix && haveSubjectDNSuffix) {
            subject = values[0] + ", " + domain;
        } else if (haveSubjectDNPrefix && !haveSubjectDNSuffix) {
            subject = values[0];
        } else if (!haveSubjectDNPrefix && haveSubjectDNSuffix) {
            subject = domain;
        } else {
            throw new PkException(PkNLSConstants.INVALID_SUBJECT_NAME);
        }
        Integer version = new Integer(values[2]);
        if (version != 3) {
            throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
        }
        version = CERT_VERSION_3;
        PkAttrs attrs = new PkAttrs();
        int approved = 3;
        if (kUsage != null && kUsage.length > 0) {
            KeyUsageExtension keyUsage = this.setKeyUsageExt(kUsage);
            if (this.keyUsageWrong(isRSAKeyType, keyUsage)) {
                if (!isRSAKeyType && debug != null) {
                    debug.text(1L, className, "initialCertRequest", "Key usage for DSA should be digitalSignature or nonRepudiation");
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            attrs.add("x509.info.extensions.KeyUsage", approved, keyUsage);
        }
        ExtKeyUsageExtension kuext = null;
        if (extkUsage != null) {
            kuext = this.setextKeyUsageExt(extkUsage);
        }
        if (kuext != null) {
            attrs.add("x509.info.extensions.ExtKeyUsage", approved, kuext);
        }
        attrs.add("x509.info.version", approved, version);
        attrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        attrs.add("x509.info.algorithmID", approved, AlgorithmId.get((String)signatureAlgorithm));
        attrs.add("x509.info.algorithmName", 2, signatureAlgorithm);
        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        long notBefore = new Long(values[5]);
        Date dtNotBefore = new Date(notBefore);
        attrs.add("x509.info.validity.notBefore", approved, dtNotBefore);
        Date dt = new Date();
        dt.setTime(dtNotBefore.getTime());
        long notAfter = new Long(values[6]);
        dt.setTime(notAfter += dt.getTime());
        if (debug != null) {
            debug.text(1L, className, "initialCertRequest", "notAfter {0}", (Object)dt);
        }
        attrs.add("x509.info.validity.notAfter", approved, dt);
        attrs.add("x509.info.subject", approved, new X500Name(subject));
        attrs.add("x509.info.key", approved, publicKey);
        if (values[3] != null) {
            attrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(values[3].getBytes()));
        }
        if (values[4] != null) {
            attrs.add("x509.info.init_pwd", 2, values[4]);
        }
        attrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(domain)));
        if (null != subjectAltNames && (sub = PkSsCertFactory.createSubjectAltName(Arrays.asList(subjectAltNames), debug, className)) != null) {
            attrs.add("x509.info.extensions.SubjectAlternativeName", approved, sub);
        }
        if (debug != null) {
            debug.text(1L, className, "initialCertRequest", "process complete attrs {0}", (Object)attrs);
        }
        return attrs;
    }

    public PkAttrs initialCertRequest(byte[] base64pkcs10RequestAsByteArray, String[] values) throws Exception {
        if (base64pkcs10RequestAsByteArray == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        CertificationRequest certReq = null;
        ByteArrayInputStream inStream = new ByteArrayInputStream(base64pkcs10RequestAsByteArray);
        DerValue der = new DerValue((InputStream)new PkBase64InputStream(inStream));
        certReq = new CertificationRequest(der.toByteArray());
        return this.initialCertRequest(certReq, values);
    }

    public PkAttrs initialCertRequest(CertificationRequest certReq, String[] values) throws Exception {
        if (certReq == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        certReq.verify();
        if (values == null || values.length < 6) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        if (debug != null) {
            for (int o = 0; o < values.length; ++o) {
                debug.text(1L, className, "initialCertRequest", "Processing {0}", (Object)values[o]);
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        String domain = new X500Name(values[0]).getName();
        PkAttrs attrs = this.getAttrs(certReq);
        int approved = 3;
        Integer version = new Integer(values[1]);
        if (version != 3) {
            throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
        }
        version = CERT_VERSION_3;
        attrs.add("x509.info.version", approved, version);
        attrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(values[2].getBytes()));
        attrs.add("x509.info.init_pwd", 2, values[3]);
        attrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(domain)));
        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        attrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        return attrs;
    }

    public PkAttrs confRequest(String[] values) {
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Processing {0}", (Object[])values);
        }
        PkAttrs attrs = new PkAttrs();
        attrs.add("x509.info.version", 2, CERT_VERSION_3);
        attrs.add("cert.oper.keyStore.initAlias", 2, values[0]);
        attrs.add("cert.oper.keyStore.initentryPwd", 2, values[1].toCharArray());
        attrs.add("x509.info.init_pwd", 2, values[2]);
        attrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(values[3].getBytes()));
        InfoTypeAndValue[] itva = null;
        if (values.length >= 5 && values[4] != null && !values[4].equalsIgnoreCase("") && (itva = this.createRevoPassphrase(values[4])) != null) {
            attrs.add("cert.oper.certRevocationPassphrase", 2, itva);
        }
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Process Complete {0}", (Object)attrs);
        }
        return attrs;
    }

    public PkAttrs confRequest(Object[] values, Object[] initCertInfo) throws Exception {
        String revopassphrase;
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Processing {0}", values);
        }
        if (values == null || values.length < 3) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        if (values[0] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs attrs = new PkAttrs();
        attrs.add("TMP_MSG_HDR", 2, values[0]);
        attrs.add("x509.info.version", 2, CERT_VERSION_3);
        if (values[1] != null) {
            attrs.add("x509.info.init_pwd", 2, (String)values[1]);
        }
        if (values[2] != null) {
            attrs.add("cert.oper.SenderKeyIdentifier", 2, new KeyIdentifier(((String)values[2]).getBytes()));
        }
        InfoTypeAndValue[] itva = null;
        if (values.length >= 4 && (revopassphrase = (String)values[3]) != null && !revopassphrase.equalsIgnoreCase("")) {
            if (revopassphrase.toCharArray().length < 12) {
                throw new PkRejectionException(PkNLSConstants.REVO_PWD_TO_SHORT);
            }
            itva = this.createRevoPassphrase(revopassphrase);
            if (itva != null) {
                attrs.add("cert.oper.certRevocationPassphrase", 2, itva);
            }
        }
        if (initCertInfo != null) {
            if (initCertInfo.length < 2) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
            }
            for (int i = 0; i < initCertInfo.length; ++i) {
                if (initCertInfo[i] != null) continue;
                throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
            attrs.add("cert.oper.messageProtectionKey", 2, initCertInfo[0]);
            X509CertImpl cert = (X509CertImpl)initCertInfo[1];
            String sigAlg = cert.getSigAlgName();
            SubjectKeyIdentifierExtension ski = (SubjectKeyIdentifierExtension)cert.get("x509.info.extensions.SubjectKeyIdentifier");
            KeyIdentifier ki = ski.get("key_id");
            attrs.add("cert.oper.SenderKeyIdentifier", 2, ki);
            int approved = 3;
            attrs.add("x509.info.algorithmID", approved, AlgorithmId.get((String)sigAlg));
            attrs.add("x509.info.algorithmName", 2, sigAlg);
            attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        }
        if (debug != null) {
            debug.text(1L, className, "confRequest", "Process Complete {0}", (Object)attrs);
        }
        return attrs;
    }

    public PkAttrs secnRequest(String[] values, String[] subjectAltNames, String[] kUsage, PublicKey publicKey, PrivateKey privateKey, String sigAlg, Object[] initCertInfo) throws Exception {
        return this.secnRequest(values, subjectAltNames, kUsage, null, publicKey, privateKey, sigAlg, initCertInfo);
    }

    public PkAttrs secnRequest(String[] values, String[] subjectAltNames, String[] kUsage, String[] extkUsage, PublicKey publicKey, PrivateKey privateKey, String sigAlg, Object[] initCertInfo) throws Exception {
        SubjectAlternativeNameExtension sub;
        AlgorithmId algId;
        String algorithmName;
        int i;
        if (values == null || values.length < 5) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (publicKey == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (extkUsage != null && debug != null) {
            for (i = 0; i < extkUsage.length; ++i) {
                debug.text(1L, className, "secnCertRequest", "Processing {0}", (Object)extkUsage[i]);
            }
        }
        if (initCertInfo == null || initCertInfo.length < 2) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (i = 0; i < initCertInfo.length; ++i) {
            if (initCertInfo[i] != null) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (debug != null) {
            debug.text(1L, className, "secnRequest", "Processing {0}", (Object[])values);
            debug.text(1L, className, "secnRequest", "Processing {0}", (Object[])kUsage);
        }
        boolean isRSAKeyType = publicKey instanceof RSAPublicKey;
        String domain = new X500Name(values[1]).getName();
        String subject = values[0] + ", " + domain;
        Integer version = new Integer(values[2]);
        if (version != 3) {
            throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
        }
        version = CERT_VERSION_3;
        KeyUsageExtension keyUsage = null;
        if (kUsage != null && this.keyUsageWrong(isRSAKeyType, keyUsage = this.setKeyUsageExt(kUsage))) {
            if (!isRSAKeyType && debug != null) {
                debug.text(1L, className, "secnCertRequest", "Key usage for DSA should be digitalSignature or nonRepudiation");
            }
            throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
        }
        ExtKeyUsageExtension kuext = null;
        if (extkUsage != null) {
            kuext = this.setextKeyUsageExt(extkUsage);
        }
        PkAttrs attrs = new PkAttrs();
        int approved = 3;
        if (kuext != null) {
            attrs.add("x509.info.extensions.ExtKeyUsage", approved, kuext);
        }
        if (keyUsage != null) {
            attrs.add("x509.info.extensions.KeyUsage", approved, keyUsage);
        }
        attrs.add("x509.info.version", approved, CERT_VERSION_3);
        attrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        boolean initKeyIsRSAKeyType = initCertInfo[0] instanceof RSAPrivateKey;
        boolean initKeyIsDSAKeyType = initCertInfo[0] instanceof DSAPrivateKey;
        boolean initKeyIsECKeyType = initCertInfo[0] instanceof ECPrivateKey;
        if (initKeyIsRSAKeyType != isRSAKeyType && debug != null) {
            debug.text(1L, className, "secnRequest", "privatekey type mismatch {0}", (Object)new Boolean(initKeyIsRSAKeyType));
        }
        attrs.add("x509.info.algorithmName", 2, sigAlg);
        attrs.add("x509.info.algorithmID", approved, AlgorithmId.get((String)sigAlg));
        if (initCertInfo.length > 2) {
            algorithmName = (String)initCertInfo[2];
            if (algorithmName == null) {
                algorithmName = "SHA1";
            }
        } else {
            algorithmName = "SHA1";
        }
        boolean initKeyIsEDKeyType = false;
        boolean initKeyIsPQCKeyType = false;
        if (algorithmName.startsWith("ED") || algorithmName.startsWith("ML-KEM") || algorithmName.startsWith("ML-DSA")) {
            try {
                Class.forName("com.ibm.crypto.plus.provider.IBMJCEPlus");
                if (algorithmName.startsWith("ED")) {
                    Class<?> edPrivateKeyClass = Class.forName("ibm.security.internal.interfaces.EdECPrivateKey");
                    initKeyIsEDKeyType = edPrivateKeyClass.isInstance(initCertInfo[0]);
                } else if (algorithmName.startsWith("ML-KEM") || algorithmName.startsWith("ML-DSA")) {
                    Class<?> pqcPrivateKeyClass = Class.forName("com.ibm.crypto.plus.provider.PQCPrivateKey");
                    initKeyIsPQCKeyType = pqcPrivateKeyClass.isInstance(initCertInfo[0]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchProviderException("IBMJCEPlus provider is not available!");
            }
        }
        if (initKeyIsRSAKeyType) {
            algId = null;
            if (algorithmName.equalsIgnoreCase("SHA1")) {
                algorithmName = "SHA1withRSA";
                algId = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
            } else if (algorithmName.equalsIgnoreCase("MD5")) {
                algorithmName = "Md5withRSA";
                algId = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
            } else if (algorithmName.equalsIgnoreCase("MD2")) {
                algorithmName = "Md2withRSA";
                algId = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid);
            } else if (algorithmName.equalsIgnoreCase("SHA-384")) {
                algorithmName = "SHA384withRSA";
                algId = new AlgorithmId(AlgorithmId.sha384WithRSAEncryption_oid);
            } else if (algorithmName.equalsIgnoreCase("SHA-512")) {
                algorithmName = "SHA512withRSA";
                algId = new AlgorithmId(AlgorithmId.sha512WithRSAEncryption_oid);
            } else {
                algId = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
                algorithmName = "SHA1withRSA";
            }
            attrs.add("x509.info.messageProtectionAlgorithmID", 2, algId);
            attrs.add("x509.info.messageProtectionAlgorithmName", 2, algorithmName);
        } else if (initKeyIsDSAKeyType) {
            attrs.add("x509.info.messageProtectionAlgorithmID", 2, AlgorithmId.get((String)"SHA1withDSA"));
            attrs.add("x509.info.messageProtectionAlgorithmName", 2, "SHA1withDSA");
        } else if (initKeyIsECKeyType) {
            algId = null;
            if (algorithmName.equalsIgnoreCase("SHA1")) {
                algorithmName = "SHA1withECDSA";
                algId = new AlgorithmId(AlgorithmId.sha1WithECDSA_oid);
            } else if (algorithmName.equalsIgnoreCase("SHA2")) {
                algorithmName = "SHA2withECDSA";
                algId = new AlgorithmId(AlgorithmId.sha256WithECDSA_oid);
            } else if (algorithmName.equalsIgnoreCase("SHA-512")) {
                algorithmName = "SHA512withECDSA";
                algId = new AlgorithmId(AlgorithmId.sha512WithECDSA_oid);
            } else {
                algId = new AlgorithmId(AlgorithmId.sha1WithECDSA_oid);
                algorithmName = "SHA1withECDSA";
            }
            attrs.add("x509.info.messageProtectionAlgorithmID", 2, algId);
            attrs.add("x509.info.messageProtectionAlgorithmName", 2, algorithmName);
        } else if (initKeyIsEDKeyType) {
            algId = null;
            if (algorithmName.equalsIgnoreCase("ED448")) {
                algorithmName = "Ed448";
                algId = new AlgorithmId(AlgorithmId.Ed448_oid);
            } else if (algorithmName.equalsIgnoreCase("ED25519")) {
                algId = new AlgorithmId(AlgorithmId.Ed25519_oid);
                algorithmName = "Ed25519";
            }
            attrs.add("x509.info.messageProtectionAlgorithmID", 2, algId);
            attrs.add("x509.info.messageProtectionAlgorithmName", 2, algorithmName);
        } else if (initKeyIsPQCKeyType) {
            algId = null;
            if (algorithmName.equalsIgnoreCase("ML-DSA-44")) {
                algorithmName = "ML-DSA-44";
                algId = new AlgorithmId(AlgorithmId.ml_DSA_44_oid);
            } else if (algorithmName.equalsIgnoreCase("ML-DSA-65")) {
                algorithmName = "ML-DSA-65";
                algId = new AlgorithmId(AlgorithmId.ml_DSA_65_oid);
            } else if (algorithmName.equalsIgnoreCase("ML-DSA-87")) {
                algorithmName = "ML-DSA-87";
                algId = new AlgorithmId(AlgorithmId.ml_DSA_87_oid);
            } else if (algorithmName.equalsIgnoreCase("ML-KEM-512")) {
                algorithmName = "ML-KEM-512";
                algId = new AlgorithmId(AlgorithmId.ml_KEM_512_oid);
            } else if (algorithmName.equalsIgnoreCase("ML-KEM-768")) {
                algorithmName = "ML-KEM-768";
                algId = new AlgorithmId(AlgorithmId.ml_KEM_768_oid);
            } else if (algorithmName.equalsIgnoreCase("ML-KEM-1024")) {
                algorithmName = "ML-KEM-1024";
                algId = new AlgorithmId(AlgorithmId.ml_KEM_1024_oid);
            }
            attrs.add("x509.info.messageProtectionAlgorithmID", 2, algId);
            attrs.add("x509.info.messageProtectionAlgorithmName", 2, algorithmName);
        }
        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        long notBefore = new Long(values[3]);
        Date dtNotBefore = new Date(notBefore);
        attrs.add("x509.info.validity.notBefore", approved, dtNotBefore);
        Date dtNotAfter = new Date();
        dtNotAfter.setTime(dtNotBefore.getTime());
        long notAfter = new Long(values[4]);
        dtNotAfter.setTime(notAfter += dtNotAfter.getTime());
        attrs.add("x509.info.validity.notAfter", approved, dtNotAfter);
        if (debug != null) {
            debug.text(1L, className, "secnRequest", "notAfter {0}", (Object)dtNotAfter);
        }
        attrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(domain)));
        attrs.add("x509.info.key", approved, publicKey);
        attrs.add("cert.oper.messageProtectionKey", 2, initCertInfo[0]);
        attrs.add("cert.oper.privateKey", 2, privateKey);
        attrs.add("CERT_X509", 2, initCertInfo[1]);
        X509CertImpl cert = (X509CertImpl)initCertInfo[1];
        SubjectKeyIdentifierExtension ski = (SubjectKeyIdentifierExtension)cert.get("x509.info.extensions.SubjectKeyIdentifier");
        KeyIdentifier ki = ski.get("key_id");
        attrs.add("cert.oper.SenderKeyIdentifier", 2, ki);
        String initSubject = new X500Name(cert.getSubjectDN().toString()).getName();
        String newSubject = new X500Name(subject).getName();
        if (!initSubject.equalsIgnoreCase(newSubject)) {
            if (debug != null) {
                debug.text(1L, className, "secnRequest", "subject mismatch.old subject {0} ", (Object)initSubject);
                debug.text(1L, className, "secnRequest", "subject mismatch.new subject {0} ", (Object)newSubject);
            }
            throw new PkRejectionException(PkNLSConstants.SUBJECT_MISMATCH_WITH_INIT_REQ);
        }
        attrs.add("x509.info.subject", approved, new X500Name(subject));
        if (subjectAltNames != null && (sub = PkSsCertFactory.createSubjectAltName(Arrays.asList(subjectAltNames), debug, className)) != null) {
            attrs.add("x509.info.extensions.SubjectAlternativeName", approved, sub);
        }
        if (debug != null) {
            debug.text(1L, className, "secnRequest", "process complete attrs {0}", (Object)attrs);
        }
        return attrs;
    }

    public PkAttrs revoRequest(Object[] items) throws Exception {
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Processing {0}", items);
        }
        if (items == null || items.length < 3) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null || i == 2 || i == 3) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (items.length == 3 && items[2] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (items.length == 4 && items[2] == null && items[3] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs attrs = new PkAttrs();
        X509CertImpl cert = null;
        BigInteger serialNum = null;
        String issuer = null;
        SubjectKeyIdentifierExtension ski = null;
        KeyIdentifier ki = null;
        PublicKey k = null;
        String sigAlg = null;
        cert = (X509CertImpl)items[0];
        serialNum = cert.getSerialNumber();
        issuer = cert.getIssuerDN().getName();
        ski = (SubjectKeyIdentifierExtension)cert.get("x509.info.extensions.SubjectKeyIdentifier");
        ki = ski.get("key_id");
        k = cert.getPublicKey();
        sigAlg = cert.getSigAlgName();
        int approved = 3;
        attrs.add("x509.info.serialNumber", approved, cert.getSerialNumber());
        attrs.add("x509.info.subject", approved, cert.getSubjectDN());
        attrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name(new String(issuer))));
        attrs.add("CERT_X509", 2, items[0]);
        attrs.add("cert.oper.SenderKeyIdentifier", 2, ki);
        attrs.add("revo.badSinceDate", 2, new Date());
        if (items[1] != null) {
            int i = (Integer)items[1];
            if (0 <= i && i < 7 || i == 8) {
                attrs.add("revo.reasonFlags", 2, items[1]);
            } else {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
            }
        }
        attrs.add("cert.oper.privateKey", 2, items[2]);
        attrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        attrs.add("x509.info.algorithmName", 2, sigAlg);
        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        if (items.length >= 4) {
            InfoTypeAndValue[] itva = null;
            if (items[3] != null && !((String)items[3]).equalsIgnoreCase("") && (itva = this.createRevoPassphrase((String)items[3])) != null) {
                attrs.add("cert.oper.certRevocationPassphrase", 2, itva);
            }
        }
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Process Complete {0}", (Object)attrs);
        }
        return attrs;
    }

    public PkAttrs revoRequest(BigInteger certSerialNumber, Object[] items) throws Exception {
        if (debug != null) {
            debug.text(1L, className, "newrevoRequest", "certSerialNumber {0}", (Object)certSerialNumber);
            debug.text(1L, className, "newrevoRequest", "Processing {0}", items);
        }
        if (items == null || items.length < 2) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null || i == 1 || i == 2) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (items.length == 2 && items[1] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (items.length == 3 && items[1] == null && items[2] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs attrs = new PkAttrs();
        int approved = 3;
        attrs.add("x509.info.serialNumber", approved, certSerialNumber);
        attrs.add("x509.info.subject", approved, new X500Name("CN=DSubject"));
        attrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name("O=DIssuer")));
        attrs.add("revo.badSinceDate", 2, new Date());
        if (items[0] != null) {
            int i = (Integer)items[0];
            if (0 <= i && i < 7 || i == 8) {
                attrs.add("revo.reasonFlags", 2, items[0]);
            } else {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
            }
        }
        if (items[1] != null) {
            PrivateKey prvKey = (PrivateKey)items[1];
            if (prvKey instanceof RSAPrivateKey) {
                attrs.add("x509.info.algorithmName", 2, "SHA1withRSA");
            } else if (prvKey instanceof DSAPrivateKey) {
                attrs.add("x509.info.algorithmName", 2, "SHA1withDSA");
            } else if (prvKey instanceof ECPrivateKey) {
                attrs.add("x509.info.algorithmName", 2, "SHA1withECDSA");
            } else {
                attrs.add("x509.info.algorithmName", 2, "Ed25519");
            }
        }
        attrs.add("cert.oper.privateKey", 2, items[1]);
        attrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        if (items.length >= 3) {
            InfoTypeAndValue[] itva = null;
            if (items[2] != null && !((String)items[2]).equalsIgnoreCase("") && (itva = this.createRevoPassphrase((String)items[2])) != null) {
                attrs.add("cert.oper.certRevocationPassphrase", 2, itva);
            }
        }
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Process Complete {0}", (Object)attrs);
        }
        return attrs;
    }

    public PkAttrs revoRequest(PublicKey publicKey, Object[] items) throws Exception {
        if (debug != null) {
            debug.text(1L, className, "newrevoRequest", "publicKey {0}", (Object)publicKey);
            debug.text(1L, className, "newrevoRequest", "Processing {0}", items);
        }
        if (items == null || items.length < 2) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != null || i == 1 || i == 2) continue;
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (items.length == 2 && items[1] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        if (items.length == 3 && items[1] == null && items[2] == null) {
            throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
        }
        PkAttrs attrs = new PkAttrs();
        int approved = 3;
        attrs.add("x509.info.subject", approved, new X500Name("CN=DSubject"));
        attrs.add("cert.oper.RECIPIENT_DN", 2, new GeneralName((GeneralNameInterface)new X500Name("O=DIssuer")));
        attrs.add("x509.info.certrevopublickey", approved, publicKey);
        attrs.add("revo.badSinceDate", 2, new Date());
        if (items[0] != null) {
            int i = (Integer)items[0];
            if (0 <= i && i < 7 || i == 8) {
                attrs.add("revo.reasonFlags", 2, items[0]);
            } else {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
            }
        }
        if (items[1] != null) {
            PrivateKey prvKey = (PrivateKey)items[1];
            if (prvKey instanceof RSAPrivateKey) {
                attrs.add("x509.info.algorithmName", 2, "SHA1withRSA");
            } else if (prvKey instanceof DSAPrivateKey) {
                attrs.add("x509.info.algorithmName", 2, "SHA1withDSA");
            } else if (prvKey instanceof ECPrivateKey) {
                attrs.add("x509.info.algorithmName", 2, "SHA1withECDSA");
            } else {
                attrs.add("x509.info.algorithmName", 2, "Ed25519");
            }
        }
        attrs.add("cert.oper.privateKey", 2, items[1]);
        attrs.add("cert.oper.CMP_VERSION", 1, BIG_ONE);
        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
        if (items.length >= 3) {
            InfoTypeAndValue[] itva = null;
            if (items[2] != null && !((String)items[2]).equalsIgnoreCase("") && (itva = this.createRevoPassphrase((String)items[2])) != null) {
                attrs.add("cert.oper.certRevocationPassphrase", 2, itva);
            }
        }
        if (debug != null) {
            debug.text(1L, className, "revoRequest", "Process Complete {0}", (Object)attrs);
        }
        return attrs;
    }

    private boolean keyUsageWrong(boolean rsaKeyType, KeyUsageExtension keyUsage) throws Exception {
        boolean bad;
        block6: {
            int i;
            boolean[] ba;
            block5: {
                ba = keyUsage.getBits();
                bad = false;
                if (!rsaKeyType) break block5;
                for (int i2 = 0; i2 < ba.length; ++i2) {
                    if (debug == null) continue;
                    debug.text(1L, className, "keyUsageWrong", "ba ={0}", (Object)new Boolean(ba[i2]));
                }
                if (ba.length <= 5) break block6;
                int j = ba.length >= 7 ? 7 : ba.length;
                for (int i3 = 5; i3 < j; ++i3) {
                    bad = bad || ba[i3];
                }
                break block6;
            }
            for (i = 0; i < ba.length; ++i) {
                if (debug == null) continue;
                debug.text(1L, className, "keyUsageWrong", "ba ={0}", (Object)new Boolean(ba[i]));
            }
            if (ba.length > 2) {
                for (i = 2; i < ba.length; ++i) {
                    bad = bad || ba[i];
                }
            }
        }
        return bad;
    }

    private PKIMessage getConfMessage(PKIHeader head, KeyIdentifier senderKid1, String initPwd) throws Exception {
        GeneralName sender1 = head.getRecipient();
        GeneralName recepient1 = head.getSender();
        KeyIdentifier recipKid1 = null;
        byte[] senderNonce1 = head.getRecipNonce();
        byte[] recipNonce1 = head.getSenderNonce();
        byte[] tx_id = head.getTransactionID();
        byte[] salt = "this is a salt".getBytes();
        AlgorithmId owf = new AlgorithmId(AlgorithmId.SHA_oid);
        int iterationCount = 1001;
        AlgorithmId mac = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pbmspec = new PBMParameterSpec(salt, owf, iterationCount, mac);
        AlgorithmParameters pbmparam = null;
        try {
            pbmparam = AlgorithmParameters.getInstance("PasswordBasedMac", PkEeFactory.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)e.toString());
            }
            throw e;
        }
        catch (NoSuchProviderException ee) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)ee.toString());
            }
            throw ee;
        }
        try {
            pbmparam.init((AlgorithmParameterSpec)pbmspec);
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)e.toString());
            }
            throw e;
        }
        AlgorithmId pbmalgid = null;
        try {
            pbmalgid = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, pbmparam.getEncoded());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(1L, className, "getConfMessage", "ERROR : {0} ", (Object)e.toString());
            }
            throw e;
        }
        PKIHeader head1 = new PKIHeader(BIG_ONE, sender1, recepient1, new Date(), pbmalgid, senderKid1, recipKid1, tx_id, senderNonce1, recipNonce1, null, null);
        PKIMessage pkiMessage1 = new PKIMessage(head1, 19, null, null, null);
        PKIMessage pkiMessage2 = null;
        try {
            pkiMessage2 = pkiMessage1.protect(initPwd.getBytes());
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        return pkiMessage2;
    }

    private InfoTypeAndValue[] createRevoPassphrase(String revoP) {
        InfoTypeAndValue[] itva;
        EncryptedValue encValue = new EncryptedValue(null, null, null, null, null, revoP.getBytes());
        try {
            RevPassphraseInfoValue revP = new RevPassphraseInfoValue(encValue);
            itva = new InfoTypeAndValue[]{new InfoTypeAndValue((InfoValue)revP)};
        }
        catch (IOException e) {
            itva = null;
        }
        return itva;
    }

    private byte[] getIPAddress(String ipString) {
        String[] splitString = PkString.split(ipString, ".");
        byte[] ipAddress = new byte[]{new Integer(splitString[0]).byteValue(), new Integer(splitString[1]).byteValue(), new Integer(splitString[2]).byteValue(), new Integer(splitString[3]).byteValue()};
        return ipAddress;
    }

    private KeyUsageExtension setKeyUsageExt(String[] kUsage) throws IOException, PkRejectionException {
        KeyUsageExtension keyUsage = new KeyUsageExtension();
        for (int index = 0; index < kUsage.length && kUsage[index] != null; ++index) {
            if (kUsage[index].equalsIgnoreCase("digital_signature")) {
                keyUsage.set("digital_signature", (Object)Boolean.TRUE);
                continue;
            }
            if (kUsage[index].equalsIgnoreCase("data_encipherment")) {
                keyUsage.set("data_encipherment", (Object)Boolean.TRUE);
                continue;
            }
            if (kUsage[index].equalsIgnoreCase("encipher_only")) {
                keyUsage.set("encipher_only", (Object)Boolean.TRUE);
                continue;
            }
            if (kUsage[index].equalsIgnoreCase("decipher_only")) {
                keyUsage.set("decipher_only", (Object)Boolean.TRUE);
                continue;
            }
            if (kUsage[index].equalsIgnoreCase("non_repudiation")) {
                keyUsage.set("non_repudiation", (Object)Boolean.TRUE);
                continue;
            }
            if (kUsage[index].equalsIgnoreCase("key_encipherment")) {
                keyUsage.set("key_encipherment", (Object)Boolean.TRUE);
                continue;
            }
            if (kUsage[index].equalsIgnoreCase("key_agreement")) {
                keyUsage.set("key_agreement", (Object)Boolean.TRUE);
                continue;
            }
            if (debug != null) {
                debug.text(1L, className, "setKeyUsageExt", "Key usage {0} is not valid", (Object)kUsage[index]);
            }
            throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
        }
        return keyUsage;
    }

    private ExtKeyUsageExtension setextKeyUsageExt(String[] extkUsage) throws IOException, PkRejectionException {
        ExtKeyUsageExtension extkeyUsage = null;
        Vector<ObjectIdentifier> v = new Vector<ObjectIdentifier>();
        for (int index = 0; index < extkUsage.length && extkUsage[index] != null; ++index) {
            if (extkUsage[index].equalsIgnoreCase("ServerAuth_Id")) {
                v.add(index, PKIXExtensions.ServerAuth_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("ClientAuth_Id")) {
                v.add(index, PKIXExtensions.ClientAuth_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("CodeSigning_Id")) {
                v.add(index, PKIXExtensions.CodeSigning_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("EmailProtection_Id")) {
                v.add(index, PKIXExtensions.EmailProtection_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("IPSecEndSystem_Id")) {
                v.add(index, PKIXExtensions.IPSecEndSystem_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("IPSecTunnel_Id")) {
                v.add(index, PKIXExtensions.IPSecTunnel_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("IPSecUser_Id")) {
                v.add(index, PKIXExtensions.IPSecUser_Id);
                continue;
            }
            if (extkUsage[index].equalsIgnoreCase("TimeStamping_Id")) {
                v.add(index, PKIXExtensions.TimeStamping_Id);
                continue;
            }
            if (debug != null) {
                debug.text(1L, className, "extsetKeyUsageExt", "Key usage {0} is not valid", (Object)extkUsage[index]);
            }
            throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
        }
        if (v.size() > 0) {
            extkeyUsage = new ExtKeyUsageExtension(v);
        }
        return extkeyUsage;
    }

    private PkAttrs getAttrs(CertificationRequest cr) throws IOException {
        CertificationRequestInfo cri = cr.getCertRequestInfo();
        PkAttrs result = new PkAttrs();
        result.add("x509.info.subject", APPROVEDAPPLIED, cri.getSubjectName());
        try {
            result.add("x509.info.key", APPROVEDAPPLIED, cri.getSubjectPublicKeyInfo());
        }
        catch (InvalidKeyException e) {
            throw new PkIoException(e);
        }
        PKCSAttribute[] attrs = cri.getAttributes().getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            ObjectIdentifier oid = attrs[i].getAttributeId();
            String name = PKCS9.getName((ObjectIdentifier)oid);
            if (name != null) {
                result.add(name, 1, attrs[i].getAttributeValue());
                continue;
            }
            if (!oid.equals(EXT_OID)) continue;
            DerInputStream derIn = new DerInputStream((byte[])attrs[i].getAttributeValue());
            DerValue[] val = derIn.getSet(1);
            DerInputStream dis = new DerInputStream(val[0].toByteArray());
            CertificateExtensions exts = new CertificateExtensions(dis);
            Enumeration enumeration = exts.getElements();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                String extName = !(obj instanceof CertAttrSet) ? ((Extension)obj).getExtensionId().toString() : "x509.info.extensions." + ((CertAttrSet)obj).getName();
                result.add(extName, 1, obj);
            }
        }
        return result;
    }
}

