/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.F;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

public final class ECParameters
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private IBMJCEPlusProvider e = null;
    private static final String[] z;

    public ECParameters(IBMJCEPlusProvider iBMJCEPlusProvider) {
        this.e = iBMJCEPlusProvider;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.a();
    }

    protected byte[] a() throws IOException {
        byte[] byArray = this.c();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName(z[13]);
            if (clazz2.isAssignableFrom(clazz)) {
                ECParameterSpec eCParameterSpec = new ECParameterSpec(this.b, this.c, this.d, this.a);
                return (T)((AlgorithmParameterSpec)clazz.cast(eCParameterSpec));
            }
            throw new InvalidParameterSpecException(z[12]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[11] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a(algorithmParameterSpec);
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            F f2 = null;
            try {
                f2 = new F(eCGenParameterSpec.getName());
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new InvalidParameterSpecException(invalidParameterException.getMessage());
            }
            ECParameterSpec eCParameterSpec = f2.b();
            this.b = eCParameterSpec.getCurve();
            this.c = eCParameterSpec.getGenerator();
            this.d = eCParameterSpec.getOrder();
            this.a = eCParameterSpec.getCofactor();
            return;
        }
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidParameterSpecException(z[26]);
        }
        this.b = ((ECParameterSpec)algorithmParameterSpec).getCurve();
        this.c = ((ECParameterSpec)algorithmParameterSpec).getGenerator();
        this.d = ((ECParameterSpec)algorithmParameterSpec).getOrder();
        this.a = ((ECParameterSpec)algorithmParameterSpec).getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.a(byArray);
    }

    protected void a(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.c(byArray);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        return this.b();
    }

    protected String b() {
        return z[21] + this.b.getA() + z[22] + this.b.getB() + z[20] + this.b.getField().getFieldSize() + z[23] + this.d.toString() + z[19] + this.a + "\n";
    }

    protected static AlgorithmParameters a(IBMJCEPlusProvider iBMJCEPlusProvider, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[9], iBMJCEPlusProvider);
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[10] + generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] a(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n3 = ellipticCurve.getField().getFieldSize();
        int n2 = n3 + 7 >> 3;
        byte[] byArray2 = ECParameters.b(eCPoint.getAffineX().toByteArray());
        byte[] byArray = ECParameters.b(eCPoint.getAffineY().toByteArray());
        if (byArray2.length <= n2 && byArray.length <= n2) {
            byte[] byArray3 = new byte[1 + (n2 << 1)];
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        throw new ProviderException(z[18]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ECPoint a(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[7]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[8]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] b(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static DerValue a(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.b(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.b(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[2] + iOException);
        }
    }

    private static EllipticCurve a(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[1]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = byArray3 == null ? new EllipticCurve(eCField, bigInteger, bigInteger2) : new EllipticCurve(eCField, bigInteger, bigInteger2, byArray3);
            return ellipticCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[0] + iOException);
        }
    }

    private static DerValue a(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[3] + iOException);
        }
    }

    private static ECFieldFp a(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[4]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[6]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[5] + iOException);
        }
    }

    private byte[] c() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            F f2 = ECParameters.b(eCParameterSpec);
            if (f2 != null) {
                return f2.c();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[16]);
            }
            DerValue derValue = ECParameters.a((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.a(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.a(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[17] + iOException);
        }
    }

    static byte[] a(ECParameterSpec eCParameterSpec) throws IOException {
        try {
            EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
            ECPoint eCPoint = eCParameterSpec.getGenerator();
            BigInteger bigInteger = eCParameterSpec.getOrder();
            int n2 = eCParameterSpec.getCofactor();
            F f2 = ECParameters.b(eCParameterSpec);
            if (f2 != null) {
                return f2.c();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[15]);
            }
            DerValue derValue = ECParameters.a((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.a(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.a(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[14] + iOException);
        }
    }

    private static ECParameterSpec c(byte[] byArray) throws IOException {
        boolean bl = false;
        try {
            DerValue derValue;
            block5: {
                block6: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValue = derInputStream.getDerValue();
                    if (derValue.getTag() == 48) break block5;
                    if (derValue.getTag() != 6) break block6;
                    String string = derValue.getOID().toString();
                    return F.c(string);
                }
                throw new IOException(z[24]);
            }
            DerInputStream derInputStream = derValue.getData();
            int n2 = derInputStream.getInteger().intValue();
            DerValue derValue2 = derInputStream.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.a(derValue2);
            DerValue derValue3 = derInputStream.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.a(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream.getOctetString();
            ECPoint eCPoint = ECParameters.a(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                bl = true;
                n3 = derInputStream.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[25] + iOException);
        }
    }

    static F b(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = F.a();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                ECParameterSpec eCParameterSpec2;
                String string;
                block43: {
                    byte[] byArray;
                    byte[] byArray2;
                    block42: {
                        string = entry.getKey();
                        eCParameterSpec2 = entry.getValue();
                        BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                        BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                        BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                        int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                        int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                        byArray2 = eCParameterSpec2.getCurve().getSeed();
                        byArray = eCParameterSpec.getCurve().getSeed();
                        if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4)) continue;
                        if (n2 != n3) {
                            continue;
                        }
                        if (byArray2 != null || byArray != null) break block42;
                        break block43;
                    }
                    if (byArray2 == null && byArray != null) {
                        continue;
                    }
                    if (byArray2 != null && byArray == null) {
                        continue;
                    }
                    if (byArray2 == null || byArray == null) break block43;
                    if (byArray2.length != byArray.length) {
                        continue;
                    }
                    boolean bl = true;
                    int n4 = 0;
                    while (true) {
                        block47: {
                            if (n4 >= byArray2.length) break;
                            if (byArray2[n4] == byArray[n4]) break block47;
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator())) {
                    continue;
                }
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder())) {
                    continue;
                }
                if (eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) {
                    continue;
                }
                F f2 = new F(string);
                return f2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[27];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:\u007fH0\u0006~~h?\u0005skY:\nYn_%\f22\u0017s";
        int n3 = -1;
        block34: while (true) {
            char[] cArray;
            block38: {
                int n4;
                int n5;
                block37: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block37;
                    n5 = n5;
                    if (n5 <= n4) break block38;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 83;
                            break;
                        }
                        case 1: {
                            n6 = 105;
                            break;
                        }
                        case 2: {
                            n6 = 26;
                            break;
                        }
                        case 3: {
                            n6 = 27;
                            break;
                        }
                        default: {
                            n6 = 45;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001d\u0006n;Ls:_Jx\u0016'Y^";
                    n3 = 0;
                    continue block34;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:~C0\u0006~~h?\u0005skY:\nYn_%\f22\u0017s";
                    n3 = 1;
                    continue block34;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:~C0\u0006~~}!\u0000w~k:\fv\u007fy*\u0019\u007f3\u0004iI";
                    n3 = 2;
                    continue block34;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001d\u0006n;Ls:_Jx\u0016'Y^";
                    n3 = 3;
                    continue block34;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:\u007fH0\u0006~~}!\u0000w~k:\fv\u007fy*\u0019\u007f3\u0004iI";
                    n3 = 4;
                    continue block34;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001a\u0007yt_!\fyo\r\u001c ^;H=\nunC'\fh~Is\roiD=\u000e:\u007fH0\u0006~~}!\u0000w~k:\fv\u007fy*\u0019\u007f5";
                    n3 = 5;
                    continue block34;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001c\u0007vb\r&\u0007yt@#\u001b\u007fh^6\r:kB:\u0007n;K<\u001bwzYs\u001aok]<\u001bn~I";
                    n3 = 6;
                    continue block34;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0003\u0006suYs\ru~^s\u0007uo\r>\bnxEs\u000fs~A7IirW6";
                    n3 = 7;
                    continue block34;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0016*";
                    n3 = 8;
                    continue block34;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0006\u0007in]#\u0006hoH7Ijz_2\u0004\u007foH!IikH0\u0000|rN2\u001dstCiI";
                    n3 = 9;
                    continue block34;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0006\u0007in]#\u0006hoH7Ijz_2\u0004\u007foH!IikH0\u0000|rN2\u001dstCiI";
                    n3 = 10;
                    continue block34;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u001a\u0007{k]!\u0006jiD2\u001d\u007f;]2\u001b{vH'\fh;^#\fyrK:\n{oD<\u0007";
                    n3 = 11;
                    continue block34;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "9\blz\u0003 \fyn_:\u001dc5^#\fy5h\u00109{iL>\fn~_\u0000\u0019\u007fx";
                    n3 = 12;
                    continue block34;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:~C0\u0006~~h\u00109{iL>\fn~_ A3!\r";
                    n3 = 13;
                    continue block34;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0016*\\rH?\r\\)@s\ftxB&\u0007n~_6\r:rCs\ftxB7\f_X}2\u001b{vH'\fhh\u0005zG:;h\u0010/s~A7/(v\r:\u001a:uB'Iyn_!\ftoA*Iin]#\u0006hoH7G";
                    n3 = 14;
                    continue block34;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u0016*\\rH?\r\\)@s\ftxB&\u0007n~_6\r:rCs\ftxB7\f_X}2\u001b{vH'\fhh\u0005zG:;h\u0010/s~A7/(v\r:\u001a:uB'Iyn_!\ftoA*Iin]#\u0006hoH7G";
                    n3 = 15;
                    continue block34;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:~C0\u0006~~h\u00109{iL>\fn~_ A3!\r";
                    n3 = 16;
                    continue block34;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0003\u0006suYs\nut_7\u0000tzY6\u001a:\u007fBs\u0007uo\r>\bnxEs\u000fs~A7IirW6";
                    n3 = 17;
                    continue block34;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "Y`ytK2\nnt_iI";
                    n3 = 18;
                    continue block34;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "Y`\u0013hD)\f ;";
                    n3 = 19;
                    continue block34;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "Y`yn_%\f ;'Z`{!\r";
                    n3 = 20;
                    continue block34;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "Y`\u0013y\u0017s";
                    n3 = 21;
                    continue block34;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "Y`uiI6\u001b ;'Z`";
                    n3 = 22;
                    continue block34;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\u001d\u0006n;Ls:_Jx\u0016'Y^\r<\u001b:zCs&S_";
                    n3 = 23;
                    continue block34;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "\u0016\u0011y~]'\u0000uu\r:\u0007:\u007fH0\u0006~~h\u00109{iL>\fn~_ A3!\r";
                    n3 = 24;
                    continue block34;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "\u001a\u0007{k]!\u0006jiD2\u001d\u007f;]2\u001b{vH'\fh;^#\fyrK:\n{oD<\u0007";
                    n3 = 25;
                    continue block34;
                }
                case 25: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

