/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbApReq;
import com.ibm.security.krb5.KrbCryptoException;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.APRep;
import com.ibm.security.krb5.internal.EncAPRepPart;
import com.ibm.security.krb5.internal.KRBError;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.LocalSeqNumber;
import com.ibm.security.krb5.internal.SeqNumber;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class KrbApRep {
    private byte[] a;
    private EncAPRepPart b;
    private APRep c;

    public KrbApRep(KrbApReq krbApReq, boolean bl, EncryptionKey encryptionKey) throws KrbException, IOException {
        LocalSeqNumber localSeqNumber = new LocalSeqNumber();
        this.a(krbApReq, encryptionKey, localSeqNumber);
    }

    public KrbApRep(byte[] byArray, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(byArray, credentials);
        this.a(krbApReq);
    }

    private void a(KrbApReq krbApReq, EncryptionKey encryptionKey, SeqNumber seqNumber) throws KrbException, IOException {
        this.a(krbApReq.getCreds().f, krbApReq.b(), krbApReq.c(), encryptionKey, seqNumber);
        this.a = this.c.asn1Encode();
    }

    private KrbApRep(byte[] byArray, Credentials credentials) throws KrbException, IOException {
        this(new DerValue(byArray), credentials);
    }

    private KrbApRep(DerValue derValue, Credentials credentials) throws KrbException, IOException {
        APRep aPRep = null;
        try {
            aPRep = new APRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            aPRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            KrbException krbException = new KrbException(kRBError.getErrorCode(), string2);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        byte[] byArray = aPRep.encPart.decrypt(credentials.f, 12);
        byte[] byArray2 = aPRep.encPart.reset(byArray);
        derValue = new DerValue(byArray2);
        this.b = new EncAPRepPart(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(KrbApReq krbApReq) throws KrbException, IOException {
        if (this.b.getCtime().getSeconds() == krbApReq.b().getSeconds() && this.b.getCusec() == krbApReq.b().getMicroSeconds()) {
            return;
        }
        throw new KrbApErrException(46);
    }

    public EncryptionKey getSubKey() {
        return this.b.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.b.getSeqNumber();
    }

    public byte[] getMessage() {
        return this.a;
    }

    private void a(EncryptionKey encryptionKey, KerberosTime kerberosTime, int n2, EncryptionKey encryptionKey2, SeqNumber seqNumber) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n3 = null;
        if (seqNumber != null) {
            n3 = new Integer(seqNumber.current());
        }
        this.b = new EncAPRepPart(kerberosTime, n2, encryptionKey2, n3);
        byte[] byArray = this.b.asn1Encode();
        EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, 12);
        this.c = new APRep(encryptedData);
    }

    public KrbApRep(DerValue derValue, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(derValue, credentials);
        this.a(krbApReq);
    }
}

