/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8EncodingSupport
implements EncodingSupport {
    private static final EncodingSupport fgSingleton = new UTF8EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    @Override
    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, InputStream inputStream, String string, boolean bl, boolean bl2, DataSourceFactory dataSourceFactory) {
        ByteStreamDataSource byteStreamDataSource = dataSourceFactory.allocateByteStreamDataSource();
        byteStreamDataSource.checkAvailable = bl2;
        byteStreamDataSource.setByteStream(inputStream, this, bl);
        return byteStreamDataSource.load(parsedEntity);
    }

    @Override
    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = 0;
        try {
            int n2;
            if (byteStreamDataSource.checkForBOM) {
                n = this.checkUTF8BOM(byteStreamDataSource, byArray);
                byteStreamDataSource.checkForBOM = false;
            }
            for (int i = byteStreamDataSource.bufferLength - 1 - n; byteStreamDataSource.stream != null && i > 0; i -= n2) {
                n2 = byteStreamDataSource.stream.read(byArray, n, i);
                if (n2 == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                } else {
                    n += n2;
                    if (!byteStreamDataSource.checkAvailable || byteStreamDataSource.stream.available() != 0) continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        dataBuffer.endOffset = n;
        return null;
    }

    private UTF8EncodingSupport() {
    }

    private int checkUTF8BOM(ByteStreamDataSource byteStreamDataSource, byte[] byArray) throws IOException {
        InputStream inputStream = byteStreamDataSource.stream;
        int n = 0;
        int n2 = inputStream.read();
        if (n2 == 239) {
            n2 = inputStream.read();
            if (n2 == 187) {
                n2 = inputStream.read();
                if (n2 == 191) {
                    return 0;
                }
                byArray[n++] = -17;
                byArray[n++] = -69;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            } else {
                byArray[n++] = -17;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (n2 != -1) {
            byArray[n++] = (byte)n2;
            return n;
        }
        byteStreamDataSource.stream.close();
        byteStreamDataSource.stream = null;
        return n;
    }
}

